<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Contact Form Box Widget .
 *
 */
class Konsal_Contact_Form extends Widget_Base {

	public function get_name() {
		return 'konsalcontactform';
	}

	public function get_title() {
		return __( 'Contact Form', 'konsal' );
	}

	public function get_icon() {
		return 'th-icon';
    }

	public function get_categories() {
		return [ 'konsal' ];
	}

	public function get_as_contact_form(){
        if ( ! class_exists( 'WPCF7' ) ) {
            return;
        }
        $as_cfa         = array();
        $as_cf_args     = array( 'posts_per_page' => -1, 'post_type'=> 'wpcf7_contact_form' );
        $as_forms       = get_posts( $as_cf_args );
        $as_cfa         = ['0' => esc_html__( 'Select Form', 'konsal' ) ];
        if( $as_forms ){
            foreach ( $as_forms as $as_form ){
                $as_cfa[$as_form->ID] = $as_form->post_title;
            }
        }else{
            $as_cfa[ esc_html__( 'No contact form found', 'konsal' ) ] = 0;
        }
        return $as_cfa;
    }

	protected function register_controls() {

		$this->start_controls_section(
			'teamd_section',
			[
				'label' 	=> __( 'Contact Form', 'konsal' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'layout_style',
			[
				'label' 		=> __( 'Contact Form Style', 'konsal' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'layout_one',
				'options' 		=> [
					'layout_one'  		=> __( 'Style One', 'konsal' ),
					'layout_two'  		=> __( 'Style Two', 'konsal' ),
				]
			]
		);
		
		
        $this->end_controls_section();


	    include konsal_get_elementor_option('contactform-options.php');

		//---------------------------------------
			//Style Section Start
		//---------------------------------------

        //---------Title Style---------//
        konsal_common_style_fields($this, 'title', 'Title', '{{WRAPPER}} .title ', ['layout_two']);
        //---------Button Style---------//
		konsal_button_style_fields( $this, '1', 'Button Style', '{{WRAPPER}} .th-btn', ['layout_one', 'layout_two'] );

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        if( $settings['layout_style'] == 'layout_one' ){
            if( !empty($settings['konsal_select_contact_form']) ){
				echo do_shortcode( '[contact-form-7  id="'.$settings['konsal_select_contact_form'].'"]' ); 
			}else{
				echo '<div class="alert alert-warning"><p class="m-0">' . __('Please Select contact form.', 'konsal' ). '</p></div>';
			}

	    }elseif( $settings['layout_style'] == 'layout_two' ){
			echo '<div class="contact-form-v1 bg-smoke" data-bg-src="'.esc_url( $settings['image']['url'] ).'">';
				if(!empty($settings['title'])){
					echo '<h3 class="fs-40 mb-30 mt-n2 title">'.esc_html($settings['title']).'</h3>';
				}
				echo '<div class="contact-form ajax-contact">';
					if( !empty($settings['konsal_select_contact_form']) ){
						echo do_shortcode( '[contact-form-7  id="'.$settings['konsal_select_contact_form'].'"]' ); 
					}else{
						echo '<div class="alert alert-warning"><p class="m-0">' . __('Please Select contact form.', 'konsal' ). '</p></div>';
					}
				echo '</div>';
			echo '</div>';

		}


	}
}