!function(root,factory){"function"==typeof define&&define.amd?define("Chartist",[],function(){return root.Chartist=factory()}):"object"==typeof module&&module.exports?module.exports=factory():root.Chartist=factory()}(this,function(){var Chartist={version:"0.11.4"};return function(globalRoot,Chartist){"use strict";var window=globalRoot.window,document=globalRoot.document;Chartist.namespaces={svg:"http://www.w3.org/2000/svg",xmlns:"http://www.w3.org/2000/xmlns/",xhtml:"http://www.w3.org/1999/xhtml",xlink:"http://www.w3.org/1999/xlink",ct:"http://gionkunz.github.com/chartist-js/ct"},Chartist.noop=function(n){return n},Chartist.alphaNumerate=function(n){return String.fromCharCode(97+n%26)},Chartist.extend=function(target){var i,source,sourceProp;for(target=target||{},i=1;i<arguments.length;i++)for(var prop in source=arguments[i])"object"!=typeof(sourceProp=source[prop])||null===sourceProp||sourceProp instanceof Array?target[prop]=sourceProp:target[prop]=Chartist.extend(target[prop],sourceProp);return target},Chartist.replaceAll=function(str,subStr,newSubStr){return str.replace(new RegExp(subStr,"g"),newSubStr)},Chartist.ensureUnit=function(value,unit){return"number"==typeof value&&(value+=unit),value},Chartist.quantity=function(match){if("string"!=typeof match)return{value:match};match=/^(\d+)\s*(.*)$/g.exec(match);return{value:+match[1],unit:match[2]||void 0}},Chartist.querySelector=function(query){return query instanceof Node?query:document.querySelector(query)},Chartist.times=function(length){return Array.apply(null,new Array(length))},Chartist.sum=function(previous,current){return previous+(current||0)},Chartist.mapMultiply=function(factor){return function(num){return num*factor}},Chartist.mapAdd=function(addend){return function(num){return num+addend}},Chartist.serialMap=function(arr,cb){var result=[],length=Math.max.apply(null,arr.map(function(e){return e.length}));return Chartist.times(length).forEach(function(e,index){var args=arr.map(function(e){return e[index]});result[index]=cb.apply(null,args)}),result},Chartist.roundWithPrecision=function(value,precision){precision=Math.pow(10,precision||Chartist.precision);return Math.round(value*precision)/precision},Chartist.precision=8,Chartist.escapingMap={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#039;"},Chartist.serialize=function(data){return null==data?data:("number"==typeof data?data=""+data:"object"==typeof data&&(data=JSON.stringify({data:data})),Object.keys(Chartist.escapingMap).reduce(function(result,key){return Chartist.replaceAll(result,key,Chartist.escapingMap[key])},data))},Chartist.deserialize=function(data){if("string"!=typeof data)return data;data=Object.keys(Chartist.escapingMap).reduce(function(result,key){return Chartist.replaceAll(result,Chartist.escapingMap[key],key)},data);try{data=void 0!==(data=JSON.parse(data)).data?data.data:data}catch(e){}return data},Chartist.createSvg=function(container,width,height,svg){return width=width||"100%",height=height||"100%",Array.prototype.slice.call(container.querySelectorAll("svg")).filter(function(svg){return svg.getAttributeNS(Chartist.namespaces.xmlns,"ct")}).forEach(function(svg){container.removeChild(svg)}),(svg=new Chartist.Svg("svg").attr({width:width,height:height}).addClass(svg))._node.style.width=width,svg._node.style.height=height,container.appendChild(svg._node),svg},Chartist.normalizeData=function(data,reverse,labelCount){var output={raw:data,normalized:{}};return output.normalized.series=Chartist.getDataArray({series:data.series||[]},reverse,labelCount),labelCount=output.normalized.series.every(function(value){return value instanceof Array})?Math.max.apply(null,output.normalized.series.map(function(series){return series.length})):output.normalized.series.length,output.normalized.labels=(data.labels||[]).slice(),Array.prototype.push.apply(output.normalized.labels,Chartist.times(Math.max(0,labelCount-output.normalized.labels.length)).map(function(){return""})),reverse&&Chartist.reverseData(output.normalized),output},Chartist.safeHasProperty=function(object,property){return null!==object&&"object"==typeof object&&object.hasOwnProperty(property)},Chartist.isDataHoleValue=function(value){return null==value||"number"==typeof value&&isNaN(value)},Chartist.reverseData=function(data){data.labels.reverse(),data.series.reverse();for(var i=0;i<data.series.length;i++)"object"==typeof data.series[i]&&void 0!==data.series[i].data?data.series[i].data.reverse():data.series[i]instanceof Array&&data.series[i].reverse()},Chartist.getDataArray=function(data,reverse,multi){return data.series.map(function recursiveConvert(value){if(Chartist.safeHasProperty(value,"value"))return recursiveConvert(value.value);if(Chartist.safeHasProperty(value,"data"))return recursiveConvert(value.data);if(value instanceof Array)return value.map(recursiveConvert);if(!Chartist.isDataHoleValue(value)){if(multi){var multiValue={};return"string"==typeof multi?multiValue[multi]=Chartist.getNumberOrUndefined(value):multiValue.y=Chartist.getNumberOrUndefined(value),multiValue.x=value.hasOwnProperty("x")?Chartist.getNumberOrUndefined(value.x):multiValue.x,multiValue.y=value.hasOwnProperty("y")?Chartist.getNumberOrUndefined(value.y):multiValue.y,multiValue}return Chartist.getNumberOrUndefined(value)}})},Chartist.normalizePadding=function(padding,fallback){return fallback=fallback||0,"number"==typeof padding?{top:padding,right:padding,bottom:padding,left:padding}:{top:"number"==typeof padding.top?padding.top:fallback,right:"number"==typeof padding.right?padding.right:fallback,bottom:"number"==typeof padding.bottom?padding.bottom:fallback,left:"number"==typeof padding.left?padding.left:fallback}},Chartist.getMetaData=function(series,value){value=(series.data||series)[value];return value?value.meta:void 0},Chartist.orderOfMagnitude=function(value){return Math.floor(Math.log(Math.abs(value))/Math.LN10)},Chartist.projectLength=function(axisLength,length,bounds){return length/bounds.range*axisLength},Chartist.getAvailableHeight=function(svg,options){return Math.max((Chartist.quantity(options.height).value||svg.height())-(options.chartPadding.top+options.chartPadding.bottom)-options.axisX.offset,0)},Chartist.getHighLow=function(data,options,dimension){var highLow={high:void 0===(options=Chartist.extend({},options,dimension?options["axis"+dimension.toUpperCase()]:{})).high?-Number.MAX_VALUE:+options.high,low:void 0===options.low?Number.MAX_VALUE:+options.low},findHigh=void 0===options.high,findLow=void 0===options.low;return(findHigh||findLow)&&function recursiveHighLow(data){if(void 0!==data)if(data instanceof Array)for(var i=0;i<data.length;i++)recursiveHighLow(data[i]);else{var value=dimension?+data[dimension]:+data;findHigh&&value>highLow.high&&(highLow.high=value),findLow&&value<highLow.low&&(highLow.low=value)}}(data),!options.referenceValue&&0!==options.referenceValue||(highLow.high=Math.max(options.referenceValue,highLow.high),highLow.low=Math.min(options.referenceValue,highLow.low)),highLow.high<=highLow.low&&(0===highLow.low?highLow.high=1:highLow.low<0?highLow.high=0:(0<highLow.high||(highLow.high=1),highLow.low=0)),highLow},Chartist.isNumeric=function(value){return null!==value&&isFinite(value)},Chartist.isFalseyButZero=function(value){return!value&&0!==value},Chartist.getNumberOrUndefined=function(value){return Chartist.isNumeric(value)?+value:void 0},Chartist.isMultiValue=function(value){return"object"==typeof value&&("x"in value||"y"in value)},Chartist.getMultiValue=function(value,dimension){return Chartist.isMultiValue(value)?Chartist.getNumberOrUndefined(value[dimension||"y"]):Chartist.getNumberOrUndefined(value)},Chartist.rho=function(num){if(1===num)return num;function f(x){return x*x+1}var divisor,x1=2,x2=2;if(num%2==0)return 2;for(;x1=f(x1)%num,x2=f(f(x2))%num,1===(divisor=function gcd(p,q){return p%q==0?q:gcd(q,p%q)}(Math.abs(x1-x2),num)););return divisor},Chartist.getBounds=function(axisLength,smallestFactor,scaleMinSpace,onlyInteger){var newMin,newMax,optimizationCounter=0,bounds={high:smallestFactor.high,low:smallestFactor.low};bounds.valueRange=bounds.high-bounds.low,bounds.oom=Chartist.orderOfMagnitude(bounds.valueRange),bounds.step=Math.pow(10,bounds.oom),bounds.min=Math.floor(bounds.low/bounds.step)*bounds.step,bounds.max=Math.ceil(bounds.high/bounds.step)*bounds.step,bounds.range=bounds.max-bounds.min,bounds.numberOfSteps=Math.round(bounds.range/bounds.step);var scaleUp=Chartist.projectLength(axisLength,bounds.step,bounds)<scaleMinSpace,smallestFactor=onlyInteger?Chartist.rho(bounds.range):0;if(onlyInteger&&Chartist.projectLength(axisLength,1,bounds)>=scaleMinSpace)bounds.step=1;else if(onlyInteger&&smallestFactor<bounds.step&&Chartist.projectLength(axisLength,smallestFactor,bounds)>=scaleMinSpace)bounds.step=smallestFactor;else for(;;){if(scaleUp&&Chartist.projectLength(axisLength,bounds.step,bounds)<=scaleMinSpace)bounds.step*=2;else{if(scaleUp||!(Chartist.projectLength(axisLength,bounds.step/2,bounds)>=scaleMinSpace))break;if(bounds.step/=2,onlyInteger&&bounds.step%1!=0){bounds.step*=2;break}}if(1e3<optimizationCounter++)throw new Error("Exceeded maximum number of iterations while optimizing scale step!")}function safeIncrement(value,increment){return value===(value+=increment)&&(value*=1+(0<increment?2221e-19:-2221e-19)),value}for(bounds.step=Math.max(bounds.step,2221e-19),newMin=bounds.min,newMax=bounds.max;newMin+bounds.step<=bounds.low;)newMin=safeIncrement(newMin,bounds.step);for(;newMax-bounds.step>=bounds.high;)newMax=safeIncrement(newMax,-bounds.step);bounds.min=newMin,bounds.max=newMax,bounds.range=bounds.max-bounds.min;for(var values=[],i=bounds.min;i<=bounds.max;i=safeIncrement(i,bounds.step)){var value=Chartist.roundWithPrecision(i);value!==values[values.length-1]&&values.push(value)}return bounds.values=values,bounds},Chartist.polarToCartesian=function(centerX,centerY,radius,angleInRadians){angleInRadians=(angleInRadians-90)*Math.PI/180;return{x:centerX+radius*Math.cos(angleInRadians),y:centerY+radius*Math.sin(angleInRadians)}},Chartist.createChartRect=function(normalizedPadding,options,chartRect){var hasAxis=!(!options.axisX&&!options.axisY),yAxisOffset=hasAxis?options.axisY.offset:0,xAxisOffset=hasAxis?options.axisX.offset:0,width=normalizedPadding.width()||Chartist.quantity(options.width).value||0,height=normalizedPadding.height()||Chartist.quantity(options.height).value||0,normalizedPadding=Chartist.normalizePadding(options.chartPadding,chartRect),width=Math.max(width,yAxisOffset+normalizedPadding.left+normalizedPadding.right),height=Math.max(height,xAxisOffset+normalizedPadding.top+normalizedPadding.bottom),chartRect={padding:normalizedPadding,width:function(){return this.x2-this.x1},height:function(){return this.y1-this.y2}};return hasAxis?("start"===options.axisX.position?(chartRect.y2=normalizedPadding.top+xAxisOffset,chartRect.y1=Math.max(height-normalizedPadding.bottom,chartRect.y2+1)):(chartRect.y2=normalizedPadding.top,chartRect.y1=Math.max(height-normalizedPadding.bottom-xAxisOffset,chartRect.y2+1)),"start"===options.axisY.position?(chartRect.x1=normalizedPadding.left+yAxisOffset,chartRect.x2=Math.max(width-normalizedPadding.right,chartRect.x1+1)):(chartRect.x1=normalizedPadding.left,chartRect.x2=Math.max(width-normalizedPadding.right-yAxisOffset,chartRect.x1+1))):(chartRect.x1=normalizedPadding.left,chartRect.x2=Math.max(width-normalizedPadding.right,chartRect.x1+1),chartRect.y2=normalizedPadding.top,chartRect.y1=Math.max(height-normalizedPadding.bottom,chartRect.y2+1)),chartRect},Chartist.createGrid=function(position,index,axis,offset,length,group,gridElement,eventEmitter){var positionalData={};positionalData[axis.units.pos+"1"]=position,positionalData[axis.units.pos+"2"]=position,positionalData[axis.counterUnits.pos+"1"]=offset,positionalData[axis.counterUnits.pos+"2"]=offset+length;gridElement=group.elem("line",positionalData,gridElement.join(" "));eventEmitter.emit("draw",Chartist.extend({type:"grid",axis:axis,index:index,group:group,element:gridElement},positionalData))},Chartist.createGridBackground=function(gridGroup,chartRect,gridBackground,eventEmitter){gridBackground=gridGroup.elem("rect",{x:chartRect.x1,y:chartRect.y2,width:chartRect.width(),height:chartRect.height()},gridBackground,!0);eventEmitter.emit("draw",{type:"gridBackground",group:gridGroup,element:gridBackground})},Chartist.createLabel=function(position,length,index,labels,axis,axisOffset,labelOffset,group,labelElement,content,eventEmitter){var positionalData={};positionalData[axis.units.pos]=position+labelOffset[axis.units.pos],positionalData[axis.counterUnits.pos]=labelOffset[axis.counterUnits.pos],positionalData[axis.units.len]=length,positionalData[axis.counterUnits.len]=Math.max(0,axisOffset-10),labelElement=content?((content=document.createElement("span")).className=labelElement.join(" "),content.setAttribute("xmlns",Chartist.namespaces.xhtml),content.innerText=labels[index],content.style[axis.units.len]=Math.round(positionalData[axis.units.len])+"px",content.style[axis.counterUnits.len]=Math.round(positionalData[axis.counterUnits.len])+"px",group.foreignObject(content,Chartist.extend({style:"overflow: visible;"},positionalData))):group.elem("text",positionalData,labelElement.join(" ")).text(labels[index]),eventEmitter.emit("draw",Chartist.extend({type:"label",axis:axis,index:index,group:group,element:labelElement,text:labels[index]},positionalData))},Chartist.getSeriesOption=function(seriesOptions,options,key){if(seriesOptions.name&&options.series&&options.series[seriesOptions.name]){seriesOptions=options.series[seriesOptions.name];return(seriesOptions.hasOwnProperty(key)?seriesOptions:options)[key]}return options[key]},Chartist.optionsProvider=function(options,responsiveOptions,eventEmitter){var currentOptions,i,baseOptions=Chartist.extend({},options),mediaQueryListeners=[];function updateCurrentOptions(mediaEvent){var previousOptions=currentOptions;if(currentOptions=Chartist.extend({},baseOptions),responsiveOptions)for(i=0;i<responsiveOptions.length;i++)window.matchMedia(responsiveOptions[i][0]).matches&&(currentOptions=Chartist.extend(currentOptions,responsiveOptions[i][1]));eventEmitter&&mediaEvent&&eventEmitter.emit("optionsChanged",{previousOptions:previousOptions,currentOptions:currentOptions})}if(!window.matchMedia)throw"window.matchMedia not found! Make sure you're using a polyfill.";if(responsiveOptions)for(i=0;i<responsiveOptions.length;i++){var mql=window.matchMedia(responsiveOptions[i][0]);mql.addListener(updateCurrentOptions),mediaQueryListeners.push(mql)}return updateCurrentOptions(),{removeMediaQueryListeners:function(){mediaQueryListeners.forEach(function(mql){mql.removeListener(updateCurrentOptions)})},getCurrentOptions:function(){return Chartist.extend({},currentOptions)}}},Chartist.splitIntoSegments=function(pathCoordinates,valueData,options){options=Chartist.extend({},{increasingX:!1,fillHoles:!1},options);for(var segments=[],hole=!0,i=0;i<pathCoordinates.length;i+=2)void 0===Chartist.getMultiValue(valueData[i/2].value)?options.fillHoles||(hole=!0):((hole=options.increasingX&&2<=i&&pathCoordinates[i]<=pathCoordinates[i-2]?!0:hole)&&(segments.push({pathCoordinates:[],valueData:[]}),hole=!1),segments[segments.length-1].pathCoordinates.push(pathCoordinates[i],pathCoordinates[i+1]),segments[segments.length-1].valueData.push(valueData[i/2]));return segments}}(this||global,Chartist),function(Chartist){"use strict";Chartist.Interpolation={},Chartist.Interpolation.none=function(options){return options=Chartist.extend({},{fillHoles:!1},options),function(pathCoordinates,valueData){for(var path=new Chartist.Svg.Path,hole=!0,i=0;i<pathCoordinates.length;i+=2){var currX=pathCoordinates[i],currY=pathCoordinates[i+1],currData=valueData[i/2];void 0!==Chartist.getMultiValue(currData.value)?(hole?path.move(currX,currY,!1,currData):path.line(currX,currY,!1,currData),hole=!1):options.fillHoles||(hole=!0)}return path}},Chartist.Interpolation.simple=function(options){options=Chartist.extend({},{divisor:2,fillHoles:!1},options);var d=1/Math.max(1,options.divisor);return function(pathCoordinates,valueData){for(var prevX,prevY,prevData,path=new Chartist.Svg.Path,i=0;i<pathCoordinates.length;i+=2){var currX=pathCoordinates[i],currY=pathCoordinates[i+1],length=(currX-prevX)*d,currData=valueData[i/2];void 0!==currData.value?(void 0===prevData?path.move(currX,currY,!1,currData):path.curve(prevX+length,prevY,currX-length,currY,currX,currY,!1,currData),prevX=currX,prevY=currY,prevData=currData):options.fillHoles||(prevX=currX=prevData=void 0)}return path}},Chartist.Interpolation.cardinal=function(options){options=Chartist.extend({},{tension:1,fillHoles:!1},options);var t=Math.min(1,Math.max(0,options.tension)),c=1-t;return function cardinal(pathCoordinates,valueData){var segments=Chartist.splitIntoSegments(pathCoordinates,valueData,{fillHoles:options.fillHoles});if(segments.length){if(1<segments.length){var paths=[];return segments.forEach(function(segment){paths.push(cardinal(segment.pathCoordinates,segment.valueData))}),Chartist.Svg.Path.join(paths)}if(pathCoordinates=segments[0].pathCoordinates,valueData=segments[0].valueData,pathCoordinates.length<=4)return Chartist.Interpolation.none()(pathCoordinates,valueData);for(var path=(new Chartist.Svg.Path).move(pathCoordinates[0],pathCoordinates[1],!1,valueData[0]),i=0,iLen=pathCoordinates.length;i<iLen-2;i+=2){var p=[{x:+pathCoordinates[i-2],y:+pathCoordinates[i-1]},{x:+pathCoordinates[i],y:+pathCoordinates[i+1]},{x:+pathCoordinates[i+2],y:+pathCoordinates[i+3]},{x:+pathCoordinates[i+4],y:+pathCoordinates[i+5]}];iLen-4===i?p[3]=p[2]:i||(p[0]={x:+pathCoordinates[i],y:+pathCoordinates[i+1]}),path.curve(t*(-p[0].x+6*p[1].x+p[2].x)/6+c*p[2].x,t*(-p[0].y+6*p[1].y+p[2].y)/6+c*p[2].y,t*(p[1].x+6*p[2].x-p[3].x)/6+c*p[2].x,t*(p[1].y+6*p[2].y-p[3].y)/6+c*p[2].y,p[2].x,p[2].y,!1,valueData[(i+2)/2])}return path}return Chartist.Interpolation.none()([])}},Chartist.Interpolation.monotoneCubic=function(options){return options=Chartist.extend({},{fillHoles:!1},options),function monotoneCubic(pathCoordinates,valueData){var segments=Chartist.splitIntoSegments(pathCoordinates,valueData,{fillHoles:options.fillHoles,increasingX:!0});if(segments.length){if(1<segments.length){var paths=[];return segments.forEach(function(segment){paths.push(monotoneCubic(segment.pathCoordinates,segment.valueData))}),Chartist.Svg.Path.join(paths)}if(pathCoordinates=segments[0].pathCoordinates,valueData=segments[0].valueData,pathCoordinates.length<=4)return Chartist.Interpolation.none()(pathCoordinates,valueData);for(var path,xs=[],ys=[],n=pathCoordinates.length/2,ms=[],ds=[],dys=[],dxs=[],i=0;i<n;i++)xs[i]=pathCoordinates[2*i],ys[i]=pathCoordinates[2*i+1];for(i=0;i<n-1;i++)dys[i]=ys[i+1]-ys[i],dxs[i]=xs[i+1]-xs[i],ds[i]=dys[i]/dxs[i];for(ms[0]=ds[0],ms[n-1]=ds[n-2],i=1;i<n-1;i++)0===ds[i]||0===ds[i-1]||0<ds[i-1]!=0<ds[i]?ms[i]=0:(ms[i]=3*(dxs[i-1]+dxs[i])/((2*dxs[i]+dxs[i-1])/ds[i-1]+(dxs[i]+2*dxs[i-1])/ds[i]),isFinite(ms[i])||(ms[i]=0));for(path=(new Chartist.Svg.Path).move(xs[0],ys[0],!1,valueData[0]),i=0;i<n-1;i++)path.curve(xs[i]+dxs[i]/3,ys[i]+ms[i]*dxs[i]/3,xs[i+1]-dxs[i]/3,ys[i+1]-ms[i+1]*dxs[i]/3,xs[i+1],ys[i+1],!1,valueData[i+1]);return path}return Chartist.Interpolation.none()([])}},Chartist.Interpolation.step=function(options){return options=Chartist.extend({},{postpone:!0,fillHoles:!1},options),function(pathCoordinates,valueData){for(var prevX,prevY,prevData,path=new Chartist.Svg.Path,i=0;i<pathCoordinates.length;i+=2){var currX=pathCoordinates[i],currY=pathCoordinates[i+1],currData=valueData[i/2];void 0!==currData.value?(void 0===prevData?path.move(currX,currY,!1,currData):(options.postpone?path.line(currX,prevY,!1,prevData):path.line(prevX,currY,!1,currData),path.line(currX,currY,!1,currData)),prevX=currX,prevY=currY,prevData=currData):options.fillHoles||(prevX=prevY=prevData=void 0)}return path}}}((this||global,Chartist)),function(Chartist){"use strict";Chartist.EventEmitter=function(){var handlers=[];return{addEventHandler:function(event,handler){handlers[event]=handlers[event]||[],handlers[event].push(handler)},removeEventHandler:function(event,handler){handlers[event]&&(handler?(handlers[event].splice(handlers[event].indexOf(handler),1),0===handlers[event].length&&delete handlers[event]):delete handlers[event])},emit:function(event,data){handlers[event]&&handlers[event].forEach(function(handler){handler(data)}),handlers["*"]&&handlers["*"].forEach(function(starHandler){starHandler(event,data)})}}}}((this||global,Chartist)),function(Chartist){"use strict";Chartist.Class={extend:function(constr,superProto){var superProto=superProto||this.prototype||Chartist.Class,proto=Object.create(superProto);return Chartist.Class.cloneDefinitions(proto,constr),(constr=function(){var fn=proto.constructor||function(){},instance=this===Chartist?Object.create(proto):this;return fn.apply(instance,Array.prototype.slice.call(arguments,0)),instance}).prototype=proto,constr.super=superProto,constr.extend=this.extend,constr},cloneDefinitions:function(){var args=function(list){var arr=[];if(list.length)for(var i=0;i<list.length;i++)arr.push(list[i]);return arr}(arguments),target=args[0];return args.splice(1,args.length-1).forEach(function(source){Object.getOwnPropertyNames(source).forEach(function(propName){delete target[propName],Object.defineProperty(target,propName,Object.getOwnPropertyDescriptor(source,propName))})}),target}}}((this||global,Chartist)),function(globalRoot,Chartist){"use strict";var window=globalRoot.window;Chartist.Base=Chartist.Class.extend({constructor:function(query,data,defaultOptions,options,responsiveOptions){this.container=Chartist.querySelector(query),this.data=data||{},this.data.labels=this.data.labels||[],this.data.series=this.data.series||[],this.defaultOptions=defaultOptions,this.options=options,this.responsiveOptions=responsiveOptions,this.eventEmitter=Chartist.EventEmitter(),this.supportsForeignObject=Chartist.Svg.isSupported("Extensibility"),this.supportsAnimations=Chartist.Svg.isSupported("AnimationEventsAttribute"),this.resizeListener=function(){this.update()}.bind(this),this.container&&(this.container.__chartist__&&this.container.__chartist__.detach(),this.container.__chartist__=this),this.initializeTimeoutId=setTimeout(function(){window.addEventListener("resize",this.resizeListener),this.optionsProvider=Chartist.optionsProvider(this.options,this.responsiveOptions,this.eventEmitter),this.eventEmitter.addEventHandler("optionsChanged",function(){this.update()}.bind(this)),this.options.plugins&&this.options.plugins.forEach(function(plugin){plugin instanceof Array?plugin[0](this,plugin[1]):plugin(this)}.bind(this)),this.eventEmitter.emit("data",{type:"initial",data:this.data}),this.createChart(this.optionsProvider.getCurrentOptions()),this.initializeTimeoutId=void 0}.bind(this),0)},optionsProvider:void 0,container:void 0,svg:void 0,eventEmitter:void 0,createChart:function(){throw new Error("Base chart type can't be instantiated!")},update:function(data,options,override){return data&&(this.data=data||{},this.data.labels=this.data.labels||[],this.data.series=this.data.series||[],this.eventEmitter.emit("data",{type:"update",data:this.data})),options&&(this.options=Chartist.extend({},override?this.options:this.defaultOptions,options),this.initializeTimeoutId||(this.optionsProvider.removeMediaQueryListeners(),this.optionsProvider=Chartist.optionsProvider(this.options,this.responsiveOptions,this.eventEmitter))),this.initializeTimeoutId||this.createChart(this.optionsProvider.getCurrentOptions()),this},detach:function(){return this.initializeTimeoutId?window.clearTimeout(this.initializeTimeoutId):(window.removeEventListener("resize",this.resizeListener),this.optionsProvider.removeMediaQueryListeners()),this},on:function(event,handler){return this.eventEmitter.addEventHandler(event,handler),this},off:function(event,handler){return this.eventEmitter.removeEventHandler(event,handler),this},version:Chartist.version,supportsForeignObject:!1})}(this||global,Chartist),function(globalRoot,Chartist){"use strict";var document=globalRoot.document;Chartist.Svg=Chartist.Class.extend({constructor:function(name,attributes,className,parent,insertFirst){name instanceof Element?this._node=name:(this._node=document.createElementNS(Chartist.namespaces.svg,name),"svg"===name&&this.attr({"xmlns:ct":Chartist.namespaces.ct})),attributes&&this.attr(attributes),className&&this.addClass(className),parent&&(insertFirst&&parent._node.firstChild?parent._node.insertBefore(this._node,parent._node.firstChild):parent._node.appendChild(this._node))},attr:function(attributes,ns){return"string"==typeof attributes?ns?this._node.getAttributeNS(ns,attributes):this._node.getAttribute(attributes):(Object.keys(attributes).forEach(function(key){var namespacedAttribute;void 0!==attributes[key]&&(-1!==key.indexOf(":")?(namespacedAttribute=key.split(":"),this._node.setAttributeNS(Chartist.namespaces[namespacedAttribute[0]],key,attributes[key])):this._node.setAttribute(key,attributes[key]))}.bind(this)),this)},elem:function(name,attributes,className,insertFirst){return new Chartist.Svg(name,attributes,className,this,insertFirst)},parent:function(){return this._node.parentNode instanceof SVGElement?new Chartist.Svg(this._node.parentNode):null},root:function(){for(var node=this._node;"svg"!==node.nodeName;)node=node.parentNode;return new Chartist.Svg(node)},querySelector:function(foundNode){return(foundNode=this._node.querySelector(foundNode))?new Chartist.Svg(foundNode):null},querySelectorAll:function(foundNodes){return(foundNodes=this._node.querySelectorAll(foundNodes)).length?new Chartist.Svg.List(foundNodes):null},getNode:function(){return this._node},foreignObject:function(content,attributes,className,fnObj){var container;return"string"==typeof content&&((container=document.createElement("div")).innerHTML=content,content=container.firstChild),content.setAttribute("xmlns",Chartist.namespaces.xmlns),(fnObj=this.elem("foreignObject",attributes,className,fnObj))._node.appendChild(content),fnObj},text:function(t){return this._node.appendChild(document.createTextNode(t)),this},empty:function(){for(;this._node.firstChild;)this._node.removeChild(this._node.firstChild);return this},remove:function(){return this._node.parentNode.removeChild(this._node),this.parent()},replace:function(newElement){return this._node.parentNode.replaceChild(newElement._node,this._node),newElement},append:function(element,insertFirst){return insertFirst&&this._node.firstChild?this._node.insertBefore(element._node,this._node.firstChild):this._node.appendChild(element._node),this},classes:function(){return this._node.getAttribute("class")?this._node.getAttribute("class").trim().split(/\s+/):[]},addClass:function(names){return this._node.setAttribute("class",this.classes(this._node).concat(names.trim().split(/\s+/)).filter(function(elem,pos,self){return self.indexOf(elem)===pos}).join(" ")),this},removeClass:function(names){var removedClasses=names.trim().split(/\s+/);return this._node.setAttribute("class",this.classes(this._node).filter(function(name){return-1===removedClasses.indexOf(name)}).join(" ")),this},removeAllClasses:function(){return this._node.setAttribute("class",""),this},height:function(){return this._node.getBoundingClientRect().height},width:function(){return this._node.getBoundingClientRect().width},animate:function(animations,guided,eventEmitter){return void 0===guided&&(guided=!0),Object.keys(animations).forEach(function(attribute){function createAnimate(animationDefinition,guided){var animate,timeout,easing,attributeProperties={};animationDefinition.easing&&(easing=animationDefinition.easing instanceof Array?animationDefinition.easing:Chartist.Svg.Easing[animationDefinition.easing],delete animationDefinition.easing),animationDefinition.begin=Chartist.ensureUnit(animationDefinition.begin,"ms"),animationDefinition.dur=Chartist.ensureUnit(animationDefinition.dur,"ms"),easing&&(animationDefinition.calcMode="spline",animationDefinition.keySplines=easing.join(" "),animationDefinition.keyTimes="0;1"),guided&&(animationDefinition.fill="freeze",attributeProperties[attribute]=animationDefinition.from,this.attr(attributeProperties),timeout=Chartist.quantity(animationDefinition.begin||0).value,animationDefinition.begin="indefinite"),animate=this.elem("animate",Chartist.extend({attributeName:attribute},animationDefinition)),guided&&setTimeout(function(){try{animate._node.beginElement()}catch(err){attributeProperties[attribute]=animationDefinition.to,this.attr(attributeProperties),animate.remove()}}.bind(this),timeout),eventEmitter&&animate._node.addEventListener("beginEvent",function(){eventEmitter.emit("animationBegin",{element:this,animate:animate._node,params:animationDefinition})}.bind(this)),animate._node.addEventListener("endEvent",function(){eventEmitter&&eventEmitter.emit("animationEnd",{element:this,animate:animate._node,params:animationDefinition}),guided&&(attributeProperties[attribute]=animationDefinition.to,this.attr(attributeProperties),animate.remove())}.bind(this))}animations[attribute]instanceof Array?animations[attribute].forEach(function(animationDefinition){createAnimate.bind(this)(animationDefinition,!1)}.bind(this)):createAnimate.bind(this)(animations[attribute],guided)}.bind(this)),this}}),Chartist.Svg.isSupported=function(feature){return document.implementation.hasFeature("http://www.w3.org/TR/SVG11/feature#"+feature,"1.1")};Chartist.Svg.Easing={easeInSine:[.47,0,.745,.715],easeOutSine:[.39,.575,.565,1],easeInOutSine:[.445,.05,.55,.95],easeInQuad:[.55,.085,.68,.53],easeOutQuad:[.25,.46,.45,.94],easeInOutQuad:[.455,.03,.515,.955],easeInCubic:[.55,.055,.675,.19],easeOutCubic:[.215,.61,.355,1],easeInOutCubic:[.645,.045,.355,1],easeInQuart:[.895,.03,.685,.22],easeOutQuart:[.165,.84,.44,1],easeInOutQuart:[.77,0,.175,1],easeInQuint:[.755,.05,.855,.06],easeOutQuint:[.23,1,.32,1],easeInOutQuint:[.86,0,.07,1],easeInExpo:[.95,.05,.795,.035],easeOutExpo:[.19,1,.22,1],easeInOutExpo:[1,0,0,1],easeInCirc:[.6,.04,.98,.335],easeOutCirc:[.075,.82,.165,1],easeInOutCirc:[.785,.135,.15,.86],easeInBack:[.6,-.28,.735,.045],easeOutBack:[.175,.885,.32,1.275],easeInOutBack:[.68,-.55,.265,1.55]},Chartist.Svg.List=Chartist.Class.extend({constructor:function(nodeList){var list=this;this.svgElements=[];for(var i=0;i<nodeList.length;i++)this.svgElements.push(new Chartist.Svg(nodeList[i]));Object.keys(Chartist.Svg.prototype).filter(function(prototypeProperty){return-1===["constructor","parent","querySelector","querySelectorAll","replace","append","classes","height","width"].indexOf(prototypeProperty)}).forEach(function(prototypeProperty){list[prototypeProperty]=function(){var args=Array.prototype.slice.call(arguments,0);return list.svgElements.forEach(function(element){Chartist.Svg.prototype[prototypeProperty].apply(element,args)}),list}})}})}(this||global,Chartist),function(Chartist){"use strict";var elementDescriptions={m:["x","y"],l:["x","y"],c:["x1","y1","x2","y2","x","y"],a:["rx","ry","xAr","lAf","sf","x","y"]},defaultOptions={accuracy:3};function element(command,params,pathElements,pos,relative,pathElement){pathElement=Chartist.extend({command:relative?command.toLowerCase():command.toUpperCase()},params,pathElement?{data:pathElement}:{});pathElements.splice(pos,0,pathElement)}function forEachParam(pathElements,cb){pathElements.forEach(function(pathElement,pathElementIndex){elementDescriptions[pathElement.command.toLowerCase()].forEach(function(paramName,paramIndex){cb(pathElement,paramName,pathElementIndex,paramIndex,pathElements)})})}Chartist.Svg.Path=Chartist.Class.extend({constructor:function(close,options){this.pathElements=[],this.pos=0,this.close=close,this.options=Chartist.extend({},defaultOptions,options)},position:function(pos){return void 0!==pos?(this.pos=Math.max(0,Math.min(this.pathElements.length,pos)),this):this.pos},remove:function(count){return this.pathElements.splice(this.pos,count),this},move:function(x,y,relative,data){return element("M",{x:+x,y:+y},this.pathElements,this.pos++,relative,data),this},line:function(x,y,relative,data){return element("L",{x:+x,y:+y},this.pathElements,this.pos++,relative,data),this},curve:function(x1,y1,x2,y2,x,y,relative,data){return element("C",{x1:+x1,y1:+y1,x2:+x2,y2:+y2,x:+x,y:+y},this.pathElements,this.pos++,relative,data),this},arc:function(rx,ry,xAr,lAf,sf,x,y,relative,data){return element("A",{rx:+rx,ry:+ry,xAr:+xAr,lAf:+lAf,sf:+sf,x:+x,y:+y},this.pathElements,this.pos++,relative,data),this},scale:function(x,y){return forEachParam(this.pathElements,function(pathElement,paramName){pathElement[paramName]*="x"===paramName[0]?x:y}),this},translate:function(x,y){return forEachParam(this.pathElements,function(pathElement,paramName){pathElement[paramName]+="x"===paramName[0]?x:y}),this},transform:function(transformFnc){return forEachParam(this.pathElements,function(pathElement,paramName,pathElementIndex,paramIndex,transformed){transformed=transformFnc(pathElement,paramName,pathElementIndex,paramIndex,transformed);!transformed&&0!==transformed||(pathElement[paramName]=transformed)}),this},parse:function(elements){var spliceArgs=elements.replace(/([A-Za-z])([0-9])/g,"$1 $2").replace(/([0-9])([A-Za-z])/g,"$1 $2").split(/[\s,]+/).reduce(function(result,element){return element.match(/[A-Za-z]/)&&result.push([]),result[result.length-1].push(element),result},[]);return"Z"===spliceArgs[spliceArgs.length-1][0].toUpperCase()&&spliceArgs.pop(),elements=spliceArgs.map(function(chunk){var command=chunk.shift(),description=elementDescriptions[command.toLowerCase()];return Chartist.extend({command:command},description.reduce(function(result,paramName,index){return result[paramName]=+chunk[index],result},{}))}),spliceArgs=[this.pos,0],Array.prototype.push.apply(spliceArgs,elements),Array.prototype.splice.apply(this.pathElements,spliceArgs),this.pos+=elements.length,this},stringify:function(){var accuracyMultiplier=Math.pow(10,this.options.accuracy);return this.pathElements.reduce(function(path,pathElement){var params=elementDescriptions[pathElement.command.toLowerCase()].map(function(paramName){return this.options.accuracy?Math.round(pathElement[paramName]*accuracyMultiplier)/accuracyMultiplier:pathElement[paramName]}.bind(this));return path+pathElement.command+params.join(",")}.bind(this),"")+(this.close?"Z":"")},clone:function(c){return(c=new Chartist.Svg.Path(c||this.close)).pos=this.pos,c.pathElements=this.pathElements.slice().map(function(pathElement){return Chartist.extend({},pathElement)}),c.options=Chartist.extend({},this.options),c},splitByCommand:function(command){var split=[new Chartist.Svg.Path];return this.pathElements.forEach(function(pathElement){pathElement.command===command.toUpperCase()&&0!==split[split.length-1].pathElements.length&&split.push(new Chartist.Svg.Path),split[split.length-1].pathElements.push(pathElement)}),split}}),Chartist.Svg.Path.elementDescriptions=elementDescriptions,Chartist.Svg.Path.join=function(paths,close,options){for(var joinedPath=new Chartist.Svg.Path(close,options),i=0;i<paths.length;i++)for(var path=paths[i],j=0;j<path.pathElements.length;j++)joinedPath.pathElements.push(path.pathElements[j]);return joinedPath}}((this||global,Chartist)),function(globalRoot,Chartist){"use strict";globalRoot.window,globalRoot.document;var axisUnits={x:{pos:"x",len:"width",dir:"horizontal",rectStart:"x1",rectEnd:"x2",rectOffset:"y2"},y:{pos:"y",len:"height",dir:"vertical",rectStart:"y2",rectEnd:"y1",rectOffset:"x1"}};Chartist.Axis=Chartist.Class.extend({constructor:function(units,chartRect,ticks,options){this.units=units,this.counterUnits=units===axisUnits.x?axisUnits.y:axisUnits.x,this.chartRect=chartRect,this.axisLength=chartRect[units.rectEnd]-chartRect[units.rectStart],this.gridOffset=chartRect[units.rectOffset],this.ticks=ticks,this.options=options},createGridAndLabels:function(gridGroup,labelGroup,useForeignObject,chartOptions,eventEmitter){var axisOptions=chartOptions["axis"+this.units.pos.toUpperCase()],projectedValues=this.ticks.map(this.projectValue.bind(this)),labelValues=this.ticks.map(axisOptions.labelInterpolationFnc);projectedValues.forEach(function(projectedValue,index){var labelOffset={x:0,y:0},labelLength=projectedValues[index+1]?projectedValues[index+1]-projectedValue:Math.max(this.axisLength-projectedValue,30);Chartist.isFalseyButZero(labelValues[index])&&""!==labelValues[index]||("x"===this.units.pos?(projectedValue=this.chartRect.x1+projectedValue,labelOffset.x=chartOptions.axisX.labelOffset.x,"start"===chartOptions.axisX.position?labelOffset.y=this.chartRect.padding.top+chartOptions.axisX.labelOffset.y+(useForeignObject?5:20):labelOffset.y=this.chartRect.y1+chartOptions.axisX.labelOffset.y+(useForeignObject?5:20)):(projectedValue=this.chartRect.y1-projectedValue,labelOffset.y=chartOptions.axisY.labelOffset.y-(useForeignObject?labelLength:0),"start"===chartOptions.axisY.position?labelOffset.x=useForeignObject?this.chartRect.padding.left+chartOptions.axisY.labelOffset.x:this.chartRect.x1-10:labelOffset.x=this.chartRect.x2+chartOptions.axisY.labelOffset.x+10),axisOptions.showGrid&&Chartist.createGrid(projectedValue,index,this,this.gridOffset,this.chartRect[this.counterUnits.len](),gridGroup,[chartOptions.classNames.grid,chartOptions.classNames[this.units.dir]],eventEmitter),axisOptions.showLabel&&Chartist.createLabel(projectedValue,labelLength,index,labelValues,this,axisOptions.offset,labelOffset,labelGroup,[chartOptions.classNames.label,chartOptions.classNames[this.units.dir],"start"===axisOptions.position?chartOptions.classNames[axisOptions.position]:chartOptions.classNames.end],useForeignObject,eventEmitter))}.bind(this))},projectValue:function(value,index,data){throw new Error("Base axis can't be instantiated!")}}),Chartist.Axis.units=axisUnits}(this||global,Chartist),function(globalRoot,Chartist){"use strict";globalRoot.window,globalRoot.document;Chartist.AutoScaleAxis=Chartist.Axis.extend({constructor:function(axisUnit,highLow,chartRect,options){highLow=options.highLow||Chartist.getHighLow(highLow,options,axisUnit.pos),this.bounds=Chartist.getBounds(chartRect[axisUnit.rectEnd]-chartRect[axisUnit.rectStart],highLow,options.scaleMinSpace||20,options.onlyInteger),this.range={min:this.bounds.min,max:this.bounds.max},Chartist.AutoScaleAxis.super.constructor.call(this,axisUnit,chartRect,this.bounds.values,options)},projectValue:function(value){return this.axisLength*(+Chartist.getMultiValue(value,this.units.pos)-this.bounds.min)/this.bounds.range}})}(this||global,Chartist),function(globalRoot,Chartist){"use strict";globalRoot.window,globalRoot.document;Chartist.FixedScaleAxis=Chartist.Axis.extend({constructor:function(axisUnit,data,chartRect,options){var highLow=options.highLow||Chartist.getHighLow(data,options,axisUnit.pos);this.divisor=options.divisor||1,this.ticks=options.ticks||Chartist.times(this.divisor).map(function(value,index){return highLow.low+(highLow.high-highLow.low)/this.divisor*index}.bind(this)),this.ticks.sort(function(a,b){return a-b}),this.range={min:highLow.low,max:highLow.high},Chartist.FixedScaleAxis.super.constructor.call(this,axisUnit,chartRect,this.ticks,options),this.stepLength=this.axisLength/this.divisor},projectValue:function(value){return this.axisLength*(+Chartist.getMultiValue(value,this.units.pos)-this.range.min)/(this.range.max-this.range.min)}})}(this||global,Chartist),function(globalRoot,Chartist){"use strict";globalRoot.window,globalRoot.document;Chartist.StepAxis=Chartist.Axis.extend({constructor:function(axisUnit,data,chartRect,calc){Chartist.StepAxis.super.constructor.call(this,axisUnit,chartRect,calc.ticks,calc),calc=Math.max(1,calc.ticks.length-(calc.stretch?1:0)),this.stepLength=this.axisLength/calc},projectValue:function(value,index){return this.stepLength*index}})}(this||global,Chartist),function(globalRoot,Chartist){"use strict";globalRoot.window,globalRoot.document;var defaultOptions={axisX:{offset:30,position:"end",labelOffset:{x:0,y:0},showLabel:!0,showGrid:!0,labelInterpolationFnc:Chartist.noop,type:void 0},axisY:{offset:40,position:"start",labelOffset:{x:0,y:0},showLabel:!0,showGrid:!0,labelInterpolationFnc:Chartist.noop,type:void 0,scaleMinSpace:20,onlyInteger:!1},width:void 0,height:void 0,showLine:!0,showPoint:!0,showArea:!1,areaBase:0,lineSmooth:!0,showGridBackground:!1,low:void 0,high:void 0,chartPadding:{top:15,right:15,bottom:5,left:10},fullWidth:!1,reverseData:!1,classNames:{chart:"ct-chart-line",label:"ct-label",labelGroup:"ct-labels",series:"ct-series",line:"ct-line",point:"ct-point",area:"ct-area",grid:"ct-grid",gridGroup:"ct-grids",gridBackground:"ct-grid-background",vertical:"ct-vertical",horizontal:"ct-horizontal",start:"ct-start",end:"ct-end"}};Chartist.Line=Chartist.Base.extend({constructor:function(query,data,options,responsiveOptions){Chartist.Line.super.constructor.call(this,query,data,defaultOptions,Chartist.extend({},defaultOptions,options),responsiveOptions)},createChart:function(options){var data=Chartist.normalizeData(this.data,options.reverseData,!0);this.svg=Chartist.createSvg(this.container,options.width,options.height,options.classNames.chart);var gridGroup=this.svg.elem("g").addClass(options.classNames.gridGroup),seriesGroup=this.svg.elem("g"),labelGroup=this.svg.elem("g").addClass(options.classNames.labelGroup),chartRect=Chartist.createChartRect(this.svg,options,defaultOptions.padding),axisX=void 0===options.axisX.type?new Chartist.StepAxis(Chartist.Axis.units.x,data.normalized.series,chartRect,Chartist.extend({},options.axisX,{ticks:data.normalized.labels,stretch:options.fullWidth})):options.axisX.type.call(Chartist,Chartist.Axis.units.x,data.normalized.series,chartRect,options.axisX),axisY=void 0===options.axisY.type?new Chartist.AutoScaleAxis(Chartist.Axis.units.y,data.normalized.series,chartRect,Chartist.extend({},options.axisY,{high:(Chartist.isNumeric(options.high)?options:options.axisY).high,low:(Chartist.isNumeric(options.low)?options:options.axisY).low})):options.axisY.type.call(Chartist,Chartist.Axis.units.y,data.normalized.series,chartRect,options.axisY);axisX.createGridAndLabels(gridGroup,labelGroup,this.supportsForeignObject,options,this.eventEmitter),axisY.createGridAndLabels(gridGroup,labelGroup,this.supportsForeignObject,options,this.eventEmitter),options.showGridBackground&&Chartist.createGridBackground(gridGroup,chartRect,options.classNames.gridBackground,this.eventEmitter),data.raw.series.forEach(function(series,seriesIndex){var seriesElement=seriesGroup.elem("g");seriesElement.attr({"ct:series-name":series.name,"ct:meta":Chartist.serialize(series.meta)}),seriesElement.addClass([options.classNames.series,series.className||options.classNames.series+"-"+Chartist.alphaNumerate(seriesIndex)].join(" "));var pathCoordinates=[],pathData=[];data.normalized.series[seriesIndex].forEach(function(value,valueIndex){var p={x:chartRect.x1+axisX.projectValue(value,valueIndex,data.normalized.series[seriesIndex]),y:chartRect.y1-axisY.projectValue(value,valueIndex,data.normalized.series[seriesIndex])};pathCoordinates.push(p.x,p.y),pathData.push({value:value,valueIndex:valueIndex,meta:Chartist.getMetaData(series,valueIndex)})}.bind(this));var line,areaBaseProjected,areaBase={lineSmooth:Chartist.getSeriesOption(series,options,"lineSmooth"),showPoint:Chartist.getSeriesOption(series,options,"showPoint"),showLine:Chartist.getSeriesOption(series,options,"showLine"),showArea:Chartist.getSeriesOption(series,options,"showArea"),areaBase:Chartist.getSeriesOption(series,options,"areaBase")},path=("function"==typeof areaBase.lineSmooth?areaBase.lineSmooth:areaBase.lineSmooth?Chartist.Interpolation.monotoneCubic():Chartist.Interpolation.none())(pathCoordinates,pathData);areaBase.showPoint&&path.pathElements.forEach(function(pathElement){var point=seriesElement.elem("line",{x1:pathElement.x,y1:pathElement.y,x2:pathElement.x+.01,y2:pathElement.y},options.classNames.point).attr({"ct:value":[pathElement.data.value.x,pathElement.data.value.y].filter(Chartist.isNumeric).join(","),"ct:meta":Chartist.serialize(pathElement.data.meta)});this.eventEmitter.emit("draw",{type:"point",value:pathElement.data.value,index:pathElement.data.valueIndex,meta:pathElement.data.meta,series:series,seriesIndex:seriesIndex,axisX:axisX,axisY:axisY,group:seriesElement,element:point,x:pathElement.x,y:pathElement.y})}.bind(this)),areaBase.showLine&&(line=seriesElement.elem("path",{d:path.stringify()},options.classNames.line,!0),this.eventEmitter.emit("draw",{type:"line",values:data.normalized.series[seriesIndex],path:path.clone(),chartRect:chartRect,index:seriesIndex,series:series,seriesIndex:seriesIndex,seriesMeta:series.meta,axisX:axisX,axisY:axisY,group:seriesElement,element:line})),areaBase.showArea&&axisY.range&&(areaBase=Math.max(Math.min(areaBase.areaBase,axisY.range.max),axisY.range.min),areaBaseProjected=chartRect.y1-axisY.projectValue(areaBase),path.splitByCommand("M").filter(function(pathSegment){return 1<pathSegment.pathElements.length}).map(function(solidPathSegments){var firstElement=solidPathSegments.pathElements[0],lastElement=solidPathSegments.pathElements[solidPathSegments.pathElements.length-1];return solidPathSegments.clone(!0).position(0).remove(1).move(firstElement.x,areaBaseProjected).line(firstElement.x,firstElement.y).position(solidPathSegments.pathElements.length+1).line(lastElement.x,areaBaseProjected)}).forEach(function(areaPath){var area=seriesElement.elem("path",{d:areaPath.stringify()},options.classNames.area,!0);this.eventEmitter.emit("draw",{type:"area",values:data.normalized.series[seriesIndex],path:areaPath.clone(),series:series,seriesIndex:seriesIndex,axisX:axisX,axisY:axisY,chartRect:chartRect,index:seriesIndex,group:seriesElement,element:area})}.bind(this)))}.bind(this)),this.eventEmitter.emit("created",{bounds:axisY.bounds,chartRect:chartRect,axisX:axisX,axisY:axisY,svg:this.svg,options:options})}})}(this||global,Chartist),function(globalRoot,Chartist){"use strict";globalRoot.window,globalRoot.document;var defaultOptions={axisX:{offset:30,position:"end",labelOffset:{x:0,y:0},showLabel:!0,showGrid:!0,labelInterpolationFnc:Chartist.noop,scaleMinSpace:30,onlyInteger:!1},axisY:{offset:40,position:"start",labelOffset:{x:0,y:0},showLabel:!0,showGrid:!0,labelInterpolationFnc:Chartist.noop,scaleMinSpace:20,onlyInteger:!1},width:void 0,height:void 0,high:void 0,low:void 0,referenceValue:0,chartPadding:{top:15,right:15,bottom:5,left:10},seriesBarDistance:15,stackBars:!1,stackMode:"accumulate",horizontalBars:!1,distributeSeries:!1,reverseData:!1,showGridBackground:!1,classNames:{chart:"ct-chart-bar",horizontalBars:"ct-horizontal-bars",label:"ct-label",labelGroup:"ct-labels",series:"ct-series",bar:"ct-bar",grid:"ct-grid",gridGroup:"ct-grids",gridBackground:"ct-grid-background",vertical:"ct-vertical",horizontal:"ct-horizontal",start:"ct-start",end:"ct-end"}};Chartist.Bar=Chartist.Base.extend({constructor:function(query,data,options,responsiveOptions){Chartist.Bar.super.constructor.call(this,query,data,defaultOptions,Chartist.extend({},defaultOptions,options),responsiveOptions)},createChart:function(options){var data;options.distributeSeries?(data=Chartist.normalizeData(this.data,options.reverseData,options.horizontalBars?"x":"y")).normalized.series=data.normalized.series.map(function(value){return[value]}):data=Chartist.normalizeData(this.data,options.reverseData,options.horizontalBars?"x":"y"),this.svg=Chartist.createSvg(this.container,options.width,options.height,options.classNames.chart+(options.horizontalBars?" "+options.classNames.horizontalBars:""));var highLow,gridGroup=this.svg.elem("g").addClass(options.classNames.gridGroup),seriesGroup=this.svg.elem("g"),labelGroup=this.svg.elem("g").addClass(options.classNames.labelGroup);(highLow=options.stackBars&&0!==data.normalized.series.length?(labelAxisTicks=Chartist.serialMap(data.normalized.series,function(){return Array.prototype.slice.call(arguments).map(function(value){return value}).reduce(function(prev,curr){return{x:prev.x+(curr&&curr.x)||0,y:prev.y+(curr&&curr.y)||0}},{x:0,y:0})}),Chartist.getHighLow([labelAxisTicks],options,options.horizontalBars?"x":"y")):Chartist.getHighLow(data.normalized.series,options,options.horizontalBars?"x":"y")).high=+options.high||(0===options.high?0:highLow.high),highLow.low=+options.low||(0===options.low?0:highLow.low);var valueAxis,labelAxis,axisX,axisY,chartRect=Chartist.createChartRect(this.svg,options,defaultOptions.padding),labelAxisTicks=options.distributeSeries&&options.stackBars?data.normalized.labels.slice(0,1):data.normalized.labels;options.horizontalBars?(valueAxis=axisX=void 0===options.axisX.type?new Chartist.AutoScaleAxis(Chartist.Axis.units.x,data.normalized.series,chartRect,Chartist.extend({},options.axisX,{highLow:highLow,referenceValue:0})):options.axisX.type.call(Chartist,Chartist.Axis.units.x,data.normalized.series,chartRect,Chartist.extend({},options.axisX,{highLow:highLow,referenceValue:0})),labelAxis=axisY=void 0===options.axisY.type?new Chartist.StepAxis(Chartist.Axis.units.y,data.normalized.series,chartRect,{ticks:labelAxisTicks}):options.axisY.type.call(Chartist,Chartist.Axis.units.y,data.normalized.series,chartRect,options.axisY)):(labelAxis=axisX=void 0===options.axisX.type?new Chartist.StepAxis(Chartist.Axis.units.x,data.normalized.series,chartRect,{ticks:labelAxisTicks}):options.axisX.type.call(Chartist,Chartist.Axis.units.x,data.normalized.series,chartRect,options.axisX),valueAxis=axisY=void 0===options.axisY.type?new Chartist.AutoScaleAxis(Chartist.Axis.units.y,data.normalized.series,chartRect,Chartist.extend({},options.axisY,{highLow:highLow,referenceValue:0})):options.axisY.type.call(Chartist,Chartist.Axis.units.y,data.normalized.series,chartRect,Chartist.extend({},options.axisY,{highLow:highLow,referenceValue:0})));var zeroPoint=options.horizontalBars?chartRect.x1+valueAxis.projectValue(0):chartRect.y1-valueAxis.projectValue(0),stackedBarValues=[];labelAxis.createGridAndLabels(gridGroup,labelGroup,this.supportsForeignObject,options,this.eventEmitter),valueAxis.createGridAndLabels(gridGroup,labelGroup,this.supportsForeignObject,options,this.eventEmitter),options.showGridBackground&&Chartist.createGridBackground(gridGroup,chartRect,options.classNames.gridBackground,this.eventEmitter),data.raw.series.forEach(function(series,seriesIndex){var biPol=seriesIndex-(data.raw.series.length-1)/2,periodHalfLength=options.distributeSeries&&!options.stackBars?labelAxis.axisLength/data.normalized.series.length/2:options.distributeSeries&&options.stackBars?labelAxis.axisLength/2:labelAxis.axisLength/data.normalized.series[seriesIndex].length/2,seriesElement=seriesGroup.elem("g");seriesElement.attr({"ct:series-name":series.name,"ct:meta":Chartist.serialize(series.meta)}),seriesElement.addClass([options.classNames.series,series.className||options.classNames.series+"-"+Chartist.alphaNumerate(seriesIndex)].join(" ")),data.normalized.series[seriesIndex].forEach(function(value,valueIndex){var bar,positions=options.distributeSeries&&!options.stackBars?seriesIndex:options.distributeSeries&&options.stackBars?0:valueIndex,metaData=options.horizontalBars?{x:chartRect.x1+valueAxis.projectValue(value&&value.x?value.x:0,valueIndex,data.normalized.series[seriesIndex]),y:chartRect.y1-labelAxis.projectValue(value&&value.y?value.y:0,positions,data.normalized.series[seriesIndex])}:{x:chartRect.x1+labelAxis.projectValue(value&&value.x?value.x:0,positions,data.normalized.series[seriesIndex]),y:chartRect.y1-valueAxis.projectValue(value&&value.y?value.y:0,valueIndex,data.normalized.series[seriesIndex])};labelAxis instanceof Chartist.StepAxis&&(labelAxis.options.stretch||(metaData[labelAxis.units.pos]+=periodHalfLength*(options.horizontalBars?-1:1)),metaData[labelAxis.units.pos]+=options.stackBars||options.distributeSeries?0:biPol*options.seriesBarDistance*(options.horizontalBars?-1:1)),bar=stackedBarValues[valueIndex]||zeroPoint,stackedBarValues[valueIndex]=bar-(zeroPoint-metaData[labelAxis.counterUnits.pos]),void 0!==value&&((positions={})[labelAxis.units.pos+"1"]=metaData[labelAxis.units.pos],positions[labelAxis.units.pos+"2"]=metaData[labelAxis.units.pos],!options.stackBars||"accumulate"!==options.stackMode&&options.stackMode?(positions[labelAxis.counterUnits.pos+"1"]=zeroPoint,positions[labelAxis.counterUnits.pos+"2"]=metaData[labelAxis.counterUnits.pos]):(positions[labelAxis.counterUnits.pos+"1"]=bar,positions[labelAxis.counterUnits.pos+"2"]=stackedBarValues[valueIndex]),positions.x1=Math.min(Math.max(positions.x1,chartRect.x1),chartRect.x2),positions.x2=Math.min(Math.max(positions.x2,chartRect.x1),chartRect.x2),positions.y1=Math.min(Math.max(positions.y1,chartRect.y2),chartRect.y1),positions.y2=Math.min(Math.max(positions.y2,chartRect.y2),chartRect.y1),metaData=Chartist.getMetaData(series,valueIndex),bar=seriesElement.elem("line",positions,options.classNames.bar).attr({"ct:value":[value.x,value.y].filter(Chartist.isNumeric).join(","),"ct:meta":Chartist.serialize(metaData)}),this.eventEmitter.emit("draw",Chartist.extend({type:"bar",value:value,index:valueIndex,meta:metaData,series:series,seriesIndex:seriesIndex,axisX:axisX,axisY:axisY,chartRect:chartRect,group:seriesElement,element:bar},positions)))}.bind(this))}.bind(this)),this.eventEmitter.emit("created",{bounds:valueAxis.bounds,chartRect:chartRect,axisX:axisX,axisY:axisY,svg:this.svg,options:options})}})}(this||global,Chartist),function(globalRoot,Chartist){"use strict";globalRoot.window,globalRoot.document;var defaultOptions={width:void 0,height:void 0,chartPadding:5,classNames:{chartPie:"ct-chart-pie",chartDonut:"ct-chart-donut",series:"ct-series",slicePie:"ct-slice-pie",sliceDonut:"ct-slice-donut",sliceDonutSolid:"ct-slice-donut-solid",label:"ct-label"},startAngle:0,total:void 0,donut:!1,donutSolid:!1,donutWidth:60,showLabel:!0,labelOffset:0,labelPosition:"inside",labelInterpolationFnc:Chartist.noop,labelDirection:"neutral",reverseData:!1,ignoreEmptyValues:!1};function determineAnchorPosition(toTheRight,label,direction){toTheRight=label.x>toTheRight.x;return toTheRight&&"explode"===direction||!toTheRight&&"implode"===direction?"start":toTheRight&&"implode"===direction||!toTheRight&&"explode"===direction?"end":"middle"}Chartist.Pie=Chartist.Base.extend({constructor:function(query,data,options,responsiveOptions){Chartist.Pie.super.constructor.call(this,query,data,defaultOptions,Chartist.extend({},defaultOptions,options),responsiveOptions)},createChart:function(options){var labelsGroup,labelRadius,data=Chartist.normalizeData(this.data),seriesGroups=[],startAngle=options.startAngle;this.svg=Chartist.createSvg(this.container,options.width,options.height,options.donut?options.classNames.chartDonut:options.classNames.chartPie);var chartRect=Chartist.createChartRect(this.svg,options,defaultOptions.padding),radius=Math.min(chartRect.width()/2,chartRect.height()/2),totalDataSum=options.total||data.normalized.series.reduce(function(previousValue,currentValue){return previousValue+currentValue},0),donutWidth=Chartist.quantity(options.donutWidth);"%"===donutWidth.unit&&(donutWidth.value*=radius/100),radius-=options.donut&&!options.donutSolid?donutWidth.value/2:0,labelRadius="outside"===options.labelPosition||options.donut&&!options.donutSolid?radius:"center"===options.labelPosition?0:options.donutSolid?radius-donutWidth.value/2:radius/2,labelRadius+=options.labelOffset;var center={x:chartRect.x1+chartRect.width()/2,y:chartRect.y2+chartRect.height()/2},hasSingleValInSeries=1===data.raw.series.filter(function(val){return val.hasOwnProperty("value")?0!==val.value:0!==val}).length;data.raw.series.forEach(function(series,index){seriesGroups[index]=this.svg.elem("g",null,null)}.bind(this)),options.showLabel&&(labelsGroup=this.svg.elem("g",null,null)),data.raw.series.forEach(function(labelPosition,index){var endAngle,innerStart,donutSolidRadius,interpolatedValue,labelElement;0===data.normalized.series[index]&&options.ignoreEmptyValues||(seriesGroups[index].attr({"ct:series-name":labelPosition.name}),seriesGroups[index].addClass([options.classNames.series,labelPosition.className||options.classNames.series+"-"+Chartist.alphaNumerate(index)].join(" ")),359.99<=(endAngle=0<totalDataSum?startAngle+data.normalized.series[index]/totalDataSum*360:0)-(interpolatedValue=Math.max(0,startAngle-(0===index||hasSingleValInSeries?0:.2)))&&(endAngle=interpolatedValue+359.99),innerStart=Chartist.polarToCartesian(center.x,center.y,radius,interpolatedValue),donutSolidRadius=Chartist.polarToCartesian(center.x,center.y,radius,endAngle),interpolatedValue=new Chartist.Svg.Path(!options.donut||options.donutSolid).move(donutSolidRadius.x,donutSolidRadius.y).arc(radius,radius,0,180<endAngle-startAngle,0,innerStart.x,innerStart.y),options.donut?options.donutSolid&&(donutSolidRadius=radius-donutWidth.value,innerStart=Chartist.polarToCartesian(center.x,center.y,donutSolidRadius,startAngle-(0===index||hasSingleValInSeries?0:.2)),labelElement=Chartist.polarToCartesian(center.x,center.y,donutSolidRadius,endAngle),interpolatedValue.line(innerStart.x,innerStart.y),interpolatedValue.arc(donutSolidRadius,donutSolidRadius,0,180<endAngle-startAngle,1,labelElement.x,labelElement.y)):interpolatedValue.line(center.x,center.y),labelElement=options.classNames.slicePie,options.donut&&(labelElement=options.classNames.sliceDonut,options.donutSolid&&(labelElement=options.classNames.sliceDonutSolid)),(labelElement=seriesGroups[index].elem("path",{d:interpolatedValue.stringify()},labelElement)).attr({"ct:value":data.normalized.series[index],"ct:meta":Chartist.serialize(labelPosition.meta)}),options.donut&&!options.donutSolid&&(labelElement._node.style.strokeWidth=donutWidth.value+"px"),this.eventEmitter.emit("draw",{type:"slice",value:data.normalized.series[index],totalDataSum:totalDataSum,index:index,meta:labelPosition.meta,series:labelPosition,group:seriesGroups[index],element:labelElement,path:interpolatedValue.clone(),center:center,radius:radius,startAngle:startAngle,endAngle:endAngle}),options.showLabel&&(labelPosition=1===data.raw.series.length?{x:center.x,y:center.y}:Chartist.polarToCartesian(center.x,center.y,labelRadius,startAngle+(endAngle-startAngle)/2),labelElement=(data.normalized.labels&&!Chartist.isFalseyButZero(data.normalized.labels[index])?data.normalized.labels:data.normalized.series)[index],!(interpolatedValue=options.labelInterpolationFnc(labelElement,index))&&0!==interpolatedValue||(labelElement=labelsGroup.elem("text",{dx:labelPosition.x,dy:labelPosition.y,"text-anchor":determineAnchorPosition(center,labelPosition,options.labelDirection)},options.classNames.label).text(""+interpolatedValue),this.eventEmitter.emit("draw",{type:"label",index:index,group:labelsGroup,element:labelElement,text:""+interpolatedValue,x:labelPosition.x,y:labelPosition.y}))),startAngle=endAngle)}.bind(this)),this.eventEmitter.emit("created",{chartRect:chartRect,svg:this.svg,options:options})},determineAnchorPosition:determineAnchorPosition})}(this||global,Chartist),Chartist});