<?php
$default_settings = [

];
$settings = array_merge($default_settings, $settings);
extract($settings);

$html_id = ct_get_element_id($settings);

$widget->add_render_attribute( 'inner', [
    'class' => 'ct-carousel-inner',
] );

$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');

$arrows = $widget->get_setting('arrows');
$dots = $widget->get_setting('dots');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay', '');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite');
$speed = $widget->get_setting('speed', '500');
if (is_rtl()) {
    $carousel_dir = 'true';
} else {
    $carousel_dir = 'false';
}
$widget->add_render_attribute( 'carousel', [
    'class' => 'ct-slick-carousel ct-arrow-middle',
    'data-arrows' => $arrows,
    'data-dots' => $dots,
    'data-pauseOnHover' => $pause_on_hover,
    'data-autoplay' => $autoplay,
    'data-autoplaySpeed' => $autoplay_speed,
    'data-infinite' => $infinite,
    'data-speed' => $speed,
    'data-colxs' => $col_xs,
    'data-colsm' => $col_sm,
    'data-colmd' => $col_md,
    'data-collg' => $col_lg,
    'data-colxl' => $col_xl,
    'data-dir' => $carousel_dir,
    'data-slidesToScroll' => $slides_to_scroll,
    'data-appendArrows' => '#append-arrows-' . $html_id,
] );
$img_size = '600x400';
if(!empty($settings['img_size'])) {
    $img_size = $settings['img_size'];
}
?>
<?php if(isset($settings['image']) && !empty($settings['image']) && count($settings['image'])): ?>
    <div id="<?php echo esc_attr($html_id) ?>" class="ct-gallery-carousel2 ct-slick-slider slick-dots-style3">
        <div <?php ct_print_html($widget->get_render_attribute_string( 'inner' )); ?>>
            <div <?php ct_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <?php foreach ($settings['image'] as $value): 
                    $img = ct_get_image_by_size( array(
                        'attach_id'  => $value['id'],
                        'thumb_size' => $img_size,
                    ));
                    $thumbnail = $img['thumbnail']; 
                    $thumbnail_url = wp_get_attachment_image_src($value['id'], 'full');
                    ?>
                    <div class="slick-slide">
                        <a href="<?php echo esc_url($thumbnail_url[0]); ?>">
                            <?php echo wp_kses_post($thumbnail); ?>
                        </a>
                    </div>
                <?php endforeach; ?>
            </div>
            <div id="<?php echo esc_attr('append-arrows-' . $html_id); ?>" class="append-arrows-custom"></div>
        </div>
        <?php if( ! empty( $image_small['url'] ) ) : 
            $img_small  = ct_get_image_by_size( array(
                'attach_id'  => $image_small['id'],
                'thumb_size' => 'full',
            ) );
            $thumbnail_small    = $img_small['thumbnail'];
            ?>
            <div class="img-circle">
                <?php echo wp_kses_post($thumbnail_small); ?>        
            </div>
        <?php endif; ?>
    </div>
<?php endif; ?>
