<?php

$default_settings = [
    'col_xl' => '4',
    'col_lg' => '4',
    'col_md' => '3',
    'col_sm' => '2',
    'col_xs' => '1',
    'content_list2' => '',
    'thumbnail_size' => '',
    'thumbnail_custom_dimension' => '',
    'ct_animate' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);
$col_xl = 12 / intval($col_xl);
$col_lg = 12 / intval($col_lg);
$col_md = 12 / intval($col_md);
$col_sm = 12 / intval($col_sm);
$col_xs = 12 / intval($col_xs);
$grid_sizer = "col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
$item_class = "grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
if($thumbnail_size != 'custom'){
    $img_size = $thumbnail_size;
}
elseif(!empty($thumbnail_custom_dimension['width']) && !empty($thumbnail_custom_dimension['height'])){
    $img_size = $thumbnail_custom_dimension['width'] . 'x' . $thumbnail_custom_dimension['height'];
}
else {
    $img_size = '270x374';
}
?>
<?php if(isset($content_list2) && !empty($content_list2) && count($content_list2)): ?>
    <div class="ct-grid ct-team ct-team-grid2">
        <div class="ct-grid-inner ct-grid-masonry row animate-time" data-gutter="7">
            <?php foreach ($content_list2 as $key => $value):
    			$title = isset($value['title']) ? $value['title'] : '';
                $position = isset($value['position']) ? $value['position'] : '';
    			$image = isset($value['image']) ? $value['image'] : '';
                $link = isset($value['link']) ? $value['link'] : '';
    			$img = ct_get_image_by_size( array(
                    'attach_id'  => $image['id'],
                    'thumb_size' => $img_size,
                    'class' => 'no-lazyload',
                ));
                $thumbnail = $img['thumbnail'];
                $link_key = $widget->get_repeater_setting_key( 'title', 'value', $key );
                if ( ! empty( $link['url'] ) ) {
                    $widget->add_render_attribute( $link_key, 'href', $link['url'] );

                    if ( $link['is_external'] ) {
                        $widget->add_render_attribute( $link_key, 'target', '_blank' );
                    }

                    if ( $link['nofollow'] ) {
                        $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                    }
                }
                $link_attributes = $widget->get_render_attribute_string( $link_key );
            	?>
                <div class="<?php echo esc_attr($item_class); ?>">
                    <div class="item--inner <?php echo esc_attr($ct_animate); ?>" data-wow-duration="1.2s">
                    	<?php if(!empty($image)) { ?>
                            <div class="item--image">
                                <?php if ( ! empty( $link['url'] ) ) { ?><a <?php echo implode( ' ', [ $link_attributes ] ); ?>><?php } ?><?php echo wp_kses_post($thumbnail); ?><?php if ( ! empty( $link['url'] ) ) { ?></a><?php } ?>
                            </div>
                        <?php } ?>
                        <div class="item--holder">
                            <div class="inner-holder">
                                <div class="bg-svg bg-svg1">
                                    <?php get_template_part( 'template-parts/svgs/team_2' ); ?>
                                </div>
                                <div class="bg-svg bg-svg2">
                                    <?php get_template_part( 'template-parts/svgs/team_1' ); ?>
                                </div>
                                 <h4 class="item--title">    
                                    <?php if ( ! empty( $link['url'] ) ) { ?><a <?php echo implode( ' ', [ $link_attributes ] ); ?>><?php } ?><?php echo ct_print_html($title); ?><?php if ( ! empty( $link['url'] ) ) { ?></a><?php } ?>
                                </h4>
                                <div class="item--position"><?php echo ct_print_html($position); ?></div>
                                <?php if ( ! empty( $link['url'] ) ) { ?>
                                    <a class="btn-icon" <?php echo implode( ' ', [ $link_attributes ] ); ?>>
                                        <i class="caseicon-double-chevron-right"></i>
                                    </a>
                                <?php } ?>
                            </div>
                        </div>
                   </div>
                </div>
            <?php endforeach; ?>
            <div class="grid-sizer <?php echo esc_attr($grid_sizer); ?>"></div>
        </div>
    </div>
<?php endif; ?>
