<?php
$default_settings = [
    'banner_icon' => '',
    'banner_image' => '',
    'banner_title' => '',
    'banner_desc' => '',
    'counter_number' => '',
    'counter_title' => '',
    'ct_animate' => '',
    'ct_animate_delay' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);
$is_new = \Elementor\Icons_Manager::is_migration_allowed();
if(!empty($banner_image['id'])) : 

	$img = ct_get_image_by_size( array(
		'attach_id'  => $banner_image['id'],
		'thumb_size' => '800x800',
	));
	$thumbnail = $img['thumbnail'];

	?>
	<div class="ct-banner layout4 <?php echo esc_attr($ct_animate); ?>" data-wow-delay="<?php echo esc_attr($ct_animate_delay); ?>ms">
		<div class="ct-banner-inner">
			<div class="ct-banner-image">
				<?php echo wp_kses_post($thumbnail); ?>
			</div>
			<div class="ct-banner-counter">
				<div class="ct-counter-number">
	                <?php if(!empty($settings['prefix'])) : ?>
	                    <span class="ct-counter-number-prefix"><?php echo ct_print_html($settings['prefix']); ?></span>
	                <?php endif; ?>
					<div class="ct-counter-number-value" data-duration="2000" data-to-value="<?php echo esc_attr($counter_number); ?>" data-delimiter=""></div>
					<?php if(!empty($settings['suffix'])) : ?>
                    	<span class="ct-counter-number-suffix"><?php echo ct_print_html($settings['suffix']); ?></span>
                	<?php endif; ?>
				</div>
				<div class="ct-counter-title el-empty"><?php echo esc_attr($counter_title); ?></div>
			</div>
            <?php if( ! empty( $image_small['url'] ) ) : 
                $img_small  = ct_get_image_by_size( array(
                    'attach_id'  => $image_small['id'],
                    'thumb_size' => '255x210',
                ) );
                $thumbnail_small    = $img_small['thumbnail'];
                ?>
                <div class="ct-image-small">
                    <?php echo wp_kses_post($thumbnail_small); ?>
                </div>
            <?php endif; ?>
		</div>
	</div>
<?php endif; ?>