<?php
$default_settings = [
    'info_box' => '',
    'icon_color' => '',
    'effect_type' => 'icon-bounce',
    'ct_animate' => '',
    'layout_active' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);
$widget->add_render_attribute( 'selected_icon', 'class' );
$has_icon = ! empty( $settings['selected_icon'] );
if ( $has_icon ) {
    $widget->add_render_attribute( 'i', 'class', $settings['selected_icon'] );
    $widget->add_render_attribute( 'i', 'aria-hidden', 'true' );
}

$is_new = \Elementor\Icons_Manager::is_migration_allowed();
$html_id = ct_get_element_id($settings);
?>

<div id="<?php echo esc_attr($html_id); ?>" class="ct-info-box layout2 <?php echo esc_attr($ct_animate); ?>" data-wow-delay="<?php echo esc_attr($settings['ct_animate_delay']); ?>ms">
    <div class="inner-box <?php echo esc_attr( $layout_active ); ?>">
        <?php if ( $settings['icon_type'] == 'icon' && $has_icon ) : ?>
            <div class="item--icon <?php echo esc_attr( $effect_type ); ?>">
                <?php if($is_new):
                    \Elementor\Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true' ] );
                    else: ?>
                    <i <?php ct_print_html($widget->get_render_attribute_string( 'i' )); ?>></i>
                <?php endif; ?>
            </div>
        <?php endif; ?>
        <?php if ( $settings['icon_type'] == 'image' && !empty($settings['icon_image']['id']) ) : ?>
            <div class="item--icon <?php echo esc_attr( $effect_type ); ?>">
                <?php $img_icon  = ct_get_image_by_size( array(
                        'attach_id'  => $settings['icon_image']['id'],
                        'thumb_size' => 'full',
                    ) );
                    $thumbnail_icon    = $img_icon['thumbnail'];
                echo ct_print_html($thumbnail_icon); ?>
            </div>
        <?php endif; ?>
        <div class="item--meta">
            <?php if(isset($settings['info_box']) && !empty($settings['info_box']) && count($settings['info_box'])): ?>
                <ul class="list-row">
                    <?php
                        foreach ($settings['info_box'] as $key => $ct_info):
                            $link_key = $widget->get_repeater_setting_key( 'title', 'value', $key );
                            if ( ! empty( $ct_info['link']['url'] ) ) {
                                $widget->add_render_attribute( $link_key, 'href', $ct_info['link']['url'] );

                                if ( $ct_info['link']['is_external'] ) {
                                    $widget->add_render_attribute( $link_key, 'target', '_blank' );
                                }

                                if ( $ct_info['link']['nofollow'] ) {
                                    $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                                }
                            }
                            $link_attributes = $widget->get_render_attribute_string( $link_key );
                            ?>
                            <li class="item--contact-info">
                                <?php if ( ! empty( $ct_info['link']['url'] ) ) { ?><a <?php echo implode( ' ', [ $link_attributes ] ); ?>><?php } ?>
                                    <span class="ct-contact-content">
                                       <?php echo ct_print_html($ct_info['content'])?>
                                    </span>
                                <?php if ( ! empty( $ct_info['link']['url'] ) ) { ?></a><?php } ?>
                           </li>
                    <?php endforeach; ?>
                </ul>
            <?php endif; ?>
        </div>
    </div>
</div>