<?php
$default_settings = [
    'image' => '',
    'img_size' => '',

    'title' => '',
    'title_tag' => 'h3',
    'style' => 'st-default',
    'sub_title' => '',

    'team_info' => '',
    'icons' => '',
    'ct_animate' => '',
    'ct_animate_delay' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);
$has_icon = ! empty( $settings['ct_icon'] );
if ( $has_icon ) {
    $widget->add_render_attribute( 'i', 'class', $settings['ct_icon'] );
    $widget->add_render_attribute( 'i', 'aria-hidden', 'true' );
}
$is_new = \Elementor\Icons_Manager::is_migration_allowed();

$has_icon2 = ! empty( $settings['ct_icon2'] );
if ( $has_icon2 ) {
    $widget->add_render_attribute( 'i', 'class', $settings['ct_icon2'] );
    $widget->add_render_attribute( 'i', 'aria-hidden', 'true' );
}
$is_new2 = \Elementor\Icons_Manager::is_migration_allowed();

$html_id = ct_get_element_id($settings);

$size = 'full';
if(!empty($img_size)) {
    $size = $img_size;
} else {
    $size = 'full';
}
$img  = ct_get_image_by_size( array(
    'attach_id'  => $image['id'],
    'thumb_size' => $size,
) );
$thumbnail    = $img['thumbnail'];
if ( ! empty( $settings['btn_link']['url'] ) ) {
    $widget->add_render_attribute( 'btn_link', 'href', $settings['btn_link']['url'] );

    if ( $settings['btn_link']['is_external'] ) {
        $widget->add_render_attribute( 'btn_link', 'target', '_blank' );
    }

    if ( $settings['btn_link']['nofollow'] ) {
        $widget->add_render_attribute( 'btn_link', 'rel', 'nofollow' );
    }
}

?>
<div id="<?php echo esc_attr($html_id); ?>" class="ct-team-info" data-wow-duration="1.2s">
    <?php if ($image['url']) { ?>
        <div class="wp-feature">
            <?php if ( ! empty( $image['url'] ) ) { echo wp_kses_post($thumbnail); } ?>
        </div>
    <?php } ?>
    <div class="wp-meta">
        <div class="inner-meta">
            <div class="wp-title">
                <<?php echo esc_attr($title_tag); ?> class="item--title case-animate-time <?php echo esc_attr($style); ?> <?php if($ct_animate != 'case-fade-in-up') { echo esc_attr($ct_animate); } ?>" data-wow-delay="<?php echo esc_attr($ct_animate_delay); ?>ms">
                    <?php if($ct_animate == 'case-fade-in-up') {
                        $arr_str = explode(' ', $title);
                        foreach ($arr_str as $index => $value) {
                            $arr_str[$index] = '<span class="slide-in-container"><span class="d-inline-block wow '.$ct_animate.'">' . $value . '</span></span>';
                        }
                        $str = implode(' ', $arr_str);
                        echo ct_print_html($str);
                    } else {
                        echo '<span>';
                            echo wp_kses_post($title);
                        echo '</span>';
                    } ?>
                </<?php echo esc_attr($title_tag); ?>>
                <?php if(!empty($sub_title)) : ?>
                    <div class="item--sub-title">
                        <span>
                            <?php echo esc_attr($sub_title); ?>
                        </span>
                    </div>
                <?php endif; ?>
            </div>
            <?php if(isset($settings['team_info']) && !empty($settings['team_info']) && count($settings['team_info'])): ?>
                <ul class="ct-list-info">
                    <?php
                        foreach ($settings['team_info'] as $key => $ct_info):
                            $icon_key2 = $widget->get_repeater_setting_key( 'ct_icon2', 'contact_info', $key );

                            $has_icon2 = ! empty( $ct_info['ct_icon2'] );
                            $widget->add_render_attribute( $icon_key2, [
                                'class' => $ct_info['ct_icon2'],
                                'aria-hidden' => 'true',
                            ] );

                            $link_key = $widget->get_repeater_setting_key( 'list', 'value', $key );
                            if ( ! empty( $ct_info['item_link']['url'] ) ) {
                                $widget->add_render_attribute( $link_key, 'href', $ct_info['item_link']['url'] );

                                if ( $ct_info['item_link']['is_external'] ) {
                                    $widget->add_render_attribute( $link_key, 'target', '_blank' );
                                }

                                if ( $ct_info['item_link']['nofollow'] ) {
                                    $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                                }
                            }
                            $link_attributes = $widget->get_render_attribute_string( $link_key );
                        ?>
                        <li>
                            <?php if( $link_attributes) { ?><a <?php echo implode( ' ', [ $link_attributes ] ); ?>><?php } ?>
                                <?php if ( $has_icon2 ) : ?>
                                    <span class="ct-contact-icon">
                                        <?php
                                            if($is_new2):
                                                \Elementor\Icons_Manager::render_icon( $ct_info['ct_icon2'], [ 'aria-hidden' => 'true' ] );
                                        ?>
                                        <?php else: ?>
                                            <i <?php ct_print_html($widget->get_render_attribute_string( $icon_key2 )); ?>></i>
                                        <?php endif; ?>
                                    </span>
                                <?php endif; ?>
                                <span class="ct-content">
                                   <?php echo ct_print_html($ct_info['content'])?>
                                </span>
                            <?php if( $link_attributes) { ?></a><?php } ?>
                       </li>
                    <?php endforeach; ?>
                </ul>
            <?php endif; ?>
            <?php if(isset($icons) && !empty($icons) && count($icons)): ?>
                <div class="ct-social">
                    <?php if(!empty($settings['btn_text'])) : ?>
                        <div class="item--button">
                            <a <?php ct_print_html($widget->get_render_attribute_string( 'btn_link' )); ?> class="btn-contact">
                                <?php echo esc_attr($settings['btn_text']); ?>
                                <span><i class="flaticon-next"></i></span>
                            </a>
                        </div>
                    <?php endif; ?>
                    <?php foreach ($settings['icons'] as $key => $value):
                        $icon_key = $widget->get_repeater_setting_key( 'ct_icon', 'icons', $key );
                        $has_icon = ! empty( $value['ct_icon'] );
                        $widget->add_render_attribute( $icon_key, [
                            'class' => $value['ct_icon'],
                            'aria-hidden' => 'true',
                        ] );

                        $link_key = $widget->get_repeater_setting_key( 'title', 'value', $key );
                        if ( ! empty( $value['icon_link']['url'] ) ) {
                            $widget->add_render_attribute( $link_key, 'href', $value['icon_link']['url'] );

                            if ( $value['icon_link']['is_external'] ) {
                                $widget->add_render_attribute( $link_key, 'target', '_blank' );
                            }

                            if ( $value['icon_link']['nofollow'] ) {
                                $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                            }
                        }
                        $link_attributes = $widget->get_render_attribute_string( $link_key ); ?>
                        <?php if ( $has_icon ) : ?>
                            <a class="<?php echo esc_attr($html_id.'-'.$key); ?>" <?php echo implode( ' ', [ $link_attributes ] ); ?>>
                                <?php
                                    if($is_new):
                                        \Elementor\Icons_Manager::render_icon( $value['ct_icon'], [ 'aria-hidden' => 'true' ] );
                                ?>
                                <?php else: ?>
                                    <i <?php ct_print_html($widget->get_render_attribute_string( $icon_key )); ?>></i>
                                <?php endif; ?>
                            </a>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>