<?php
ct_add_custom_widget(
    array(
        'name' => 'ct_banner_poster',
        'title' => esc_html__('CT Banner Poster', 'industo'),
        'icon' => 'eicon-posts-ticker',
        'categories' => array(Case_Theme_Core::CT_CATEGORY_NAME),
        'scripts' => array(
            'elementor-waypoints',
            'jquery-numerator',
            'ct-counter-widget-js',
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'layout_section',
                    'label' => esc_html__('Layout', 'industo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'industo' ),
                            'type' => Case_Theme_Core::LAYOUT_CONTROL,
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'industo' ),
                                    'image' => get_template_directory_uri() . '/elementor/templates/widgets/ct_banner_poster/layout-image/layout1.jpg'
                                ],
                                '2' => [
                                    'label' => esc_html__('Layout 2', 'industo' ),
                                    'image' => get_template_directory_uri() . '/elementor/templates/widgets/ct_banner_poster/layout-image/layout2.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'industo'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'title_text',
                            'label' => esc_html__('Title', 'industo' ),
                            'type' => \Elementor\Controls_Manager::TEXTAREA,
                            'placeholder' => esc_html__('Enter your title', 'industo' ),
                            'rows' => '3',
                            'label_block' => true,
                        ),
                        array(
                            'name' => 'btn_text',
                            'label' => esc_html__('Button Text', 'industo' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                        ),
                        array(
                            'name' => 'btn_link',
                            'label' => esc_html__('Button Link', 'industo' ),
                            'type' => \Elementor\Controls_Manager::URL,
                        ),
                        array(
                            'name' => 'video_link',
                            'label' => esc_html__('Video Link', 'industo' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                        ),

                        array(
                            'name' => 'phone_label',
                            'label' => esc_html__('Phone Label', 'industo' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                        ),
                        array(
                            'name' => 'phone_text',
                            'label' => esc_html__('Phone Number', 'industo' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                        ),
                        array(
                            'name' => 'phone_link',
                            'label' => esc_html__('Phone Link', 'industo' ),
                            'type' => \Elementor\Controls_Manager::URL,
                        ),
                    ),
                ),
                array(
                    'name' => 'source_section',
                    'label' => esc_html__('Box Settings', 'industo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'banner_image',
                            'label' => esc_html__('Background Image', 'industo' ),
                            'type' => \Elementor\Controls_Manager::MEDIA,
                        ),
                        array(
                            'name' => 'image_small',
                            'label' => esc_html__('Image', 'industo' ),
                            'type' => \Elementor\Controls_Manager::MEDIA,
                            'condition' => [
                                'layout' => ['1'],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'animate_section',
                    'label' => esc_html__('Animate Settings', 'industo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'ct_animate',
                            'label' => esc_html__('Case Animate', 'industo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => industo_animate(),
                            'default' => '',
                        ),
                        array(
                            'name' => 'ct_animate_delay',
                            'label' => esc_html__('Animate Delay', 'industo' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => '0',
                            'description' => 'Enter number. Default 0ms',
                        ),
                    ),
                ),
                array(
                    'name' => 'section_title_style',
                    'label' => esc_html__('Title Style', 'industo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'title_color',
                            'label' => esc_html__('Title Color', 'industo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .box-content .ct--title' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'title_typography',
                            'label' => esc_html__('Title Typography', 'industo' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .box-content .ct--title',
                        ),
                    ),
                ),
                array(
                    'name' => 'section_button_style',
                    'label' => esc_html__('Button Style', 'industo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'btn_color',
                            'label' => esc_html__('Button Color', 'industo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .item-box .btn' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'btn_typography',
                            'label' => esc_html__('Title Typography', 'industo' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .item-box .btn',
                        ),
                        array(
                            'name' => 'bg_btn_color',
                            'label' => esc_html__('Background Button Color', 'industo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .item-box .btn' => 'background-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'bg_btn_hv',
                            'label' => esc_html__('Background Color Hover', 'industo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .item-box .btn:hover' => 'background-color: {{VALUE}};',
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_video_style',
                    'label' => esc_html__('Video Style', 'industo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'video_color',
                            'label' => esc_html__('Video Icon Color', 'industo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .item-box .ct-video-button' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'video_bg_color',
                            'label' => esc_html__('Background Video Color', 'industo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .item-box .ct-video-button' => 'background-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'video_bg_hv',
                            'label' => esc_html__('Background Color Hover', 'industo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .item-box .ct-video-button:hover' => 'background-color: {{VALUE}};',
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_phone_style',
                    'label' => esc_html__('Phone Style', 'industo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'phone_color',
                            'label' => esc_html__('Phone Color', 'industo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .item-box a.btn-phone' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .item-box label' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'phone_color_hover',
                            'label' => esc_html__('Phone Color', 'industo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .item-box a.btn-phone:hover' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'phone_typography',
                            'label' => esc_html__('Title Typography', 'industo' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .item-box a.btn-phone, {{WRAPPER}} .item-box label',
                        ),
                    ),
                ),
            ),
        ),
    ),
    get_template_directory() . '/elementor/core/widgets/'
);