<?php
$default_settings = [
    'banner_image' => '',
    'ct_animate' => '',
    'ct_animate_delay' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);

$html_id = ct_get_element_id($settings);
// Button Link
if ( ! empty( $settings['btn_link']['url'] ) ) {
    $widget->add_render_attribute( 'btn_link', 'href', $settings['btn_link']['url'] );

    if ( $settings['btn_link']['is_external'] ) {
        $widget->add_render_attribute( 'btn_link', 'target', '_blank' );
    }

    if ( $settings['btn_link']['nofollow'] ) {
        $widget->add_render_attribute( 'btn_link', 'rel', 'nofollow' );
    }
}
// Phone Link
if ( ! empty( $settings['phone_link']['url'] ) ) {
    $widget->add_render_attribute( 'phone_link', 'href', $settings['phone_link']['url'] );

    if ( $settings['phone_link']['is_external'] ) {
        $widget->add_render_attribute( 'phone_link', 'target', '_blank' );
    }

    if ( $settings['phone_link']['nofollow'] ) {
        $widget->add_render_attribute( 'phone_link', 'rel', 'nofollow' );
    }
}

$is_new = \Elementor\Icons_Manager::is_migration_allowed();
if(!empty($banner_image['id'])) : 

	$img = ct_get_image_by_size( array(
		'attach_id'  => $banner_image['id'],
		'thumb_size' => '1170x600',
	));
	$thumbnail = $img['thumbnail'];

	?>
	<div class="ct-banner-poster layout1 <?php echo esc_attr($ct_animate); ?>" data-wow-delay="<?php echo esc_attr($ct_animate_delay); ?>ms">
		<div class="ct-banner-inner">
            <div class="ct-circle circle1 bounce-2"></div>
            <div class="ct-circle circle2"></div>
			<div class="ct-bg-image" style="background-image: url(<?php echo esc_url($banner_image['url']); ?>);"></div>
            <div class="box-content">
                <h4 class="ct--title">
                    <?php echo ct_print_html($settings['title_text']); ?>
                </h4>
                <div class="list-meta">
                    <?php if(!empty($settings['btn_text'])) : ?>
                        <div class="item-box">
                            <a <?php ct_print_html($widget->get_render_attribute_string( 'btn_link' )); ?> class="btn btn-primary">
                                <?php echo esc_attr($settings['btn_text']); ?>
                            </a>
                        </div>
                    <?php endif; ?>
                    <?php if(!empty($settings['video_link'])) : ?>
                        <div class="item-box">
                            <a class="ct-video-button" href="<?php echo esc_url($settings['video_link']); ?>">
                                <i class="fa fa-play"></i>
                            </a>
                        </div>
                    <?php endif; ?>
                    <div class="item-box">
                        <label><?php echo ct_print_html($settings['phone_label']); ?></label>
                        <a class="btn-phone" <?php ct_print_html($widget->get_render_attribute_string( 'phone_link' )); ?>>
                            <?php echo ct_print_html($settings['phone_text']); ?>
                        </a>
                    </div>
                </div>
            </div>
            <?php if( ! empty( $image_small['url'] ) ) : 
                $img_small  = ct_get_image_by_size( array(
                    'attach_id'  => $image_small['id'],
                    'thumb_size' => 'full',
                ) );
                $thumbnail_small    = $img_small['thumbnail'];
                ?>
                <div class="box-feature">
                    <?php echo wp_kses_post($thumbnail_small); ?>        
                </div>
            <?php endif; ?>
		</div>
	</div>
<?php endif; ?>