<?php
$default_settings = [
    'title_text' => '',
    'sub_title' => '',
    'text_holder' => '',
    'btn_bg_color' => '',
    'btn_bg_color_gradient' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings); 
$html_id = ct_get_element_id($settings);
$source = $widget->get_setting('source', '');
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 6);
$post_ids = $widget->get_setting('post_ids', '');
extract(ct_get_posts_of_grid('post', [
    'source' => $source,
    'orderby' => $orderby,
    'order' => $order,
    'limit' => $limit,
    'post_ids' => $post_ids,
]));

$widget->add_render_attribute( 'inner', [
    'class' => 'ct-carousel-inner',
] );

$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');


$arrows = $widget->get_setting('arrows');
$dots = $widget->get_setting('dots');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite');
$speed = $widget->get_setting('speed', '500');

$show_author = $widget->get_setting('show_author');
$show_date = $widget->get_setting('show_date');
$show_comment = $widget->get_setting('show_comment');
$show_button = $widget->get_setting('show_button');
$button_text = $widget->get_setting('button_text');

if (is_rtl()) {
    $carousel_dir = 'true';
} else {
    $carousel_dir = 'false';
}

$widget->add_render_attribute( 'carousel', [
    'class' => 'ct-slick-carousel slick-shadow',
    'data-arrows' => $arrows,
    'data-dots' => $dots,
    'data-pauseOnHover' => $pause_on_hover,
    'data-autoplay' => $autoplay,
    'data-autoplaySpeed' => $autoplay_speed,
    'data-infinite' => $infinite,
    'data-speed' => $speed,
    'data-dir' => $carousel_dir,
    'data-colxs' => $col_xs,
    'data-colsm' => $col_sm,
    'data-colmd' => $col_md,
    'data-collg' => $col_lg,
    'data-colxl' => $col_xl,
    'data-slidesToScroll' => $slides_to_scroll,
    'data-appendArrows' => '#append-arrows-' . $html_id,
    'data-appendDots' => '#append-dots-' . $html_id,
] );
$widget->add_inline_editing_attributes( 'title_text', 'none' );
$images_size = '500x425';
if(!empty($img_size)) {
    $images_size = $img_size;
}
$btn_g_rotate = '90deg';
if($settings['btn_gradient_rotate']['size']) {
    $btn_g_rotate = $settings['btn_gradient_rotate']['size'].'deg';
}
if (is_array($posts)): ?>
<div id="<?php echo esc_attr($html_id) ?>" class="ct-blog-carousel-layout4 ct-slick-slider">
    <div class="ct-inline-css"  data-css="
        <?php if( !empty($settings['btn_bg_color']) && !empty($settings['btn_bg_color_gradient']) ) : ?>
            #<?php echo esc_attr($html_id) ?>.ct-blog-carousel-layout4 .item--readmore a {
                background-image: -webkit-linear-gradient(<?php echo esc_attr($btn_g_rotate); ?>, <?php echo esc_attr($settings['btn_bg_color']); ?> 0%, <?php echo esc_attr($settings['btn_bg_color_gradient']); ?> 50%, <?php echo esc_attr($settings['btn_bg_color']); ?>) !important;
                background-image: -moz-linear-gradient(<?php echo esc_attr($btn_g_rotate); ?>, <?php echo esc_attr($settings['btn_bg_color']); ?> 0%, <?php echo esc_attr($settings['btn_bg_color_gradient']); ?> 50%, <?php echo esc_attr($settings['btn_bg_color']); ?>) !important;
                background-image: -ms-linear-gradient(<?php echo esc_attr($btn_g_rotate); ?>, <?php echo esc_attr($settings['btn_bg_color']); ?> 0%, <?php echo esc_attr($settings['btn_bg_color_gradient']); ?> 50%, <?php echo esc_attr($settings['btn_bg_color']); ?>) !important;
                background-image: -o-linear-gradient(<?php echo esc_attr($btn_g_rotate); ?>, <?php echo esc_attr($settings['btn_bg_color']); ?> 0%, <?php echo esc_attr($settings['btn_bg_color_gradient']); ?> 50%, <?php echo esc_attr($settings['btn_bg_color']); ?>) !important;
                background-image: linear-gradient(<?php echo esc_attr($btn_g_rotate); ?>, <?php echo esc_attr($settings['btn_bg_color']); ?> 0%, <?php echo esc_attr($settings['btn_bg_color_gradient']); ?> 50%, <?php echo esc_attr($settings['btn_bg_color']); ?>) !important;
                filter: progid:DXImageTransform.Microsoft.gradient(startColorStr='<?php echo esc_attr($settings['btn_bg_color']); ?>', endColorStr='<?php echo esc_attr($settings['btn_bg_color_gradient']); ?>') !important;
                background-color: transparent !important;

            }
        <?php endif; ?>">
    </div>
    <div <?php ct_print_html($widget->get_render_attribute_string( 'inner' )); ?>>
        <div class="container-custom">
            <div class="wp-meta">
                <?php if(!empty($text_holder)) : ?>
                    <h4 class="title-holder">
                      <?php echo wp_kses_post($text_holder); ?>
                    </h4>
                <?php endif; ?>
                <?php if(!empty($sub_title)) : ?>
                    <div class="el--sub-title">
                        <?php echo wp_kses_post($sub_title); ?>
                    </div>
                <?php endif; ?>
                <?php if(!empty($title_text)) : ?>
                    <h3 class="el--title">
                        <?php echo ct_print_html($settings['title_text']); ?>
                    </h3>
                <?php endif; ?>
            </div>
            <div id="<?php echo esc_attr('append-arrows-' . $html_id); ?>" class="append-arrows-custom">
            </div>
        </div>
        <div <?php ct_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
        <?php
            foreach ($posts as $post):
            $author = get_user_by('id', $post->post_author); 
            $comment_count = get_comments_number($post->ID); 
            if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)):  
            $img_id       = get_post_thumbnail_id( $post->ID );
            $img          = ct_get_image_by_size( array(
                'attach_id'  => $img_id,
                'thumb_size' => $images_size,
            ) );
            $thumbnail    = $img['thumbnail'];
            ?>
            <div class="carousel-item slick-slide">
                <div class="grid-item-inner <?php echo esc_attr($settings['ct_animate']); ?>">
                    <div class="item--featured">
                        <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo wp_kses_post($thumbnail); ?></a>
                        <?php if( $show_date == 'true' || $show_author == 'true'  || $show_comment == 'true' ) : ?>
                            <ul class="item--meta">
                                <?php if($show_date == 'true'): ?>
                                    <li class="item-date"><i class="caseicon-calendar"></i>
                                        <?php $year = get_the_date('Y', $post->ID);?>
                                        <span><?php echo get_the_date('d', $post->ID); ?></span>
                                        <span><?php echo get_the_date('M', $post->ID); ?> <?php echo esc_html($year); ?></span>
                                    </li>
                                <?php endif; ?>
                                <?php if($show_author == 'true'): ?>
                                    <li class="item-author">
                                        <i class="caseicon-user"></i><a href="<?php echo esc_url(get_author_posts_url($post->post_author, $author->user_nicename)); ?>"><?php echo esc_html($author->display_name); ?></a>
                                    </li>
                                <?php endif; ?>

                                <?php if( $settings['show_comment'] == 'true' ) { ?>
                                    <li class="item--comment">
                                        <a href="<?php the_permalink(); ?>">
                                            <i class="caseicon-comment"></i>
                                            <?php
                                                $comment_count = get_comments_number( $post->ID );
                                                if ( 1 === intval($comment_count) ) {
                                                    echo esc_html__( '1', 'industo' );
                                                } else {
                                                    echo esc_attr( $comment_count );
                                                }
                                            ?>
                                        </a>
                                    </li>
                                <?php } ?>
                            </ul>
                        <?php endif; ?>
                    </div>
                    <div class="item--body">
                        <h3 class="item--title"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_attr(get_the_title($post->ID)); ?></a></h3>
                        <?php if($show_button == 'true') : ?>
                            <div class="item--readmore">
                                <a class="btn-readmore" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                    <span><?php if(!empty($button_text)) {
                                        echo esc_attr($button_text);
                                    } else {
                                        echo esc_html__('Read More', 'industo');
                                    } ?></span>
                                    <i>+</i>
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endif;
        endforeach; ?>
        </div>
    </div>
</div>
<?php endif; ?>