<?php
$default_settings = [
    'download2' => '',
    'box_title'    => '',
    'style_box' => 'box-nomarl',
    'ct_animate' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);

$has_icon = ! empty( $settings['ct_icon'] );
if ( $has_icon ) {
    $widget->add_render_attribute( 'i', 'class', $settings['ct_icon'] );
    $widget->add_render_attribute( 'i', 'aria-hidden', 'true' );
}
$is_new = \Elementor\Icons_Manager::is_migration_allowed();
?>
<?php if(isset($download2) && !empty($download2) && count($download2)): ?>
    <div class="ct-download layout2 <?php echo esc_attr($style_box.' '.$ct_animate); ?>">
        <?php if ( $box_title ) { ?>
            <h3 class="entry-title">
                <?php echo esc_attr($box_title); ?>    
            </h3>
        <?php } ?>
        <?php foreach ($download2 as $key => $ct_download2):
    		$icon_key = $widget->get_repeater_setting_key( 'ct_icon', 'download2', $key );

    		$has_icon = ! empty( $ct_download2['ct_icon'] );
    		$widget->add_render_attribute( $icon_key, [
                'class' => $ct_download2['ct_icon'],
                'aria-hidden' => 'true',
            ] );
            
        	$link_key = $widget->get_repeater_setting_key( 'title', 'download2', $key );
        	if ( ! empty( $ct_download2['link']['url'] ) ) {
			    $widget->add_render_attribute( $link_key, 'href', $ct_download2['link']['url'] );

			    if ( $ct_download2['link']['is_external'] ) {
			        $widget->add_render_attribute( $link_key, 'target', '_blank' );
			    }

			    if ( $ct_download2['link']['nofollow'] ) {
			        $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
			    }
			}
			$link_attributes = $widget->get_render_attribute_string( $link_key );
        	?>
            <div class="item--download">
            	<a <?php echo implode( ' ', [ $link_attributes ] ); ?>>
	            	<?php ct_print_html(nl2br($ct_download2['title'])); ?>
	            	<?php if(!empty($ct_download2['file_type'])) : ?>
	            		<span class="download-file-type"><?php echo esc_attr($ct_download2['file_type']); ?></span>
	            	<?php endif; ?>
	            	<?php if ( $ct_download2['icon_type'] == 'icon' && $has_icon ) : ?>
				        <span class="ct-contact-icon">
			                <?php
			                    if($is_new):
			                        \Elementor\Icons_Manager::render_icon( $ct_download2['ct_icon'], [ 'aria-hidden' => 'true' ] );
			                ?>
			                <?php else: ?>
			                    <i <?php ct_print_html($widget->get_render_attribute_string( $icon_key )); ?>></i>
			                <?php endif; ?>
				        </span>
				    <?php endif; ?>
	                <?php if ( $ct_download2['icon_type'] == 'image' && !empty($ct_download2['icon_image']) ) : 
	                    $img_icon  = ct_get_image_by_size( array(
	                        'attach_id'  => $ct_download2['icon_image']['id'],
	                        'thumb_size' => 'full',
	                    ) );
	                    $thumbnail_icon    = $img_icon['thumbnail'];
	                    ?>
	                    <span class="ct-contact-icon">
	                        <?php echo ct_print_html($thumbnail_icon); ?>
	                    </span>
	                <?php endif; ?>
	            </a>
           </div>
        <?php endforeach; ?>
    </div>
<?php endif; ?>