<?php
$default_settings = [
    'phone_link' => '',
    'effect_type' => 'icon-bounce',
    'ct_animate' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);
$widget->add_render_attribute( 'selected_icon', 'class' );
$has_icon = ! empty( $settings['selected_icon'] );
if ( $has_icon ) {
    $widget->add_render_attribute( 'i', 'class', $settings['selected_icon'] );
    $widget->add_render_attribute( 'i', 'aria-hidden', 'true' );
}

$is_new = \Elementor\Icons_Manager::is_migration_allowed();
$html_id = ct_get_element_id($settings);

if ( ! empty( $phone_link['url'] ) ) {
    $widget->add_render_attribute( 'phone_link', 'href', $phone_link['url'] );

    if ( $phone_link['is_external'] ) {
        $widget->add_render_attribute( 'phone_link', 'target', '_blank' );
    }

    if ( $phone_link['nofollow'] ) {
        $widget->add_render_attribute( 'phone_link', 'rel', 'nofollow' );
    }
}

$widget->add_inline_editing_attributes( 'phone_text', 'none' );
$widget->add_inline_editing_attributes( 'label', 'none' );
?>
<div id="<?php echo esc_attr($html_id); ?>" class="ct-phone <?php echo esc_attr($ct_animate); ?>" data-wow-duration="1.2s">
    <div class="ct-search-popup"><i class="caseicon-search"></i></div>
    <div class="inner-box">
        <?php if ( $settings['icon_type'] == 'icon' && $has_icon ) : ?>
            <div class="item--icon <?php echo esc_attr( $effect_type ); ?>">
                <?php if($is_new):
                    \Elementor\Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true' ] );
                    else: ?>
                    <i <?php ct_print_html($widget->get_render_attribute_string( 'i' )); ?>></i>
                <?php endif; ?>
            </div>
        <?php endif; ?>
        <?php if ( $settings['icon_type'] == 'image' && !empty($settings['icon_image']['id']) ) : ?>
            <div class="item--icon <?php echo esc_attr( $effect_type ); ?>">
                <?php $img_icon  = ct_get_image_by_size( array(
                        'attach_id'  => $settings['icon_image']['id'],
                        'thumb_size' => 'full',
                    ) );
                    $thumbnail_icon    = $img_icon['thumbnail'];
                echo ct_print_html($thumbnail_icon); ?>
            </div>
        <?php endif; ?>
        <div class="item--meta">
            <div class="item--label">
                <?php echo ct_print_html($settings['label']); ?>
            </div>
            <h3 class="item--phone">
                <?php if ( ! empty( $phone_link['url'] ) ) { ?><a <?php ct_print_html($widget->get_render_attribute_string( 'phone_link' )); ?>><?php } ?>
                    <?php echo ct_print_html($settings['phone_text']); ?>
                <?php if ( ! empty( $phone_link['url'] ) ) { ?></a><?php } ?>
            </h3>
        </div>
    </div>
</div>
