<?php
extract($settings);
$html_id = ct_get_element_id($settings);
$widget->add_render_attribute( 'inner', [
    'class' => 'ct-carousel-inner',
] );

$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');

$arrows = $widget->get_setting('arrows');
$dots = $widget->get_setting('dots');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay', '');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite');
$speed = $widget->get_setting('speed', '500');
if (is_rtl()) {
    $carousel_dir = 'true';
} else {
    $carousel_dir = 'false';
}
$widget->add_render_attribute( 'carousel', [
    'class' => 'ct-slick-carousel ct-arrow-middle',
    'data-arrows' => $arrows,
    'data-dots' => $dots,
    'data-pauseOnHover' => $pause_on_hover,
    'data-autoplay' => $autoplay,
    'data-autoplaySpeed' => $autoplay_speed,
    'data-infinite' => $infinite,
    'data-speed' => $speed,
    'data-colxs' => 1,
    'data-colsm' => 1,
    'data-colmd' => 1,
    'data-collg' => 1,
    'data-colxl' => 1,
    'data-dir' => $carousel_dir,
    'data-slidesToScroll' => 1,
    'data-appendArrows' => '#append-arrows-' . $html_id,
] );
$img_size = '890x520';
if(!empty($settings['img_size'])) {
    $img_size = $settings['img_size'];
}
?>
<?php if(isset($settings['image']) && !empty($settings['image']) && count($settings['image'])): ?>
    <div id="<?php echo esc_attr($html_id) ?>" class="ct-showcase-carousel2 ct-slick-slider">
        <div <?php ct_print_html($widget->get_render_attribute_string( 'inner' )); ?>>
            <div <?php ct_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <?php foreach ($settings['image'] as $value): 
                    $img = ct_get_image_by_size( array(
                        'attach_id'  => $value['id'],
                        'thumb_size' => $img_size,
                    ));
                    $thumbnail = $img['thumbnail']; 
                    $thumbnail_url = wp_get_attachment_image_src($value['id'], 'full');
                    ?>
                    <div class="slick-slide">
                        <div class="inner-item">
                            <a href="<?php echo esc_url($thumbnail_url[0]); ?>">
                                <?php echo wp_kses_post($thumbnail); ?>
                            </a>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            <div id="<?php echo esc_attr('append-arrows-' . $html_id); ?>" class="append-arrows-custom ct-slick-arrow-middle"></div>
        </div>
    </div>
<?php endif; ?>
