<?php
$default_settings = [
    'title_text' => '',
    'sub_title' => '',
];

$settings = array_merge($default_settings, $settings);
extract($settings);

$widget->add_render_attribute( 'inner', [
    'class' => 'ct-carousel-inner',
] );
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');

$show_star = $widget->get_setting('show_star');
$vertical = $widget->get_setting('vertical');
$arrows = $widget->get_setting('arrows');
$dots = $widget->get_setting('dots');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay', '');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite');
$speed = $widget->get_setting('speed', '500');
if (is_rtl()) {
    $carousel_dir = 'true';
} else {
    $carousel_dir = 'false';
}
$widget->add_render_attribute( 'carousel', [
    'class' => 'ct-slick-carousel',
    'data-arrows' => $arrows,
    'data-dots' => $dots,
    'data-centerMode' => 'true',
    'data-pauseOnHover' => $pause_on_hover,
    'data-autoplay' => $autoplay,
    'data-autoplaySpeed' => $autoplay_speed,
    'data-infinite' => $infinite,
    'data-speed' => $speed,
    'data-colxs' => $col_xs,
    'data-colsm' => $col_sm,
    'data-colmd' => $col_md,
    'data-collg' => $col_lg,
    'data-colxl' => $col_xl,
    'data-dir' => $carousel_dir,
    'data-slidesToScroll' => $slides_to_scroll,
    'data-vertical'=> $vertical
] );
if ( ! empty( $settings['el_btn_link']['url'] ) ) {
    $widget->add_render_attribute( 'el_btn_text', 'href', $settings['el_btn_link']['url'] );

    if ( $settings['el_btn_link']['is_external'] ) {
        $widget->add_render_attribute( 'el_btn_text', 'target', '_blank' );
    }

    if ( $settings['el_btn_link']['nofollow'] ) {
        $widget->add_render_attribute( 'el_btn_text', 'rel', 'nofollow' );
    }
}
?>
<?php if(isset($settings['testimonial']) && !empty($settings['testimonial']) && count($settings['testimonial'])): ?>
    <div class="ct-testimonial ct-testimonial-carousel7 ct-slick-slider slick-dots-style2">
        <div <?php ct_print_html($widget->get_render_attribute_string( 'inner' )); ?>>
            <div class="container-custom">
                <div class="wp-meta">
                    <div class="wp-titles">
                        <?php if(!empty($sub_title)) : ?>
                            <div class="el--sub-title">
                                <?php echo wp_kses_post($sub_title); ?>
                            </div>
                        <?php endif; ?>
                        <?php if(!empty($settings['title_text'])) : ?>
                            <h3 class="el--title">
                                <?php echo ct_print_html($settings['title_text']); ?>
                            </h3>
                        <?php endif; ?>
                    </div>
                    <?php if ( ! empty( $settings['el_btn_link']['url'] ) ) { ?>
                        <a class="btn-readmore" <?php ct_print_html($widget->get_render_attribute_string( 'el_btn_text' )); ?>>
                            <span><?php echo esc_html($settings['el_btn_text']); ?></span>
                        </a>
                    <?php } ?>
                </div>
            </div>
            <div <?php ct_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <?php foreach ($settings['testimonial'] as $value): 
                    $title = isset($value['title']) ? $value['title'] : '';
                    $position = isset($value['position']) ? $value['position'] : '';
                    $description = isset($value['description']) ? $value['description'] : '';
                    $image = isset($value['image']) ? $value['image'] : '';
                    $style_star = isset($value['style_star']) ? $value['style_star'] : '';
                    ?>
                        <div class="slick-slide">
                            <div class="item--inner <?php echo esc_attr($settings['ct_animate']); ?>">
                                <?php if(!empty($image['id'])) { 
                                    $img = ct_get_image_by_size( array(
                                        'attach_id'  => $image['id'],
                                        'thumb_size' => '77x77',
                                    ));
                                    $thumbnail = $img['thumbnail']; 
                                    ?>
                                    <div class="item--image">
                                        <?php echo wp_kses_post($thumbnail); ?>
                                    </div>
                                <?php } ?>
                                <div class="item-main">
                                    <?php if(!empty($title)) { ?>
                                        <h3 class="item--title">    
                                            <?php echo esc_attr($title); ?>
                                        </h3>
                                    <?php } ?>
                                    <?php if(!empty($description)) { ?>
                                        <div class="item--description">
                                            <?php echo ct_print_html($description); ?>
                                        </div>
                                    <?php } ?>
                                </div>
                                <div class="item--holder">
                                    <span class="item-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="31" height="24" viewBox="0 0 31 24">
                                          <defs>
                                          </defs>
                                          <text data-name="“" class="cls-1" transform="translate(13.808 76.035) scale(6.246)"><tspan x="0">“</tspan></text>
                                        </svg>
                                    </span>
                                    <div class="item--meta">
                                        <?php if(!empty($title)) { ?>
                                            <h3 class="item--title">    
                                                <?php echo esc_attr($title); ?>
                                            </h3>
                                        <?php } ?>
                                        <?php if(!empty($position)) { ?>
                                            <div class="item--position"><?php echo esc_attr($position); ?></div>
                                        <?php } ?>
                                    </div>
                                    <?php if( $show_star == 'true' ) : ?>
                                        <span class="item-star <?php echo esc_attr( $style_star ); ?>">
                                            <i class="fa fa-star"></i>
                                            <i class="fa fa-star"></i>
                                            <i class="fa fa-star"></i>
                                            <i class="fa fa-star"></i>
                                            <i class="fa fa-star"></i>
                                        </span>
                                    <?php endif; ?>
                                    <?php if(!empty($description)) { ?>
                                        <div class="item--description"><?php echo ct_print_html($description); ?></div>
                                    <?php } ?>
                                </div>
                           </div>
                        </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
<?php endif; ?>