<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @package Industo
 */
$page_404 = industo_get_opt( 'page_404', 'default' );
$page_custom_404 = industo_get_opt( 'page_custom_404' );
$search_field_placeholder = industo_get_opt( 'search_field_placeholder' );
get_header(); ?>
    
    <div class="container content-container">
        <div class="row content-row">
            <div id="primary" class="content-area col-12">
                <main id="main" class="site-main">
                    <?php if($page_404 == 'default') { ?>
                        <section class="error-404">
                            <div class="error-404-content">
                                <div class="box-search">
                                    <h3 class="title-404"><?php echo esc_html__('Sorry We Can’t Find Page!', 'industo'); ?></h3>
                                    <div class="excerpt-404">
                                        <?php echo esc_html__('The page you are looking for was moved, Removed, renamed or never existed.', 'industo'); ?>
                                    </div>
                                    <form role="search" method="get" class="search-form" action="<?php echo esc_url(home_url( '/' )); ?>">
                                        <div class="searchform-wrap">
                                            <input type="text" placeholder="<?php if(!empty($search_field_placeholder)) { echo esc_attr( $search_field_placeholder ); } else { esc_attr_e('Search here...', 'industo'); } ?>" name="s" class="search-field" />
                                            <button type="submit" class="search-submit"><i class="caseicon-search"></i></button>
                                        </div>
                                    </form>
                                </div>
                                <div class="error-404-image"><img src="<?php echo esc_url(get_template_directory_uri().'/assets/images/image-404.jpg'); ?>" alt="<?php echo esc_attr__('404 Error', 'industo'); ?>" /></div>
                                <div class="entry-footer">
                                    <img class="bounce-1" src="<?php echo esc_url(get_template_directory_uri().'/assets/images/arrow-404.png'); ?>" alt="<?php echo esc_attr__('404 Error', 'industo'); ?>" />
                                    <a class="btn btn-animate btn-primary" href="<?php echo esc_url(home_url('/')); ?>">
                                        <?php echo esc_html__('Back To Home', 'industo'); ?>
                                    </a>
                                </div>
                            </div>
                        </section>
                    <?php } else { ?>
                        <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                            <div class="entry-content clearfix">
                                <?php $post = get_post($page_custom_404);
                                if (!is_wp_error($post) && $post->ID == $page_custom_404 && class_exists('Case_Theme_Core') && function_exists('ct_print_html')){
                                    $content = \Elementor\Plugin::$instance->frontend->get_builder_content( $page_custom_404 );
                                    ct_print_html($content);
                                } ?>
                            </div>
                        </article>
                    <?php } ?>
                </main><!-- #main -->
            </div><!-- #primary -->
        </div>
    </div>

<?php
get_footer();
