<?php
$default_settings = [
    'banner_image' => '',
    'ct_animate' => '',
    'ct_animate_delay' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);
$is_new = \Elementor\Icons_Manager::is_migration_allowed();
if ( ! empty( $settings['btn_link']['url'] ) ) {
    $widget->add_render_attribute( 'btn_text', 'href', $settings['btn_link']['url'] );

    if ( $settings['btn_link']['is_external'] ) {
        $widget->add_render_attribute( 'btn_text', 'target', '_blank' );
    }

    if ( $settings['btn_link']['nofollow'] ) {
        $widget->add_render_attribute( 'btn_text', 'rel', 'nofollow' );
    }
}
if(!empty($banner_image['id'])) : 

	$img = ct_get_image_by_size( array(
		'attach_id'  => $banner_image['id'],
		'thumb_size' => '600x650',
	));
	$thumbnail = $img['thumbnail'];

	?>
	<div class="ct-banner layout5 <?php echo esc_attr($ct_animate); ?>" data-wow-delay="<?php echo esc_attr($ct_animate_delay); ?>ms">
		<div class="ct-banner-inner">
			<div class="ct-banner-image">
				<div class="box-squares squares1">
					<span class="item-square1 "></span>
					<span class="item-square2"></span>
					<span class="item-square3"></span>
				</div>
				<div class="box-squares squares2">
					<span class="item-square1"></span>
					<span class="item-square2"></span>
					<span class="item-square3"></span>
				</div>
				<div class="item-feature">
					<?php echo wp_kses_post($thumbnail); ?>
				</div>
		        <?php if ( ! empty( $settings['btn_link']['url'] ) ) { ?>
		        	<div class="item-btn">
		        		<a class="btn-link wow fadeInLeft" <?php ct_print_html($widget->get_render_attribute_string( 'btn_text' )); ?>><?php echo esc_html($settings['btn_text']); ?></a>
		        	</div>
		        <?php } ?>
			</div>			
		</div>
	</div>
<?php endif; ?>