<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Faq Box Widget .
 *
 */
class Konsal_Faq extends Widget_Base {

	public function get_name() {
		return 'konsalfaq';
	}

	public function get_title() {
		return __( 'Faq', 'konsal' );
	}

	public function get_icon() {
		return 'th-icon';
    }

	public function get_categories() {
		return [ 'konsal' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'faq_section',
			[
				'label' 	=> __( 'Faq', 'konsal' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'layout_style',
			[
				'label' 		=> __( 'Faq Style', 'konsal' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'layout_one',
				'options' 		=> [
					'layout_one'  		=> __( 'Style One', 'konsal' ),
					'layout_two'  		=> __( 'Style Two', 'konsal' ),
				]
			]
		);
		
		
        $this->end_controls_section();




	    include konsal_get_elementor_option('faq-one-options.php');


	

        //-------------------------------------title styling-------------------------------------//

        $this->start_controls_section(
			'section_title_style_section',
			[
				'label' => __( 'Style', 'konsal' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
        konsal_all_elementor_style($this, 'Question', '{{WRAPPER}} .accordion-button',['layout_one'] );
        konsal_all_elementor_style($this, 'Answer', '{{WRAPPER}} .accordion-card .faq-text',['layout_one'],'--white-color' );



        $this->end_controls_section();

       
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        if( $settings['layout_style'] == 'layout_one' ){

        	echo '<div class="accordion" id="faqAccordion">';
				$x = 1;
                foreach( $settings['faq_repeater'] as $single_data ){
					if( $x == '1' ){
						$ariaexpanded 	= 'true';
						$class 			= 'show';
						$collesed 		= '';
						$is_active 		= 'active';
					}else{
						$ariaexpanded 	= 'false';
						$class 			= '';
						$collesed 		= 'collapsed';
						$is_active 		= '';
					}


					echo '<div class="accordion-card '.esc_attr( $is_active ).'">';
						if( ! empty( $single_data['faq_question'] ) ){
	                        echo '<div class="accordion-header" id="collapse-item-'.esc_attr( $x ).'">';
	                            echo '<button class="accordion-button '.esc_attr( $collesed ).'" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-'.esc_attr( $x ).'" aria-expanded="'.esc_attr( $ariaexpanded ).'" aria-controls="collapse-'.esc_attr( $x ).'">'.esc_html($single_data['faq_question']).'</button>';
	                        echo '</div>';
	                    }
	                    if( ! empty( $single_data['faq_answer'] ) ){
	                        echo '<div id="collapse-'.esc_attr( $x ).'" class="accordion-collapse collapse '.esc_attr( $class ).'" aria-labelledby="collapse-item-'.esc_attr( $x ).'" data-bs-parent="#faqAccordion">';
	                            echo '<div class="accordion-body">';
	                                echo '<p class="faq-text">'.esc_html($single_data['faq_answer']).'</p>';
	                            echo '</div>';
	                        echo '</div>';
	                    }
                    echo '</div>';
					$x++;
                }
            echo '</div>';
	    }
	}
}